/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yanny.ytech.registration.YTechRecipeSerializers;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemainingShapelessRecipe
extends ShapelessRecipe {
    public RemainingShapelessRecipe(String p_249640_, CraftingBookCategory p_249390_, ItemStack p_252071_, List<Ingredient> p_250689_) {
        super(p_249640_, p_249390_, p_252071_, p_250689_);
    }

    public RemainingShapelessRecipe(ShapelessRecipe recipe) {
        super(recipe.group(), recipe.category(), recipe.result, recipe.ingredients);
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingInput container) {
        NonNullList list = NonNullList.withSize((int)container.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack item = container.getItem(i);
            ItemStack craftingRemainder = item.getCraftingRemainder();
            if (!craftingRemainder.isEmpty()) {
                list.set(i, (Object)craftingRemainder);
                continue;
            }
            if (!item.isDamageableItem()) continue;
            ItemStack result = item.copy();
            list.set(i, (Object)result);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) continue;
            result.hurtAndBreak(1, server.overworld(), null, it -> {});
        }
        return list;
    }

    @NotNull
    public RecipeSerializer<ShapelessRecipe> getSerializer() {
        return (RecipeSerializer)YTechRecipeSerializers.REMAINING_SHAPELESS.get();
    }

    public static class Builder
    extends ShapelessRecipeBuilder {
        public Builder(HolderGetter<Item> holderGetter, RecipeCategory pCategory, ItemStack pResult) {
            super(holderGetter, pCategory, pResult);
        }

        public static Builder shapeless(@NotNull HolderGetter<Item> holderGetter, @NotNull RecipeCategory pCategory, @NotNull ItemStack pResult) {
            return new Builder(holderGetter, pCategory, pResult);
        }

        public static Builder shapeless(@NotNull HolderGetter<Item> holderGetter, @NotNull RecipeCategory pCategory, ItemLike pResult) {
            return Builder.shapeless(holderGetter, pCategory, pResult, 1);
        }

        public static Builder shapeless(@NotNull HolderGetter<Item> holderGetter, @NotNull RecipeCategory pCategory, ItemLike pResult, int pCount) {
            return new Builder(holderGetter, pCategory, pResult.asItem().getDefaultInstance().copyWithCount(pCount));
        }

        public void save(final @NotNull RecipeOutput consumer, @NotNull ResourceKey<Recipe<?>> id) {
            super.save(new RecipeOutput(){

                @NotNull
                public Advancement.Builder advancement() {
                    return consumer.advancement();
                }

                public void includeRootAdvancement() {
                    consumer.includeRootAdvancement();
                }

                public void accept(@NotNull ResourceKey<Recipe<?>> id, @NotNull Recipe<?> recipe, @Nullable AdvancementHolder advancementHolder, ICondition ... iConditions) {
                    consumer.accept(id, (Recipe)new RemainingShapelessRecipe((ShapelessRecipe)recipe), advancementHolder);
                }
            }, id);
        }
    }

    public static class Serializer
    implements RecipeSerializer<RemainingShapelessRecipe> {
        private static final MapCodec<RemainingShapelessRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapelessRecipe::group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapelessRecipe::category), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.lazyInitialized(() -> Ingredient.CODEC.listOf(1, 9)).fieldOf("ingredients").forGetter(recipe -> recipe.ingredients)).apply((Applicative)instance, RemainingShapelessRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, RemainingShapelessRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ShapelessRecipe::group, (StreamCodec)CraftingBookCategory.STREAM_CODEC, ShapelessRecipe::category, (StreamCodec)ItemStack.STREAM_CODEC, recipe -> recipe.result, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), recipe -> recipe.ingredients, RemainingShapelessRecipe::new);

        @NotNull
        public MapCodec<RemainingShapelessRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, RemainingShapelessRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

