/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.yanny.ytech.configuration.block.WoodenBoxBlock;
import com.yanny.ytech.configuration.block_entity.WoodenBoxBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WoodenBoxRenderer
implements BlockEntityRenderer<WoodenBoxBlockEntity> {
    public WoodenBoxRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@NotNull WoodenBoxBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Level level = blockEntity.getLevel();
        Direction direction = (Direction)blockEntity.getBlockState().getValue(WoodenBoxBlock.HORIZONTAL_FACING);
        int i = 0;
        poseStack.pushPose();
        poseStack.scale(0.25f, 0.25f, 0.25f);
        if (level != null) {
            for (int z = 0; z < 3; ++z) {
                for (int x = 0; x < 3; ++x) {
                    int[] position;
                    if ((position = WoodenBoxBlock.getPosition(i++)) == null) continue;
                    int index = WoodenBoxBlock.getIndex(position);
                    ItemStack itemStack = (ItemStack)blockEntity.getItems().get(index);
                    if (itemStack.isEmpty()) continue;
                    poseStack.pushPose();
                    poseStack.translate(0.5 + (double)x, 2.3, 0.5 + (double)z);
                    poseStack.translate(0.5, 0.5, 0.5);
                    poseStack.pushPose();
                    poseStack.rotateAround(Axis.YN.rotationDegrees(direction.toYRot()), 0.0f, 0.0f, 0.0f);
                    poseStack.rotateAround(Axis.XN.rotationDegrees(90.0f), 0.0f, 0.0f, 0.0f);
                    ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
                    BakedModel bakedmodel = itemRenderer.getModel(itemStack, level, null, 0);
                    itemRenderer.render(itemStack, ItemDisplayContext.GUI, false, poseStack, buffer, packedLight, packedOverlay, bakedmodel);
                    poseStack.popPose();
                    poseStack.popPose();
                }
            }
        }
        poseStack.popPose();
    }

    private static int rgba(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }
}

