/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.screen.components;

import com.yanny.ytech.configuration.screen.components.IComponent;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import org.jetbrains.annotations.NotNull;

class BottomUpAnimationComponent
implements IComponent {
    protected final int x;
    protected final int y;
    protected final int uWidth;
    protected final int vHeight;
    protected final int uOffset;
    protected final int vOffset;
    protected final int uAnimationOffset;
    protected final int vAnimationOffset;
    protected int maxValue = 100;
    protected int value = 0;
    protected boolean renderAnimation = true;

    BottomUpAnimationComponent(int x, int y, int uWidth, int vHeight, int uOffset, int vOffset, int uAnimationOffset, int vAnimationOffset) {
        this.x = x;
        this.y = y;
        this.uWidth = uWidth;
        this.vHeight = vHeight;
        this.uOffset = uOffset;
        this.vOffset = vOffset;
        this.uAnimationOffset = uAnimationOffset;
        this.vAnimationOffset = vAnimationOffset;
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int left, int top) {
        int height = Math.min(Math.round((float)this.value / (float)this.maxValue * (float)this.vHeight), this.vHeight);
        int offset = Math.max(this.vHeight - height, 0);
        graphics.blit(RenderType::guiTextured, GUI, left + this.x, top + this.y, (float)this.uOffset, (float)this.vOffset, this.uWidth, this.vHeight, 256, 256);
        if (this.renderAnimation) {
            graphics.blit(RenderType::guiTextured, GUI, left + this.x, top + this.y + offset, (float)this.uAnimationOffset, (float)(this.vAnimationOffset + offset), this.uWidth, this.vHeight - offset, 256, 256);
        }
    }

    public void set(int maxValue, int value) {
        this.maxValue = maxValue;
        this.value = value;
    }

    public void setRenderAnimation(boolean renderAnimation) {
        this.renderAnimation = renderAnimation;
    }
}

