/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.generation;

import com.yanny.ytech.loot_modifier.AddItemModifier;
import com.yanny.ytech.loot_modifier.ReplaceItemModifier;
import com.yanny.ytech.registration.YTechItemTags;
import com.yanny.ytech.registration.YTechItems;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;

public class YTechGlobalLootModifierProvider
extends GlobalLootModifierProvider {
    public YTechGlobalLootModifierProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, "ytech");
    }

    protected void start() {
        this.add("grass_drops_fibers", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{LootItemRandomChanceCondition.randomChance((float)0.75f).build(), MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of((HolderGetter)this.registries.lookupOrThrow(Registries.ITEM), YTechItemTags.SHARP_FLINTS)).build(), LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)Blocks.SHORT_GRASS).build()}, (Item)YTechItems.GRASS_FIBERS.get()), new ICondition[0]);
        this.add("gravel_drops_pebble", (IGlobalLootModifier)new AddItemModifier(new LootItemCondition[]{LootItemRandomChanceCondition.randomChance((float)0.2f).build(), LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)Blocks.GRAVEL).build()}, (Item)YTechItems.PEBBLE.get()), new ICondition[0]);
        this.addReplaceLeatherByRawHide(EntityType.COW);
        this.addReplaceLeatherByRawHide(EntityType.HORSE);
        this.addReplaceLeatherByRawHide(EntityType.DONKEY);
        this.addReplaceLeatherByRawHide(EntityType.LLAMA);
        this.addReplaceLeatherByRawHide(EntityType.MULE);
        this.addReplaceLeatherByRawHide(EntityType.MOOSHROOM);
        this.addReplaceLeatherByRawHide(EntityType.TRADER_LLAMA);
        this.addReplaceLeatherByRawHide(EntityType.HOGLIN);
    }

    private void addReplaceLeatherByRawHide(EntityType<?> entityType) {
        this.add(Objects.requireNonNull(BuiltInRegistries.ENTITY_TYPE.getKey(entityType)).getPath() + "_replace_leather_by_raw_hide", (IGlobalLootModifier)new ReplaceItemModifier(new LootItemCondition[]{LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate)EntityPredicate.Builder.entity().entityType(EntityTypePredicate.of((HolderGetter)BuiltInRegistries.ENTITY_TYPE, entityType)).build()).build()}, Items.LEATHER, (Item)YTechItems.RAW_HIDE.get()), new ICondition[0]);
    }
}

