/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.generation;

import com.yanny.ytech.configuration.IType;
import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.item.BasketItem;
import com.yanny.ytech.configuration.item.DiviningRodItem;
import com.yanny.ytech.configuration.item.SpearItem;
import com.yanny.ytech.registration.YTechItems;
import java.util.EnumSet;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

class YTechItemModelsProvider
extends ItemModelProvider {
    public YTechItemModelsProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "ytech", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleItem(YTechItems.ANTLER);
        this.basketItem();
        this.simpleItem(YTechItems.BEESWAX);
        this.simpleItem(YTechItems.BONE_NEEDLE);
        this.simpleItem(YTechItems.BREAD_DOUGH);
        this.simpleItem(YTechItems.BRICK_MOLD);
        this.simpleItem(YTechItems.CLAY_BUCKET);
        this.simpleItem(YTechItems.COOKED_VENISON);
        this.diviningRodItem();
        this.simpleItem(YTechItems.DRIED_BEEF);
        this.simpleItem(YTechItems.DRIED_CHICKEN);
        this.simpleItem(YTechItems.DRIED_COD);
        this.simpleItem(YTechItems.DRIED_MUTTON);
        this.simpleItem(YTechItems.DRIED_PORKCHOP);
        this.simpleItem(YTechItems.DRIED_RABBIT);
        this.simpleItem(YTechItems.DRIED_SALMON);
        this.simpleItem(YTechItems.DRIED_VENISON);
        this.simpleItem(YTechItems.FLOUR);
        this.simpleItem(YTechItems.GRASS_FIBERS);
        this.simpleItem(YTechItems.GRASS_TWINE);
        this.simpleItem(YTechItems.IRON_BLOOM);
        this.clayBucketItem(YTechItems.LAVA_CLAY_BUCKET);
        this.simpleItem(YTechItems.LEATHER_STRIPS);
        this.simpleItem(YTechItems.MAMMOTH_TUSK);
        this.simpleItem(YTechItems.PEBBLE);
        this.simpleItem(YTechItems.RAW_HIDE);
        this.simpleItem(YTechItems.RHINO_HORN);
        this.simpleItem(YTechItems.SHARP_FLINT);
        this.unfiredAmphoraItem();
        this.simpleItem(YTechItems.UNFIRED_BRICK);
        this.simpleItem(YTechItems.UNFIRED_CLAY_BUCKET);
        this.decoratedPotItem();
        this.simpleItem(YTechItems.UNFIRED_FLOWER_POT);
        this.simpleItem(YTechItems.UNLIT_TORCH);
        this.simpleItem(YTechItems.VENISON);
        this.clayBucketItem(YTechItems.WATER_CLAY_BUCKET);
        this.simpleItem(YTechItems.CHLORITE_BRACELET);
        this.simpleItem(YTechItems.LION_MAN);
        this.simpleItem(YTechItems.SHELL_BEADS);
        this.simpleItem(YTechItems.VENUS_OF_HOHLE_FELS);
        this.simpleItem(YTechItems.WILD_HORSE);
        this.spawnEggModel(YTechItems.AUROCHS_SPAWN_EGG);
        this.spawnEggModel(YTechItems.DEER_SPAWN_EGG);
        this.spawnEggModel(YTechItems.FOWL_SPAWN_EGG);
        this.spawnEggModel(YTechItems.MOUFLON_SPAWN_EGG);
        this.spawnEggModel(YTechItems.SABER_TOOTH_TIGER_SPAWN_EGG);
        this.spawnEggModel(YTechItems.TERROR_BIRD_SPAWN_EGG);
        this.spawnEggModel(YTechItems.WILD_BOAR_SPAWN_EGG);
        this.spawnEggModel(YTechItems.WOOLLY_MAMMOTH_SPAWN_EGG);
        this.spawnEggModel(YTechItems.WOOLLY_RHINO_SPAWN_EGG);
        this.simpleTypedItem(YTechItems.CLAY_MOLDS);
        this.simpleTypedItem(YTechItems.PATTERNS);
        this.simpleTypedItem(YTechItems.SAND_MOLDS);
        this.simpleTypedItem(YTechItems.UNFIRED_MOLDS);
        this.simpleMultiTypedItem(YTechItems.PARTS);
        this.simpleTypedItem(YTechItems.ARROWS);
        this.simpleTypedItem(YTechItems.AXES, EnumSet.of(MaterialType.IRON, MaterialType.GOLD), "item/handheld");
        this.simpleTypedItem(YTechItems.BOLTS);
        this.simpleTypedItem(YTechItems.BOOTS, EnumSet.of(MaterialType.IRON, MaterialType.GOLD, MaterialType.LEATHER), "item/generated");
        this.simpleTypedItem(YTechItems.CHESTPLATES, EnumSet.of(MaterialType.IRON, MaterialType.GOLD, MaterialType.LEATHER), "item/generated");
        this.simpleTypedItem(YTechItems.CRUSHED_MATERIALS);
        this.simpleTypedItem(YTechItems.FILES, "item/handheld");
        this.simpleTypedItem(YTechItems.HAMMERS, "item/handheld");
        this.simpleTypedItem(YTechItems.HELMETS, EnumSet.of(MaterialType.IRON, MaterialType.GOLD, MaterialType.LEATHER), "item/generated");
        this.simpleTypedItem(YTechItems.HOES, EnumSet.of(MaterialType.IRON, MaterialType.GOLD), "item/handheld");
        this.simpleTypedItem(YTechItems.INGOTS, MaterialType.VANILLA_METALS, "item/generated");
        this.simpleTypedItem(YTechItems.KNIVES);
        this.simpleTypedItem(YTechItems.LEGGINGS, EnumSet.of(MaterialType.IRON, MaterialType.GOLD, MaterialType.LEATHER), "item/generated");
        this.simpleTypedItem(YTechItems.MESHES);
        this.simpleTypedItem(YTechItems.MORTAR_AND_PESTLES);
        this.simpleTypedItem(YTechItems.PICKAXES, EnumSet.of(MaterialType.IRON, MaterialType.GOLD), "item/handheld");
        this.simpleTypedItem(YTechItems.PLATES);
        this.simpleTypedItem(YTechItems.RAW_MATERIALS, MaterialType.VANILLA_METALS, "item/generated");
        this.simpleTypedItem(YTechItems.RODS);
        this.simpleTypedItem(YTechItems.SAWS, "item/handheld");
        this.simpleTypedItem(YTechItems.SAW_BLADES);
        this.simpleTypedItem(YTechItems.SHEARS, EnumSet.of(MaterialType.IRON), "item/handheld");
        this.simpleTypedItem(YTechItems.SHOVELS, EnumSet.of(MaterialType.IRON, MaterialType.GOLD, MaterialType.WOODEN), "item/handheld");
        this.spearItem();
        this.simpleTypedItem(YTechItems.SWORDS, EnumSet.of(MaterialType.IRON, MaterialType.GOLD), "item/handheld");
    }

    private void simpleItem(DeferredItem<Item> item) {
        ((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), "item/generated")).texture("layer0", Utils.modItemLoc(item.getId().getPath()));
    }

    private <E extends Enum<E>> void simpleTypedItem(YTechItems.TypedItem<E> typedItem, String parent) {
        typedItem.keySet().forEach(type -> ((ItemModelBuilder)this.withExistingParent(((DeferredItem)typedItem.get(type)).getId().getPath(), parent)).texture("layer0", Utils.modItemLoc(typedItem.getGroup() + "/" + ((IType)((Object)type)).key())));
    }

    private <E extends Enum<E>> void simpleTypedItem(YTechItems.TypedItem<E> typedItem) {
        this.simpleTypedItem(typedItem, "item/generated");
    }

    private <E extends Enum<E>> void simpleTypedItem(YTechItems.TypedItem<E> typedItem, EnumSet<E> excludeTypes, String parent) {
        typedItem.keySet().forEach(type -> {
            if (!excludeTypes.contains(type)) {
                ((ItemModelBuilder)this.withExistingParent(((DeferredItem)typedItem.get(type)).getId().getPath(), parent)).texture("layer0", Utils.modItemLoc(typedItem.getGroup() + "/" + ((IType)((Object)type)).key()));
            }
        });
    }

    private <E extends Enum<E>, F extends Enum<F>> void simpleMultiTypedItem(YTechItems.MultiTypedItem<E, F> multiTypedItem, String parent) {
        multiTypedItem.forEach((key1, map) -> map.forEach((key2, item) -> ((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), parent)).texture("layer0", Utils.modItemLoc(multiTypedItem.getGroup() + "/" + ((IType)((Object)key2)).key() + "/" + ((IType)((Object)key1)).key()))));
    }

    private <E extends Enum<E>, F extends Enum<F>> void simpleMultiTypedItem(YTechItems.MultiTypedItem<E, F> multiTypedItem) {
        this.simpleMultiTypedItem(multiTypedItem, "item/generated");
    }

    private void basketItem() {
        ItemModelBuilder builder = (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(Utils.getPath(YTechItems.BASKET))).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"));
        ModelBuilder model = ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(Utils.getPath(YTechItems.BASKET) + "_filled")).parent((ModelFile)builder)).texture("layer0", Utils.modItemLoc(Utils.getPath(YTechItems.BASKET) + "_filled"));
        builder.override().predicate(BasketItem.FILLED_PREDICATE, 1.0E-4f).model((ModelFile)model).end();
        builder.texture("layer0", Utils.modItemLoc(Utils.getPath(YTechItems.BASKET)));
    }

    private void diviningRodItem() {
        ItemModelBuilder builder = (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(Utils.getPath(YTechItems.DIVINING_ROD))).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"));
        ModelBuilder someWater = ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(Utils.getPath(YTechItems.DIVINING_ROD) + "_some_water")).parent((ModelFile)builder)).texture("layer0", Utils.modItemLoc("divining_rod/some_water"));
        ModelBuilder moreWater = ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(Utils.getPath(YTechItems.DIVINING_ROD) + "_more_water")).parent((ModelFile)builder)).texture("layer0", Utils.modItemLoc("divining_rod/more_water"));
        ModelBuilder plentyWater = ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(Utils.getPath(YTechItems.DIVINING_ROD) + "_plenty_water")).parent((ModelFile)builder)).texture("layer0", Utils.modItemLoc("divining_rod/plenty_water"));
        builder.override().predicate(DiviningRodItem.ABUNDANCE_PREDICATE, 0.25f).model((ModelFile)someWater).end();
        builder.override().predicate(DiviningRodItem.ABUNDANCE_PREDICATE, 0.5f).model((ModelFile)moreWater).end();
        builder.override().predicate(DiviningRodItem.ABUNDANCE_PREDICATE, 0.75f).model((ModelFile)plentyWater).end();
        builder.texture("layer0", Utils.modItemLoc("divining_rod/no_water"));
    }

    private void clayBucketItem(@NotNull DeferredItem<Item> item) {
        ItemModelBuilder builder = (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(Utils.getPath(item))).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"));
        builder.texture("layer0", Utils.modItemLoc("clay_bucket"));
        builder.texture("layer1", Utils.modItemLoc("bucket_overlay"));
    }

    private void spearItem() {
        YTechItems.SPEARS.forEach((material, item) -> {
            String texture = Utils.modItemLoc(YTechItems.SPEARS.getGroup() + "/" + material.key).getPath();
            ItemModelBuilder i = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(Utils.getPath(item))).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture);
            ItemModelBuilder throwing = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(Utils.getPath(item) + "_throwing")).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).guiLight(BlockModel.GuiLight.FRONT)).texture("particle", texture)).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, 90.0f, 180.0f).translation(8.0f, -17.0f, 9.0f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, 180.0f).translation(8.0f, -17.0f, -7.0f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 25.0f).translation(-3.0f, 17.0f, 1.0f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -25.0f).translation(13.0f, 17.0f, 1.0f).end().transform(ItemDisplayContext.GUI).rotation(15.0f, -25.0f, -5.0f).translation(2.0f, 3.0f, 0.0f).scale(0.65f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 180.0f, 0.0f).translation(-2.0f, 4.0f, -5.0f).scale(0.5f).end().transform(ItemDisplayContext.GROUND).translation(4.0f, 4.0f, 2.0f).scale(0.25f).end().end();
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(Utils.getPath(item) + "_in_hand")).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).guiLight(BlockModel.GuiLight.FRONT)).texture("particle", texture)).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, 60.0f, 0.0f).translation(11.0f, 17.0f, -2.0f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 60.0f, 0.0f).translation(3.0f, 17.0f, 12.0f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 25.0f).translation(-3.0f, 17.0f, 1.0f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -25.0f).translation(13.0f, 17.0f, 1.0f).end().transform(ItemDisplayContext.GUI).rotation(15.0f, -25.0f, -5.0f).translation(2.0f, 3.0f, 0.0f).scale(0.65f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 180.0f, 0.0f).translation(-2.0f, 4.0f, -5.0f).scale(0.5f).end().transform(ItemDisplayContext.GROUND).translation(4.0f, 4.0f, 2.0f).scale(0.25f).end().end()).override().predicate(SpearItem.THROWING_PREDICATE, 1.0f).model((ModelFile)throwing).end();
        });
    }

    private void decoratedPotItem() {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(Utils.getPath(YTechItems.UNFIRED_DECORATED_POT))).parent((ModelFile)this.getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case WEST: 
                case SOUTH: 
                case EAST: {
                    faceBuilder.uvs(1.0f, 0.0f, 15.0f, 16.0f).texture("#1");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 6.5f, 7.0f, 13.5f).texture("#0");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(7.0f, 6.5f, 14.0f, 13.5f).texture("#0");
                }
            }
        }).from(1.0f, 0.0f, 1.0f).to(15.0f, 16.0f, 15.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(9.0f, 5.5f, 12.0f, 6.0f).texture("#0");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(6.0f, 5.5f, 9.0f, 6.0f).texture("#0");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(3.0f, 5.5f, 6.0f, 6.0f).texture("#0");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(0.0f, 5.5f, 3.0f, 6.0f).texture("#0");
                }
            }
        }).from(5.0f, 16.0f, 5.0f).to(11.0f, 17.0f, 11.0f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(7.0f, 16.0f, 7.0f).end().end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(4.0f, 4.0f, 8.0f, 5.5f).texture("#0");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(12.0f, 4.0f, 16.0f, 5.5f).texture("#0");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(8.0f, 4.0f, 12.0f, 5.5f).texture("#0");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(0.0f, 4.0f, 4.0f, 5.5f).texture("#0");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(4.0f, 0.0f, 8.0f, 4.0f).texture("#0");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(8.0f, 0.0f, 12.0f, 4.0f).texture("#0");
                }
            }
        }).from(4.0f, 17.0f, 4.0f).to(12.0f, 20.0f, 12.0f).rotation().angle(0.0f).axis(Direction.Axis.Y).origin(4.0f, 17.0f, 4.0f).end().end()).texture("particle", Utils.modBlockLoc("unfired_decorated_pot_side"))).texture("0", Utils.modBlockLoc("unfired_decorated_pot_base"))).texture("1", Utils.modBlockLoc("unfired_decorated_pot_side"));
    }

    private void unfiredAmphoraItem() {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(Utils.getPath(YTechItems.UNFIRED_AMPHORA))).parent((ModelFile)this.getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case WEST: 
                case SOUTH: 
                case EAST: {
                    faceBuilder.uvs(5.0f, 13.0f, 11.0f, 16.0f).texture("#1");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(5.0f, 5.0f, 11.0f, 11.0f).texture("#0");
                }
            }
        }).from(5.0f, 0.0f, 5.0f).to(11.0f, 3.0f, 11.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case WEST: 
                case SOUTH: 
                case EAST: {
                    faceBuilder.uvs(3.0f, 4.0f, 13.0f, 14.0f).texture("#1");
                    break;
                }
                case UP: 
                case DOWN: {
                    faceBuilder.uvs(3.0f, 3.0f, 13.0f, 13.0f).texture("#0");
                }
            }
        }).from(3.0f, 6.0f, 3.0f).to(13.0f, 16.0f, 13.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case WEST: 
                case SOUTH: 
                case EAST: {
                    faceBuilder.uvs(6.0f, 2.0f, 10.0f, 4.0f).texture("#1");
                }
            }
        }).from(5.999f, 16.0f, 5.999f).to(10.001f, 18.0f, 10.001f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case WEST: 
                case SOUTH: 
                case EAST: {
                    faceBuilder.uvs(4.0f, 10.0f, 12.0f, 13.0f).texture("#1");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(4.0f, 4.0f, 12.0f, 12.0f).texture("#2");
                }
            }
        }).from(4.0f, 3.0f, 4.0f).to(12.0f, 6.0f, 12.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case WEST: 
                case SOUTH: 
                case EAST: {
                    faceBuilder.uvs(5.0f, 0.0f, 11.0f, 2.0f).texture("#1");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(5.0f, 5.0f, 11.0f, 11.0f).texture("#2");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(5.0f, 5.0f, 11.0f, 11.0f).texture("#0");
                }
            }
        }).from(4.999f, 18.0f, 4.999f).to(11.001f, 19.999f, 11.001f).end()).texture("particle", Utils.modBlockLoc("unfired_amphora/amphora_side"))).texture("0", Utils.modBlockLoc("unfired_amphora/amphora_base"))).texture("1", Utils.modBlockLoc("unfired_amphora/amphora_side"))).texture("2", Utils.modBlockLoc("unfired_amphora/amphora_top"));
    }

    private void spawnEggModel(DeferredItem<Item> item) {
        ((ItemModelBuilder)this.getBuilder(Utils.getPath(item))).parent((ModelFile)new ModelFile.UncheckedModelFile("item/template_spawn_egg"));
    }
}

