/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.generation;

import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block.GrassBedBlock;
import com.yanny.ytech.configuration.block.WellPulleyBlock;
import com.yanny.ytech.configuration.entity.DeerEntity;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechEntityTypes;
import com.yanny.ytech.registration.YTechItemTags;
import com.yanny.ytech.registration.YTechItems;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

class YTechLootTableProvider
extends LootTableProvider {
    public YTechLootTableProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
        super(packOutput, Collections.emptySet(), YTechLootTableProvider.getSubProviders(), registries);
    }

    protected void validate(@NotNull WritableRegistry<LootTable> writableregistry, @NotNull ValidationContext validationcontext, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ProblemReporter.Collector problemreporter$collector) {
    }

    private static List<LootTableProvider.SubProviderEntry> getSubProviders() {
        return List.of(new LootTableProvider.SubProviderEntry(YTechBlockLootSub::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(YTechEntityLootSub::new, LootContextParamSets.ENTITY), new LootTableProvider.SubProviderEntry(YTechFishingLootSub::new, LootContextParamSets.FISHING));
    }

    private static Stream<Map.Entry<MaterialType, DeferredBlock<Block>>> filteredStream(YTechBlocks.MaterialBlock block, EnumSet<MaterialType> exclude) {
        return block.entries().stream().filter(entry -> !exclude.contains(entry.getKey()));
    }

    private static void registerMaterialLootTable(YTechBlocks.MaterialBlock block, Consumer<DeferredBlock<Block>> loot, EnumSet<MaterialType> exclude) {
        YTechLootTableProvider.filteredStream(block, exclude).map(Map.Entry::getValue).forEach(loot);
    }

    private static void registerMaterialLootTable(YTechBlocks.MaterialBlock block, BiConsumer<DeferredBlock<Block>, MaterialType> loot, EnumSet<MaterialType> exclude) {
        YTechLootTableProvider.filteredStream(block, exclude).forEach(entry -> loot.accept((DeferredBlock)entry.getValue(), (MaterialType)entry.getKey()));
    }

    private static void registerMaterialLootTable(YTechBlocks.MaterialBlock block, BiConsumer<DeferredBlock<Block>, MaterialType> loot) {
        block.entries().forEach(entry -> loot.accept((DeferredBlock)entry.getValue(), (MaterialType)entry.getKey()));
    }

    private static void registerMaterialLootTable(YTechBlocks.MaterialBlock block, Consumer<DeferredBlock<Block>> loot) {
        block.entries().forEach(entry -> loot.accept((DeferredBlock)entry.getValue()));
    }

    private static class YTechFishingLootSub
    implements LootTableSubProvider {
        private final Map<ResourceLocation, LootTable.Builder> map = new HashMap<ResourceLocation, LootTable.Builder>();
        private final HolderLookup.Provider provider;

        public YTechFishingLootSub(HolderLookup.Provider provider) {
            this.provider = provider;
        }

        private void generateStrainerLootTable() {
            LootTable.Builder builder = LootTable.lootTable();
            builder.withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CLAY).setWeight(100)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SAND).setWeight(50)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GRAVEL).setWeight(40)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.FISHING).setWeight(10)).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of((HolderGetter)this.provider.lookupOrThrow(Registries.ITEM), (TagKey)YTechItemTags.MESHES.get(MaterialType.TWINE)))));
            builder.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CLAY).setWeight(70)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SAND).setWeight(50)).when(LootItemRandomChanceCondition.randomChance((float)0.7f)).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of((HolderGetter)this.provider.lookupOrThrow(Registries.ITEM), (TagKey)YTechItemTags.MESHES.get(MaterialType.COPPER)))));
            this.addPool(builder, (TagKey<Item>)((TagKey)YTechItemTags.MESHES.get(MaterialType.COPPER)), 0.3f, (Item)((DeferredItem)YTechItems.RAW_MATERIALS.get(MaterialType.CASSITERITE)).get());
            this.addPool(builder, (TagKey<Item>)((TagKey)YTechItemTags.MESHES.get(MaterialType.COPPER)), 0.2f, (Item)((DeferredItem)YTechItems.RAW_MATERIALS.get(MaterialType.GALENA)).get());
            this.addPool(builder, (TagKey<Item>)((TagKey)YTechItemTags.MESHES.get(MaterialType.COPPER)), 0.1f, (Item)((DeferredItem)YTechItems.RAW_MATERIALS.get(MaterialType.COPPER)).get());
            builder.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CLAY)).when(LootItemRandomChanceCondition.randomChance((float)0.3f)).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of((HolderGetter)this.provider.lookupOrThrow(Registries.ITEM), (TagKey)YTechItemTags.MESHES.get(MaterialType.BRONZE)))));
            this.addPool(builder, (TagKey<Item>)((TagKey)YTechItemTags.MESHES.get(MaterialType.BRONZE)), 0.3f, (Item)((DeferredItem)YTechItems.RAW_MATERIALS.get(MaterialType.CASSITERITE)).get());
            this.addPool(builder, (TagKey<Item>)((TagKey)YTechItemTags.MESHES.get(MaterialType.BRONZE)), 0.2f, (Item)((DeferredItem)YTechItems.RAW_MATERIALS.get(MaterialType.GALENA)).get());
            this.addPool(builder, (TagKey<Item>)((TagKey)YTechItemTags.MESHES.get(MaterialType.BRONZE)), 0.1f, (Item)((DeferredItem)YTechItems.RAW_MATERIALS.get(MaterialType.COPPER)).get());
            this.addPool(builder, (TagKey<Item>)((TagKey)YTechItemTags.MESHES.get(MaterialType.BRONZE)), 0.05f, (Item)((DeferredItem)YTechItems.RAW_MATERIALS.get(MaterialType.GOLD)).get());
            this.addPool(builder, (TagKey<Item>)((TagKey)YTechItemTags.MESHES.get(MaterialType.BRONZE)), 0.05f, (Item)((DeferredItem)YTechItems.RAW_MATERIALS.get(MaterialType.IRON)).get());
            this.add(Utils.modLoc("strainer"), builder);
        }

        private void addPool(LootTable.Builder builder, TagKey<Item> tool, float chance, Item item) {
            builder.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)))).when(LootItemRandomChanceCondition.randomChance((float)chance)).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of((HolderGetter)this.provider.lookupOrThrow(Registries.ITEM), tool))));
        }

        private void add(ResourceLocation location, LootTable.Builder builder) {
            this.map.put(location, builder);
        }

        public void generate(@NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> biConsumer) {
            this.generateStrainerLootTable();
            this.map.forEach((k, v) -> biConsumer.accept((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)k.withPrefix("fishing/")), (LootTable.Builder)v));
        }
    }

    private static class YTechEntityLootSub
    extends EntityLootSubProvider {
        protected YTechEntityLootSub(HolderLookup.Provider provider) {
            super(FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA), FeatureFlagSet.of(), provider);
        }

        public void generate() {
            this.registerAurochsLootTable();
            this.registerDeerLootTable();
            this.registerFowlLootTable();
            this.registerMouflonLootTable();
            this.registerSaberToothTigerLootTable();
            this.registerTerrorBirdLootTable();
            this.registerWildBoarLootTable();
            this.registerWoollyMammothLootTable();
            this.registerWoollyRhinoLootTable();
        }

        private void registerAurochsLootTable() {
            EntityPredicate.Builder entityOnFire = EntityPredicate.Builder.entity().flags(EntityFlagsPredicate.Builder.flags().setOnFire(Boolean.valueOf(true)));
            this.add((EntityType)YTechEntityTypes.AUROCHS.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)YTechItems.RAW_HIDE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BEEF).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)entityOnFire))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
        }

        private void registerDeerLootTable() {
            EntityPredicate.Builder entityOnFire = EntityPredicate.Builder.entity().flags(EntityFlagsPredicate.Builder.flags().setOnFire(Boolean.valueOf(true)));
            this.add((EntityType)YTechEntityTypes.DEER.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)YTechItems.RAW_HIDE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)YTechItems.VENISON.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)entityOnFire))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)YTechItems.ANTLER.get())).when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().nbt((NbtPredicate)NbtPredicate.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)new JsonPrimitive(DeerEntity.hasAntlersStr())).result().orElseThrow())))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))))));
        }

        private void registerFowlLootTable() {
            EntityPredicate.Builder entityOnFire = EntityPredicate.Builder.entity().flags(EntityFlagsPredicate.Builder.flags().setOnFire(Boolean.valueOf(true)));
            this.add((EntityType)YTechEntityTypes.FOWL.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FEATHER).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CHICKEN).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)entityOnFire))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
        }

        private void registerMouflonLootTable() {
            EntityPredicate.Builder entityOnFire = EntityPredicate.Builder.entity().flags(EntityFlagsPredicate.Builder.flags().setOnFire(Boolean.valueOf(true)));
            this.add((EntityType)YTechEntityTypes.MOUFLON.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)YTechItems.RAW_HIDE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MUTTON).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)entityOnFire))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
        }

        private void registerSaberToothTigerLootTable() {
            this.add((EntityType)YTechEntityTypes.SABER_TOOTH_TIGER.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)YTechItems.RAW_HIDE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
        }

        private void registerTerrorBirdLootTable() {
            EntityPredicate.Builder entityOnFire = EntityPredicate.Builder.entity().flags(EntityFlagsPredicate.Builder.flags().setOnFire(Boolean.valueOf(true)));
            this.add((EntityType)YTechEntityTypes.TERROR_BIRD.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FEATHER).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)5.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CHICKEN).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)entityOnFire))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
        }

        private void registerWildBoarLootTable() {
            EntityPredicate.Builder entityOnFire = EntityPredicate.Builder.entity().flags(EntityFlagsPredicate.Builder.flags().setOnFire(Boolean.valueOf(true)));
            this.add((EntityType)YTechEntityTypes.WILD_BOAR.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.PORKCHOP).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)entityOnFire))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
        }

        private void registerWoollyMammothLootTable() {
            this.add((EntityType)YTechEntityTypes.WOOLLY_MAMMOTH.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)YTechItems.RAW_HIDE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)6.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)YTechItems.MAMMOTH_TUSK.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))))));
        }

        private void registerWoollyRhinoLootTable() {
            this.add((EntityType)YTechEntityTypes.WOOLLY_RHINO.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)YTechItems.RAW_HIDE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)YTechItems.RHINO_HORN.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
        }
    }

    private static class YTechBlockLootSub
    extends BlockLootSubProvider {
        protected YTechBlockLootSub(HolderLookup.Provider provider) {
            super(new HashSet(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        protected void generate() {
            this.dropSelf(YTechBlocks.AMPHORA);
            this.dropSelf(YTechBlocks.AQUEDUCT_FERTILIZER);
            this.dropSelf(YTechBlocks.AQUEDUCT_HYDRATOR);
            this.dropSelf(YTechBlocks.AQUEDUCT_VALVE);
            this.dropSelf(YTechBlocks.BRICK_CHIMNEY);
            this.dropSelf(YTechBlocks.BRONZE_ANVIL);
            this.dropSelf(YTechBlocks.FIRE_PIT);
            GrassBedBlock.registerLootTable(this);
            this.dropSelf(YTechBlocks.MILLSTONE);
            this.dropSelf(YTechBlocks.POTTERS_WHEEL);
            this.dropSelf(YTechBlocks.PRIMITIVE_ALLOY_SMELTER);
            this.dropSelf(YTechBlocks.PRIMITIVE_SMELTER);
            this.dropSelf(YTechBlocks.REINFORCED_BRICKS);
            this.dropSelf(YTechBlocks.REINFORCED_BRICK_CHIMNEY);
            this.dropSelf(YTechBlocks.STRAINER);
            this.dropSelf(YTechBlocks.TERRACOTTA_BRICKS);
            this.registerSlabLootTable(YTechBlocks.TERRACOTTA_BRICK_SLAB);
            this.dropSelf(YTechBlocks.TERRACOTTA_BRICK_STAIRS);
            this.dropSelf(YTechBlocks.THATCH);
            this.registerSlabLootTable(YTechBlocks.THATCH_SLAB);
            this.dropSelf(YTechBlocks.THATCH_STAIRS);
            this.dropSelf(YTechBlocks.TOOL_RACK);
            this.dropSelf(YTechBlocks.TREE_STUMP);
            this.registerWellPulleyLootTable();
            this.dropSelf(YTechBlocks.WOODEN_BOX);
            YTechLootTableProvider.registerMaterialLootTable(YTechBlocks.AQUEDUCTS, this::dropSelf);
            YTechLootTableProvider.registerMaterialLootTable(YTechBlocks.DEEPSLATE_ORES, this::oreLoot, MaterialType.VANILLA_METALS);
            YTechLootTableProvider.registerMaterialLootTable(YTechBlocks.DRYING_RACKS, this::dropSelf);
            YTechLootTableProvider.registerMaterialLootTable(YTechBlocks.GRAVEL_DEPOSITS, (block, material) -> this.depositLootProvider((DeferredBlock<Block>)block, (MaterialType)material, Items.GRAVEL));
            YTechLootTableProvider.registerMaterialLootTable(YTechBlocks.NETHER_ORES, this::oreLoot, EnumSet.of(MaterialType.GOLD));
            YTechLootTableProvider.registerMaterialLootTable(YTechBlocks.RAW_STORAGE_BLOCKS, this::dropSelf, MaterialType.VANILLA_METALS);
            YTechLootTableProvider.registerMaterialLootTable(YTechBlocks.SAND_DEPOSITS, (block, material) -> this.depositLootProvider((DeferredBlock<Block>)block, (MaterialType)material, Items.SAND));
            YTechLootTableProvider.registerMaterialLootTable(YTechBlocks.STONE_ORES, this::oreLoot, MaterialType.VANILLA_METALS);
            YTechLootTableProvider.registerMaterialLootTable(YTechBlocks.STORAGE_BLOCKS, this::dropSelf, MaterialType.VANILLA_METALS);
            YTechLootTableProvider.registerMaterialLootTable(YTechBlocks.TANNING_RACKS, this::dropSelf);
        }

        @NotNull
        protected Iterable<Block> getKnownBlocks() {
            return Stream.of(Stream.of(YTechBlocks.AMPHORA, YTechBlocks.AQUEDUCT_FERTILIZER, YTechBlocks.AQUEDUCT_HYDRATOR, YTechBlocks.AQUEDUCT_VALVE, YTechBlocks.BRICK_CHIMNEY, YTechBlocks.BRONZE_ANVIL, YTechBlocks.FIRE_PIT, YTechBlocks.GRASS_BED, YTechBlocks.MILLSTONE, YTechBlocks.POTTERS_WHEEL, YTechBlocks.PRIMITIVE_ALLOY_SMELTER, YTechBlocks.PRIMITIVE_SMELTER, YTechBlocks.REINFORCED_BRICKS, YTechBlocks.REINFORCED_BRICK_CHIMNEY, YTechBlocks.STRAINER, YTechBlocks.TERRACOTTA_BRICKS, YTechBlocks.TERRACOTTA_BRICK_SLAB, YTechBlocks.TERRACOTTA_BRICK_STAIRS, YTechBlocks.THATCH, YTechBlocks.THATCH_SLAB, YTechBlocks.THATCH_STAIRS, YTechBlocks.TREE_STUMP, YTechBlocks.TOOL_RACK, YTechBlocks.WELL_PULLEY, YTechBlocks.WOODEN_BOX).map(DeferredHolder::get), YTechBlocks.AQUEDUCTS.entries().stream().map(Map.Entry::getValue).map(DeferredHolder::get), YTechLootTableProvider.filteredStream(YTechBlocks.DEEPSLATE_ORES, MaterialType.VANILLA_METALS).map(Map.Entry::getValue).map(DeferredHolder::get), YTechBlocks.DRYING_RACKS.entries().stream().map(Map.Entry::getValue).map(DeferredHolder::get), YTechBlocks.GRAVEL_DEPOSITS.entries().stream().map(Map.Entry::getValue).map(DeferredHolder::get), YTechLootTableProvider.filteredStream(YTechBlocks.NETHER_ORES, EnumSet.of(MaterialType.GOLD)).map(Map.Entry::getValue).map(DeferredHolder::get), YTechLootTableProvider.filteredStream(YTechBlocks.RAW_STORAGE_BLOCKS, MaterialType.VANILLA_METALS).map(Map.Entry::getValue).map(DeferredHolder::get), YTechBlocks.SAND_DEPOSITS.entries().stream().map(Map.Entry::getValue).map(DeferredHolder::get), YTechLootTableProvider.filteredStream(YTechBlocks.STONE_ORES, MaterialType.VANILLA_METALS).map(Map.Entry::getValue).map(DeferredHolder::get), YTechLootTableProvider.filteredStream(YTechBlocks.STORAGE_BLOCKS, MaterialType.VANILLA_METALS).map(Map.Entry::getValue).map(DeferredHolder::get), YTechBlocks.TANNING_RACKS.entries().stream().map(Map.Entry::getValue).map(DeferredHolder::get)).flatMap(i -> i).toList();
        }

        private void dropSelf(DeferredBlock<Block> block) {
            this.dropSelf((Block)block.get());
        }

        private void registerSlabLootTable(DeferredBlock<Block> block) {
            this.add((Block)block.get(), arg_0 -> ((YTechBlockLootSub)this).createSlabItemTable(arg_0));
        }

        private void oreLoot(DeferredBlock<Block> block, MaterialType material) {
            this.add((Block)block.get(), b -> this.createOreDrop((Block)b, (Item)((DeferredItem)YTechItems.RAW_MATERIALS.get(material)).get()));
        }

        private void depositLootProvider(DeferredBlock<Block> object, MaterialType material, @NotNull Item baseItem) {
            HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            LootItemCondition.Builder hasSilkTouch = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)registrylookup.getOrThrow(Enchantments.SILK_TOUCH), MinMaxBounds.Ints.atLeast((int)1))))));
            this.add((Block)object.get(), block -> LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(hasSilkTouch).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(hasSilkTouch.invert()).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)baseItem))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(hasSilkTouch.invert()).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)((DeferredItem)YTechItems.CRUSHED_MATERIALS.get(material)).get())).when(LootItemRandomChanceCondition.randomChance((float)0.25f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (int)2)))));
        }

        private void registerWellPulleyLootTable() {
            this.add((Block)YTechBlocks.WELL_PULLEY.get(), b -> this.createSinglePropConditionTable((Block)b, (Property)WellPulleyBlock.WELL_PART, (Comparable)((Object)WellPulleyBlock.WellPulleyPart.BASE)));
        }
    }
}

