/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.generation;

import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.PartType;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.recipe.AlloyingRecipe;
import com.yanny.ytech.configuration.recipe.BlockHitRecipe;
import com.yanny.ytech.configuration.recipe.ChoppingRecipe;
import com.yanny.ytech.configuration.recipe.DryingRecipe;
import com.yanny.ytech.configuration.recipe.HammeringRecipe;
import com.yanny.ytech.configuration.recipe.MillingRecipe;
import com.yanny.ytech.configuration.recipe.PotteryRecipe;
import com.yanny.ytech.configuration.recipe.RemainingPartShapelessRecipe;
import com.yanny.ytech.configuration.recipe.RemainingShapedRecipe;
import com.yanny.ytech.configuration.recipe.RemainingShapelessRecipe;
import com.yanny.ytech.configuration.recipe.SmeltingRecipe;
import com.yanny.ytech.configuration.recipe.TanningRecipe;
import com.yanny.ytech.configuration.recipe.WorkspaceCraftingRecipe;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechItemTags;
import com.yanny.ytech.registration.YTechItems;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.TippedArrowRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

class YTechRecipeProvider
extends RecipeProvider {
    public YTechRecipeProvider(HolderLookup.Provider provider, RecipeOutput output) {
        super(provider, output);
    }

    protected void buildRecipes() {
        this.mcSplitBySawRecipe(Items.ACACIA_PLANKS, Items.ACACIA_SLAB);
        this.mcSplitBySawRecipe(Items.BIRCH_PLANKS, Items.BIRCH_SLAB);
        this.mcSplitBySawRecipe(Items.CHERRY_PLANKS, Items.CHERRY_SLAB);
        this.mcSplitBySawRecipe(Items.JUNGLE_PLANKS, Items.JUNGLE_SLAB);
        this.mcSplitBySawRecipe(Items.OAK_PLANKS, Items.OAK_SLAB);
        this.mcSplitBySawRecipe(Items.DARK_OAK_PLANKS, Items.DARK_OAK_SLAB);
        this.mcSplitBySawRecipe(Items.MANGROVE_PLANKS, Items.MANGROVE_SLAB);
        this.mcSplitBySawRecipe(Items.SPRUCE_PLANKS, Items.SPRUCE_SLAB);
        this.mcSplitBySawRecipe(Items.CRIMSON_PLANKS, Items.CRIMSON_SLAB);
        this.mcSplitBySawRecipe(Items.BAMBOO_PLANKS, Items.BAMBOO_SLAB);
        this.mcSplitBySawRecipe(Items.WARPED_PLANKS, Items.WARPED_SLAB);
        this.mcSplitBySawRecipe(Items.ACACIA_LOG, Items.ACACIA_PLANKS);
        this.mcSplitBySawRecipe(Items.BIRCH_LOG, Items.BIRCH_PLANKS);
        this.mcSplitBySawRecipe(Items.CHERRY_LOG, Items.CHERRY_PLANKS);
        this.mcSplitBySawRecipe(Items.JUNGLE_LOG, Items.JUNGLE_PLANKS);
        this.mcSplitBySawRecipe(Items.OAK_LOG, Items.OAK_PLANKS);
        this.mcSplitBySawRecipe(Items.DARK_OAK_LOG, Items.DARK_OAK_PLANKS);
        this.mcSplitBySawRecipe(Items.MANGROVE_LOG, Items.MANGROVE_PLANKS);
        this.mcSplitBySawRecipe(Items.SPRUCE_LOG, Items.SPRUCE_PLANKS);
        this.mcSplitBySawRecipe(Items.CRIMSON_STEM, Items.CRIMSON_PLANKS);
        this.mcSplitBySawRecipe(Items.BAMBOO_BLOCK, Items.BAMBOO_PLANKS);
        this.mcSplitBySawRecipe(Items.WARPED_STEM, Items.WARPED_PLANKS);
        this.mcSplitByAxeRecipe(Items.ACACIA_PLANKS, Items.ACACIA_SLAB);
        this.mcSplitByAxeRecipe(Items.BIRCH_PLANKS, Items.BIRCH_SLAB);
        this.mcSplitByAxeRecipe(Items.CHERRY_PLANKS, Items.CHERRY_SLAB);
        this.mcSplitByAxeRecipe(Items.JUNGLE_PLANKS, Items.JUNGLE_SLAB);
        this.mcSplitByAxeRecipe(Items.OAK_PLANKS, Items.OAK_SLAB);
        this.mcSplitByAxeRecipe(Items.DARK_OAK_PLANKS, Items.DARK_OAK_SLAB);
        this.mcSplitByAxeRecipe(Items.MANGROVE_PLANKS, Items.MANGROVE_SLAB);
        this.mcSplitByAxeRecipe(Items.SPRUCE_PLANKS, Items.SPRUCE_SLAB);
        this.mcSplitByAxeRecipe(Items.CRIMSON_PLANKS, Items.CRIMSON_SLAB);
        this.mcSplitByAxeRecipe(Items.BAMBOO_PLANKS, Items.BAMBOO_SLAB);
        this.mcSplitByAxeRecipe(Items.WARPED_PLANKS, Items.WARPED_SLAB);
        this.mcSplitByAxeRecipe(Items.ACACIA_LOG, Items.ACACIA_PLANKS);
        this.mcSplitByAxeRecipe(Items.BIRCH_LOG, Items.BIRCH_PLANKS);
        this.mcSplitByAxeRecipe(Items.CHERRY_LOG, Items.CHERRY_PLANKS);
        this.mcSplitByAxeRecipe(Items.JUNGLE_LOG, Items.JUNGLE_PLANKS);
        this.mcSplitByAxeRecipe(Items.OAK_LOG, Items.OAK_PLANKS);
        this.mcSplitByAxeRecipe(Items.DARK_OAK_LOG, Items.DARK_OAK_PLANKS);
        this.mcSplitByAxeRecipe(Items.MANGROVE_LOG, Items.MANGROVE_PLANKS);
        this.mcSplitByAxeRecipe(Items.SPRUCE_LOG, Items.SPRUCE_PLANKS);
        this.mcSplitByAxeRecipe(Items.CRIMSON_STEM, Items.CRIMSON_PLANKS);
        this.mcSplitByAxeRecipe(Items.BAMBOO_BLOCK, Items.BAMBOO_PLANKS);
        this.mcSplitByAxeRecipe(Items.WARPED_STEM, Items.WARPED_PLANKS);
        this.mcSplitByChoppingRecipe(Items.ACACIA_LOG, Items.ACACIA_PLANKS);
        this.mcSplitByChoppingRecipe(Items.BIRCH_LOG, Items.BIRCH_PLANKS);
        this.mcSplitByChoppingRecipe(Items.CHERRY_LOG, Items.CHERRY_PLANKS);
        this.mcSplitByChoppingRecipe(Items.JUNGLE_LOG, Items.JUNGLE_PLANKS);
        this.mcSplitByChoppingRecipe(Items.OAK_LOG, Items.OAK_PLANKS);
        this.mcSplitByChoppingRecipe(Items.DARK_OAK_LOG, Items.DARK_OAK_PLANKS);
        this.mcSplitByChoppingRecipe(Items.MANGROVE_LOG, Items.MANGROVE_PLANKS);
        this.mcSplitByChoppingRecipe(Items.SPRUCE_LOG, Items.SPRUCE_PLANKS);
        this.mcSplitByChoppingRecipe(Items.CRIMSON_STEM, Items.CRIMSON_PLANKS);
        this.mcSplitByChoppingRecipe(Items.BAMBOO_BLOCK, Items.BAMBOO_PLANKS);
        this.mcSplitByChoppingRecipe(Items.WARPED_STEM, Items.WARPED_PLANKS);
        this.mcFenceRecipe(Items.ACACIA_PLANKS, Items.ACACIA_FENCE);
        this.mcFenceRecipe(Items.BIRCH_PLANKS, Items.BIRCH_FENCE);
        this.mcFenceRecipe(Items.CHERRY_PLANKS, Items.CHERRY_FENCE);
        this.mcFenceRecipe(Items.JUNGLE_PLANKS, Items.JUNGLE_FENCE);
        this.mcFenceRecipe(Items.OAK_PLANKS, Items.OAK_FENCE);
        this.mcFenceRecipe(Items.DARK_OAK_PLANKS, Items.DARK_OAK_FENCE);
        this.mcFenceRecipe(Items.MANGROVE_PLANKS, Items.MANGROVE_FENCE);
        this.mcFenceRecipe(Items.SPRUCE_PLANKS, Items.SPRUCE_FENCE);
        this.mcFenceRecipe(Items.CRIMSON_PLANKS, Items.CRIMSON_FENCE);
        this.mcFenceRecipe(Items.BAMBOO_PLANKS, Items.BAMBOO_FENCE);
        this.mcFenceRecipe(Items.WARPED_PLANKS, Items.WARPED_FENCE);
        this.mcFenceGateRecipe(Items.ACACIA_PLANKS, Items.ACACIA_FENCE_GATE);
        this.mcFenceGateRecipe(Items.BIRCH_PLANKS, Items.BIRCH_FENCE_GATE);
        this.mcFenceGateRecipe(Items.CHERRY_PLANKS, Items.CHERRY_FENCE_GATE);
        this.mcFenceGateRecipe(Items.JUNGLE_PLANKS, Items.JUNGLE_FENCE_GATE);
        this.mcFenceGateRecipe(Items.OAK_PLANKS, Items.OAK_FENCE_GATE);
        this.mcFenceGateRecipe(Items.DARK_OAK_PLANKS, Items.DARK_OAK_FENCE_GATE);
        this.mcFenceGateRecipe(Items.MANGROVE_PLANKS, Items.MANGROVE_FENCE_GATE);
        this.mcFenceGateRecipe(Items.SPRUCE_PLANKS, Items.SPRUCE_FENCE_GATE);
        this.mcFenceGateRecipe(Items.CRIMSON_PLANKS, Items.CRIMSON_FENCE_GATE);
        this.mcFenceGateRecipe(Items.BAMBOO_PLANKS, Items.BAMBOO_FENCE_GATE);
        this.mcFenceGateRecipe(Items.WARPED_PLANKS, Items.WARPED_FENCE_GATE);
        this.mcDoorRecipe(Items.ACACIA_PLANKS, Items.ACACIA_DOOR);
        this.mcDoorRecipe(Items.BIRCH_PLANKS, Items.BIRCH_DOOR);
        this.mcDoorRecipe(Items.CHERRY_PLANKS, Items.CHERRY_DOOR);
        this.mcDoorRecipe(Items.JUNGLE_PLANKS, Items.JUNGLE_DOOR);
        this.mcDoorRecipe(Items.OAK_PLANKS, Items.OAK_DOOR);
        this.mcDoorRecipe(Items.DARK_OAK_PLANKS, Items.DARK_OAK_DOOR);
        this.mcDoorRecipe(Items.MANGROVE_PLANKS, Items.MANGROVE_DOOR);
        this.mcDoorRecipe(Items.SPRUCE_PLANKS, Items.SPRUCE_DOOR);
        this.mcDoorRecipe(Items.CRIMSON_PLANKS, Items.CRIMSON_DOOR);
        this.mcDoorRecipe(Items.BAMBOO_PLANKS, Items.BAMBOO_DOOR);
        this.mcDoorRecipe(Items.WARPED_PLANKS, Items.WARPED_DOOR);
        this.mcTrapdoorRecipe(Items.ACACIA_PLANKS, Items.ACACIA_TRAPDOOR);
        this.mcTrapdoorRecipe(Items.BIRCH_PLANKS, Items.BIRCH_TRAPDOOR);
        this.mcTrapdoorRecipe(Items.CHERRY_PLANKS, Items.CHERRY_TRAPDOOR);
        this.mcTrapdoorRecipe(Items.JUNGLE_PLANKS, Items.JUNGLE_TRAPDOOR);
        this.mcTrapdoorRecipe(Items.OAK_PLANKS, Items.OAK_TRAPDOOR);
        this.mcTrapdoorRecipe(Items.DARK_OAK_PLANKS, Items.DARK_OAK_TRAPDOOR);
        this.mcTrapdoorRecipe(Items.MANGROVE_PLANKS, Items.MANGROVE_TRAPDOOR);
        this.mcTrapdoorRecipe(Items.SPRUCE_PLANKS, Items.SPRUCE_TRAPDOOR);
        this.mcTrapdoorRecipe(Items.CRIMSON_PLANKS, Items.CRIMSON_TRAPDOOR);
        this.mcTrapdoorRecipe(Items.BAMBOO_PLANKS, Items.BAMBOO_TRAPDOOR);
        this.mcTrapdoorRecipe(Items.WARPED_PLANKS, Items.WARPED_TRAPDOOR);
        this.mcPressurePlateRecipe(Items.ACACIA_PLANKS, Items.ACACIA_PRESSURE_PLATE);
        this.mcPressurePlateRecipe(Items.BIRCH_PLANKS, Items.BIRCH_PRESSURE_PLATE);
        this.mcPressurePlateRecipe(Items.CHERRY_PLANKS, Items.CHERRY_PRESSURE_PLATE);
        this.mcPressurePlateRecipe(Items.JUNGLE_PLANKS, Items.JUNGLE_PRESSURE_PLATE);
        this.mcPressurePlateRecipe(Items.OAK_PLANKS, Items.OAK_PRESSURE_PLATE);
        this.mcPressurePlateRecipe(Items.DARK_OAK_PLANKS, Items.DARK_OAK_PRESSURE_PLATE);
        this.mcPressurePlateRecipe(Items.MANGROVE_PLANKS, Items.MANGROVE_PRESSURE_PLATE);
        this.mcPressurePlateRecipe(Items.SPRUCE_PLANKS, Items.SPRUCE_PRESSURE_PLATE);
        this.mcPressurePlateRecipe(Items.CRIMSON_PLANKS, Items.CRIMSON_PRESSURE_PLATE);
        this.mcPressurePlateRecipe(Items.BAMBOO_PLANKS, Items.BAMBOO_PRESSURE_PLATE);
        this.mcPressurePlateRecipe(Items.WARPED_PLANKS, Items.WARPED_PRESSURE_PLATE);
        this.mcButtonRecipe(Items.ACACIA_PLANKS, Items.ACACIA_BUTTON);
        this.mcButtonRecipe(Items.BIRCH_PLANKS, Items.BIRCH_BUTTON);
        this.mcButtonRecipe(Items.CHERRY_PLANKS, Items.CHERRY_BUTTON);
        this.mcButtonRecipe(Items.JUNGLE_PLANKS, Items.JUNGLE_BUTTON);
        this.mcButtonRecipe(Items.OAK_PLANKS, Items.OAK_BUTTON);
        this.mcButtonRecipe(Items.DARK_OAK_PLANKS, Items.DARK_OAK_BUTTON);
        this.mcButtonRecipe(Items.MANGROVE_PLANKS, Items.MANGROVE_BUTTON);
        this.mcButtonRecipe(Items.SPRUCE_PLANKS, Items.SPRUCE_BUTTON);
        this.mcButtonRecipe(Items.CRIMSON_PLANKS, Items.CRIMSON_BUTTON);
        this.mcButtonRecipe(Items.BAMBOO_PLANKS, Items.BAMBOO_BUTTON);
        this.mcButtonRecipe(Items.WARPED_PLANKS, Items.WARPED_BUTTON);
        this.mcStairsRecipe(Items.ACACIA_PLANKS, Items.ACACIA_SLAB, Items.ACACIA_STAIRS);
        this.mcStairsRecipe(Items.BIRCH_PLANKS, Items.BIRCH_SLAB, Items.BIRCH_STAIRS);
        this.mcStairsRecipe(Items.CHERRY_PLANKS, Items.CHERRY_SLAB, Items.CHERRY_STAIRS);
        this.mcStairsRecipe(Items.JUNGLE_PLANKS, Items.JUNGLE_SLAB, Items.JUNGLE_STAIRS);
        this.mcStairsRecipe(Items.OAK_PLANKS, Items.OAK_SLAB, Items.OAK_STAIRS);
        this.mcStairsRecipe(Items.DARK_OAK_PLANKS, Items.DARK_OAK_SLAB, Items.DARK_OAK_STAIRS);
        this.mcStairsRecipe(Items.MANGROVE_PLANKS, Items.MANGROVE_SLAB, Items.MANGROVE_STAIRS);
        this.mcStairsRecipe(Items.SPRUCE_PLANKS, Items.SPRUCE_SLAB, Items.SPRUCE_STAIRS);
        this.mcStairsRecipe(Items.CRIMSON_PLANKS, Items.CRIMSON_SLAB, Items.CRIMSON_STAIRS);
        this.mcStairsRecipe(Items.BAMBOO_PLANKS, Items.BAMBOO_SLAB, Items.BAMBOO_STAIRS);
        this.mcStairsRecipe(Items.WARPED_PLANKS, Items.WARPED_SLAB, Items.WARPED_STAIRS);
        this.mcBedRecipe(Items.BLACK_WOOL, Items.BLACK_BED);
        this.mcBedRecipe(Items.BLUE_WOOL, Items.BLUE_BED);
        this.mcBedRecipe(Items.BROWN_WOOL, Items.BROWN_BED);
        this.mcBedRecipe(Items.WHITE_WOOL, Items.WHITE_BED);
        this.mcBedRecipe(Items.CYAN_WOOL, Items.CYAN_BED);
        this.mcBedRecipe(Items.GRAY_WOOL, Items.GRAY_BED);
        this.mcBedRecipe(Items.GREEN_WOOL, Items.GREEN_BED);
        this.mcBedRecipe(Items.LIME_WOOL, Items.LIME_BED);
        this.mcBedRecipe(Items.MAGENTA_WOOL, Items.MAGENTA_BED);
        this.mcBedRecipe(Items.ORANGE_WOOL, Items.ORANGE_BED);
        this.mcBedRecipe(Items.PINK_WOOL, Items.PINK_BED);
        this.mcBedRecipe(Items.PURPLE_WOOL, Items.PURPLE_BED);
        this.mcBedRecipe(Items.RED_WOOL, Items.RED_BED);
        this.mcBedRecipe(Items.YELLOW_WOOL, Items.YELLOW_BED);
        this.mcBedRecipe(Items.LIGHT_BLUE_WOOL, Items.LIGHT_BLUE_BED);
        this.mcBedRecipe(Items.LIGHT_GRAY_WOOL, Items.LIGHT_GRAY_BED);
        this.mcBoatRecipe(Items.ACACIA_PLANKS, Items.ACACIA_BOAT);
        this.mcBoatRecipe(Items.BIRCH_PLANKS, Items.BIRCH_BOAT);
        this.mcBoatRecipe(Items.CHERRY_PLANKS, Items.CHERRY_BOAT);
        this.mcBoatRecipe(Items.JUNGLE_PLANKS, Items.JUNGLE_BOAT);
        this.mcBoatRecipe(Items.OAK_PLANKS, Items.OAK_BOAT);
        this.mcBoatRecipe(Items.DARK_OAK_PLANKS, Items.DARK_OAK_BOAT);
        this.mcBoatRecipe(Items.MANGROVE_PLANKS, Items.MANGROVE_BOAT);
        this.mcBoatRecipe(Items.SPRUCE_PLANKS, Items.SPRUCE_BOAT);
        this.mcBoatRecipe(Items.BAMBOO_PLANKS, Items.BAMBOO_RAFT);
        this.mcSplitByHammerRecipe(Items.ANDESITE, Items.ANDESITE_SLAB);
        this.mcSplitByHammerRecipe(Items.COBBLESTONE, Items.COBBLESTONE_SLAB);
        this.mcSplitByHammerRecipe(Items.DIORITE, Items.DIORITE_SLAB);
        this.mcSplitByHammerRecipe(Items.GRANITE, Items.GRANITE_SLAB);
        this.mcSplitByHammerRecipe(Items.SMOOTH_STONE, Items.SMOOTH_STONE_SLAB);
        this.mcSplitByHammerRecipe(Items.STONE, Items.STONE_SLAB);
        this.mcHorseArmorRecipe(Items.LEATHER, Items.LEATHER_HORSE_ARMOR);
        this.mcHorseArmorRecipe(MaterialType.GOLD, Items.GOLDEN_HORSE_ARMOR);
        this.mcHorseArmorRecipe(MaterialType.IRON, Items.IRON_HORSE_ARMOR);
        this.mcCookingRecipe(RecipeCategory.FOOD, YTechItemTags.BREAD_DOUGHS, Items.BREAD, 0.1f, 200);
        this.mcCookingRecipe(RecipeCategory.MISC, YTechItemTags.UNFIRED_BRICKS, Items.BRICK, 0.3f, 200);
        this.mcBowRecipe();
        this.mcBowlRecipe();
        this.mcIronBarsRecipe();
        this.mcIronDoorRecipe();
        this.mcIronTrapdoorRecipe();
        this.mcHeavyWeightedPressurePlateRecipe();
        this.mcLightWeightedPressurePlateRecipe();
        this.mcChainRecipe();
        this.mcLanternRecipe();
        this.mcSoulLanternRecipe();
        this.mcFishingRodRecipe();
        this.mcLeadRecipe();
        this.mcSaddleRecipe();
        this.mcBoneMealRecipe();
        this.mcCookieRecipe();
        this.mcCakeRecipe();
        this.mcTripwireHookRecipe();
        this.mcCrossbowRecipe();
        this.mcCampfireRecipe();
        this.mcSoulCampfireRecipe();
        this.mcMudRecipe();
        this.registerBasketRecipe();
        this.registerBeeswaxRecipe();
        this.registerBoneNeedleRecipe();
        this.registerBreadDoughRecipe();
        this.registerBrickMoldRecipe();
        this.registerCookedVenisonRecipe();
        this.registerDiviningRodRecipe();
        this.registerFlourRecipe();
        this.registerGrassTwineRecipe();
        this.registerIronBloomRecipe();
        this.registerLeatherStripsRecipe();
        this.registerRawHideRecipe();
        this.registerUnfiredBrickRecipe();
        this.registerUnlitTorchRecipe();
        this.registerVenusOfHohleFelsRecipe();
        this.registerLionManRecipe();
        this.registerWildHorseRecipe();
        this.registerShellBeadsRecipe();
        this.registerChloriteBraceletRecipe();
        YTechItems.CLAY_MOLDS.forEach((part, item) -> this.smeltingRecipe((TagKey<Item>)((TagKey)YTechItemTags.UNFIRED_MOLDS.get(part)), (Item)item.get(), 1000, 200));
        YTechItems.PATTERNS.forEach((type, item) -> this.registerPatternRecipe((DeferredItem<Item>)item, (PartType)type));
        YTechItems.SAND_MOLDS.forEach((type, item) -> this.registerSandMoldRecipe((DeferredItem<Item>)item, (PartType)type));
        YTechItems.UNFIRED_MOLDS.forEach((part, item) -> this.registerUnfiredMoldRecipe((DeferredItem<Item>)item, (PartType)part));
        YTechItems.PARTS.forEach((material, map) -> map.forEach((part, item) -> this.smeltingRecipe((TagKey<Item>)((TagKey)YTechItemTags.INGOTS.get(material)), part.ingotCount, (TagKey<Item>)((TagKey)YTechItemTags.MOLDS.get(part)), (Item)item.get(), material.meltingTemp, 200 * part.ingotCount, "mold")));
        YTechItems.ARROWS.forEach((material, item) -> this.registerArrowRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.AXES.forEach((material, item) -> this.registerAxeRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.BOLTS.forEach((material, item) -> this.registerBoltRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.BOOTS.forEach((material, item) -> this.registerBootsRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.CHESTPLATES.forEach((material, item) -> this.registerChestplateRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.CRUSHED_MATERIALS.forEach((material, item) -> this.registerCrushedRawMaterialRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.FILES.forEach((material, item) -> this.registerFileRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.HAMMERS.forEach((material, item) -> this.registerHammerRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.HELMETS.forEach((material, item) -> this.registerHelmetRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.HOES.forEach((material, item) -> this.registerHoeRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.INGOTS.forEach((material, item) -> this.registerIngotRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.KNIVES.forEach((material, item) -> this.registerKnifeRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.LEGGINGS.forEach((material, item) -> this.registerLeggingsRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.MESHES.forEach((material, item) -> this.registerMeshRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.MORTAR_AND_PESTLES.forEach((material, item) -> this.registerMortarAndPestleRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.PICKAXES.forEach((material, item) -> this.registerPickaxeRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.PLATES.forEach((material, item) -> this.registerPlateRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.RAW_MATERIALS.forEach((material, item) -> this.registerRawMaterialRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.RODS.forEach((material, item) -> this.registerRodRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.SAWS.forEach((material, item) -> this.registerSawRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.SAW_BLADES.forEach((material, item) -> this.registerSawBladeRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.SHEARS.forEach((material, item) -> this.registerShearsRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.SHOVELS.forEach((material, item) -> this.registerShovelRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.SPEARS.forEach((material, item) -> this.registerSpearRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.SWORDS.forEach((key, item) -> this.registerSwordRecipe((DeferredItem<Item>)item, (MaterialType)key));
        this.registerFertilizerRecipe();
        this.registerHydratorRecipe();
        this.registerValveRecipe();
        this.registerBrickChimneyRecipe();
        this.registerBronzeAnvilRecipe();
        this.registerCraftingWorkspaceRecipe();
        this.registerFirePitRecipe();
        this.registerGrassBedRecipe();
        this.registerMillstoneRecipe();
        this.registerPottersWheelRecipe();
        this.registerPrimitiveAlloySmelterRecipe();
        this.registerPrimitiveSmelterRecipe();
        this.registerReinforcedBricksRecipe();
        this.registerReinforcedBrickChimneyRecipe();
        this.registerStrainerRecipe();
        this.registerTerracottaBricksRecipe();
        this.registerTerracottaBrickSlabRecipe();
        this.registerTerracottaBrickStairsRecipe();
        this.registerThatchBlockRecipe();
        this.registerThatchBlockSlabRecipe();
        this.registerThatchBlockStairsRecipe();
        this.registerTreeStumpRecipe();
        YTechItems.AQUEDUCTS.forEach((material, item) -> this.registerAqueductRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.DRYING_RACKS.forEach((material, item) -> this.registerDryingRackRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.RAW_STORAGE_BLOCKS.forEach((material, item) -> this.registerRawStorageBlockRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.STORAGE_BLOCKS.forEach((material, item) -> this.registerStorageBlockRecipe((DeferredItem<Item>)item, (MaterialType)material));
        YTechItems.TANNING_RACKS.forEach((material, item) -> this.registerTanningRackRecipe((DeferredItem<Item>)item, (MaterialType)material));
        this.alloyingRecipe((TagKey<Item>)((TagKey)YTechItemTags.INGOTS.get(MaterialType.COPPER)), 9, (TagKey<Item>)((TagKey)YTechItemTags.INGOTS.get(MaterialType.TIN)), 1, (Item)((DeferredItem)YTechItems.INGOTS.get(MaterialType.BRONZE)).get(), 10, Math.max(MaterialType.COPPER.meltingTemp, MaterialType.TIN.meltingTemp), 200);
        this.alloyingRecipe((TagKey<Item>)((TagKey)YTechItemTags.CRUSHED_MATERIALS.get(MaterialType.GALENA)), 1, (TagKey<Item>)ItemTags.SMELTS_TO_GLASS, 1, Items.GLASS, 1, 800, 200);
        this.smeltingRecipe((TagKey<Item>)((TagKey)YTechItemTags.CRUSHED_MATERIALS.get(MaterialType.COPPER)), 1, (TagKey<Item>)((TagKey)YTechItemTags.MOLDS.get(PartType.INGOT)), Items.COPPER_INGOT, MaterialType.COPPER.meltingTemp, 200, "smelting");
        this.smeltingRecipe((TagKey<Item>)((TagKey)YTechItemTags.CRUSHED_MATERIALS.get(MaterialType.GOLD)), 1, (TagKey<Item>)((TagKey)YTechItemTags.MOLDS.get(PartType.INGOT)), Items.GOLD_INGOT, MaterialType.GOLD.meltingTemp, 200, "smelting");
        this.smeltingRecipe((TagKey<Item>)((TagKey)YTechItemTags.CRUSHED_MATERIALS.get(MaterialType.CASSITERITE)), 1, (TagKey<Item>)((TagKey)YTechItemTags.MOLDS.get(PartType.INGOT)), (Item)((DeferredItem)YTechItems.INGOTS.get(MaterialType.TIN)).get(), MaterialType.CASSITERITE.meltingTemp, 200, "smelting");
        this.smeltingRecipe((TagKey<Item>)((TagKey)YTechItemTags.CRUSHED_MATERIALS.get(MaterialType.GALENA)), 1, (TagKey<Item>)((TagKey)YTechItemTags.MOLDS.get(PartType.INGOT)), (Item)((DeferredItem)YTechItems.INGOTS.get(MaterialType.LEAD)).get(), MaterialType.GALENA.meltingTemp, 200, "smelting");
        this.smeltingRecipe(YTechItemTags.UNFIRED_CLAY_BUCKETS, (Item)YTechItems.CLAY_BUCKET.get(), 1000, 200);
        this.smeltingRecipe(YTechItemTags.UNFIRED_DECORATED_POTS, Items.DECORATED_POT, 1000, 200);
        this.smeltingRecipe(YTechItemTags.UNFIRED_FLOWER_POTS, Items.FLOWER_POT, 1000, 200);
        this.smeltingRecipe(YTechItemTags.UNFIRED_AMPHORAE, (Item)YTechItems.AMPHORA.get(), 1000, 200);
        this.smeltingRecipe((TagKey<Item>)Tags.Items.COBBLESTONES_NORMAL, Items.STONE, 1300, 200);
        this.hammeringRecipe(YTechItemTags.IRON_BLOOMS, 4, Items.IRON_INGOT);
        this.registerBlockHitRecipe(Items.FLINT, (TagKey<Item>)Tags.Items.STONES, (Item)YTechItems.SHARP_FLINT.get());
        this.registerBlockHitRecipe((Item)YTechItems.UNLIT_TORCH.get(), YTechItemTags.FIRE_SOURCE, Items.TORCH);
        this.registerBlockHitRecipe((Item)YTechItems.UNLIT_TORCH.get(), YTechItemTags.SOUL_FIRE_SOURCE, Items.SOUL_TORCH);
        this.registerDryingRecipe(Items.BEEF, YTechItems.DRIED_BEEF);
        this.registerDryingRecipe(Items.CHICKEN, YTechItems.DRIED_CHICKEN);
        this.registerDryingRecipe(Items.COD, YTechItems.DRIED_COD);
        this.registerDryingRecipe(Items.KELP, Items.DRIED_KELP, 1200);
        this.registerDryingRecipe(Items.MUTTON, YTechItems.DRIED_MUTTON);
        this.registerDryingRecipe(Items.PORKCHOP, YTechItems.DRIED_PORKCHOP);
        this.registerDryingRecipe(Items.RABBIT, YTechItems.DRIED_RABBIT);
        this.registerDryingRecipe(Items.SALMON, YTechItems.DRIED_SALMON);
        this.registerDryingRecipe(YTechItemTags.VENISON, YTechItems.DRIED_VENISON);
        this.crushingRecipe(YTechItemTags.ANTLERS, Items.BONE_MEAL, 2, Utils.getPath(YTechItems.ANTLER));
        this.crushingRecipe(YTechItemTags.MAMMOTH_TUSKS, Items.BONE_MEAL, 5, Utils.getPath(YTechItems.MAMMOTH_TUSK));
        this.crushingRecipe(YTechItemTags.RHINO_HORNS, Items.BONE_MEAL, 3, Utils.getPath(YTechItems.RHINO_HORN));
        this.potteryRecipe(2, YTechItems.UNFIRED_FLOWER_POT);
        this.potteryRecipe(3, YTechItems.UNFIRED_CLAY_BUCKET);
        this.potteryRecipe(4, YTechItems.UNFIRED_DECORATED_POT);
        this.potteryRecipe(5, YTechItems.UNFIRED_AMPHORA);
        this.wcChestRecipe();
        this.wcFurnaceRecipe();
        this.wcCraftingTableRecipe();
        this.wcStonecutterRecipe();
        this.wcBarrelRecipe();
        this.wcFletchingTableRecipe();
        this.wcCartographyTableRecipe();
        this.wcSmithingTableRecipe();
        this.wcGrindstoneRecipe();
        this.wcLoomRecipe();
        this.wcSmokerRecipe();
        this.wcComposterRecipe();
        this.wcWoodenBoxRecipe();
        this.wcToolRackRecipe();
        this.wcWellPulleyRecipe();
        this.removeVanillaRecipes();
    }

    private void removeVanillaRecipes() {
        this.removeVanillaRecipe(Items.WOODEN_AXE);
        this.removeVanillaRecipe(Items.WOODEN_HOE);
        this.removeVanillaRecipe(Items.WOODEN_PICKAXE);
        this.removeVanillaRecipe(Items.WOODEN_SWORD);
        this.removeVanillaRecipe(Items.STONE_AXE);
        this.removeVanillaRecipe(Items.STONE_PICKAXE);
        this.removeVanillaRecipe(Items.STONE_SHOVEL);
        this.removeVanillaRecipe(Items.STONE_SWORD);
        this.removeVanillaSmeltingBlastingRecipe(Items.COPPER_INGOT, Items.RAW_COPPER);
        this.removeVanillaSmeltingBlastingRecipe(Items.COPPER_INGOT, Items.COPPER_ORE);
        this.removeVanillaSmeltingBlastingRecipe(Items.COPPER_INGOT, Items.DEEPSLATE_COPPER_ORE);
        this.removeVanillaSmeltingBlastingRecipe(Items.GOLD_INGOT, Items.RAW_GOLD);
        this.removeVanillaSmeltingBlastingRecipe(Items.GOLD_INGOT, Items.GOLD_ORE);
        this.removeVanillaSmeltingBlastingRecipe(Items.GOLD_INGOT, Items.DEEPSLATE_GOLD_ORE);
        this.removeVanillaSmeltingBlastingRecipe(Items.GOLD_INGOT, Items.NETHER_GOLD_ORE);
        this.removeVanillaSmeltingBlastingRecipe(Items.IRON_INGOT, Items.RAW_IRON);
        this.removeVanillaSmeltingBlastingRecipe(Items.IRON_INGOT, Items.IRON_ORE);
        this.removeVanillaSmeltingBlastingRecipe(Items.IRON_INGOT, Items.DEEPSLATE_IRON_ORE);
        this.removeVanillaRecipe(Items.GLASS);
        this.removeVanillaRecipe(Items.STONE);
        this.removeVanillaSmeltingBlastingRecipe(Items.STONE, Items.COBBLESTONE);
        this.removeVanillaRecipe(Items.FLOWER_POT);
        this.removeVanillaRecipe(Items.TORCH);
        this.removeVanillaRecipe(Items.SOUL_TORCH);
        this.removeVanillaRecipe(Items.CRAFTING_TABLE);
        this.removeVanillaRecipe(Items.FURNACE);
        this.removeVanillaRecipe(Items.SMOKER);
        this.removeVanillaRecipe(Items.FLETCHING_TABLE);
        this.removeVanillaRecipe(Items.CARTOGRAPHY_TABLE);
        this.removeVanillaRecipe(Items.STONECUTTER);
        this.removeVanillaRecipe(Items.SMITHING_TABLE);
        this.removeVanillaRecipe(Items.GRINDSTONE);
        this.removeVanillaRecipe(Items.LOOM);
        this.removeVanillaRecipe(Items.CHEST);
        this.removeVanillaRecipe(Items.BARREL);
        this.removeVanillaRecipe(Items.COMPOSTER);
        SpecialRecipeBuilder.special(TippedArrowRecipe::new).save(this.output, Utils.mcLoc("decorated_pot_simple").toString());
    }

    private void removeVanillaRecipe(Item item) {
        SpecialRecipeBuilder.special(TippedArrowRecipe::new).save(this.output, Utils.loc(item).toString());
    }

    private void removeVanillaSmeltingBlastingRecipe(Item to, Item from) {
        SpecialRecipeBuilder.special(TippedArrowRecipe::new).save(this.output, Utils.mcLoc(Utils.loc(to).getPath() + "_from_smelting_" + Utils.loc(from).getPath()).toString());
        SpecialRecipeBuilder.special(TippedArrowRecipe::new).save(this.output, Utils.mcLoc(Utils.loc(to).getPath() + "_from_blasting_" + Utils.loc(from).getPath()).toString());
    }

    private void mcSplitBySawRecipe(@NotNull Item input, @NotNull Item result) {
        RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, 3).requires((ItemLike)input).requires(YTechItemTags.SAWS.tag).group(Utils.loc(result).getPath()).unlockedBy(RecipeProvider.getHasName((ItemLike)input), this.has((ItemLike)input)).save(this.output, this.key(result));
    }

    private void mcSplitByChoppingRecipe(@NotNull Item input, @NotNull Item result) {
        ChoppingRecipe.Builder.chopping((HolderGetter<Item>)this.items, (ItemLike)input, YTechItemTags.AXES.tag, 3, result, 2).group(Utils.loc(result).getPath()).unlockedBy(RecipeProvider.getHasName((ItemLike)input), this.has((ItemLike)input)).save(this.output, this.key(result, "chopping"));
    }

    private void mcSplitByAxeRecipe(@NotNull Item input, @NotNull Item result) {
        RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.BUILDING_BLOCKS, (ItemLike)result).requires((ItemLike)input).requires(YTechItemTags.AXES.tag).group(Utils.loc(result).getPath()).unlockedBy(RecipeProvider.getHasName((ItemLike)input), this.has((ItemLike)input)).save(this.output, this.key(Utils.modLoc(result)));
    }

    private void mcSplitByHammerRecipe(@NotNull Item input, @NotNull Item result) {
        RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.BUILDING_BLOCKS, (ItemLike)result).requires((ItemLike)input).requires(YTechItemTags.HAMMERS.tag).unlockedBy(RecipeProvider.getHasName((ItemLike)input), this.has((ItemLike)input)).save(this.output, this.key(result));
    }

    private void mcFenceRecipe(@NotNull Item planks, @NotNull Item result) {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result, (int)2).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('W'), YTechItemTags.SAWS.tag).define(Character.valueOf('P'), (ItemLike)planks).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("H W").pattern("PSP").pattern("PSP").group("wooden_fence").unlockedBy(YTechRecipeProvider.getHasName((ItemLike)Items.STICK), this.has((ItemLike)Items.STICK)).save(this.output, this.key(result));
    }

    private void mcFenceGateRecipe(@NotNull Item planks, @NotNull Item result) {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)result, (int)2).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('W'), YTechItemTags.SAWS.tag).define(Character.valueOf('B'), (TagKey)YTechItemTags.BOLTS.get(MaterialType.WOODEN)).define(Character.valueOf('P'), (ItemLike)planks).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("H W").pattern("BPB").pattern("SPS").group("wooden_fence_gate").unlockedBy(YTechRecipeProvider.getHasName((ItemLike)Items.STICK), this.has((ItemLike)Items.STICK)).save(this.output, this.key(result));
    }

    private void mcDoorRecipe(@NotNull Item planks, @NotNull Item result) {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)result).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('W'), YTechItemTags.SAWS.tag).define(Character.valueOf('B'), (TagKey)YTechItemTags.BOLTS.get(MaterialType.WOODEN)).define(Character.valueOf('P'), (ItemLike)planks).pattern("PPH").pattern("PPB").pattern("PPW").group("wooden_door").unlockedBy(Utils.getHasName(), this.has(ItemTags.PLANKS)).save(this.output, this.key(result));
    }

    private void mcTrapdoorRecipe(@NotNull Item planks, @NotNull Item result) {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)result, (int)2).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('W'), YTechItemTags.SAWS.tag).define(Character.valueOf('B'), (TagKey)YTechItemTags.BOLTS.get(MaterialType.WOODEN)).define(Character.valueOf('P'), (ItemLike)planks).pattern("HBW").pattern("PPP").pattern("PPP").group("wooden_trapdoor").unlockedBy(Utils.getHasName(), this.has(ItemTags.PLANKS)).save(this.output, this.key(result));
    }

    private void mcPressurePlateRecipe(@NotNull Item planks, @NotNull Item result) {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)result).define(Character.valueOf('W'), YTechItemTags.SAWS.tag).define(Character.valueOf('B'), (TagKey)YTechItemTags.BOLTS.get(MaterialType.WOODEN)).define(Character.valueOf('P'), (ItemLike)planks).pattern(" W ").pattern("PPP").pattern("BBB").group("wooden_pressure_plate").unlockedBy(Utils.getHasName(), this.has(ItemTags.PLANKS)).save(this.output, this.key(result));
    }

    private void mcButtonRecipe(@NotNull Item planks, @NotNull Item result) {
        RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.REDSTONE, (ItemLike)result).requires(YTechItemTags.SAWS.tag).requires((TagKey)YTechItemTags.BOLTS.get(MaterialType.WOODEN)).requires((ItemLike)planks).group("wooden_button").unlockedBy(Utils.getHasName(), this.has(ItemTags.PLANKS)).save(this.output, this.key(result));
    }

    private void mcStairsRecipe(@NotNull Item planks, @NotNull Item slab, @NotNull Item result) {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)2).define(Character.valueOf('W'), YTechItemTags.SAWS.tag).define(Character.valueOf('B'), (TagKey)YTechItemTags.BOLTS.get(MaterialType.WOODEN)).define(Character.valueOf('P'), (ItemLike)planks).define(Character.valueOf('S'), (ItemLike)slab).pattern("PW").pattern("BB").pattern("SS").group("wooden_stairs").unlockedBy(Utils.getHasName(), this.has(ItemTags.PLANKS)).save(this.output, this.key(result));
    }

    private void mcBedRecipe(@NotNull Item wool, @NotNull Item result) {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('S'), YTechItemTags.SAWS.tag).define(Character.valueOf('W'), (ItemLike)wool).define(Character.valueOf('P'), ItemTags.WOODEN_SLABS).pattern("H S").pattern("WWW").pattern("PPP").group("bed").unlockedBy(Utils.getHasName(), this.has(ItemTags.WOOL)).save(this.output, this.key(result));
    }

    private void mcBoatRecipe(@NotNull Item planks, @NotNull Item result) {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)result).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('S'), YTechItemTags.SAWS.tag).define(Character.valueOf('F'), YTechItemTags.FILES.tag).define(Character.valueOf('I'), YTechItemTags.RODS.tag).define(Character.valueOf('P'), (ItemLike)planks).pattern("HFS").pattern("PIP").pattern("PPP").group("boat").unlockedBy(Utils.getHasName(), this.has(ItemTags.PLANKS)).save(this.output, this.key(result));
    }

    private void mcHorseArmorRecipe(@NotNull Item item, @NotNull Item result) {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)result).define(Character.valueOf('#'), YTechItemTags.KNIVES.tag).define(Character.valueOf('S'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('L'), (ItemLike)item).define(Character.valueOf('X'), (ItemLike)Items.SADDLE).pattern("L#L").pattern("LXL").pattern("LSL").unlockedBy(YTechRecipeProvider.getHasName((ItemLike)Items.LEATHER), this.has((ItemLike)Items.LEATHER)).save(this.output, this.key(result));
    }

    private void mcHorseArmorRecipe(@NotNull MaterialType material, @NotNull Item result) {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)result).define(Character.valueOf('#'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('S'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('L'), (TagKey)YTechItemTags.PLATES.get(material)).define(Character.valueOf('X'), (ItemLike)Items.SADDLE).pattern("L#L").pattern("LXL").pattern("LSL").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.INGOTS.get(material))).save(this.output, this.key(result));
    }

    private void mcSoulCampfireRecipe() {
        ShapedRecipeBuilder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Items.SOUL_CAMPFIRE).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('L'), ItemTags.LOGS).define(Character.valueOf('T'), (ItemLike)Items.SOUL_TORCH).pattern(" S ").pattern("STS").pattern("LLL").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.SOUL_TORCH), this.has((ItemLike)Items.SOUL_TORCH)).save(this.output, this.key(Items.SOUL_CAMPFIRE));
    }

    private void mcMudRecipe() {
        ShapelessRecipeBuilder.shapeless((HolderGetter)this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Items.MUD, (int)3).requires((ItemLike)Items.DIRT, 3).requires(YTechItemTags.WATER_BUCKETS).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.DIRT), this.has((ItemLike)Items.DIRT)).save(this.output, this.key(Items.MUD, true));
    }

    private void mcCampfireRecipe() {
        ShapedRecipeBuilder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Items.CAMPFIRE).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('L'), ItemTags.LOGS).define(Character.valueOf('T'), (ItemLike)Items.TORCH).pattern(" S ").pattern("STS").pattern("LLL").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.TORCH), this.has((ItemLike)Items.TORCH)).save(this.output, this.key(Items.CAMPFIRE));
    }

    private void mcCrossbowRecipe() {
        ShapedRecipeBuilder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)Items.CROSSBOW).define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('$'), (ItemLike)Items.TRIPWIRE_HOOK).define(Character.valueOf('&'), (TagKey)YTechItemTags.RODS.get(MaterialType.IRON)).define(Character.valueOf('~'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('S'), ItemTags.WOODEN_SLABS).define(Character.valueOf('F'), YTechItemTags.KNIVES.tag).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).pattern("#&#").pattern("~$~").pattern("FSH").unlockedBy(Utils.getHasName(), this.has((ItemLike)Items.TRIPWIRE_HOOK)).save(this.output, this.key(Items.CROSSBOW));
    }

    private void mcTripwireHookRecipe() {
        ShapedRecipeBuilder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Items.TRIPWIRE_HOOK).define(Character.valueOf('I'), (TagKey)YTechItemTags.RODS.get(MaterialType.IRON)).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('L'), ItemTags.LOGS).pattern("IH").pattern("S ").pattern("L ").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.INGOTS.get(MaterialType.IRON))).save(this.output, this.key(Items.TRIPWIRE_HOOK));
    }

    private void mcCakeRecipe() {
        ShapedRecipeBuilder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.CAKE).define(Character.valueOf('A'), YTechItemTags.FLOURS).define(Character.valueOf('B'), (ItemLike)Items.SUGAR).define(Character.valueOf('C'), (ItemLike)Items.MILK_BUCKET).define(Character.valueOf('D'), (ItemLike)Items.EGG).pattern("CCC").pattern("BDB").pattern("AAA").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.FLOURS)).save(this.output, this.key(Items.CAKE));
    }

    private void mcCookieRecipe() {
        ShapedRecipeBuilder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.COOKIE, (int)8).define(Character.valueOf('#'), YTechItemTags.FLOURS).define(Character.valueOf('X'), (ItemLike)Items.COCOA_BEANS).pattern("#X#").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.FLOURS)).save(this.output, this.key(Items.COOKIE));
    }

    private void mcBoneMealRecipe() {
        RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.MISC, (ItemLike)Items.BONE_MEAL).requires((ItemLike)Items.BONE).requires(YTechItemTags.MORTAR_AND_PESTLES.tag).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.BONE), this.has((ItemLike)Items.BONE)).save(this.output, this.key(Items.BONE_MEAL));
        MillingRecipe.Builder.milling((ItemLike)Items.BONE, Items.BONE_MEAL, 2).bonusChance(0.2f).unlockedBy(Utils.getHasName(), this.has((ItemLike)Items.BONE)).save(this.output, this.key(Items.BONE_MEAL, "milling"));
    }

    private void mcSaddleRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.SADDLE).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).define(Character.valueOf('S'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('I'), (TagKey)YTechItemTags.RODS.get(MaterialType.IRON)).define(Character.valueOf('H'), YTechItemTags.BONE_NEEDLES).define(Character.valueOf('K'), YTechItemTags.KNIVES.tag).pattern("LLL").pattern("LSL").pattern("HIK").unlockedBy(Utils.getHasName(), this.has((ItemLike)Items.LEATHER)).save(this.output, this.key(Items.SADDLE));
    }

    private void mcLeadRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)Items.LEAD).define(Character.valueOf('L'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('S'), Tags.Items.STRINGS).pattern("LL ").pattern("LS ").pattern("  L").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.LEATHER_STRIPS)).save(this.output, this.key(Items.LEAD));
    }

    private void mcFishingRodRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)Items.FISHING_ROD).define(Character.valueOf('B'), YTechItemTags.BOLTS.tag).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('T'), Tags.Items.STRINGS).pattern("  S").pattern(" ST").pattern("S B").unlockedBy(Utils.getHasName(), this.has((ItemLike)Items.STICK)).save(this.output, this.key(Items.FISHING_ROD));
    }

    private void mcSoulLanternRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.SOUL_LANTERN).define(Character.valueOf('I'), YTechItemTags.RODS.tag).define(Character.valueOf('P'), YTechItemTags.PLATES.tag).define(Character.valueOf('T'), (ItemLike)Items.SOUL_TORCH).pattern(" P ").pattern("ITI").pattern(" P ").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.INGOTS.get(MaterialType.IRON))).save(this.output, this.key(Items.SOUL_LANTERN));
    }

    private void mcLanternRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.LANTERN).define(Character.valueOf('I'), YTechItemTags.RODS.tag).define(Character.valueOf('P'), YTechItemTags.PLATES.tag).define(Character.valueOf('T'), (ItemLike)Items.TORCH).pattern(" P ").pattern("ITI").pattern(" P ").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.INGOTS.get(MaterialType.IRON))).save(this.output, this.key(Items.LANTERN));
    }

    private void mcChainRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Items.CHAIN).define(Character.valueOf('W'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('I'), (TagKey)YTechItemTags.RODS.get(MaterialType.IRON)).pattern("IW").pattern("I ").pattern("I ").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.INGOTS.get(MaterialType.IRON))).save(this.output, this.key(Items.CHAIN));
    }

    private void mcLightWeightedPressurePlateRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Items.LIGHT_WEIGHTED_PRESSURE_PLATE).define(Character.valueOf('W'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('B'), (TagKey)YTechItemTags.BOLTS.get(MaterialType.GOLD)).define(Character.valueOf('P'), (TagKey)YTechItemTags.PLATES.get(MaterialType.GOLD)).pattern(" W ").pattern("PPP").pattern("BBB").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.INGOTS.get(MaterialType.GOLD))).save(this.output, this.key(Items.LIGHT_WEIGHTED_PRESSURE_PLATE));
    }

    private void mcHeavyWeightedPressurePlateRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Items.HEAVY_WEIGHTED_PRESSURE_PLATE).define(Character.valueOf('W'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('B'), (TagKey)YTechItemTags.BOLTS.get(MaterialType.IRON)).define(Character.valueOf('P'), (TagKey)YTechItemTags.PLATES.get(MaterialType.IRON)).pattern(" W ").pattern("PPP").pattern("BBB").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.INGOTS.get(MaterialType.IRON))).save(this.output, this.key(Items.HEAVY_WEIGHTED_PRESSURE_PLATE));
    }

    private void mcIronTrapdoorRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Items.IRON_TRAPDOOR, (int)2).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('B'), (TagKey)YTechItemTags.BOLTS.get(MaterialType.IRON)).define(Character.valueOf('P'), (TagKey)YTechItemTags.PLATES.get(MaterialType.IRON)).pattern("HB ").pattern("PPP").pattern("PPP").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.INGOTS.get(MaterialType.IRON))).save(this.output, this.key(Items.IRON_TRAPDOOR));
    }

    private void mcIronDoorRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Items.IRON_DOOR).define(Character.valueOf('C'), (TagKey)YTechItemTags.PLATES.get(MaterialType.IRON)).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('B'), (TagKey)YTechItemTags.BOLTS.get(MaterialType.IRON)).pattern("CCH").pattern("CCB").pattern("CC ").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.INGOTS.get(MaterialType.IRON))).save(this.output, this.key(Items.IRON_DOOR));
    }

    private void mcIronBarsRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Items.IRON_BARS).define(Character.valueOf('C'), (TagKey)YTechItemTags.RODS.get(MaterialType.IRON)).pattern("CCC").pattern("CCC").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.INGOTS.get(MaterialType.IRON))).save(this.output, this.key(Items.IRON_BARS));
    }

    private void mcBowlRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BOWL).define(Character.valueOf('#'), YTechItemTags.KNIVES.tag).define(Character.valueOf('P'), ItemTags.PLANKS).pattern("P#P").pattern(" P ").unlockedBy(Utils.getHasName(), this.has(ItemTags.PLANKS)).save(this.output, this.key(Items.BOWL));
    }

    private void mcBowRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)Items.BOW).define(Character.valueOf('#'), YTechItemTags.KNIVES.tag).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('W'), Tags.Items.STRINGS).pattern(" SW").pattern("S#W").pattern(" SW").unlockedBy(YTechRecipeProvider.getHasName((ItemLike)Items.STICK), this.has((ItemLike)Items.STICK)).save(this.output, this.key(Items.BOW));
    }

    private void smeltingRecipe(@NotNull TagKey<Item> input, @NotNull Item result, int temperature, int smeltingTime) {
        SmeltingRecipe.Builder.smelting((HolderGetter<Item>)this.items, input, temperature, smeltingTime, result).unlockedBy(Utils.getHasName(), this.has(input)).save(this.output, this.key(result, "smelting"));
    }

    private void smeltingRecipe(@NotNull TagKey<Item> input, int inputCount, TagKey<Item> mold, @NotNull Item result, int temperature, int smeltingTime, String from) {
        SmeltingRecipe.Builder.smelting((HolderGetter<Item>)this.items, input, inputCount, mold, temperature, smeltingTime, result).unlockedBy(Utils.getHasName(), this.has(input)).save(this.output, this.key(result, from));
    }

    private void registerBlockHitRecipe(@NotNull Item input, @NotNull TagKey<Item> block, @NotNull Item result) {
        BlockHitRecipe.Builder.blockUse((HolderGetter<Item>)this.items, (ItemLike)input, block, result).unlockedBy(Utils.getHasName(), this.has((ItemLike)input)).save(this.output, this.key(Utils.modLoc(result)));
    }

    private void mcCookingRecipe(@NotNull RecipeCategory category, @NotNull TagKey<Item> input, @NotNull Item result, float xp, int cookingTime) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((HolderSet)this.items.getOrThrow(input)), (RecipeCategory)category, (ItemLike)result, (float)xp, (int)cookingTime).unlockedBy(Utils.getHasName(), this.has(input)).save(this.output, this.key(result));
    }

    private void alloyingRecipe(@NotNull TagKey<Item> input1, int count1, @NotNull TagKey<Item> input2, int count2, @NotNull Item result, int count, int temp, int smeltingTime) {
        AlloyingRecipe.Builder.alloying((HolderGetter<Item>)this.items, input1, count1, input2, count2, temp, smeltingTime, result, count).unlockedBy(Utils.getHasName(), this.has(input1)).save(this.output, this.key(result, "alloying"));
    }

    private void registerDryingRecipe(@NotNull Item input, @NotNull Item result, int dryingTime) {
        DryingRecipe.Builder.drying((ItemLike)input, dryingTime, result).unlockedBy(RecipeProvider.getHasName((ItemLike)input), this.has((ItemLike)input)).save(this.output, this.key(result));
    }

    private void hammeringRecipe(@NotNull TagKey<Item> input, int hitCount, @NotNull Item result) {
        HammeringRecipe.Builder.hammering((HolderGetter<Item>)this.items, input, YTechItemTags.HAMMERS.tag, hitCount, result).unlockedBy(Utils.getHasName(), this.has(input)).save(this.output, this.key(result));
    }

    private void crushingRecipe(@NotNull TagKey<Item> input, @NotNull Item result, int count, String suffix) {
        RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.MISC, (ItemLike)result, count).requires(input).requires(YTechItemTags.MORTAR_AND_PESTLES.tag).unlockedBy(Utils.getHasName(), this.has(input)).save(this.output, this.key(result, suffix));
        MillingRecipe.Builder.milling((HolderGetter<Item>)this.items, input, result, count + (int)Math.ceil((double)count / 2.0)).bonusChance(0.2f).unlockedBy(Utils.getHasName(), this.has(input)).save(this.output, this.key(result, suffix + "_from_milling"));
    }

    private void potteryRecipe(int count, DeferredItem<Item> result) {
        PotteryRecipe.Builder.pottery(count, (Item)result.get()).unlockedBy(Utils.getHasName(), this.has((ItemLike)Items.CLAY_BALL)).save(this.output, this.key(result));
    }

    private void registerGrassTwineRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)YTechItems.GRASS_TWINE.get())).define(Character.valueOf('#'), YTechItemTags.GRASS_FIBERS).pattern("##").pattern("##").unlockedBy(Utils.getHasItem(YTechItems.GRASS_FIBERS), this.has(YTechItemTags.GRASS_FIBERS)).save(this.output, this.key(YTechItems.GRASS_TWINE));
    }

    private void registerBrickMoldRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)YTechItems.BRICK_MOLD.get())).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(MaterialType.WOODEN)).define(Character.valueOf('I'), (TagKey)YTechItemTags.BOLTS.get(MaterialType.WOODEN)).pattern("I#I").pattern("###").pattern("I#I").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.PLATES.get(MaterialType.WOODEN))).save(this.output, this.key(YTechItems.BRICK_MOLD));
    }

    private void registerRawHideRecipe() {
        TanningRecipe.Builder.tanning((HolderGetter<Item>)this.items, YTechItemTags.RAW_HIDES, YTechItemTags.SHARP_FLINTS, 5, Items.LEATHER).unlockedBy(Utils.getHasItem(YTechItems.RAW_HIDE), this.has(YTechItemTags.RAW_HIDES)).save(this.output, this.key(YTechItems.RAW_HIDE));
    }

    private void registerLeatherStripsRecipe() {
        RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.MISC, (ItemLike)YTechItems.LEATHER_STRIPS.get(), 4).requires((ItemLike)Items.LEATHER).requires(YTechItemTags.SHARP_FLINTS).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.LEATHER), this.has((ItemLike)Items.LEATHER)).save(this.output, this.key(YTechItems.LEATHER_STRIPS));
    }

    private void registerIronBloomRecipe() {
        AlloyingRecipe.Builder.alloying((HolderGetter<Item>)this.items, (TagKey<Item>)((TagKey)YTechItemTags.CRUSHED_MATERIALS.get(MaterialType.IRON)), 1, (ItemLike)Items.CHARCOAL, 1, 1250, 200, (Item)YTechItems.IRON_BLOOM.get(), 1).unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.CRUSHED_MATERIALS.get(MaterialType.IRON))).save(this.output, this.key(YTechItems.IRON_BLOOM));
    }

    private void registerUnfiredBrickRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)YTechItems.UNFIRED_BRICK.get()), (int)8).define(Character.valueOf('#'), YTechItemTags.BRICK_MOLDS).define(Character.valueOf('B'), (ItemLike)Items.CLAY_BALL).pattern("BBB").pattern("B#B").pattern("BBB").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.CLAY_BALL), this.has((ItemLike)Items.CLAY_BALL)).save(this.output, this.key(YTechItems.UNFIRED_BRICK));
    }

    private void registerUnlitTorchRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)YTechItems.UNLIT_TORCH.get()), (int)4).define(Character.valueOf('#'), ItemTags.COALS).define(Character.valueOf('B'), (ItemLike)Items.STICK).pattern("#").pattern("B").unlockedBy(Utils.getHasName(), this.has(ItemTags.COALS)).save(this.output, this.key(YTechItems.UNLIT_TORCH));
    }

    private void registerVenusOfHohleFelsRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)YTechItems.VENUS_OF_HOHLE_FELS.get())).define(Character.valueOf('T'), YTechItemTags.MAMMOTH_TUSKS).define(Character.valueOf('#'), YTechItemTags.SHARP_FLINTS).pattern("T#").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.MAMMOTH_TUSKS)).save(this.output, this.key(YTechItems.VENUS_OF_HOHLE_FELS));
    }

    private void registerLionManRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)YTechItems.LION_MAN.get())).define(Character.valueOf('T'), YTechItemTags.MAMMOTH_TUSKS).define(Character.valueOf('#'), YTechItemTags.SHARP_FLINTS).pattern("T ").pattern(" #").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.MAMMOTH_TUSKS)).save(this.output, this.key(YTechItems.LION_MAN));
    }

    private void registerWildHorseRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)YTechItems.WILD_HORSE.get())).define(Character.valueOf('T'), YTechItemTags.MAMMOTH_TUSKS).define(Character.valueOf('#'), YTechItemTags.SHARP_FLINTS).pattern("T").pattern("#").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.MAMMOTH_TUSKS)).save(this.output, this.key(YTechItems.WILD_HORSE));
    }

    private void registerShellBeadsRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)YTechItems.SHELL_BEADS.get())).define(Character.valueOf('S'), (ItemLike)Items.NAUTILUS_SHELL).define(Character.valueOf('L'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('F'), YTechItemTags.SHARP_FLINTS).pattern("FL ").pattern("SSS").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.LEATHER_STRIPS)).save(this.output, this.key(YTechItems.SHELL_BEADS));
    }

    private void registerChloriteBraceletRecipe() {
        RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.MISC, (ItemLike)YTechItems.CHLORITE_BRACELET.get()).requires(YTechItemTags.PEBBLES).requires(YTechItemTags.SHARP_FLINTS).unlockedBy(Utils.getHasName(), this.has(YTechItemTags.PEBBLES)).save(this.output, this.key(YTechItems.CHLORITE_BRACELET));
    }

    private void registerDryingRecipe(Item rawMeat, DeferredItem<Item> result) {
        DryingRecipe.Builder.drying((ItemLike)rawMeat, 1200, (Item)result.get()).unlockedBy(RecipeProvider.getHasName((ItemLike)rawMeat), this.has((ItemLike)rawMeat)).save(this.output, this.key(result.getId()));
    }

    private void registerDryingRecipe(TagKey<Item> rawMeat, DeferredItem<Item> result) {
        DryingRecipe.Builder.drying((HolderGetter<Item>)this.items, rawMeat, 1200, (Item)result.get()).unlockedBy(Utils.getHasItem(rawMeat), this.has(rawMeat)).save(this.output, this.key(result.getId()));
    }

    private void registerBasketRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)YTechItems.BASKET.get())).define(Character.valueOf('#'), YTechItemTags.GRASS_TWINES).define(Character.valueOf('B'), YTechItemTags.BONE_NEEDLES).pattern(" # ").pattern("#B#").pattern("###").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.GRASS_TWINES)).save(this.output, this.key(YTechItems.BASKET));
    }

    private void registerBeeswaxRecipe() {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike)Items.HONEYCOMB), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)YTechItems.BEESWAX.get()), (float)0.5f, (int)100).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.CLAY_BALL), this.has((ItemLike)Items.CLAY_BALL)).save(this.output, this.key(YTechItems.BEESWAX));
    }

    private void registerBoneNeedleRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)YTechItems.BONE_NEEDLE.get())).define(Character.valueOf('T'), Tags.Items.BONES).define(Character.valueOf('#'), YTechItemTags.SHARP_FLINTS).pattern("#T").unlockedBy(Utils.getHasName(), this.has(Tags.Items.BONES)).save(this.output, this.key(YTechItems.BONE_NEEDLE));
    }

    private void registerKnifeRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        if (material == MaterialType.FLINT) {
            RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.COMBAT, (ItemLike)item.get()).requires((ItemLike)Items.STICK).requires((ItemLike)Items.FLINT).requires(YTechItemTags.LEATHER_STRIPS).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.FLINT), this.has((ItemLike)Items.FLINT)).save(this.output, this.key(item));
        } else {
            RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('P'), (TagKey)YTechItemTags.PLATES.get(material)).define(Character.valueOf('F'), YTechItemTags.FILES.tag).pattern("FP").pattern("S ").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.PLATES.get(material))).save(this.output, this.key(item));
        }
    }

    private void registerCookedVenisonRecipe() {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((HolderSet)this.items.getOrThrow(YTechItemTags.VENISON)), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)YTechItems.COOKED_VENISON.get()), (float)0.35f, (int)200).unlockedBy(Utils.getHasName(), this.has(YTechItemTags.VENISON)).save(this.output, this.key(YTechItems.COOKED_VENISON));
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((HolderSet)this.items.getOrThrow(YTechItemTags.VENISON)), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)YTechItems.COOKED_VENISON.get()), (float)0.35f, (int)600).unlockedBy(Utils.getHasName(), this.has(YTechItemTags.VENISON)).save(this.output, this.key(YTechItems.COOKED_VENISON, "campfire"));
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((HolderSet)this.items.getOrThrow(YTechItemTags.VENISON)), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)YTechItems.COOKED_VENISON.get()), (float)0.35f, (int)100).unlockedBy(Utils.getHasName(), this.has(YTechItemTags.VENISON)).save(this.output, this.key(YTechItems.COOKED_VENISON, "smoker"));
    }

    private void registerDiviningRodRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)YTechItems.DIVINING_ROD.get())).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('T'), YTechItemTags.GRASS_TWINES).define(Character.valueOf('F'), YTechItemTags.SHARP_FLINTS).pattern("SS").pattern("TF").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.SHARP_FLINTS)).save(this.output, this.key(YTechItems.DIVINING_ROD));
    }

    private void registerFlourRecipe() {
        RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.MISC, (ItemLike)YTechItems.FLOUR.get()).requires(Tags.Items.CROPS_WHEAT).requires(YTechItemTags.MORTAR_AND_PESTLES.tag).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.WHEAT), this.has(Tags.Items.CROPS_WHEAT)).save(this.output, this.key(YTechItems.FLOUR));
        MillingRecipe.Builder.milling((HolderGetter<Item>)this.items, (TagKey<Item>)Tags.Items.CROPS_WHEAT, (Item)YTechItems.FLOUR.get(), 2).bonusChance(0.5f).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.WHEAT), this.has(Tags.Items.CROPS_WHEAT)).save(this.output, this.key(YTechItems.FLOUR, "milling"));
    }

    private void registerBreadDoughRecipe() {
        RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.MISC, (ItemLike)YTechItems.BREAD_DOUGH.get()).requires(YTechItemTags.FLOURS).requires(YTechItemTags.FLOURS).requires(YTechItemTags.FLOURS).requires(YTechItemTags.WATER_BUCKETS).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.WHEAT), this.has(Tags.Items.CROPS_WHEAT)).save(this.output, this.key(YTechItems.BREAD_DOUGH));
    }

    public void registerPatternRecipe(@NotNull DeferredItem<Item> item, PartType partType) {
        switch (partType) {
            case AXE_HEAD: {
                RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('P'), YTechItemTags.BEESWAXES).define(Character.valueOf('#'), YTechItemTags.KNIVES.tag).pattern("#").pattern("P").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.HONEYCOMB), this.has((ItemLike)Items.HONEYCOMB)).save(this.output, this.key(item));
                break;
            }
            case HAMMER_HEAD: {
                RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('P'), YTechItemTags.BEESWAXES).define(Character.valueOf('#'), YTechItemTags.KNIVES.tag).pattern(" #").pattern("P ").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.HONEYCOMB), this.has((ItemLike)Items.HONEYCOMB)).save(this.output, this.key(item));
                break;
            }
            case PICKAXE_HEAD: {
                RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('P'), YTechItemTags.BEESWAXES).define(Character.valueOf('#'), YTechItemTags.KNIVES.tag).pattern("P#").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.HONEYCOMB), this.has((ItemLike)Items.HONEYCOMB)).save(this.output, this.key(item));
                break;
            }
            case SWORD_BLADE: {
                RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('P'), YTechItemTags.BEESWAXES).define(Character.valueOf('#'), YTechItemTags.KNIVES.tag).pattern("P ").pattern(" #").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.HONEYCOMB), this.has((ItemLike)Items.HONEYCOMB)).save(this.output, this.key(item));
                break;
            }
            case INGOT: {
                RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('P'), YTechItemTags.BEESWAXES).define(Character.valueOf('#'), YTechItemTags.KNIVES.tag).pattern("P").pattern("#").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.HONEYCOMB), this.has((ItemLike)Items.HONEYCOMB)).save(this.output, this.key(item));
                break;
            }
            default: {
                throw new IllegalArgumentException("Missing recipe");
            }
        }
    }

    public void registerSandMoldRecipe(@NotNull DeferredItem<Item> item, PartType partType) {
        if (partType == PartType.INGOT) {
            RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.MISC, (ItemLike)item.get()).requires(ItemTags.SAND).requires(YTechItemTags.INGOTS.tag).unlockedBy(Utils.getHasName(), this.has(ItemTags.SAND)).save(this.output, this.key(item));
        } else {
            RemainingPartShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.MISC, (ItemLike)item.get()).requires((TagKey<Item>)ItemTags.SAND).requires(YTechItemTags.PARTS.getSubType(partType)).unlockedBy(Utils.getHasName(), this.has(ItemTags.SAND)).save(this.output, this.key(item));
        }
    }

    public void registerUnfiredMoldRecipe(@NotNull DeferredItem<Item> item, PartType partType) {
        ShapelessRecipeBuilder.shapeless((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)item.get())).requires((ItemLike)Items.CLAY).requires((TagKey)YTechItemTags.PATTERNS.get(partType)).unlockedBy(YTechRecipeProvider.getHasName((ItemLike)Items.CLAY), this.has((ItemLike)Items.CLAY)).save(this.output, this.key(item));
    }

    public void registerArrowRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('F'), (ItemLike)Items.FEATHER).define(Character.valueOf('#'), (TagKey)YTechItemTags.BOLTS.get(material)).pattern("#").pattern("S").pattern("F").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.BOLTS.get(material))).save(this.output, this.key(item));
    }

    private void registerAxeRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        switch (material) {
            case FLINT: {
                RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.TOOLS, (ItemLike)item.get()).requires((ItemLike)Items.STICK).requires((ItemLike)Items.FLINT).requires(YTechItemTags.GRASS_TWINES).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.STICK), this.has((ItemLike)Items.STICK)).save(this.output, this.key(item));
                break;
            }
            case IRON: {
                RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(material)).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).pattern("##H").pattern("#S ").pattern(" S ").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.PLATES.get(material))).save(this.output, this.key(item));
                break;
            }
            default: {
                RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.TOOLS, (ItemLike)item.get()).requires((ItemLike)Items.STICK).requires(YTechItemTags.PARTS.get(material, PartType.AXE_HEAD)).requires(YTechItemTags.HAMMERS.tag).unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.PLATES.get(material))).save(this.output, this.key(item));
            }
        }
    }

    private void registerBoltRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        if (material == MaterialType.WOODEN) {
            RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.MISC, (ItemLike)((DeferredItem)YTechItems.BOLTS.get(MaterialType.WOODEN)).get()).requires((ItemLike)Items.STICK).requires(YTechItemTags.AXES.tag).group(Utils.getPath((DeferredHolder)YTechItems.BOLTS.get(MaterialType.WOODEN))).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.STICK), this.has((ItemLike)Items.STICK)).save(this.output, this.key((DeferredItem<Item>)((DeferredItem)YTechItems.BOLTS.get(MaterialType.WOODEN)), "axe"));
            RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.MISC, (ItemLike)((DeferredItem)YTechItems.BOLTS.get(MaterialType.WOODEN)).get(), 2).requires((ItemLike)Items.STICK).requires(YTechItemTags.SAWS.tag).group(Utils.getPath((DeferredHolder)YTechItems.BOLTS.get(MaterialType.WOODEN))).unlockedBy(RecipeProvider.getHasName((ItemLike)Items.STICK), this.has((ItemLike)Items.STICK)).save(this.output, this.key((DeferredItem<Item>)((DeferredItem)YTechItems.BOLTS.get(MaterialType.WOODEN)), "saw"));
        } else {
            RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)item.get()), (int)2).define(Character.valueOf('#'), (TagKey)YTechItemTags.RODS.get(material)).define(Character.valueOf('S'), YTechItemTags.SAWS.tag).pattern("# ").pattern(" S").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.RODS.get(material))).save(this.output, this.key(item));
        }
    }

    public void registerBootsRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        if (material == MaterialType.LEATHER) {
            RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('#'), YTechItemTags.BONE_NEEDLES).define(Character.valueOf('S'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).pattern(" # ").pattern("LSL").pattern("LSL").unlockedBy(YTechRecipeProvider.getHasName((ItemLike)Items.LEATHER), this.has((ItemLike)Items.LEATHER)).save(this.output, this.key(item));
        } else {
            RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(material)).pattern("#H#").pattern("# #").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.PLATES.get(material))).save(this.output, this.key(item));
        }
    }

    public void registerChestplateRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        if (material == MaterialType.LEATHER) {
            RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('#'), YTechItemTags.BONE_NEEDLES).define(Character.valueOf('S'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).pattern("L#L").pattern("LSL").pattern("LLL").unlockedBy(YTechRecipeProvider.getHasName((ItemLike)Items.LEATHER), this.has((ItemLike)Items.LEATHER)).save(this.output, this.key(item));
        } else {
            RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(material)).pattern("#H#").pattern("###").pattern("###").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.PLATES.get(material))).save(this.output, this.key(item));
        }
    }

    public void registerCrushedRawMaterialRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.MISC, (ItemLike)item.get()).requires((TagKey)YTechItemTags.RAW_MATERIALS.get(material)).requires(YTechItemTags.MORTAR_AND_PESTLES.tag).unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.RAW_MATERIALS.get(material))).save(this.output, this.key(item));
        MillingRecipe.Builder.milling((HolderGetter<Item>)this.items, (TagKey<Item>)((TagKey)YTechItemTags.RAW_MATERIALS.get(material)), (Item)item.get(), 1).bonusChance(0.5f).unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.RAW_MATERIALS.get(material))).save(this.output, this.key(item, "milling"));
    }

    public void registerFileRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(material)).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("#").pattern("S").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.PLATES.get(material))).save(this.output, this.key(item));
    }

    public void registerHammerRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        switch (material) {
            case STONE: {
                RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('T'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('#'), YTechItemTags.PEBBLES).pattern(" #T").pattern(" S#").pattern("S  ").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.LEATHER_STRIPS)).save(this.output, this.key(item));
                break;
            }
            case IRON: {
                RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('#'), (TagKey)YTechItemTags.STORAGE_BLOCKS.get(material)).pattern(" # ").pattern(" S#").pattern("S  ").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.STORAGE_BLOCKS.get(material))).save(this.output, this.key(item));
                break;
            }
            default: {
                RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.COMBAT, (ItemLike)item.get()).requires((ItemLike)Items.STICK).requires(YTechItemTags.PARTS.get(material, PartType.HAMMER_HEAD)).requires(YTechItemTags.HAMMERS.tag).unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.INGOTS.get(material))).save(this.output, this.key(item));
            }
        }
    }

    public void registerHelmetRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        if (material == MaterialType.LEATHER) {
            RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('#'), YTechItemTags.BONE_NEEDLES).define(Character.valueOf('S'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).pattern(" # ").pattern("LLL").pattern("LSL").unlockedBy(YTechRecipeProvider.getHasName((ItemLike)Items.LEATHER), this.has((ItemLike)Items.LEATHER)).save(this.output, this.key(item));
        } else {
            RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(material)).pattern("###").pattern("#H#").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.PLATES.get(material))).save(this.output, this.key(item));
        }
    }

    private void registerHoeRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(material)).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).pattern("##H").pattern(" S ").pattern(" S ").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.PLATES.get(material))).save(this.output, this.key(item));
    }

    public void registerIngotRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        if (!MaterialType.VANILLA_METALS.contains(material)) {
            RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.MISC, (ItemLike)item.get(), 9).requires((TagKey)YTechItemTags.STORAGE_BLOCKS.get(material)).unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.STORAGE_BLOCKS.get(material))).save(this.output, this.key(item));
        }
    }

    public void registerLeggingsRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        if (material == MaterialType.LEATHER) {
            RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('#'), YTechItemTags.BONE_NEEDLES).define(Character.valueOf('S'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).pattern("LLL").pattern("L#L").pattern("LSL").unlockedBy(YTechRecipeProvider.getHasName((ItemLike)Items.LEATHER), this.has((ItemLike)Items.LEATHER)).save(this.output, this.key(item));
        } else {
            RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(material)).pattern("###").pattern("#H#").pattern("# #").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.PLATES.get(material))).save(this.output, this.key(item));
        }
    }

    public void registerMeshRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        if (material == MaterialType.TWINE) {
            RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('T'), YTechItemTags.GRASS_TWINES).pattern("TTT").pattern("TTT").pattern("TTT").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.GRASS_TWINES)).save(this.output, this.key(item));
        } else {
            RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('R'), (TagKey)YTechItemTags.RODS.get(material)).pattern("RRR").pattern("RRR").pattern("RRR").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.RODS.get(material))).save(this.output, this.key(item));
        }
    }

    public void registerMortarAndPestleRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        if (material == MaterialType.STONE) {
            RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('P'), YTechItemTags.PEBBLES).define(Character.valueOf('#'), Tags.Items.COBBLESTONES).pattern(" P ").pattern("# #").pattern(" # ").unlockedBy(Utils.getHasName(), this.has(Tags.Items.STONES)).save(this.output, this.key(item));
        } else {
            RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('P'), YTechItemTags.PEBBLES).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(material)).pattern(" P ").pattern("# #").pattern(" # ").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.INGOTS.get(material))).save(this.output, this.key(item));
        }
    }

    private void registerPickaxeRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        switch (material) {
            case ANTLER: {
                RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.TOOLS, (ItemLike)item.get()).requires(YTechItemTags.ANTLERS).requires(YTechItemTags.SHARP_FLINTS).unlockedBy(Utils.getHasName(), this.has(YTechItemTags.SHARP_FLINTS)).save(this.output, this.key(item));
                break;
            }
            case IRON: {
                RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('P'), (TagKey)YTechItemTags.PLATES.get(material)).define(Character.valueOf('R'), (TagKey)YTechItemTags.RODS.get(material)).define(Character.valueOf('#'), (TagKey)YTechItemTags.INGOTS.get(material)).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).pattern("P#R").pattern(" SH").pattern(" S ").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.INGOTS.get(material))).save(this.output, this.key(item));
                break;
            }
            default: {
                RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.TOOLS, (ItemLike)item.get()).requires((ItemLike)Items.STICK).requires(YTechItemTags.PARTS.get(material, PartType.PICKAXE_HEAD)).requires(YTechItemTags.HAMMERS.tag).unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.INGOTS.get(material))).save(this.output, this.key(item));
            }
        }
    }

    private void registerPlateRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        if (material == MaterialType.WOODEN) {
            RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.MISC, (ItemLike)((DeferredItem)YTechItems.PLATES.get(MaterialType.WOODEN)).get()).requires(ItemTags.WOODEN_SLABS).requires(YTechItemTags.AXES.tag).group(Utils.getPath((DeferredHolder)YTechItems.PLATES.get(MaterialType.WOODEN))).unlockedBy(Utils.getHasName(), this.has(ItemTags.WOODEN_SLABS)).save(this.output, this.key((DeferredItem<Item>)((DeferredItem)YTechItems.PLATES.get(MaterialType.WOODEN)), "_using_axe"));
            RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.MISC, (ItemLike)((DeferredItem)YTechItems.PLATES.get(MaterialType.WOODEN)).get(), 2).requires(ItemTags.WOODEN_SLABS).requires(YTechItemTags.SAWS.tag).group(Utils.getPath((DeferredHolder)YTechItems.PLATES.get(MaterialType.WOODEN))).unlockedBy(Utils.getHasName(), this.has(ItemTags.WOODEN_SLABS)).save(this.output, this.key((DeferredItem<Item>)((DeferredItem)YTechItems.PLATES.get(MaterialType.WOODEN)), "_using_saw"));
        } else {
            RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('#'), (TagKey)YTechItemTags.INGOTS.get(material)).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).pattern("#").pattern("#").pattern("H").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.INGOTS.get(material))).save(this.output, this.key(item));
            HammeringRecipe.Builder.hammering((HolderGetter<Item>)this.items, (TagKey<Item>)((TagKey)YTechItemTags.INGOTS.get(material)), YTechItemTags.HAMMERS.tag, 2, (Item)item.get()).unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.INGOTS.get(material))).save(this.output, this.key(item, "hammering"));
        }
    }

    public void registerRawMaterialRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        if (!MaterialType.VANILLA_METALS.contains(material)) {
            RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.MISC, (ItemLike)item.get(), 9).requires((TagKey)YTechItemTags.RAW_STORAGE_BLOCKS.get(material)).unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.RAW_STORAGE_BLOCKS.get(material))).save(this.output, this.key(item));
        }
    }

    public void registerRodRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('#'), (TagKey)YTechItemTags.INGOTS.get(material)).define(Character.valueOf('F'), YTechItemTags.FILES.tag).pattern("#").pattern("F").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.INGOTS.get(material))).save(this.output, this.key(item));
    }

    public void registerSawRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(material)).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).pattern("S##").pattern("H  ").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.PLATES.get(material))).save(this.output, this.key(item));
    }

    public void registerSawBladeRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('P'), (TagKey)YTechItemTags.PLATES.get(material)).pattern(" P ").pattern("PHP").pattern(" P ").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.PLATES.get(material))).save(this.output, this.key(item));
    }

    private void registerShearsRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(material)).define(Character.valueOf('R'), (TagKey)YTechItemTags.RODS.get(material)).define(Character.valueOf('B'), (TagKey)YTechItemTags.BOLTS.get(material)).define(Character.valueOf('F'), YTechItemTags.FILES.tag).define(Character.valueOf('L'), YTechItemTags.LEATHER_STRIPS).pattern(" #F").pattern("RB#").pattern("LR ").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.PLATES.get(material))).save(this.output, this.key(item));
    }

    private void registerShovelRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        if (material == MaterialType.WOODEN) {
            RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(MaterialType.WOODEN)).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("#").pattern("S").pattern("S").unlockedBy(YTechRecipeProvider.getHasName((ItemLike)Items.STICK), this.has((ItemLike)Items.STICK)).save(this.output, this.key(item));
        } else {
            RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(material)).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).pattern("#H").pattern("S ").pattern("S ").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.PLATES.get(material))).save(this.output, this.key(item));
        }
    }

    private void registerSpearRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        if (material == MaterialType.FLINT) {
            RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('T'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('S'), (ItemLike)Items.FLINT).define(Character.valueOf('#'), (ItemLike)Items.STICK).pattern(" TS").pattern(" #T").pattern("#  ").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.LEATHER_STRIPS)).save(this.output, this.key(item));
        } else {
            RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('T'), YTechItemTags.LEATHER_STRIPS).define(Character.valueOf('S'), (TagKey)YTechItemTags.PLATES.get(material)).define(Character.valueOf('#'), (ItemLike)Items.STICK).pattern(" TS").pattern(" #T").pattern("#  ").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.LEATHER_STRIPS)).save(this.output, this.key(item));
        }
    }

    private void registerSwordRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        if (material == MaterialType.IRON) {
            RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('#'), (TagKey)YTechItemTags.PLATES.get(material)).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).pattern("# ").pattern("# ").pattern("SH").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.PLATES.get(material))).save(this.output, this.key(item));
        } else {
            RemainingShapelessRecipe.Builder.shapeless((HolderGetter<Item>)this.items, RecipeCategory.COMBAT, (ItemLike)item.get()).requires((ItemLike)Items.STICK).requires(YTechItemTags.PARTS.get(material, PartType.SWORD_BLADE)).requires(YTechItemTags.HAMMERS.tag).unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.PLATES.get(material))).save(this.output, this.key(item));
        }
    }

    private void registerAqueductRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        switch (material) {
            case MUDBRICK: {
                RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)item.get()), (int)2).define(Character.valueOf('#'), (ItemLike)Items.MUD_BRICKS).pattern("# #").pattern("# #").pattern("###").unlockedBy(Utils.getHasName(), this.has((ItemLike)Items.MUD_BRICKS)).save(this.output, this.key(item));
                break;
            }
            case TERRACOTTA: {
                RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)item.get()), (int)2).define(Character.valueOf('#'), YTechItemTags.TERRACOTTA_BRICKS).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).pattern("# #").pattern("#H#").pattern("###").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.TERRACOTTA_BRICKS)).save(this.output, this.key(item));
                break;
            }
            case STONE: {
                RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)item.get()), (int)2).define(Character.valueOf('#'), (ItemLike)Items.STONE_BRICKS).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).pattern("# #").pattern("#H#").pattern("###").unlockedBy(Utils.getHasName(), this.has((ItemLike)Items.STONE_BRICKS)).save(this.output, this.key(item));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void registerFertilizerRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)YTechBlocks.AQUEDUCT_FERTILIZER.get())).define(Character.valueOf('#'), YTechItemTags.AQUEDUCT_HYDRATORS).define(Character.valueOf('R'), (TagKey)YTechItemTags.RODS.get(MaterialType.BRONZE)).define(Character.valueOf('S'), (TagKey)YTechItemTags.PLATES.get(MaterialType.BRONZE)).define(Character.valueOf('B'), (TagKey)YTechItemTags.BOLTS.get(MaterialType.BRONZE)).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('F'), YTechItemTags.FILES.tag).define(Character.valueOf('C'), Tags.Items.CHESTS).pattern("HCF").pattern("S#S").pattern("RBR").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.TERRACOTTA_BRICKS)).save(this.output, this.key(YTechBlocks.AQUEDUCT_FERTILIZER));
    }

    public void registerHydratorRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)YTechBlocks.AQUEDUCT_HYDRATOR.get())).define(Character.valueOf('#'), YTechItemTags.TERRACOTTA_BRICKS).define(Character.valueOf('R'), (TagKey)YTechItemTags.RODS.get(MaterialType.COPPER)).define(Character.valueOf('S'), (TagKey)YTechItemTags.PLATES.get(MaterialType.COPPER)).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).pattern("#R#").pattern("SHS").pattern("#R#").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.TERRACOTTA_BRICKS)).save(this.output, this.key(YTechBlocks.AQUEDUCT_HYDRATOR));
    }

    public void registerValveRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)YTechBlocks.AQUEDUCT_VALVE.get())).define(Character.valueOf('#'), YTechItemTags.TERRACOTTA_BRICKS).define(Character.valueOf('R'), YTechItemTags.RODS.tag).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('S'), YTechItemTags.SAWS.tag).pattern("###").pattern("HRS").pattern("###").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.TERRACOTTA_BRICKS)).save(this.output, this.key(YTechBlocks.AQUEDUCT_VALVE));
    }

    public void registerBrickChimneyRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)YTechBlocks.BRICK_CHIMNEY.get())).define(Character.valueOf('B'), (ItemLike)Items.BRICKS).pattern(" B ").pattern("B B").pattern(" B ").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.BRICKS), this.has((ItemLike)Items.BRICKS)).save(this.output, this.key(YTechBlocks.BRICK_CHIMNEY));
    }

    public void registerBronzeAnvilRecipe() {
        WorkspaceCraftingRecipe.Builder.recipe((HolderGetter<Item>)this.items, YTechItemTags.HAMMERS.tag, (ItemLike)YTechBlocks.BRONZE_ANVIL.get()).define(Character.valueOf('B'), (TagKey<Item>)((TagKey)YTechItemTags.STORAGE_BLOCKS.get(MaterialType.BRONZE))).bottomPattern(" B ").bottomPattern("BBB").bottomPattern(" B ").middlePattern("   ").middlePattern(" B ").middlePattern("   ").topPattern("BBB").topPattern("BBB").topPattern("BBB").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.INGOTS.get(MaterialType.BRONZE))).save(this.output, this.key(YTechBlocks.BRONZE_ANVIL));
    }

    public void registerCraftingWorkspaceRecipe() {
        ShapedRecipeBuilder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)YTechBlocks.CRAFTING_WORKSPACE.get())).define(Character.valueOf('T'), YTechItemTags.GRASS_TWINES).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("TT").pattern("SS").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.GRASS_TWINES)).save(this.output, this.key(YTechBlocks.CRAFTING_WORKSPACE));
    }

    public void registerFirePitRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)YTechBlocks.FIRE_PIT.get())).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('P'), YTechItemTags.PEBBLES).pattern("SS").pattern("PP").unlockedBy("has_pebble", this.has(YTechItemTags.PEBBLES)).save(this.output, this.key(YTechBlocks.FIRE_PIT));
    }

    public void registerGrassBedRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)YTechBlocks.GRASS_BED.get())).define(Character.valueOf('G'), YTechItemTags.THATCH_SLABS).define(Character.valueOf('S'), YTechItemTags.GRASS_FIBERS).pattern("SSS").pattern("GGG").pattern("GGG").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.THATCH_SLABS)).save(this.output, this.key(YTechBlocks.GRASS_BED));
    }

    public void registerMillstoneRecipe() {
        WorkspaceCraftingRecipe.Builder.recipe((HolderGetter<Item>)this.items, YTechItemTags.HAMMERS.tag, (ItemLike)YTechBlocks.MILLSTONE.get()).define(Character.valueOf('W'), (TagKey<Item>)ItemTags.LOGS).define(Character.valueOf('S'), (ItemLike)Items.SMOOTH_STONE).bottomPattern("SSS").bottomPattern("SWS").bottomPattern("SSS").middlePattern("SSS").middlePattern("SWS").middlePattern("SSS").topPattern("   ").topPattern(" W ").topPattern("   ").unlockedBy("has_logs", this.has(ItemTags.LOGS)).save(this.output, this.key(YTechBlocks.MILLSTONE));
    }

    public void registerPottersWheelRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)YTechBlocks.POTTERS_WHEEL.get())).define(Character.valueOf('W'), ItemTags.LOGS).define(Character.valueOf('S'), ItemTags.WOODEN_SLABS).define(Character.valueOf('A'), YTechItemTags.AXES.tag).define(Character.valueOf('B'), YTechItemTags.SAWS.tag).pattern("ASB").pattern(" W ").pattern("SSS").unlockedBy("has_logs", this.has(ItemTags.LOGS)).save(this.output, this.key(YTechBlocks.POTTERS_WHEEL));
    }

    public void registerPrimitiveAlloySmelterRecipe() {
        WorkspaceCraftingRecipe.Builder.recipe((HolderGetter<Item>)this.items, YTechItemTags.HAMMERS.tag, (ItemLike)YTechBlocks.PRIMITIVE_ALLOY_SMELTER.get()).define(Character.valueOf('A'), (ItemLike)Items.FURNACE).define(Character.valueOf('C'), (ItemLike)Items.BRICKS).bottomPattern("CCC").bottomPattern("CCC").bottomPattern("CCC").middlePattern("CCC").middlePattern("AAA").middlePattern("C C").topPattern("CCC").topPattern("C C").topPattern("CCC").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.BRICKS), this.has((ItemLike)Items.BRICKS)).save(this.output, this.key(YTechBlocks.PRIMITIVE_ALLOY_SMELTER));
    }

    public void registerPrimitiveSmelterRecipe() {
        WorkspaceCraftingRecipe.Builder.recipe((HolderGetter<Item>)this.items, YTechItemTags.HAMMERS.tag, (ItemLike)YTechBlocks.PRIMITIVE_SMELTER.get()).define(Character.valueOf('A'), (ItemLike)Items.FURNACE).define(Character.valueOf('C'), (ItemLike)Items.BRICKS).bottomPattern("CCC").bottomPattern("CCC").bottomPattern("CCC").middlePattern("CCC").middlePattern("CAC").middlePattern("C C").topPattern("CCC").topPattern("C C").topPattern("CCC").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.BRICKS), this.has((ItemLike)Items.BRICKS)).save(this.output, this.key(YTechBlocks.PRIMITIVE_SMELTER));
    }

    private void registerReinforcedBricksRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)YTechBlocks.REINFORCED_BRICKS.get())).define(Character.valueOf('B'), (ItemLike)Items.BRICKS).define(Character.valueOf('P'), (TagKey)YTechItemTags.PLATES.get(MaterialType.COPPER)).define(Character.valueOf('#'), (TagKey)YTechItemTags.BOLTS.get(MaterialType.COPPER)).pattern("#P#").pattern("PBP").pattern("#P#").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.BRICKS), this.has((ItemLike)Items.BRICKS)).save(this.output, this.key(YTechBlocks.REINFORCED_BRICKS));
    }

    public void registerReinforcedBrickChimneyRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)YTechBlocks.REINFORCED_BRICK_CHIMNEY.get())).define(Character.valueOf('#'), YTechItemTags.REINFORCED_BRICKS).pattern(" # ").pattern("# #").pattern(" # ").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.REINFORCED_BRICKS)).save(this.output, this.key(YTechBlocks.REINFORCED_BRICK_CHIMNEY));
    }

    private void registerStrainerRecipe() {
        WorkspaceCraftingRecipe.Builder.recipe((HolderGetter<Item>)this.items, YTechItemTags.SHARP_FLINTS, (ItemLike)YTechItems.STRAINER.get()).define(Character.valueOf('L'), (TagKey<Item>)ItemTags.LOGS).define(Character.valueOf('W'), YTechItemTags.WOODEN_BOXES).bottomPattern("LLL").bottomPattern("LLL").bottomPattern("LLL").middlePattern("LLL").middlePattern("LWL").middlePattern("LLL").topPattern("L L").topPattern("   ").topPattern("L L").unlockedBy(Utils.getHasName(), this.has(ItemTags.LOGS)).save(this.output, this.key(YTechBlocks.STRAINER));
    }

    private void registerTerracottaBricksRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)YTechBlocks.TERRACOTTA_BRICKS.get()), (int)4).define(Character.valueOf('B'), (ItemLike)Items.TERRACOTTA).pattern("BB").pattern("BB").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.TERRACOTTA), this.has((ItemLike)Items.TERRACOTTA)).save(this.output, this.key(YTechBlocks.TERRACOTTA_BRICKS));
    }

    private void registerTerracottaBrickSlabRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)YTechBlocks.TERRACOTTA_BRICK_SLAB.get()), (int)6).define(Character.valueOf('B'), YTechItemTags.TERRACOTTA_BRICKS).pattern("BBB").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.TERRACOTTA_BRICKS)).save(this.output, this.key(YTechBlocks.TERRACOTTA_BRICK_SLAB));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((HolderSet)this.items.getOrThrow(YTechItemTags.TERRACOTTA_BRICKS)), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)YTechBlocks.TERRACOTTA_BRICK_SLAB.get()), (int)2).unlockedBy(Utils.getHasName(), this.has(YTechItemTags.TERRACOTTA_BRICKS)).save(this.output, this.key(YTechBlocks.TERRACOTTA_BRICK_SLAB, "stonecutting"));
    }

    private void registerTerracottaBrickStairsRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)YTechBlocks.TERRACOTTA_BRICK_STAIRS.get()), (int)4).define(Character.valueOf('B'), YTechItemTags.TERRACOTTA_BRICKS).pattern("B  ").pattern("BB ").pattern("BBB").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.TERRACOTTA_BRICKS)).save(this.output, this.key(YTechBlocks.TERRACOTTA_BRICK_STAIRS));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((HolderSet)this.items.getOrThrow(YTechItemTags.TERRACOTTA_BRICKS)), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)YTechBlocks.TERRACOTTA_BRICK_STAIRS.get())).unlockedBy(Utils.getHasName(), this.has(YTechItemTags.TERRACOTTA_BRICKS)).save(this.output, this.key(YTechBlocks.TERRACOTTA_BRICK_STAIRS, "stonecutting"));
    }

    private void registerThatchBlockRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)YTechBlocks.THATCH.get())).define(Character.valueOf('B'), YTechItemTags.GRASS_FIBERS).pattern("BBB").pattern("BBB").pattern("BBB").unlockedBy("has_thatch", this.has(YTechItemTags.GRASS_FIBERS)).save(this.output, this.key(YTechBlocks.THATCH));
    }

    private void registerThatchBlockSlabRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)YTechBlocks.THATCH_SLAB.get()), (int)6).define(Character.valueOf('B'), YTechItemTags.THATCH).pattern("BBB").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.THATCH)).save(this.output, this.key(YTechBlocks.THATCH_SLAB));
    }

    private void registerThatchBlockStairsRecipe() {
        RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)YTechBlocks.THATCH_STAIRS.get()), (int)4).define(Character.valueOf('B'), YTechItemTags.THATCH).pattern("B  ").pattern("BB ").pattern("BBB").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.THATCH)).save(this.output, this.key(YTechBlocks.THATCH_STAIRS));
    }

    public void registerDryingRackRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        WorkspaceCraftingRecipe.Builder.recipe((HolderGetter<Item>)this.items, YTechItemTags.AXES.tag, (ItemLike)item.get()).define(Character.valueOf('W'), Utils.getLogFromMaterial(material)).define(Character.valueOf('T'), YTechItemTags.GRASS_TWINES).bottomPattern("   ").bottomPattern("W W").bottomPattern("   ").middlePattern("   ").middlePattern("W W").middlePattern("   ").topPattern("   ").topPattern("WTW").topPattern("   ").group(YTechBlocks.DRYING_RACKS.getGroup() + "_" + material.group).unlockedBy("has_logs", this.has(ItemTags.LOGS)).save(this.output, this.key(item));
    }

    private void registerTreeStumpRecipe() {
        WorkspaceCraftingRecipe.Builder.recipe((HolderGetter<Item>)this.items, YTechItemTags.AXES.tag, (ItemLike)YTechItems.TREE_STUMP.get()).define(Character.valueOf('C'), (TagKey<Item>)ItemTags.LOGS).define(Character.valueOf('S'), (TagKey<Item>)Tags.Items.COBBLESTONES_NORMAL).bottomPattern("SSS").bottomPattern("SSS").bottomPattern("SSS").middlePattern("CCC").middlePattern("CCC").middlePattern("CCC").topPattern("CCC").topPattern("CCC").topPattern("CCC").unlockedBy(Utils.getHasName(), this.has(ItemTags.LOGS)).save(this.output, this.key(YTechItems.TREE_STUMP));
    }

    private void registerRawStorageBlockRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        if (!MaterialType.VANILLA_METALS.contains(material)) {
            RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('#'), (TagKey)YTechItemTags.RAW_MATERIALS.get(material)).pattern("###").pattern("###").pattern("###").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.RAW_MATERIALS.get(material))).save(this.output, this.key(item));
        }
    }

    private void registerStorageBlockRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        if (!MaterialType.VANILLA_METALS.contains(material)) {
            RemainingShapedRecipe.Builder.shaped((HolderGetter)this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)item.get())).define(Character.valueOf('#'), (TagKey)YTechItemTags.INGOTS.get(material)).pattern("###").pattern("###").pattern("###").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.INGOTS.get(material))).save(this.output, this.key(item));
        }
    }

    public void registerTanningRackRecipe(@NotNull DeferredItem<Item> item, MaterialType material) {
        WorkspaceCraftingRecipe.Builder.recipe((HolderGetter<Item>)this.items, YTechItemTags.AXES.tag, (ItemLike)item.get()).define(Character.valueOf('W'), Utils.getLogFromMaterial(material)).define(Character.valueOf('T'), YTechItemTags.GRASS_TWINES).bottomPattern("   ").bottomPattern("WTW").bottomPattern("   ").middlePattern("   ").middlePattern("W W").middlePattern("   ").topPattern("   ").topPattern("WTW").topPattern("   ").group(YTechBlocks.TANNING_RACKS.getGroup() + "_" + material.group).unlockedBy("has_logs", this.has(ItemTags.LOGS)).save(this.output, this.key(item));
    }

    private ResourceKey<Recipe<?>> key(@NotNull Item item) {
        return this.key(item, false);
    }

    private ResourceKey<Recipe<?>> key(@NotNull Item item, boolean modLoc) {
        return this.key(modLoc ? Utils.modLoc(item) : Utils.loc(item));
    }

    private ResourceKey<Recipe<?>> key(@NotNull DeferredItem<? extends Item> item) {
        return this.key(Utils.loc(item));
    }

    private ResourceKey<Recipe<?>> key(@NotNull DeferredBlock<Block> block) {
        return this.key(Utils.loc(block));
    }

    private ResourceKey<Recipe<?>> key(@NotNull Item item, String from) {
        return this.key(Utils.modLoc(Utils.loc(item).getPath() + "_from_" + from));
    }

    private ResourceKey<Recipe<?>> key(@NotNull DeferredItem<Item> item, String from) {
        return this.key(Utils.modLoc(Utils.loc((Item)item.get()).getPath() + "_from_" + from));
    }

    private ResourceKey<Recipe<?>> key(@NotNull DeferredBlock<Block> block, String from) {
        return this.key(Utils.modLoc(Utils.loc((Block)block.get()).getPath() + "_from_" + from));
    }

    private ResourceKey<Recipe<?>> key(@NotNull ResourceLocation resource) {
        return ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)resource);
    }

    private void wcChestRecipe() {
        WorkspaceCraftingRecipe.Builder.recipe((HolderGetter<Item>)this.items, YTechItemTags.HAMMERS.tag, (ItemLike)Items.CHEST).define(Character.valueOf('C'), (TagKey<Item>)ItemTags.PLANKS).define(Character.valueOf('R'), (TagKey<Item>)((TagKey)YTechItemTags.RODS.get(MaterialType.IRON))).define(Character.valueOf('B'), (TagKey<Item>)ItemTags.WOODEN_BUTTONS).bottomPattern("CCC").bottomPattern("CCC").bottomPattern("CCC").middlePattern("CCC").middlePattern("C C").middlePattern("CBC").topPattern("RRR").topPattern("CCC").topPattern("CCC").unlockedBy(Utils.getHasName(), this.has(ItemTags.PLANKS)).save(this.output, this.key(Items.CHEST, true));
    }

    private void wcFurnaceRecipe() {
        WorkspaceCraftingRecipe.Builder.recipe((HolderGetter<Item>)this.items, YTechItemTags.HAMMERS.tag, (ItemLike)Items.FURNACE).define(Character.valueOf('C'), (TagKey<Item>)Tags.Items.COBBLESTONES_NORMAL).define(Character.valueOf('A'), (ItemLike)Items.CAMPFIRE).bottomPattern("CCC").bottomPattern("CCC").bottomPattern("CCC").middlePattern("CCC").middlePattern("CAC").middlePattern("C C").topPattern("CCC").topPattern("CCC").topPattern("CCC").unlockedBy(RecipeProvider.getHasName((ItemLike)Items.COBBLESTONE), this.has(Tags.Items.COBBLESTONES_NORMAL)).save(this.output, this.key(Items.FURNACE, true));
    }

    private void wcCraftingTableRecipe() {
        WorkspaceCraftingRecipe.Builder.recipe((HolderGetter<Item>)this.items, YTechItemTags.SHARP_FLINTS, (ItemLike)Items.CRAFTING_TABLE).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).define(Character.valueOf('P'), (TagKey<Item>)ItemTags.PLANKS).bottomPattern("PPP").bottomPattern("PPP").bottomPattern("PPP").middlePattern("PPP").middlePattern("PPP").middlePattern("PPP").topPattern("   ").topPattern(" L ").topPattern("   ").unlockedBy(Utils.getHasName(), this.has(ItemTags.PLANKS)).save(this.output, this.key(Items.CRAFTING_TABLE, true));
    }

    private void wcStonecutterRecipe() {
        WorkspaceCraftingRecipe.Builder.recipe((HolderGetter<Item>)this.items, YTechItemTags.HAMMERS.tag, (ItemLike)Items.STONECUTTER).define(Character.valueOf('L'), (TagKey<Item>)ItemTags.LOGS).define(Character.valueOf('P'), (ItemLike)Items.SMOOTH_STONE).define(Character.valueOf('S'), YTechItemTags.SAW_BLADES.tag).bottomPattern("LPL").bottomPattern("PPP").bottomPattern("LPL").middlePattern("LPL").middlePattern("PPP").middlePattern("LPL").topPattern("   ").topPattern(" S ").topPattern("   ").unlockedBy(Utils.getHasName(), this.has((ItemLike)Items.SMOOTH_STONE)).save(this.output, this.key(Items.STONECUTTER, true));
    }

    private void wcBarrelRecipe() {
        WorkspaceCraftingRecipe.Builder.recipe((HolderGetter<Item>)this.items, YTechItemTags.HAMMERS.tag, (ItemLike)Items.BARREL).define(Character.valueOf('S'), (TagKey<Item>)ItemTags.WOODEN_SLABS).define(Character.valueOf('P'), (TagKey<Item>)ItemTags.PLANKS).bottomPattern("PPP").bottomPattern("PPP").bottomPattern("PPP").middlePattern("PPP").middlePattern("P P").middlePattern("PPP").topPattern("SSS").topPattern("SSS").topPattern("SSS").unlockedBy(Utils.getHasName(), this.has(ItemTags.PLANKS)).save(this.output, this.key(Items.BARREL, true));
    }

    private void wcFletchingTableRecipe() {
        WorkspaceCraftingRecipe.Builder.recipe((HolderGetter<Item>)this.items, YTechItemTags.HAMMERS.tag, (ItemLike)Items.FLETCHING_TABLE).define(Character.valueOf('T'), (ItemLike)Items.TARGET).define(Character.valueOf('P'), (TagKey<Item>)ItemTags.PLANKS).bottomPattern("PPP").bottomPattern("PPP").bottomPattern("PPP").middlePattern("PTP").middlePattern("PPP").middlePattern("PTP").topPattern("PPP").topPattern("PPP").topPattern("PPP").unlockedBy(Utils.getHasName(), this.has(ItemTags.PLANKS)).save(this.output, this.key(Items.FLETCHING_TABLE, true));
    }

    private void wcCartographyTableRecipe() {
        WorkspaceCraftingRecipe.Builder.recipe((HolderGetter<Item>)this.items, YTechItemTags.HAMMERS.tag, (ItemLike)Items.CARTOGRAPHY_TABLE).define(Character.valueOf('P'), (TagKey<Item>)ItemTags.PLANKS).define(Character.valueOf('M'), (ItemLike)Items.MAP).bottomPattern("PPP").bottomPattern("PPP").bottomPattern("PPP").middlePattern("PPP").middlePattern("PPP").middlePattern("PPP").topPattern("   ").topPattern(" M ").topPattern("   ").unlockedBy(Utils.getHasName(), this.has(ItemTags.PLANKS)).save(this.output, this.key(Items.CARTOGRAPHY_TABLE, true));
    }

    private void wcSmithingTableRecipe() {
        WorkspaceCraftingRecipe.Builder.recipe((HolderGetter<Item>)this.items, YTechItemTags.HAMMERS.tag, (ItemLike)Items.SMITHING_TABLE).define(Character.valueOf('P'), (TagKey<Item>)ItemTags.PLANKS).define(Character.valueOf('C'), (TagKey<Item>)((TagKey)YTechItemTags.STORAGE_BLOCKS.get(MaterialType.IRON))).bottomPattern("CPC").bottomPattern("PPP").bottomPattern("CPC").middlePattern("CPC").middlePattern("PPP").middlePattern("CPC").topPattern("CCC").topPattern("CCC").topPattern("CCC").unlockedBy(Utils.getHasName(), this.has((TagKey)YTechItemTags.INGOTS.get(MaterialType.IRON))).save(this.output, this.key(Items.SMITHING_TABLE, true));
    }

    private void wcGrindstoneRecipe() {
        WorkspaceCraftingRecipe.Builder.recipe((HolderGetter<Item>)this.items, YTechItemTags.HAMMERS.tag, (ItemLike)Items.GRINDSTONE).define(Character.valueOf('L'), (TagKey<Item>)ItemTags.LOGS).define(Character.valueOf('S'), (ItemLike)Items.SMOOTH_STONE).bottomPattern(" L ").bottomPattern("SSS").bottomPattern(" L ").middlePattern(" L ").middlePattern("SSS").middlePattern(" L ").topPattern("   ").topPattern("SSS").topPattern("   ").unlockedBy(Utils.getHasName(), this.has((ItemLike)Items.SMOOTH_STONE)).save(this.output, this.key(Items.GRINDSTONE, true));
    }

    private void wcLoomRecipe() {
        WorkspaceCraftingRecipe.Builder.recipe((HolderGetter<Item>)this.items, YTechItemTags.HAMMERS.tag, (ItemLike)Items.LOOM).define(Character.valueOf('P'), (TagKey<Item>)ItemTags.PLANKS).define(Character.valueOf('S'), (TagKey<Item>)Tags.Items.STRINGS).bottomPattern("P P").bottomPattern("   ").bottomPattern("P P").middlePattern("PPP").middlePattern("PPP").middlePattern("PPP").topPattern("PPP").topPattern("SSS").topPattern("SSS").unlockedBy(Utils.getHasName(), this.has(ItemTags.PLANKS)).save(this.output, this.key(Items.LOOM, true));
    }

    private void wcSmokerRecipe() {
        WorkspaceCraftingRecipe.Builder.recipe((HolderGetter<Item>)this.items, YTechItemTags.HAMMERS.tag, (ItemLike)Items.SMOKER).define(Character.valueOf('L'), (TagKey<Item>)ItemTags.LOGS).define(Character.valueOf('A'), (ItemLike)Items.CAMPFIRE).define(Character.valueOf('C'), (TagKey<Item>)Tags.Items.COBBLESTONES_NORMAL).bottomPattern("LCL").bottomPattern("CCC").bottomPattern("LCL").middlePattern("LCL").middlePattern("CAC").middlePattern("L L").topPattern("LCL").topPattern("C C").topPattern("LCL").unlockedBy(Utils.getHasName(), this.has(Tags.Items.COBBLESTONES_NORMAL)).save(this.output, this.key(Items.SMOKER, true));
    }

    private void wcComposterRecipe() {
        WorkspaceCraftingRecipe.Builder.recipe((HolderGetter<Item>)this.items, YTechItemTags.HAMMERS.tag, (ItemLike)Items.COMPOSTER).define(Character.valueOf('L'), (TagKey<Item>)ItemTags.PLANKS).bottomPattern("LLL").bottomPattern("LLL").bottomPattern("LLL").middlePattern("LLL").middlePattern("L L").middlePattern("LLL").topPattern("LLL").topPattern("L L").topPattern("LLL").unlockedBy(Utils.getHasName(), this.has(ItemTags.PLANKS)).save(this.output, this.key(Items.COMPOSTER, true));
    }

    private void wcWoodenBoxRecipe() {
        WorkspaceCraftingRecipe.Builder.recipe((HolderGetter<Item>)this.items, YTechItemTags.HAMMERS.tag, (ItemLike)YTechItems.WOODEN_BOX.get()).define(Character.valueOf('L'), (TagKey<Item>)ItemTags.PLANKS).bottomPattern("LLL").bottomPattern("LLL").bottomPattern("LLL").middlePattern("LLL").middlePattern("L L").middlePattern("LLL").topPattern("   ").topPattern("   ").topPattern("   ").unlockedBy(Utils.getHasName(), this.has(ItemTags.PLANKS)).save(this.output, this.key(YTechItems.WOODEN_BOX));
    }

    private void wcToolRackRecipe() {
        WorkspaceCraftingRecipe.Builder.recipe((HolderGetter<Item>)this.items, YTechItemTags.HAMMERS.tag, (ItemLike)YTechItems.TOOL_RACK.get()).define(Character.valueOf('L'), (TagKey<Item>)ItemTags.PLANKS).define(Character.valueOf('B'), YTechItemTags.BOLTS.tag).bottomPattern("LLL").bottomPattern("BBB").bottomPattern("   ").middlePattern("LLL").middlePattern("BBB").middlePattern("   ").topPattern("LLL").topPattern("BBB").topPattern("   ").unlockedBy(Utils.getHasName(), this.has(ItemTags.PLANKS)).save(this.output, this.key(YTechItems.TOOL_RACK));
    }

    private void wcWellPulleyRecipe() {
        WorkspaceCraftingRecipe.Builder.recipe((HolderGetter<Item>)this.items, YTechItemTags.HAMMERS.tag, (ItemLike)YTechItems.WELL_PULLEY.get()).define(Character.valueOf('L'), (TagKey<Item>)ItemTags.LOGS).define(Character.valueOf('P'), (TagKey<Item>)ItemTags.PLANKS).define(Character.valueOf('B'), YTechItemTags.TERRACOTTA_BRICKS).define(Character.valueOf('T'), YTechItemTags.GRASS_TWINES).define(Character.valueOf('V'), YTechItemTags.AQUEDUCT_VALVES).bottomPattern("BBB").bottomPattern("BVB").bottomPattern("BBB").middlePattern("   ").middlePattern("LTL").middlePattern("   ").topPattern("   ").topPattern("LPL").topPattern("   ").unlockedBy(Utils.getHasName(), this.has(YTechItemTags.TERRACOTTA_BRICKS)).save(this.output, this.key(YTechItems.WELL_PULLEY));
    }

    static class Runner
    extends RecipeProvider.Runner {
        protected Runner(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> completableFuture) {
            super(packOutput, completableFuture);
        }

        @NotNull
        protected RecipeProvider createRecipeProvider(@NotNull HolderLookup.Provider provider, @NotNull RecipeOutput recipeOutput) {
            return new YTechRecipeProvider(provider, recipeOutput);
        }

        @NotNull
        public String getName() {
            return "ytech";
        }
    }
}

