/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.network.generic.client;

import com.yanny.ytech.network.generic.client.ClientNetwork;
import com.yanny.ytech.network.generic.common.CommonNetwork;
import com.yanny.ytech.network.generic.common.INetworkBlockEntity;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class ClientLevelData<N extends ClientNetwork, O extends INetworkBlockEntity> {
    @NotNull
    private final ConcurrentHashMap<Integer, N> networkMap;

    public ClientLevelData(@NotNull Map<Integer, N> networkMap) {
        this.networkMap = new ConcurrentHashMap<Integer, N>(networkMap);
    }

    public ClientLevelData() {
        this.networkMap = new ConcurrentHashMap();
    }

    @NotNull
    public N getNetwork(@NotNull O blockEntity) {
        return (N)((ClientNetwork)this.networkMap.get(blockEntity.getNetworkId()));
    }

    public void onNetworkAddedOrUpdated(@NotNull N network) {
        this.networkMap.put(((CommonNetwork)network).getNetworkId(), network);
    }

    public void onNetworkRemoved(int networkId) {
        this.networkMap.remove(networkId);
    }
}

