/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.network.irrigation;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.network.generic.client.ClientPropagator;
import com.yanny.ytech.network.generic.common.CommonNetwork;
import com.yanny.ytech.network.generic.common.NetworkFactory;
import com.yanny.ytech.network.generic.message.LevelSyncMessage;
import com.yanny.ytech.network.generic.message.NetworkAddedOrUpdatedMessage;
import com.yanny.ytech.network.generic.message.NetworkRemovedMessage;
import com.yanny.ytech.network.generic.server.ServerPropagator;
import com.yanny.ytech.network.irrigation.IIrrigationBlockEntity;
import com.yanny.ytech.network.irrigation.IrrigationClientNetwork;
import com.yanny.ytech.network.irrigation.IrrigationServerNetwork;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

public class IrrigationUtils {
    public static YTechMod.DistHolder<ClientPropagator<IrrigationClientNetwork, IIrrigationBlockEntity>, ServerPropagator<IrrigationServerNetwork, IIrrigationBlockEntity>> registerIrrigationPropagator(PayloadRegistrar channel) {
        ServerPropagator<IrrigationServerNetwork, IIrrigationBlockEntity> server = new ServerPropagator<IrrigationServerNetwork, IIrrigationBlockEntity>(new Factory(), "irrigation");
        IrrigationClientPropagator client = FMLEnvironment.dist == Dist.CLIENT ? new IrrigationClientPropagator() : null;
        channel.playToClient(MyLevelSyncMessage.TYPE, MyLevelSyncMessage.CODEC, (msg, ctx) -> {
            if (client != null) {
                client.onSyncLevel((MyLevelSyncMessage)msg, ctx);
            }
        });
        channel.playToClient(MyNetworkUpdatedMessage.TYPE, MyNetworkUpdatedMessage.CODEC, (msg, ctx) -> {
            if (client != null) {
                client.onNetworkAddedOrUpdated((MyNetworkUpdatedMessage)msg, ctx);
            }
        });
        channel.playToClient(MyNetworkRemoveMessage.TYPE, MyNetworkRemoveMessage.CODEC, (msg, ctx) -> {
            if (client != null) {
                client.onNetworkRemoved((MyNetworkRemoveMessage)msg, ctx);
            }
        });
        return new YTechMod.DistHolder<ClientPropagator<IrrigationClientNetwork, IIrrigationBlockEntity>, ServerPropagator<IrrigationServerNetwork, IIrrigationBlockEntity>>(client, server);
    }

    private static class Factory
    implements NetworkFactory<IrrigationServerNetwork, IIrrigationBlockEntity> {
        private Factory() {
        }

        @Override
        @NotNull
        public IrrigationServerNetwork createNetwork(@NotNull CompoundTag tag, int networkId, @NotNull Consumer<Integer> onChange, @NotNull BiConsumer<Integer, ChunkPos> onRemove, HolderLookup.Provider provider) {
            return new IrrigationServerNetwork(tag, networkId, onChange, onRemove, provider);
        }

        @Override
        @NotNull
        public IrrigationServerNetwork createNetwork(int networkId, @NotNull Consumer<Integer> onChange, @NotNull BiConsumer<Integer, ChunkPos> onRemove) {
            return new IrrigationServerNetwork(networkId, onChange, onRemove);
        }

        @Override
        public void sendRemoved(@NotNull ServerPlayer player, int networkId) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new MyNetworkRemoveMessage(networkId), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        @Override
        public void sendUpdated(@NotNull ServerPlayer player, @NotNull IrrigationServerNetwork network) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new MyNetworkUpdatedMessage(new Payload(network.getNetworkId(), network.getFluidHandler().getFluidAmount(), network.getFluidHandler().getCapacity())), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        @Override
        public void sendLevelSync(@NotNull ServerPlayer player, @NotNull Map<Integer, IrrigationServerNetwork> networkMap) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new MyLevelSyncMessage(networkMap.entrySet().stream().map(entry -> {
                IrrigationServerNetwork network = (IrrigationServerNetwork)entry.getValue();
                return new Payload((Integer)entry.getKey(), network.getFluidHandler().getFluidAmount(), network.getFluidHandler().getCapacity());
            }).collect(Collectors.toMap(a -> a.networkId, b -> b))), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static class IrrigationClientPropagator
    extends ClientPropagator<IrrigationClientNetwork, IIrrigationBlockEntity> {
        public IrrigationClientPropagator() {
            super("irrigation");
        }

        public void onSyncLevel(@NotNull MyLevelSyncMessage msg, @NotNull IPayloadContext context) {
            context.enqueueWork(() -> this.syncLevel(msg.networkMap.entrySet().stream().map(entry -> {
                Payload payload = (Payload)entry.getValue();
                return new IrrigationClientNetwork((Integer)entry.getKey(), payload.amount, payload.capacity);
            }).collect(Collectors.toMap(CommonNetwork::getNetworkId, b -> b))));
        }

        public void onNetworkAddedOrUpdated(@NotNull MyNetworkUpdatedMessage msg, @NotNull IPayloadContext context) {
            context.enqueueWork(() -> {
                Payload payload = (Payload)msg.payload;
                this.addOrUpdateNetwork(new IrrigationClientNetwork(payload.networkId, payload.amount, payload.capacity));
            });
        }

        public void onNetworkRemoved(@NotNull MyNetworkRemoveMessage msg, @NotNull IPayloadContext context) {
            context.enqueueWork(() -> this.deletedNetwork(msg.networkId));
        }
    }

    static class MyLevelSyncMessage
    extends LevelSyncMessage<Payload>
    implements CustomPacketPayload {
        public static final CustomPacketPayload.Type<MyLevelSyncMessage> TYPE = new CustomPacketPayload.Type(Utils.modLoc("irrigation_level_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, MyLevelSyncMessage> CODEC = new StreamCodec<RegistryFriendlyByteBuf, MyLevelSyncMessage>(){

            @NotNull
            public MyLevelSyncMessage decode(@NotNull RegistryFriendlyByteBuf buf) {
                return new MyLevelSyncMessage(buf);
            }

            public void encode(@NotNull RegistryFriendlyByteBuf buf, @NotNull MyLevelSyncMessage message) {
                message.write(buf);
            }
        };

        public MyLevelSyncMessage(@NotNull Map<Integer, Payload> networkMap) {
            super(networkMap);
        }

        public MyLevelSyncMessage(@NotNull RegistryFriendlyByteBuf buf) {
            super(buf, buffer -> new Payload(buffer.readInt(), buffer.readInt(), buffer.readInt()));
        }

        public void write(@NotNull RegistryFriendlyByteBuf buf) {
            super.write(buf, (buffer, payload) -> {
                buffer.writeInt(payload.networkId);
                buffer.writeInt(payload.amount);
                buffer.writeInt(payload.capacity);
            });
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    static class MyNetworkUpdatedMessage
    extends NetworkAddedOrUpdatedMessage<Payload>
    implements CustomPacketPayload {
        public static final CustomPacketPayload.Type<MyNetworkUpdatedMessage> TYPE = new CustomPacketPayload.Type(Utils.modLoc("irrigation_network_updated"));
        public static final StreamCodec<RegistryFriendlyByteBuf, MyNetworkUpdatedMessage> CODEC = new StreamCodec<RegistryFriendlyByteBuf, MyNetworkUpdatedMessage>(){

            @NotNull
            public MyNetworkUpdatedMessage decode(@NotNull RegistryFriendlyByteBuf buf) {
                return new MyNetworkUpdatedMessage(buf);
            }

            public void encode(@NotNull RegistryFriendlyByteBuf buf, @NotNull MyNetworkUpdatedMessage message) {
                message.write(buf);
            }
        };

        public MyNetworkUpdatedMessage(@NotNull Payload payload) {
            super(payload);
        }

        public MyNetworkUpdatedMessage(@NotNull RegistryFriendlyByteBuf buf) {
            super(buf, buffer -> new Payload(buffer.readInt(), buffer.readInt(), buffer.readInt()));
        }

        public void write(@NotNull RegistryFriendlyByteBuf buf) {
            super.write(buf, (buffer, payload) -> {
                buffer.writeInt(payload.networkId);
                buffer.writeInt(payload.amount);
                buffer.writeInt(payload.capacity);
            });
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    static class MyNetworkRemoveMessage
    extends NetworkRemovedMessage
    implements CustomPacketPayload {
        public static final CustomPacketPayload.Type<MyNetworkRemoveMessage> TYPE = new CustomPacketPayload.Type(Utils.modLoc("irrigation_network_removed"));
        public static final StreamCodec<RegistryFriendlyByteBuf, MyNetworkRemoveMessage> CODEC = new StreamCodec<RegistryFriendlyByteBuf, MyNetworkRemoveMessage>(){

            @NotNull
            public MyNetworkRemoveMessage decode(@NotNull RegistryFriendlyByteBuf byteBuf) {
                return new MyNetworkRemoveMessage(byteBuf);
            }

            public void encode(@NotNull RegistryFriendlyByteBuf byteBuf, @NotNull MyNetworkRemoveMessage message) {
                message.write(byteBuf);
            }
        };

        public MyNetworkRemoveMessage(int networkId) {
            super(networkId);
        }

        public MyNetworkRemoveMessage(@NotNull RegistryFriendlyByteBuf buf) {
            super(buf);
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    record Payload(int networkId, int amount, int capacity) {
    }
}

