/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.registration;

import com.yanny.ytech.configuration.IType;
import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.PartType;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.registration.YTechBlockTags;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechItems;
import java.util.AbstractMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class YTechItemTags {
    public static final TagKey<Item> ANTLERS = YTechItemTags.create("antlers");
    public static final TagKey<Item> BASKETS = YTechItemTags.create("baskets");
    public static final TagKey<Item> BEESWAXES = YTechItemTags.create("beeswaxes");
    public static final TagKey<Item> BONE_NEEDLES = YTechItemTags.create("bone_needles");
    public static final TagKey<Item> BREAD_DOUGHS = YTechItemTags.create("bread_doughs");
    public static final TagKey<Item> BRICK_MOLDS = YTechItemTags.create("brick_molds");
    public static final TagKey<Item> CLAY_BUCKETS = YTechItemTags.create("clay_buckets");
    public static final TagKey<Item> COOKED_VENISON = YTechItemTags.create("cooked_venison");
    public static final TagKey<Item> DIVINING_RODS = YTechItemTags.create("divining_rods");
    public static final TagKey<Item> DRIED_BEEFS = YTechItemTags.create("dried_beefs");
    public static final TagKey<Item> DRIED_CHICKENS = YTechItemTags.create("dried_chickens");
    public static final TagKey<Item> DRIED_CODS = YTechItemTags.create("dried_cods");
    public static final TagKey<Item> DRIED_MUTTONS = YTechItemTags.create("dried_muttons");
    public static final TagKey<Item> DRIED_PORKCHOP = YTechItemTags.create("dried_pork_chops");
    public static final TagKey<Item> DRIED_RABBITS = YTechItemTags.create("dried_rabbits");
    public static final TagKey<Item> DRIED_SALMONS = YTechItemTags.create("dried_salmons");
    public static final TagKey<Item> DRIED_VENISON = YTechItemTags.create("dried_venison");
    public static final TagKey<Item> FLOURS = YTechItemTags.create("flours");
    public static final TagKey<Item> GRASS_FIBERS = YTechItemTags.create("grass_fibers");
    public static final TagKey<Item> GRASS_TWINES = YTechItemTags.create("grass_twines");
    public static final TagKey<Item> IRON_BLOOMS = YTechItemTags.create("iron_blooms");
    public static final TagKey<Item> LAVA_BUCKETS = YTechItemTags.create("lava_buckets");
    public static final TagKey<Item> LEATHER_STRIPS = YTechItemTags.create("leather_strips");
    public static final TagKey<Item> MAMMOTH_TUSKS = YTechItemTags.create("mammoth_tusks");
    public static final TagKey<Item> PEBBLES = YTechItemTags.create("pebbles");
    public static final TagKey<Item> RAW_HIDES = YTechItemTags.create("raw_hides");
    public static final TagKey<Item> RHINO_HORNS = YTechItemTags.create("rhino_horns");
    public static final TagKey<Item> SHARP_FLINTS = YTechItemTags.create("sharp_flints");
    public static final TagKey<Item> UNFIRED_AMPHORAE = YTechItemTags.create("unfired_amphorae");
    public static final TagKey<Item> UNFIRED_BRICKS = YTechItemTags.create("unfired_bricks");
    public static final TagKey<Item> UNFIRED_CLAY_BUCKETS = YTechItemTags.create("unfired_clay_buckets");
    public static final TagKey<Item> UNFIRED_DECORATED_POTS = YTechItemTags.create("unfired_decorated_pots");
    public static final TagKey<Item> UNFIRED_FLOWER_POTS = YTechItemTags.create("unfired_flower_pots");
    public static final TagKey<Item> UNLIT_TORCH = YTechItemTags.create("unlit_torch");
    public static final TagKey<Item> VENISON = YTechItemTags.create("venison");
    public static final TagKey<Item> WATER_BUCKETS = YTechItemTags.create("water_buckets");
    public static final TagKey<Item> FERTILIZER = YTechItemTags.create("fertilizer");
    public static final TagKey<Item> FIRE_SOURCE = YTechItemTags.create("fire_source");
    public static final TagKey<Item> SOUL_FIRE_SOURCE = YTechItemTags.create("soul_fire_source");
    public static final TagKey<Item> AUROCHS_FOOD = YTechItemTags.create("aurochs_food");
    public static final TagKey<Item> AUROCHS_TEMP_ITEMS = YTechItemTags.create("aurochs_temp_items");
    public static final TagKey<Item> DEER_FOOD = YTechItemTags.create("deer_food");
    public static final TagKey<Item> DEER_TEMP_ITEMS = YTechItemTags.create("deer_temp_items");
    public static final TagKey<Item> FOWL_FOOD = YTechItemTags.create("fowl_food");
    public static final TagKey<Item> FOWL_TEMP_ITEMS = YTechItemTags.create("fowl_temp_items");
    public static final TagKey<Item> MOUFLON_FOOD = YTechItemTags.create("mouflon_food");
    public static final TagKey<Item> MOUFLON_TEMP_ITEMS = YTechItemTags.create("mouflon_temp_items");
    public static final TagKey<Item> SABER_TOOTH_TIGER_TEMP_ITEMS = YTechItemTags.create("saber_tooth_tiger_temp_items");
    public static final TagKey<Item> TERROR_BIRD_TEMP_ITEMS = YTechItemTags.create("terror_bird_temp_items");
    public static final TagKey<Item> WILD_BOAR_FOOD = YTechItemTags.create("wild_boar_food");
    public static final TagKey<Item> WILD_BOAR_TEMP_ITEMS = YTechItemTags.create("wild_boar_temp_items");
    public static final TagKey<Item> WOOLLY_MAMMOTH_TEMP_ITEMS = YTechItemTags.create("woolly_mammoth_temp_items");
    public static final TagKey<Item> WOOLLY_RHINO_TEMP_ITEMS = YTechItemTags.create("woolly_rhino_temp_items");
    public static final TagKey<Item> AMPHORAE = YTechItemTags.create(YTechBlockTags.AMPHORAE);
    public static final TagKey<Item> AQUEDUCT_FERTILIZERS = YTechItemTags.create(YTechBlockTags.AQUEDUCT_FERTILIZERS);
    public static final TagKey<Item> AQUEDUCT_HYDRATORS = YTechItemTags.create(YTechBlockTags.AQUEDUCT_HYDRATORS);
    public static final TagKey<Item> AQUEDUCT_VALVES = YTechItemTags.create(YTechBlockTags.AQUEDUCT_VALVES);
    public static final TagKey<Item> BRICK_CHIMNEYS = YTechItemTags.create(YTechBlockTags.BRICK_CHIMNEYS);
    public static final TagKey<Item> BRONZE_ANVILS = YTechItemTags.create(YTechBlockTags.BRONZE_ANVILS);
    public static final TagKey<Item> CRAFTING_WORKSPACES = YTechItemTags.create(YTechBlockTags.CRAFTING_WORKSPACES);
    public static final TagKey<Item> FIRE_PITS = YTechItemTags.create(YTechBlockTags.FIRE_PITS);
    public static final TagKey<Item> GRASS_BEDS = YTechItemTags.create(YTechBlockTags.GRASS_BEDS);
    public static final TagKey<Item> MILLSTONES = YTechItemTags.create(YTechBlockTags.MILLSTONES);
    public static final TagKey<Item> POTTERS_WHEELS = YTechItemTags.create(YTechBlockTags.POTTERS_WHEELS);
    public static final TagKey<Item> PRIMITIVE_ALLOY_SMELTERS = YTechItemTags.create(YTechBlockTags.PRIMITIVE_ALLOY_SMELTERS);
    public static final TagKey<Item> PRIMITIVE_SMELTERS = YTechItemTags.create(YTechBlockTags.PRIMITIVE_SMELTERS);
    public static final TagKey<Item> REINFORCED_BRICKS = YTechItemTags.create(YTechBlockTags.REINFORCED_BRICKS);
    public static final TagKey<Item> REINFORCED_BRICK_CHIMNEYS = YTechItemTags.create(YTechBlockTags.REINFORCED_BRICK_CHIMNEYS);
    public static final TagKey<Item> STRAINERS = YTechItemTags.create(YTechBlockTags.STRAINERS);
    public static final TagKey<Item> TERRACOTTA_BRICKS = YTechItemTags.create(YTechBlockTags.TERRACOTTA_BRICKS);
    public static final TagKey<Item> TERRACOTTA_BRICK_SLABS = YTechItemTags.create(YTechBlockTags.TERRACOTTA_BRICK_SLABS);
    public static final TagKey<Item> TERRACOTTA_BRICK_STAIRS = YTechItemTags.create(YTechBlockTags.TERRACOTTA_BRICK_STAIRS);
    public static final TagKey<Item> THATCH = YTechItemTags.create(YTechBlockTags.THATCH);
    public static final TagKey<Item> THATCH_SLABS = YTechItemTags.create(YTechBlockTags.THATCH_SLABS);
    public static final TagKey<Item> THATCH_STAIRS = YTechItemTags.create(YTechBlockTags.THATCH_STAIRS);
    public static final TagKey<Item> TOOL_RACKS = YTechItemTags.create(YTechBlockTags.TOOL_RACKS);
    public static final TagKey<Item> TREE_STUMPS = YTechItemTags.create(YTechBlockTags.TREE_STUMPS);
    public static final TagKey<Item> WELL_PULLEYS = YTechItemTags.create(YTechBlockTags.WELL_PULLEYS);
    public static final TagKey<Item> WOODEN_BOXES = YTechItemTags.create(YTechBlockTags.WOODEN_BOXES);
    public static final TagKey<Item> CURIOS_BRACELETS = YTechItemTags.create("curios", "bracelet");
    public static final TagKey<Item> CURIOS_CHARMS = YTechItemTags.create("curios", "charm");
    public static final TagKey<Item> CURIOS_NECKLACES = YTechItemTags.create("curios", "necklace");
    public static final TagKey<Item> CHLORITE_BRACELETS = YTechItemTags.create("chlorite_bracelets");
    public static final TagKey<Item> LION_MANS = YTechItemTags.create("lion_mans");
    public static final TagKey<Item> SHELL_BEADS = YTechItemTags.create("shell_beads");
    public static final TagKey<Item> VENUS_OF_HOHLE_FELS = YTechItemTags.create("venus_of_hohle_fels");
    public static final TagKey<Item> WILD_HORSES = YTechItemTags.create("wild_horse");
    public static final TypedTag<PartType> CLAY_MOLDS = new PartTag("clay_molds", YTechItems.CLAY_MOLDS);
    public static final TypedTag<PartType> PATTERNS = new PartTag("patterns", YTechItems.PATTERNS);
    public static final TypedTag<PartType> SAND_MOLDS = new PartTag("sand_molds", YTechItems.SAND_MOLDS);
    public static final TypedTag<PartType> UNFIRED_MOLDS = new PartTag("unfired_molds", YTechItems.UNFIRED_MOLDS);
    public static final TypedTag<PartType> MOLDS = new PartTag("molds", PartType.ALL_PARTS);
    public static final MultiTypedTag<MaterialType, PartType> PARTS = new MaterialPartTag("parts", YTechItems.PARTS);
    public static final TypedTag<MaterialType> ARROWS = new MaterialTag("arrows", (TagKey<Item>)ItemTags.ARROWS, YTechItems.ARROWS);
    public static final TypedTag<MaterialType> AXES = new MaterialTag("axes", "c", (TagKey<Item>)ItemTags.AXES, YTechItems.AXES);
    public static final TypedTag<MaterialType> BOLTS = new MaterialTag("bolts", "c", YTechItems.BOLTS);
    public static final TypedTag<MaterialType> BOOTS = new MaterialTag("boots", "c", (TagKey<Item>)ItemTags.FOOT_ARMOR, YTechItems.BOOTS);
    public static final TypedTag<MaterialType> CHESTPLATES = new MaterialTag("chestplates", "c", (TagKey<Item>)ItemTags.CHEST_ARMOR, YTechItems.CHESTPLATES);
    public static final TypedTag<MaterialType> CRUSHED_MATERIALS = new MaterialTag("crushed_materials", "c", YTechItems.CRUSHED_MATERIALS);
    public static final TypedTag<MaterialType> FILES = new MaterialTag("files", "c", YTechItems.FILES);
    public static final TypedTag<MaterialType> HAMMERS = new MaterialTag("hammers", "c", YTechItems.HAMMERS);
    public static final TypedTag<MaterialType> HELMETS = new MaterialTag("helmets", "c", (TagKey<Item>)ItemTags.HEAD_ARMOR, YTechItems.HELMETS);
    public static final TypedTag<MaterialType> HOES = new MaterialTag("hoes", "c", (TagKey<Item>)ItemTags.HOES, YTechItems.HOES);
    public static final TypedTag<MaterialType> INGOTS = new IngotMaterialTag();
    public static final TypedTag<MaterialType> KNIVES = new MaterialTag("knives", "c", YTechItems.KNIVES);
    public static final TypedTag<MaterialType> MESHES = new MaterialTag("meshes", YTechItems.MESHES);
    public static final TypedTag<MaterialType> MORTAR_AND_PESTLES = new MaterialTag("mortar_and_pestles", "c", YTechItems.MORTAR_AND_PESTLES);
    public static final TypedTag<MaterialType> LEGGINGS = new MaterialTag("leggings", "c", (TagKey<Item>)ItemTags.LEG_ARMOR, YTechItems.LEGGINGS);
    public static final TypedTag<MaterialType> PICKAXES = new MaterialTag("pickaxes", "c", (TagKey<Item>)ItemTags.PICKAXES, YTechItems.PICKAXES);
    public static final TypedTag<MaterialType> PLATES = new MaterialTag("plates", "c", YTechItems.PLATES);
    public static final TypedTag<MaterialType> RAW_MATERIALS = new RawMaterialTag();
    public static final TypedTag<MaterialType> RODS = new MaterialTag("rods", "c", (TagKey<Item>)Tags.Items.RODS, YTechItems.RODS);
    public static final TypedTag<MaterialType> SAWS = new MaterialTag("saws", "c", YTechItems.SAWS);
    public static final TypedTag<MaterialType> SHEARS = new MaterialTag("shears", "c", YTechItems.SHEARS);
    public static final TypedTag<MaterialType> SAW_BLADES = new MaterialTag("saw_blades", YTechItems.SAW_BLADES);
    public static final TypedTag<MaterialType> SHOVELS = new MaterialTag("shovels", "forge", (TagKey<Item>)ItemTags.SHOVELS, YTechItems.SHOVELS);
    public static final TypedTag<MaterialType> SPEARS = new MaterialTag("spears", YTechItems.SPEARS);
    public static final TypedTag<MaterialType> SWORDS = new MaterialTag("swords", "forge", (TagKey<Item>)ItemTags.SWORDS, YTechItems.SWORDS);
    public static final TypedTag<MaterialType> AQUEDUCTS = new MaterialTag(YTechBlockTags.AQUEDUCTS);
    public static final TypedTag<MaterialType> DEEPSLATE_ORES = new DeepslateOreMaterialTag();
    public static final TypedTag<MaterialType> DRYING_RACKS = new MaterialTag(YTechBlockTags.DRYING_RACKS);
    public static final TypedTag<MaterialType> GRAVEL_DEPOSITS = new MaterialTag(YTechBlockTags.GRAVEL_DEPOSITS);
    public static final TypedTag<MaterialType> NETHER_ORES = new NetherOreMaterialTag();
    public static final TypedTag<MaterialType> RAW_STORAGE_BLOCKS = new RawStorageBlockMaterialTag();
    public static final TypedTag<MaterialType> SAND_DEPOSITS = new MaterialTag(YTechBlockTags.SAND_DEPOSITS);
    public static final TypedTag<MaterialType> STONE_ORES = new StoneOreMaterialTag();
    public static final TypedTag<MaterialType> STORAGE_BLOCKS = new StorageBlockMaterialTag();
    public static final TypedTag<MaterialType> TANNING_RACKS = new MaterialTag(YTechBlockTags.TANNING_RACKS);

    private static TagKey<Item> create(String name) {
        return ItemTags.create((ResourceLocation)Utils.modLoc(name));
    }

    private static TagKey<Item> create(TagKey<Block> block) {
        return ItemTags.create((ResourceLocation)block.location());
    }

    private static TagKey<Item> create(String namespace, String name) {
        return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)name));
    }

    public static class PartTag
    extends TypedTag<PartType> {
        public PartTag(String name, YTechItems.TypedItem<PartType> item) {
            super(name, "ytech", YTechItemTags.create(name), EnumSet.copyOf(item.keySet()), type -> type.key);
        }

        public PartTag(String name, EnumSet<PartType> parts) {
            super(name, "ytech", YTechItemTags.create(name), parts, type -> type.key);
        }
    }

    public static class TypedTag<E extends Enum<E>>
    extends AbstractMap<E, TagKey<Item>> {
        public final TagKey<Item> tag;
        protected final Map<E, TagKey<Item>> tags;

        public TypedTag(String name, String namespace, TagKey<Item> tag, EnumSet<E> types, Function<E, String> typeNameSupplier) {
            this.tag = tag;
            this.tags = new HashMap<E, TagKey<Item>>();
            types.forEach((? super T type) -> this.tags.put(type, (TagKey<Item>)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(name + "/" + (String)typeNameSupplier.apply(type))))));
        }

        @Override
        @NotNull
        public Set<Map.Entry<E, TagKey<Item>>> entrySet() {
            return this.tags.entrySet();
        }
    }

    private static class MaterialPartTag
    extends MultiTypedTag<MaterialType, PartType> {
        public MaterialPartTag(String name, YTechItems.MultiTypedItem<MaterialType, PartType> multiTypedItem) {
            super(YTechItemTags.create(name));
            for (PartType part : Utils.exclude(PartType.ALL_PARTS, (Enum[])new PartType[]{PartType.INGOT})) {
                for (MaterialType material : multiTypedItem.keySet()) {
                    this.tags.computeIfAbsent(material, t -> new HashMap()).put(part, ItemTags.create((ResourceLocation)Utils.modLoc(name + "/" + part.key + "s/" + material.key)));
                }
                this.categoryTags.put(part, ItemTags.create((ResourceLocation)Utils.modLoc(name + "/" + part.key + "s")));
            }
        }
    }

    public static class MultiTypedTag<E extends Enum<E>, F extends Enum<F>>
    extends AbstractMap<E, Map<F, TagKey<Item>>> {
        public final TagKey<Item> tag;
        protected final Map<F, TagKey<Item>> categoryTags = new HashMap<F, TagKey<Item>>();
        protected final Map<E, Map<F, TagKey<Item>>> tags = new HashMap<E, Map<F, TagKey<Item>>>();

        public MultiTypedTag(TagKey<Item> tag) {
            this.tag = tag;
        }

        public TagKey<Item> get(E type1, F type2) {
            return Objects.requireNonNull(this.tags.get(type1).get(type2), ((IType)type1).key() + "_" + ((IType)type2).key());
        }

        public TagKey<Item> getSubType(F type) {
            return Objects.requireNonNull(this.categoryTags.get(type), ((IType)type).key());
        }

        @Override
        @NotNull
        public Set<Map.Entry<E, Map<F, TagKey<Item>>>> entrySet() {
            return this.tags.entrySet();
        }

        @NotNull
        public Set<Map.Entry<F, TagKey<Item>>> entrySubSet() {
            return this.categoryTags.entrySet();
        }
    }

    public static class MaterialTag
    extends TypedTag<MaterialType> {
        public MaterialTag(String name, YTechItems.TypedItem<MaterialType> item) {
            this(name, YTechItemTags.create(name), item);
        }

        public MaterialTag(String name, String namespace, YTechItems.TypedItem<MaterialType> item) {
            this(name, namespace, YTechItemTags.create(namespace, name), item);
        }

        public MaterialTag(String name, TagKey<Item> tag, YTechItems.TypedItem<MaterialType> item) {
            this(name, "ytech", tag, item);
        }

        public MaterialTag(String name, String namespace, TagKey<Item> tag, YTechItems.TypedItem<MaterialType> item) {
            this(name, namespace, tag, EnumSet.copyOf(item.keySet()));
        }

        public MaterialTag(YTechBlockTags.MaterialTag materialTag) {
            super(materialTag.getName(), materialTag.getNamespace(), YTechItemTags.create(materialTag.tag), EnumSet.copyOf(materialTag.tags.keySet()), materialTag.materialNameSupplier);
        }

        public MaterialTag(YTechBlockTags.MaterialTag materialTag, EnumSet<MaterialType> materials) {
            super(materialTag.getName(), materialTag.getNamespace(), YTechItemTags.create(materialTag.tag), materials, materialTag.materialNameSupplier);
        }

        public MaterialTag(String name, String namespace, TagKey<Item> tag, EnumSet<MaterialType> materials) {
            super(name, namespace, tag, materials, type -> type.key);
        }
    }

    private static class IngotMaterialTag
    extends MaterialTag {
        public IngotMaterialTag() {
            super("ingots", "c", (TagKey<Item>)Tags.Items.INGOTS, YTechItems.INGOTS);
            this.tags.put(MaterialType.COPPER, Tags.Items.INGOTS_COPPER);
            this.tags.put(MaterialType.GOLD, Tags.Items.INGOTS_GOLD);
            this.tags.put(MaterialType.IRON, Tags.Items.INGOTS_IRON);
        }
    }

    private static class RawMaterialTag
    extends MaterialTag {
        public RawMaterialTag() {
            super("raw_materials", "c", (TagKey<Item>)Tags.Items.RAW_MATERIALS, YTechItems.RAW_MATERIALS);
            this.tags.put(MaterialType.COPPER, Tags.Items.RAW_MATERIALS_COPPER);
            this.tags.put(MaterialType.GOLD, Tags.Items.RAW_MATERIALS_GOLD);
            this.tags.put(MaterialType.IRON, Tags.Items.RAW_MATERIALS_IRON);
        }
    }

    private static class DeepslateOreMaterialTag
    extends MaterialTag {
        public DeepslateOreMaterialTag() {
            super(YTechBlockTags.DEEPSLATE_ORES, Utils.exclude(EnumSet.copyOf(YTechBlocks.DEEPSLATE_ORES.materials()), MaterialType.VANILLA_METALS));
            this.tags.put(MaterialType.COPPER, Tags.Items.ORES_COPPER);
            this.tags.put(MaterialType.GOLD, Tags.Items.ORES_GOLD);
            this.tags.put(MaterialType.IRON, Tags.Items.ORES_IRON);
        }
    }

    private static class NetherOreMaterialTag
    extends MaterialTag {
        public NetherOreMaterialTag() {
            super(YTechBlockTags.NETHER_ORES, Utils.exclude(EnumSet.copyOf(YTechBlocks.NETHER_ORES.materials()), (Enum[])new MaterialType[]{MaterialType.GOLD}));
            this.tags.put(MaterialType.GOLD, Tags.Items.ORES_GOLD);
        }
    }

    private static class RawStorageBlockMaterialTag
    extends MaterialTag {
        public RawStorageBlockMaterialTag() {
            super(YTechBlockTags.RAW_STORAGE_BLOCKS, Utils.exclude(EnumSet.copyOf(YTechBlocks.RAW_STORAGE_BLOCKS.materials()), MaterialType.VANILLA_METALS));
            this.tags.put(MaterialType.COPPER, Tags.Items.STORAGE_BLOCKS_RAW_COPPER);
            this.tags.put(MaterialType.GOLD, Tags.Items.STORAGE_BLOCKS_RAW_GOLD);
            this.tags.put(MaterialType.IRON, Tags.Items.STORAGE_BLOCKS_RAW_IRON);
        }
    }

    private static class StoneOreMaterialTag
    extends MaterialTag {
        public StoneOreMaterialTag() {
            super(YTechBlockTags.STONE_ORES, Utils.exclude(EnumSet.copyOf(YTechBlocks.STONE_ORES.materials()), MaterialType.VANILLA_METALS));
            this.tags.put(MaterialType.COPPER, Tags.Items.ORES_COPPER);
            this.tags.put(MaterialType.GOLD, Tags.Items.ORES_GOLD);
            this.tags.put(MaterialType.IRON, Tags.Items.ORES_IRON);
        }
    }

    private static class StorageBlockMaterialTag
    extends MaterialTag {
        public StorageBlockMaterialTag() {
            super(YTechBlockTags.STORAGE_BLOCKS, Utils.exclude(EnumSet.copyOf(YTechBlocks.STORAGE_BLOCKS.materials()), MaterialType.VANILLA_METALS));
            this.tags.put(MaterialType.COPPER, Tags.Items.STORAGE_BLOCKS_COPPER);
            this.tags.put(MaterialType.GOLD, Tags.Items.STORAGE_BLOCKS_GOLD);
            this.tags.put(MaterialType.IRON, Tags.Items.STORAGE_BLOCKS_IRON);
        }
    }
}

