/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.logging.LogUtils;
import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.block.CraftingWorkspaceBlock;
import com.yanny.ytech.configuration.block.GrassBedBlock;
import com.yanny.ytech.configuration.block.WoodenBoxBlock;
import com.yanny.ytech.registration.YTechBiomeTags;
import com.yanny.ytech.registration.YTechBlockTags;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechMobEffects;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingBreatheEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="ytech", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeBusSubscriber {
    @NotNull
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void onPlayerSpawnSet(@NotNull PlayerSetSpawnEvent event) {
        BlockPos pos = event.getNewSpawn();
        if (pos != null && event.getEntity().m_9236_().m_8055_(pos).m_60734_() instanceof GrassBedBlock) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLevelLoad(@NotNull LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            YTechMod.IRRIGATION_PROPAGATOR.server().onLevelLoad(level);
        } else if (levelAccessor instanceof ClientLevel) {
            ClientLevel level = (ClientLevel)levelAccessor;
            YTechMod.IRRIGATION_PROPAGATOR.client().onLevelLoad(level);
        }
    }

    @SubscribeEvent
    public static void onLevelUnload(@NotNull LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            YTechMod.IRRIGATION_PROPAGATOR.server().onLevelUnload(level);
        } else if (levelAccessor instanceof ClientLevel) {
            ClientLevel level = (ClientLevel)levelAccessor;
            YTechMod.IRRIGATION_PROPAGATOR.client().onLevelUnload(level);
        }
    }

    @SubscribeEvent
    public static void onServerStarting(@NotNull ServerStartingEvent event) {
        Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getTag(YTechBlockTags.REQUIRE_VALID_TOOL).forEach(ForgeBusSubscriber::setBlockRequireValidTool);
    }

    @SubscribeEvent
    public static void onPlayerLogIn(@NotNull PlayerEvent.PlayerLoggedInEvent event) {
        YTechMod.IRRIGATION_PROPAGATOR.server().onPlayerLogIn(event.getEntity());
    }

    @SubscribeEvent
    public static void onLevelTick(@NotNull TickEvent.LevelTickEvent event) {
        ServerLevel level;
        Level level2;
        if (event.phase == TickEvent.Phase.START && event.side == LogicalSide.SERVER && (level2 = event.level) instanceof ServerLevel) {
            level = (ServerLevel)level2;
            YTechMod.IRRIGATION_PROPAGATOR.server().getNetworks(level).values().forEach(network -> network.tick((ServerLevel)event.level));
        }
        if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.SERVER && (level2 = event.level) instanceof ServerLevel) {
            level = (ServerLevel)level2;
            YTechMod.IRRIGATION_PROPAGATOR.server().tick(level);
        }
    }

    @SubscribeEvent
    public static void onChunkWatch(@NotNull ChunkWatchEvent.Watch event) {
        YTechMod.IRRIGATION_PROPAGATOR.server().onChunkWatch(event.getLevel(), event.getPlayer(), event.getChunk());
    }

    @SubscribeEvent
    public static void onPlayerLeftClickBlock(@NotNull PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        Level level = event.getLevel();
        ItemStack heldItem = player.m_21205_();
        BlockState blockState = level.m_8055_(event.getPos());
        Direction direction = event.getFace();
        if (!level.f_46443_ && !player.m_7500_() && direction != null && event.getAction() == PlayerInteractEvent.LeftClickBlock.Action.START && event.getHand() == InteractionHand.MAIN_HAND) {
            level.m_7465_().m_44015_((RecipeType)YTechRecipeTypes.BLOCK_HIT.get(), (Container)new SimpleContainer(new ItemStack[]{heldItem, blockState.m_60734_().m_5456_().m_7968_()}), level).ifPresent(recipe -> {
                Block.m_152435_((Level)level, (BlockPos)event.getPos(), (Direction)direction, (ItemStack)recipe.result().m_41777_());
                heldItem.m_41774_(1);
            });
        }
    }

    @SubscribeEvent
    public static void onLivingBreatheEvent(@NotNull LivingBreatheEvent event) {
        if (event.getEntity().m_21023_((MobEffect)YTechMobEffects.ABYSS_WALKER.get()) && event.getEntity().m_9236_().m_46467_() % 2L == 0L) {
            event.setConsumeAirAmount(0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRenderHighlightEvent(RenderHighlightEvent.Block event) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (level != null && player != null) {
            if (level.m_8055_(event.getTarget().m_82425_()).m_60713_((Block)YTechBlocks.CRAFTING_WORKSPACE.get())) {
                Vec3 camera = event.getCamera().m_90583_();
                PoseStack poseStack = event.getPoseStack();
                ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
                int[] position = CraftingWorkspaceBlock.getPosition(event.getTarget(), itemStack.m_41619_());
                if (position == null) {
                    return;
                }
                poseStack.m_85836_();
                poseStack.m_85837_(-camera.f_82479_, -camera.f_82480_, -camera.f_82481_);
                poseStack.m_85837_((double)position[0] / 3.0, (double)position[1] / 3.0, (double)position[2] / 3.0);
                float cR = 0.1f;
                float cG = 1.0f;
                float cB = 0.1f;
                BlockPos target = event.getTarget().m_82425_();
                LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)event.getMultiBufferSource().m_6299_((RenderType)RenderType.f_110371_), (AABB)CraftingWorkspaceBlock.BOX.m_83215_().m_82338_(target), (float)cR, (float)cG, (float)cB, (float)1.0f);
                poseStack.m_85849_();
            } else if (level.m_8055_(event.getTarget().m_82425_()).m_60713_((Block)YTechBlocks.WOODEN_BOX.get())) {
                Vec3 camera = event.getCamera().m_90583_();
                PoseStack poseStack = event.getPoseStack();
                BlockHitResult hitResult = event.getTarget();
                int[] position = WoodenBoxBlock.getPosition(event.getTarget());
                if (position == null || hitResult.m_82434_() != Direction.UP) {
                    return;
                }
                poseStack.m_85836_();
                poseStack.m_85837_(-camera.f_82479_, -camera.f_82480_, -camera.f_82481_);
                poseStack.m_85837_(0.125 + (double)position[0] / 4.0, 0.5, 0.125 + (double)position[1] / 4.0);
                float cR = 0.1f;
                float cG = 0.1f;
                float cB = 0.1f;
                BlockPos target = event.getTarget().m_82425_();
                LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)event.getMultiBufferSource().m_6299_((RenderType)RenderType.f_110371_), (AABB)WoodenBoxBlock.BOX.m_83215_().m_82338_(target), (float)cR, (float)cG, (float)cB, (float)0.5f);
                poseStack.m_85849_();
            }
        }
    }

    @SubscribeEvent
    public static void onCreateFluidSourceEvent(@NotNull BlockEvent.CreateFluidSourceEvent event) {
        if (event.getState().m_60819_().m_192917_((Fluid)Fluids.f_76193_) && YTechMod.CONFIGURATION.hasFiniteWaterSource() && !event.getLevel().m_204166_(event.getPos()).m_203656_(YTechBiomeTags.INFINITE_WATER_SOURCE_BIOMES)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onCropGrowEvent(@NotNull BlockEvent.CropGrowEvent.Pre event) {
        BlockState blockState;
        if (YTechMod.CONFIGURATION.cropsNeedWateredFarmland() && (blockState = event.getLevel().m_8055_(event.getPos().m_7495_())).m_61138_((Property)BlockStateProperties.f_61423_) && (Integer)blockState.m_61143_((Property)BlockStateProperties.f_61423_) < 7) {
            event.setResult(Event.Result.DENY);
        }
    }

    private static void setBlockRequireValidTool(@NotNull Block block) {
        try {
            BlockState blockState = (BlockState)ObfuscationReflectionHelper.getPrivateValue(Block.class, (Object)block, (String)"f_49786_");
            if (blockState != null) {
                ObfuscationReflectionHelper.setPrivateValue(BlockBehaviour.BlockStateBase.class, (Object)blockState, (Object)Boolean.TRUE, (String)"f_60600_");
            }
            LOGGER.info("Set requiresCorrectToolForDrops on {}", (Object)Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)));
        }
        catch (Exception e) {
            LOGGER.warn("Unable to set requiresCorrectToolForDrops on block {}: {}", (Object)Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)), (Object)e.getMessage());
        }
    }
}

