/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.compatibility;

import com.yanny.ytech.compatibility.emi.EmiAlloyingRecipe;
import com.yanny.ytech.compatibility.emi.EmiBlockHitRecipe;
import com.yanny.ytech.compatibility.emi.EmiChoppingRecipe;
import com.yanny.ytech.compatibility.emi.EmiDryingRecipe;
import com.yanny.ytech.compatibility.emi.EmiHammeringRecipe;
import com.yanny.ytech.compatibility.emi.EmiMillingRecipe;
import com.yanny.ytech.compatibility.emi.EmiPotteryRecipe;
import com.yanny.ytech.compatibility.emi.EmiSmeltingRecipe;
import com.yanny.ytech.compatibility.emi.EmiTanningRecipe;
import com.yanny.ytech.compatibility.emi.EmiWorkspaceCraftingRecipe;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.registration.YTechRecipeTypes;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.RegistryObject;

@EmiEntrypoint
public class EmiCompatibility
implements EmiPlugin {
    public static final ResourceLocation TEXTURE = Utils.modLoc("textures/gui/emi.png");

    public void register(EmiRegistry emiRegistry) {
        this.registerRecipe(emiRegistry, YTechRecipeTypes.ALLOYING, EmiAlloyingRecipe.CATEGORY, (EmiIngredient)EmiAlloyingRecipe.WORKSTATION, EmiAlloyingRecipe::new);
        this.registerRecipe(emiRegistry, YTechRecipeTypes.BLOCK_HIT, EmiBlockHitRecipe.CATEGORY, (EmiIngredient)EmiBlockHitRecipe.WORKSTATION, EmiBlockHitRecipe::new);
        this.registerRecipe(emiRegistry, YTechRecipeTypes.CHOPPING, EmiChoppingRecipe.CATEGORY, (EmiIngredient)EmiChoppingRecipe.WORKSTATION, EmiChoppingRecipe::new);
        this.registerRecipe(emiRegistry, YTechRecipeTypes.DRYING, EmiDryingRecipe.CATEGORY, EmiDryingRecipe.WORKSTATION, EmiDryingRecipe::new);
        this.registerRecipe(emiRegistry, YTechRecipeTypes.HAMMERING, EmiHammeringRecipe.CATEGORY, (EmiIngredient)EmiHammeringRecipe.WORKSTATION, EmiHammeringRecipe::new);
        this.registerRecipe(emiRegistry, YTechRecipeTypes.MILLING, EmiMillingRecipe.CATEGORY, (EmiIngredient)EmiMillingRecipe.WORKSTATION, EmiMillingRecipe::new);
        this.registerRecipe(emiRegistry, YTechRecipeTypes.POTTERY, EmiPotteryRecipe.CATEGORY, (EmiIngredient)EmiPotteryRecipe.WORKSTATION, EmiPotteryRecipe::new);
        this.registerRecipe(emiRegistry, YTechRecipeTypes.SMELTING, EmiSmeltingRecipe.CATEGORY, (EmiIngredient)EmiSmeltingRecipe.WORKSTATION, EmiSmeltingRecipe::new);
        this.registerRecipe(emiRegistry, YTechRecipeTypes.TANNING, EmiTanningRecipe.CATEGORY, EmiTanningRecipe.WORKSTATION, EmiTanningRecipe::new);
        this.registerRecipe(emiRegistry, YTechRecipeTypes.WORKSPACE_CRAFTING, EmiWorkspaceCraftingRecipe.CATEGORY, (EmiIngredient)EmiWorkspaceCraftingRecipe.WORKSTATION, EmiWorkspaceCraftingRecipe::new);
    }

    private <T extends Recipe<Container>> void registerRecipe(EmiRegistry registry, RegistryObject<RecipeType<T>> recipe, EmiRecipeCategory category, EmiIngredient icon, Function<T, EmiRecipe> supplier) {
        RecipeManager manager = registry.getRecipeManager();
        registry.addCategory(category);
        registry.addWorkstation(category, icon);
        for (Recipe r : manager.m_44013_((RecipeType)recipe.get())) {
            registry.addRecipe(supplier.apply(r));
        }
    }

    public static <T extends Recipe<?>> ResourceLocation ref(RegistryObject<RecipeType<T>> recipeType) {
        return new ResourceLocation(((RecipeType)recipeType.get()).toString());
    }
}

