/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.compatibility.jei;

import com.yanny.ytech.compatibility.jei.TemperatureWidget;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.recipe.AlloyingRecipe;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechItems;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class AlloyingRecipeCategory
extends AbstractRecipeCategory<AlloyingRecipe> {
    public static final RecipeType<AlloyingRecipe> RECIPE_TYPE = RecipeType.create((String)"ytech", (String)"alloying", AlloyingRecipe.class);
    public static final ResourceLocation TEXTURE = Utils.modLoc("textures/gui/emi.png");

    public AlloyingRecipeCategory(IGuiHelper guiHelper) {
        super(RECIPE_TYPE, (Component)Component.m_237115_((String)"emi.category.ytech.alloying"), guiHelper.createDrawableItemLike((ItemLike)YTechItems.PRIMITIVE_ALLOY_SMELTER.get()), 112, 38);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AlloyingRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 5).setStandardSlotBackground().addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Stream.of(recipe.ingredient1().m_43908_()).peek(r -> r.m_41764_(recipe.count1())).toList());
        builder.addSlot(RecipeIngredientRole.INPUT, 28, 5).setStandardSlotBackground().addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Stream.of(recipe.ingredient2().m_43908_()).peek(r -> r.m_41764_(recipe.count2())).toList());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 91, 5).setOutputSlotBackground().addItemStack(recipe.result());
    }

    public void createRecipeExtras(@NotNull IRecipeExtrasBuilder builder, @NotNull AlloyingRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addAnimatedRecipeArrow(recipe.smeltingTime()).setPosition(54, 5);
        builder.addAnimatedRecipeFlame(1600).setPosition(19, 24);
        builder.addWidget((IRecipeWidget)new TemperatureWidget(0, 0, 4000));
    }

    public void getTooltip(@NotNull ITooltipBuilder tooltip, @NotNull AlloyingRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        super.getTooltip(tooltip, (Object)recipe, recipeSlotsView, mouseX, mouseY);
        if (mouseX >= 54.0 && mouseX <= 78.0 && mouseY >= 5.0 && mouseY <= 22.0) {
            tooltip.add((FormattedText)Component.m_237110_((String)"emi.alloying.time", (Object[])new Object[]{Float.valueOf((float)recipe.smeltingTime() / 20.0f)}));
        }
        if (mouseX >= 0.0 && mouseX <= 8.0 && mouseY >= 0.0 && mouseY <= 38.0) {
            tooltip.add((FormattedText)Component.m_237110_((String)"emi.alloying.temperature", (Object[])new Object[]{recipe.minTemperature()}));
        }
    }

    public static List<AlloyingRecipe> getRecipes(@NotNull RecipeManager recipeManager) {
        return recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)YTechRecipeTypes.ALLOYING.get()).stream().toList();
    }

    public static void registerCatalyst(@NotNull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)YTechBlocks.PRIMITIVE_ALLOY_SMELTER.get()), new RecipeType[]{RECIPE_TYPE, RecipeTypes.FUELING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)YTechBlocks.BRICK_CHIMNEY.get()), new RecipeType[]{RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)YTechBlocks.REINFORCED_BRICK_CHIMNEY.get()), new RecipeType[]{RECIPE_TYPE});
    }
}

