/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration;

import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechItemTags;
import com.yanny.ytech.registration.YTechItems;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public enum AdvancementType {
    STONE_AGE(new Builder("stone_age", "root").root((ItemLike)Items.f_42484_, Utils.modLoc("textures/advancements/stone_age.png"), "Stone Age", "Lasted for roughly 3.4 million years and ended with the advent of metalworking.").hasOneOfItems(new ItemLike[]{Items.f_42484_})),
    FIRST_STEPS(new Builder("stone_age", "first_steps").parent(() -> AdvancementType.STONE_AGE.advancement).display((ItemLike)YTechItems.SHARP_FLINT.get(), FrameType.TASK, "First Steps", "Hit the flint against the stone.").hasOneOfTags(YTechItemTags.SHARP_FLINTS)),
    GRASS_HUNT(new Builder("stone_age", "grass_hunt").parent(() -> AdvancementType.FIRST_STEPS.advancement).display((ItemLike)YTechItems.GRASS_FIBERS.get(), FrameType.TASK, "Grass Hunt", "Collect grass fibers by breaking grass with a sharp flint.").hasOneOfTags(YTechItemTags.GRASS_FIBERS)),
    RUN_FOREST_RUN(new Builder("stone_age", "run_forest_run").parent(() -> AdvancementType.FIRST_STEPS.advancement).display((ItemLike)YTechItems.ANTLER.get(), FrameType.TASK, "Run Forest Run", "Go and hunt deer for antlers.").hasOneOfTags(YTechItemTags.ANTLERS)),
    LEATHERCRAFT(new Builder("stone_age", "leathercraft").parent(() -> AdvancementType.FIRST_STEPS.advancement).display((ItemLike)Items.f_42454_, FrameType.TASK, "Leathercraft", "Process raw hide to create leather.").hasOneOfItems(new ItemLike[]{Items.f_42454_})),
    SUNNY_DAY(new Builder("stone_age", "sunny_day").parent(() -> AdvancementType.FIRST_STEPS.advancement).display((ItemLike)((RegistryObject)YTechItems.DRYING_RACKS.get(MaterialType.OAK_WOOD)).get(), FrameType.CHALLENGE, "Sunny Day", "Create all dried foods.").hasAllTags(YTechItemTags.DRIED_BEEFS, YTechItemTags.DRIED_CHICKENS, YTechItemTags.DRIED_CODS, YTechItemTags.DRIED_MUTTONS, YTechItemTags.DRIED_PORKCHOP, YTechItemTags.DRIED_RABBITS, YTechItemTags.DRIED_SALMONS, YTechItemTags.DRIED_VENISON)),
    SMELTER_TIME(new Builder("stone_age", "smelter_time").parent(() -> AdvancementType.FIRST_STEPS.advancement).display((ItemLike)YTechBlocks.PRIMITIVE_SMELTER.get(), FrameType.TASK, "Smelter Time", "Craft smelter and some chimneys to be able melt crushed ore.").hasOneOfTags(YTechItemTags.PRIMITIVE_SMELTERS)),
    IRRIGATION_SYSTEM(new Builder("stone_age", "irrigation_system").parent(() -> AdvancementType.FIRST_STEPS.advancement).display((ItemLike)YTechBlocks.AQUEDUCTS.of(MaterialType.TERRACOTTA).get(), FrameType.TASK, "Irrigation System", "Craft aqueduct for long distance water transportation.").hasOneOfTags(YTechItemTags.AQUEDUCTS.tag)),
    BETTER_THAN_NOTHING(new Builder("stone_age", "better_than_nothing").parent(() -> AdvancementType.GRASS_HUNT.advancement).display((ItemLike)((RegistryObject)YTechItems.KNIVES.get(MaterialType.FLINT)).get(), FrameType.TASK, "Better Than Nothing", "Craft flint knife.").hasOneOfTags((TagKey)YTechItemTags.KNIVES.get(MaterialType.FLINT))),
    NOT_THAT_SIMPLE(new Builder("stone_age", "not_that_simple").parent(() -> AdvancementType.GRASS_HUNT.advancement).display((ItemLike)((RegistryObject)YTechItems.AXES.get(MaterialType.FLINT)).get(), FrameType.TASK, "Not That Simple", "Craft flint axe to get wood.").hasOneOfTags((TagKey)YTechItemTags.AXES.get(MaterialType.FLINT))),
    MINECRAFT(new Builder("stone_age", "minecraft").parent(() -> AdvancementType.GRASS_HUNT.advancement).display((ItemLike)((RegistryObject)YTechItems.PICKAXES.get(MaterialType.ANTLER)).get(), FrameType.TASK, "Minecraft", "First pickaxe was made from antler.").hasOneOfTags((TagKey)YTechItemTags.PICKAXES.get(MaterialType.ANTLER))),
    DIRTY_THINGS(new Builder("stone_age", "dirty_things").parent(() -> AdvancementType.GRASS_HUNT.advancement).display((ItemLike)Items.f_42421_, FrameType.TASK, "Dirty Things", "Craft wooden shovel, so you can finally build an shack.").hasOneOfItems(new ItemLike[]{Items.f_42421_})),
    STORAGE_MANAGEMENT(new Builder("stone_age", "storage_management").parent(() -> AdvancementType.GRASS_HUNT.advancement).display((ItemLike)YTechItems.BASKET.get(), FrameType.TASK, "Storage Management", "Increase your inventory capacity by crafting basket.").hasOneOfTags(YTechItemTags.BASKETS)),
    COVER_ME_IN_LEATHER(new Builder("stone_age", "cover_me_in_leather").parent(() -> AdvancementType.LEATHERCRAFT.advancement).display((ItemLike)Items.f_42408_, FrameType.GOAL, "Cover Me in Leather", "Craft all parts of leather armor.").hasAllItems(new ItemLike[]{Items.f_42407_, Items.f_42408_, Items.f_42462_, Items.f_42463_})),
    COPPER(new Builder("stone_age", "copper").parent(() -> AdvancementType.SMELTER_TIME.advancement).display((ItemLike)Items.f_151052_, FrameType.TASK, "Copper", "Smelt copper ingot.").hasOneOfTags((TagKey)YTechItemTags.INGOTS.get(MaterialType.COPPER))),
    TIN(new Builder("stone_age", "tin").parent(() -> AdvancementType.SMELTER_TIME.advancement).display((ItemLike)((RegistryObject)YTechItems.INGOTS.get(MaterialType.TIN)).get(), FrameType.TASK, "Tin", "Smelt tin ingot.").hasOneOfTags((TagKey)YTechItemTags.INGOTS.get(MaterialType.TIN))),
    TAKE_THE_LEAD(new Builder("stone_age", "take_the_lead").parent(() -> AdvancementType.SMELTER_TIME.advancement).display((ItemLike)((RegistryObject)YTechItems.INGOTS.get(MaterialType.LEAD)).get(), FrameType.TASK, "Take The Lead", "Smelt lead ingot.").hasOneOfTags((TagKey)YTechItemTags.INGOTS.get(MaterialType.LEAD))),
    IN_GOLD_WE_TRUST(new Builder("stone_age", "in_gold_we_trust").parent(() -> AdvancementType.SMELTER_TIME.advancement).display((ItemLike)Items.f_42417_, FrameType.TASK, "In Gold We Trust", "Smelt gold ingot.").hasOneOfTags((TagKey)YTechItemTags.INGOTS.get(MaterialType.GOLD))),
    ALLOY_SMELTER(new Builder("stone_age", "alloy_smelter").parent(() -> AdvancementType.COPPER.advancement).display((ItemLike)YTechBlocks.PRIMITIVE_ALLOY_SMELTER.get(), FrameType.TASK, "Alloy Smelter", "Craft the alloy smelter and raise the temperature.").hasOneOfTags(YTechItemTags.PRIMITIVE_ALLOY_SMELTERS)),
    COPPER_ARMOR(new Builder("stone_age", "copper_armor").parent(() -> AdvancementType.COPPER.advancement).display((ItemLike)((RegistryObject)YTechItems.CHESTPLATES.get(MaterialType.COPPER)).get(), FrameType.GOAL, "Copper Armor", "Craft all pieces of copper armor.").hasAllTags((TagKey)YTechItemTags.HELMETS.get(MaterialType.COPPER), (TagKey)YTechItemTags.CHESTPLATES.get(MaterialType.COPPER), (TagKey)YTechItemTags.LEGGINGS.get(MaterialType.COPPER), (TagKey)YTechItemTags.BOOTS.get(MaterialType.COPPER))),
    NEW_FRONTIER(new Builder("stone_age", "new_frontier").parent(() -> AdvancementType.ALLOY_SMELTER.advancement).display((ItemLike)((RegistryObject)YTechItems.INGOTS.get(MaterialType.BRONZE)).get(), FrameType.GOAL, "New Frontier", "Smelting copper and tin together creates new stronger material.").hasOneOfTags((TagKey)YTechItemTags.INGOTS.get(MaterialType.BRONZE))),
    BRONZE_AGE(new Builder("bronze_age", "root").root((ItemLike)((RegistryObject)YTechItems.AXES.get(MaterialType.BRONZE)).get(), Utils.modLoc("textures/advancements/bronze_age.png"), "Bronze Age", "Bronze Age is characterized by the use of bronze").hasOneOfTags((TagKey)YTechItemTags.INGOTS.get(MaterialType.BRONZE))),
    HIT_HARD(new Builder("bronze_age", "hit_hard").parent(() -> AdvancementType.BRONZE_AGE.advancement).display((ItemLike)YTechBlocks.BRONZE_ANVIL.get(), FrameType.TASK, "Hit Hard", "Craft bronze anvil.").hasOneOfTags(YTechItemTags.BRONZE_ANVILS)),
    FERTILIZING_CROPS(new Builder("bronze_age", "fertilizing_crops").parent(() -> AdvancementType.HIT_HARD.advancement).display((ItemLike)YTechBlocks.AQUEDUCT_FERTILIZER.get(), FrameType.TASK, "Fertilizing Crops", "Craft aqueduct fertilizer.").hasOneOfTags(YTechItemTags.AQUEDUCT_FERTILIZERS)),
    BRONZE_ARMOR(new Builder("stone_age", "bronze_armor").parent(() -> AdvancementType.BRONZE_AGE.advancement).display((ItemLike)((RegistryObject)YTechItems.CHESTPLATES.get(MaterialType.BRONZE)).get(), FrameType.GOAL, "Bronze Armor", "Craft all pieces of bronze armor.").hasAllTags((TagKey)YTechItemTags.HELMETS.get(MaterialType.BRONZE), (TagKey)YTechItemTags.CHESTPLATES.get(MaterialType.BRONZE), (TagKey)YTechItemTags.LEGGINGS.get(MaterialType.BRONZE), (TagKey)YTechItemTags.BOOTS.get(MaterialType.BRONZE))),
    BRONZE_TOOLS(new Builder("bronze_age", "bronze_tools").parent(() -> AdvancementType.BRONZE_AGE.advancement).display((ItemLike)((RegistryObject)YTechItems.PICKAXES.get(MaterialType.BRONZE)).get(), FrameType.GOAL, "Bronze Tools", "Craft all bronze tools.").hasAllTags((TagKey)YTechItemTags.PICKAXES.get(MaterialType.BRONZE), (TagKey)YTechItemTags.AXES.get(MaterialType.BRONZE), (TagKey)YTechItemTags.SHOVELS.get(MaterialType.BRONZE), (TagKey)YTechItemTags.SWORDS.get(MaterialType.BRONZE))),
    MORE_AND_MORE(new Builder("bronze_age", "more_and_more").parent(() -> AdvancementType.BRONZE_AGE.advancement).display((ItemLike)YTechBlocks.REINFORCED_BRICK_CHIMNEY.get(), FrameType.TASK, "More and More", "Craft reinforced brick chimney.").hasOneOfTags(YTechItemTags.REINFORCED_BRICK_CHIMNEYS)),
    BLOOMBERG(new Builder("bronze_age", "bloomberg").parent(() -> AdvancementType.MORE_AND_MORE.advancement).display((ItemLike)YTechItems.IRON_BLOOM.get(), FrameType.TASK, "Bloomberg", "Smelt iron with charcoal to create iron bloom.").hasOneOfTags(YTechItemTags.IRON_BLOOMS)),
    IRON_MAN(new Builder("bronze_age", "iron_man").parent(() -> AdvancementType.BLOOMBERG.advancement).display((ItemLike)Items.f_42416_, FrameType.TASK, "Iron Man", "Using hammer on iron bloom creates iron ingot.").hasOneOfTags((TagKey)YTechItemTags.INGOTS.get(MaterialType.IRON)));

    private static final String STONE_AGE_GROUP = "stone_age";
    private static final String BRONZE_AGE_GROUP = "bronze_age";
    private final Builder builder;
    private Advancement advancement;

    private AdvancementType(Builder builder) {
        this.builder = builder;
    }

    public String titleId() {
        return this.builder.titleId;
    }

    public String title() {
        return this.builder.title;
    }

    public String description() {
        return this.builder.description;
    }

    public String descriptionId() {
        return this.builder.descriptionId;
    }

    public void generate(@NotNull Consumer<Advancement> saver, @NotNull ExistingFileHelper existingFileHelper) {
        if (this.builder.advancement != null) {
            this.builder.builder.m_138398_(this.builder.advancement.get());
        }
        this.advancement = this.builder.builder.save(saver, Utils.modLoc(this.builder.group + "/" + this.builder.id), existingFileHelper);
    }

    private static class Builder {
        private final Advancement.Builder builder;
        private final String group;
        private final String id;
        private Supplier<Advancement> advancement;
        private String titleId = "";
        private String title = "";
        private String descriptionId = "";
        private String description = "";

        Builder(@NotNull String group, @NotNull String id) {
            this.group = group;
            this.id = id;
            this.builder = Advancement.Builder.m_138353_();
        }

        Builder parent(@NotNull Supplier<Advancement> advancement) {
            this.advancement = advancement;
            return this;
        }

        Builder root(@NotNull ItemLike icon, @NotNull ResourceLocation background, @NotNull String title, @NotNull String descr) {
            this.title = title;
            this.description = descr;
            this.titleId = "advancements.ytech." + this.group + ".title." + this.id;
            this.descriptionId = "advancements.ytech." + this.group + ".description." + this.id;
            this.builder.m_138371_(icon, (Component)Component.m_237115_((String)this.titleId), (Component)Component.m_237115_((String)this.descriptionId), background, FrameType.TASK, false, false, false);
            return this;
        }

        Builder display(@NotNull ItemLike icon, @NotNull FrameType type, @NotNull String title, @NotNull String descr) {
            this.title = title;
            this.description = descr;
            this.titleId = "advancements.ytech." + this.group + ".title." + this.id;
            this.descriptionId = "advancements.ytech." + this.group + ".description." + this.id;
            this.builder.m_138371_(icon, (Component)Component.m_237115_((String)this.titleId), (Component)Component.m_237115_((String)this.descriptionId), null, type, false, false, false);
            return this;
        }

        Builder hasOneOfItems(ItemLike ... items) {
            this.builder.m_138386_(Utils.getHasName(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(items).m_45077_()}));
            return this;
        }

        Builder hasAllItems(ItemLike ... items) {
            this.builder.m_138360_(RequirementsStrategy.f_15978_);
            for (ItemLike item : items) {
                this.builder.m_138386_(RecipeProvider.m_176602_((ItemLike)item), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_()}));
            }
            return this;
        }

        @SafeVarargs
        final Builder hasOneOfTags(TagKey<Item> ... tags) {
            this.builder.m_138360_(RequirementsStrategy.f_15979_);
            for (TagKey<Item> tag : tags) {
                this.builder.m_138386_(Utils.getHasName(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(tag).m_45077_()}));
            }
            return this;
        }

        @SafeVarargs
        final Builder hasAllTags(TagKey<Item> ... tags) {
            this.builder.m_138360_(RequirementsStrategy.f_15978_);
            for (TagKey<Item> tag : tags) {
                this.builder.m_138386_(Utils.getHasName() + "_" + tag.f_203868_().m_135815_(), (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(tag).m_45077_()}));
            }
            return this;
        }
    }
}

