/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block_entity.TanningRackBlockEntity;
import com.yanny.ytech.configuration.recipe.WorkspaceCraftingRecipe;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechItemTags;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TanningRackBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE_EAST_WEST = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625);
    private static final VoxelShape SHAPE_NORTH_SOUTH = Shapes.m_83048_((double)0.4375, (double)0.0, (double)0.0, (double)0.5625, (double)1.0, (double)1.0);

    public TanningRackBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
    }

    @NotNull
    public BlockState m_5573_(@NotNull BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)blockPlaceContext.m_8125_().m_122424_());
    }

    public boolean m_7420_(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos) {
        return true;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull CollisionContext collisionContext) {
        Direction direction = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_);
        return direction == Direction.EAST || direction == Direction.WEST ? SHAPE_NORTH_SOUTH : SHAPE_EAST_WEST;
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new TanningRackBlockEntity(pos, state);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Optional optional = level.m_141902_(pos, (BlockEntityType)YTechBlockEntityTypes.TANNING_RACK.get());
        if (optional.isPresent()) {
            return ((TanningRackBlockEntity)((Object)optional.get())).onUse(state, level, pos, player, hand, hitResult);
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && !level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof TanningRackBlockEntity) {
            TanningRackBlockEntity tanningRack = (TanningRackBlockEntity)blockEntity;
            Containers.m_19010_((Level)level, (BlockPos)pos, (NonNullList)NonNullList.m_122780_((int)1, (Object)tanningRack.getItem()));
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    public static void registerModel(@NotNull BlockStateProvider provider, @NotNull RegistryObject<Block> block, MaterialType material) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(Utils.getPath(block))).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    faceBuilder.uvs(2.0f, 2.0f, 14.0f, 4.0f).texture("#2");
                }
            }
        }).from(2.0f, 13.0f, 8.0f).to(14.0f, 15.0f, 8.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    faceBuilder.uvs(2.0f, 2.0f, 14.0f, 4.0f).texture("#2");
                }
            }
        }).from(2.0f, 1.0f, 8.0f).to(14.0f, 3.0f, 8.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 16.0f).texture("#3");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(2.0f, 0.0f, 4.0f, 16.0f).texture("#3");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(4.0f, 0.0f, 6.0f, 16.0f).texture("#3");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(6.0f, 0.0f, 8.0f, 16.0f).texture("#3").cullface(direction);
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 2.0f).texture("#3").cullface(direction);
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(0.0f, 2.0f, 2.0f, 4.0f).texture("#3").cullface(direction);
                }
            }
        }).from(0.0f, 0.0f, 7.0f).to(2.0f, 16.0f, 9.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(8.0f, 0.0f, 10.0f, 16.0f).texture("#3");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(10.0f, 0.0f, 12.0f, 16.0f).texture("#3").cullface(direction);
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(12.0f, 0.0f, 14.0f, 16.0f).texture("#3");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(14.0f, 0.0f, 16.0f, 16.0f).texture("#3");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(8.0f, 0.0f, 10.0f, 2.0f).texture("#3").cullface(direction);
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(8.0f, 2.0f, 10.0f, 4.0f).texture("#3").cullface(direction);
                }
            }
        }).from(14.0f, 0.0f, 7.0f).to(16.0f, 16.0f, 9.0f).end()).texture("particle", Utils.modBlockLoc("wood/dark_bottom_" + material.key + "_log"))).texture("3", Utils.modBlockLoc("wood/dark_bottom_" + material.key + "_log"))).texture("2", Utils.modBlockLoc("horizontal_rope"));
        provider.horizontalBlock((Block)block.get(), (ModelFile)model);
        ((ItemModelBuilder)provider.itemModels().getBuilder(Utils.getPath(block))).parent((ModelFile)model);
    }

    public static void registerRecipe(@NotNull Consumer<FinishedRecipe> recipeConsumer, @NotNull RegistryObject<Item> item, MaterialType material) {
        WorkspaceCraftingRecipe.Builder.recipe(YTechItemTags.AXES.tag, (ItemLike)item.get()).define(Character.valueOf('W'), Utils.getLogFromMaterial(material)).define(Character.valueOf('T'), YTechItemTags.GRASS_TWINES).bottomPattern("   ").bottomPattern("WTW").bottomPattern("   ").middlePattern("   ").middlePattern("W W").middlePattern("   ").topPattern("   ").topPattern("WTW").topPattern("   ").group(YTechBlocks.TANNING_RACKS.getGroup() + "_" + material.group).unlockedBy("has_logs", (CriterionTriggerInstance)RecipeProvider.m_206406_((TagKey)ItemTags.f_13182_)).m_126140_(recipeConsumer, Utils.modLoc(item));
    }
}

