/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block.AqueductConsumerBlock;
import com.yanny.ytech.configuration.block.IrrigationBlock;
import com.yanny.ytech.configuration.block_entity.WellPulleyBlockEntity;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechBlocks;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WellPulleyBlock
extends IrrigationBlock {
    public static final EnumProperty<WellPulleyPart> WELL_PART = EnumProperty.m_61587_((String)"well", WellPulleyPart.class);
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty ACTIVATED = AqueductConsumerBlock.ACTIVATED;
    private static final VoxelShape WELL_SHAPE_Z = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.375, (double)1.0, (double)1.0, (double)0.625);
    private static final VoxelShape WELL_SHAPE_X = Shapes.m_83048_((double)0.375, (double)0.0, (double)0.0, (double)0.625, (double)1.0, (double)1.0);

    public WellPulleyBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50352_).m_278166_(PushReaction.DESTROY));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        if (pState.m_61143_(WELL_PART) == WellPulleyPart.BASE) {
            return Shapes.m_83144_();
        }
        if (((Direction)pState.m_61143_((Property)HORIZONTAL_FACING)).m_122434_() == Direction.Axis.X) {
            return WELL_SHAPE_X;
        }
        return WELL_SHAPE_Z;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Optional optional;
        BlockPos basePos = pos;
        BlockState aboveState = state;
        if (state.m_61143_(WELL_PART) == WellPulleyPart.TOP) {
            basePos = basePos.m_7495_();
        }
        if (aboveState.m_61143_(WELL_PART) == WellPulleyPart.BASE) {
            aboveState = level.m_8055_(basePos.m_7494_());
        }
        if ((optional = level.m_141902_(pos, (BlockEntityType)YTechBlockEntityTypes.WELL_PULLEY.get())).isPresent()) {
            return ((WellPulleyBlockEntity)optional.get()).onUse(level, aboveState, player);
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState blockState) {
        return RenderShape.MODEL;
    }

    @Override
    public List<BlockPos> getValidNeighbors(@NotNull BlockState blockState, @NotNull BlockPos pos) {
        return Direction.Plane.HORIZONTAL.m_122557_().map(dir -> pos.m_121955_(dir.m_122436_())).toList();
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        if (blockState.m_61143_(WELL_PART) == WellPulleyPart.BASE) {
            return new WellPulleyBlockEntity(blockPos, blockState);
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> entityType) {
        if (!level.f_46443_) {
            return (level1, pos, state1, blockEntity) -> WellPulleyBlock.createAqueductConsumerTicker(level1, blockEntity);
        }
        return null;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction direction = pContext.m_8125_();
        BlockPos clickedPos = pContext.m_8083_();
        BlockPos relative = clickedPos.m_121945_(Direction.UP);
        Level level = pContext.m_43725_();
        BlockPos below = clickedPos.m_7495_();
        BlockState blockBelow = level.m_8055_(below);
        if (level.m_8055_(relative).m_60629_(pContext) && level.m_6857_().m_61937_(relative) && blockBelow.m_60838_((BlockGetter)level, below)) {
            boolean hasNorthConnection = WellPulleyBlock.isValidForConnection((LevelAccessor)level, clickedPos, Direction.NORTH);
            boolean hasEastConnection = WellPulleyBlock.isValidForConnection((LevelAccessor)level, clickedPos, Direction.EAST);
            boolean hasSouthConnection = WellPulleyBlock.isValidForConnection((LevelAccessor)level, clickedPos, Direction.SOUTH);
            boolean hasWestConnection = WellPulleyBlock.isValidForConnection((LevelAccessor)level, clickedPos, Direction.WEST);
            BlockState state = this.m_49966_();
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(hasNorthConnection));
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(hasEastConnection));
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(hasSouthConnection));
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(hasWestConnection));
            return (BlockState)((BlockState)((BlockState)state.m_61124_(WELL_PART, (Comparable)((Object)WellPulleyPart.BASE))).m_61124_((Property)HORIZONTAL_FACING, (Comparable)direction.m_122424_())).m_61124_((Property)ACTIVATED, (Comparable)Boolean.valueOf(false));
        }
        return null;
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        if (state.m_61143_(WELL_PART) == WellPulleyPart.BASE && (pos.m_7494_().equals((Object)neighborPos) && !neighborState.m_60713_((Block)YTechBlocks.WELL_PULLEY.get()) || pos.m_7495_().equals((Object)neighborPos) && !neighborState.m_60838_((BlockGetter)level, neighborPos))) {
            return Blocks.f_50016_.m_49966_();
        }
        if (state.m_61143_(WELL_PART) == WellPulleyPart.TOP && pos.m_7495_().equals((Object)neighborPos) && !neighborState.m_60713_((Block)YTechBlocks.WELL_PULLEY.get())) {
            return Blocks.f_50016_.m_49966_();
        }
        boolean hasNorthConnection = WellPulleyBlock.isValidForConnection(level, pos, Direction.NORTH);
        boolean hasEastConnection = WellPulleyBlock.isValidForConnection(level, pos, Direction.EAST);
        boolean hasSouthConnection = WellPulleyBlock.isValidForConnection(level, pos, Direction.SOUTH);
        boolean hasWestConnection = WellPulleyBlock.isValidForConnection(level, pos, Direction.WEST);
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(hasNorthConnection));
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(hasEastConnection));
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(hasSouthConnection));
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(hasWestConnection));
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{WELL_PART, HORIZONTAL_FACING, ACTIVATED, BlockStateProperties.f_61368_, BlockStateProperties.f_61369_, BlockStateProperties.f_61370_, BlockStateProperties.f_61371_});
    }

    public void m_6402_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @javax.annotation.Nullable LivingEntity pPlacer, @NotNull ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        if (!pLevel.f_46443_) {
            pLevel.m_7731_(pPos.m_7494_(), (BlockState)pState.m_61124_(WELL_PART, (Comparable)((Object)WellPulleyPart.TOP)), 3);
            pLevel.m_6289_(pPos, Blocks.f_50016_);
            pState.m_60701_((LevelAccessor)pLevel, pPos, 3);
        }
    }

    public void m_5707_(Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull Player pPlayer) {
        if (!pLevel.f_46443_ && pPlayer.m_7500_()) {
            WellPulleyPart part = (WellPulleyPart)((Object)pState.m_61143_(WELL_PART));
            if (part == WellPulleyPart.BASE) {
                BlockPos blockPos = pPos.m_7494_();
                BlockState blockState = pLevel.m_8055_(blockPos);
                if (blockState.m_60713_((Block)this) && blockState.m_61143_(WELL_PART) == WellPulleyPart.TOP) {
                    pLevel.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 35);
                    pLevel.m_5898_(pPlayer, 2001, blockPos, Block.m_49956_((BlockState)blockState));
                }
            } else {
                BlockPos blockPos = pPos.m_7495_();
                BlockState blockState = pLevel.m_8055_(blockPos);
                if (blockState.m_60713_((Block)this) && blockState.m_61143_(WELL_PART) == WellPulleyPart.BASE) {
                    pLevel.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
                    pLevel.m_5898_(pPlayer, 2001, blockPos, Block.m_49956_((BlockState)blockState));
                }
            }
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public static void registerModel(@NotNull BlockStateProvider provider) {
        ModelBuilder base = provider.models().cubeColumnHorizontal("well_pulley_base", Utils.modBlockLoc("terracotta_bricks"), Utils.modBlockLoc("aqueduct/aqueduct_well"));
        ModelBuilder overlay = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(Utils.getPath(YTechBlocks.WELL_PULLEY) + "_overlay")).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            if (Objects.requireNonNull(direction) == Direction.NORTH) {
                faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#1");
            } else {
                faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#3");
            }
        }).from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).end()).renderType("minecraft:cutout")).texture("1", Utils.modBlockLoc("aqueduct/aqueduct_valve"))).texture("3", Utils.modBlockLoc("invisible"));
        ModelFile top = WellPulleyBlock.getTopModel(provider, false);
        ModelFile topActivated = WellPulleyBlock.getTopModel(provider, true);
        MultiPartBlockStateBuilder builder = provider.getMultipartBuilder((Block)YTechBlocks.WELL_PULLEY.get());
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)base).addModel()).condition(WELL_PART, (Comparable[])new WellPulleyPart[]{WellPulleyPart.BASE}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(top).addModel()).condition(WELL_PART, (Comparable[])new WellPulleyPart[]{WellPulleyPart.TOP}).condition((Property)HORIZONTAL_FACING, (Comparable[])new Direction[]{Direction.NORTH, Direction.SOUTH}).condition((Property)ACTIVATED, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(top).rotationY(90).addModel()).condition(WELL_PART, (Comparable[])new WellPulleyPart[]{WellPulleyPart.TOP}).condition((Property)HORIZONTAL_FACING, (Comparable[])new Direction[]{Direction.EAST, Direction.WEST}).condition((Property)ACTIVATED, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(topActivated).addModel()).condition(WELL_PART, (Comparable[])new WellPulleyPart[]{WellPulleyPart.TOP}).condition((Property)HORIZONTAL_FACING, (Comparable[])new Direction[]{Direction.NORTH, Direction.SOUTH}).condition((Property)ACTIVATED, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(topActivated).rotationY(90).addModel()).condition(WELL_PART, (Comparable[])new WellPulleyPart[]{WellPulleyPart.TOP}).condition((Property)HORIZONTAL_FACING, (Comparable[])new Direction[]{Direction.EAST, Direction.WEST}).condition((Property)ACTIVATED, (Comparable[])new Boolean[]{true}).end();
        PROPERTY_BY_DIRECTION.forEach((arg_0, arg_1) -> WellPulleyBlock.lambda$registerModel$3(builder, (ModelFile)overlay, arg_0, arg_1));
        ((ItemModelBuilder)provider.itemModels().getBuilder(Utils.getPath(YTechBlocks.WELL_PULLEY))).parent(top);
    }

    protected static void createAqueductConsumerTicker(@NotNull Level level, @NotNull BlockEntity blockEntity) {
        if (blockEntity instanceof WellPulleyBlockEntity) {
            WellPulleyBlockEntity wellPulleyBlockEntity = (WellPulleyBlockEntity)blockEntity;
            wellPulleyBlockEntity.tick((ServerLevel)level);
        }
    }

    private static ModelFile getTopModel(@NotNull BlockStateProvider provider, boolean activated) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(Utils.getPath(YTechBlocks.WELL_PULLEY) + (activated ? "_activated" : ""))).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case EAST: 
                case SOUTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 4.0f, 16.0f).texture("#0");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(0.0f, 0.0f, 4.0f, 16.0f).texture("#0").cullface(direction);
                    break;
                }
                case UP: 
                case DOWN: {
                    faceBuilder.uvs(6.0f, 6.0f, 10.0f, 10.0f).texture("#1").cullface(direction);
                }
            }
        }).from(0.0f, 0.0f, 6.0f).to(4.0f, 16.0f, 10.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 0.0f, 4.0f, 16.0f).texture("#0");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(0.0f, 0.0f, 4.0f, 16.0f).texture("#0").cullface(direction);
                    break;
                }
                case UP: 
                case DOWN: {
                    faceBuilder.uvs(6.0f, 6.0f, 10.0f, 10.0f).texture("#1").cullface(direction);
                }
            }
        }).from(12.0f, 0.0f, 6.0f).to(16.0f, 16.0f, 10.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: 
                case UP: 
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 3.0f, 2.0f).texture("#2");
                }
            }
        }).from(4.0f, 13.0f, 7.0f).to(7.0f, 15.0f, 9.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: 
                case UP: 
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 3.0f, 2.0f).texture("#2");
                }
            }
        }).from(9.0f, 13.0f, 7.0f).to(12.0f, 15.0f, 9.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case EAST: 
                case SOUTH: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 1.0f, 2.0f, 16.0f).texture("#3");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(2.0f, 0.0f, 4.0f, 2.0f).texture("#3");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(2.0f, 0.0f, 4.0f, 2.0f).texture("#3").cullface(direction);
                }
            }
        }).from(7.0f, 0.0f, 7.0f).to(9.0f, 15.0f, 9.0f).end()).texture("particle", Utils.mcBlockLoc("oak_log"))).texture("0", Utils.mcBlockLoc("oak_log"))).texture("1", Utils.modBlockLoc("well_top"))).texture("2", Utils.mcBlockLoc("oak_planks"))).texture("3", Utils.modBlockLoc(activated ? "vertical_rope_activated" : "vertical_rope"));
    }

    private static /* synthetic */ void lambda$registerModel$3(MultiPartBlockStateBuilder builder, ModelFile overlay, Direction dir, BooleanProperty value) {
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(overlay).rotationY(((Integer)ANGLE_BY_DIRECTION.get(dir)).intValue()).addModel()).condition(WELL_PART, (Comparable[])new WellPulleyPart[]{WellPulleyPart.BASE}).condition((Property)value, (Comparable[])new Boolean[]{true}).end();
    }

    public static enum WellPulleyPart implements StringRepresentable
    {
        BASE("base"),
        TOP("top");

        public final String name;

        private WellPulleyPart(String name) {
            this.name = name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }
}

