/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.block_entity.BrickChimneyBlockEntity;
import com.yanny.ytech.configuration.block_entity.MachineBlockEntity;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPrimitiveMachineBlockEntity
extends MachineBlockEntity {
    private static final String TAG_ITEMS = "items";
    private static final String TAG_SMELTING_TIME = "smeltingTime";
    private static final String TAG_LEFT_SMELTING = "smeltingLeft";
    private static final String TAG_RECIPE_TEMPERATURE = "recipeTemperature";
    private static final String TAG_BURNING_TIME = "burningTime";
    private static final String TAG_LEFT_BURNING = "burningLeft";
    private static final String TAG_TEMPERATURE = "temperature";
    private static final String TAG_NR_CHIMNEY = "nrChimney";
    private final RecipeType<?> recipeType;
    private int nrChimney = -1;
    private int burningTime = 0;
    private int leftBurningTime = 0;
    protected int temperature = 0;
    protected int leftSmelting = 0;
    protected int smeltingTime = 0;
    protected int recipeTemperature = 0;

    public AbstractPrimitiveMachineBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState, RecipeType<?> recipeType) {
        super(blockEntityType, pos, blockState);
        this.recipeType = recipeType;
    }

    @Override
    public void tickServer(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState blockState, @NotNull MachineBlockEntity blockEntity) {
        boolean isBurning = false;
        int maxTemperature = this.getMaxTemperature();
        AtomicBoolean hasChanged = new AtomicBoolean(false);
        if (!this.hasActiveRecipe()) {
            if (this.hasItemsInInput()) {
                this.startRecipe(hasChanged);
            }
        } else if (this.temperature >= this.recipeTemperature) {
            if (this.leftSmelting > 0) {
                --this.leftSmelting;
            } else {
                this.finishRecipe();
            }
            hasChanged.set(true);
        }
        if (this.leftBurningTime > 0) {
            --this.leftBurningTime;
            isBurning = true;
            hasChanged.set(true);
        } else {
            ItemStack fuel = this.itemStackHandler.getStackInSlot(this.getFuelSlot());
            if (!fuel.m_41619_() && (this.hasItemsInInput() && this.isValidRecipeInInput() || this.hasActiveRecipe())) {
                this.leftBurningTime = this.burningTime = ForgeHooks.getBurnTime((ItemStack)fuel, this.recipeType);
                isBurning = true;
                if (fuel.hasCraftingRemainingItem()) {
                    this.itemStackHandler.setStackInSlot(this.getFuelSlot(), fuel.getCraftingRemainingItem());
                }
                fuel.m_41774_(1);
                this.setLitState(level, blockState, pos, true);
            } else {
                this.setLitState(level, blockState, pos, false);
            }
        }
        int oldTemperature = this.temperature;
        if (isBurning && maxTemperature > this.temperature) {
            this.temperature = Math.min(maxTemperature, this.temperature + 1);
        } else if (!isBurning || maxTemperature < this.temperature) {
            this.temperature = Math.max(YTechMod.CONFIGURATION.getMinSmelterTemperature(), this.temperature - 1);
        }
        if (this.temperature != oldTemperature) {
            hasChanged.set(true);
        }
        if (hasChanged.get()) {
            AbstractPrimitiveMachineBlockEntity.m_155232_((Level)level, (BlockPos)this.f_58858_, (BlockState)Blocks.f_50016_.m_49966_());
        }
    }

    @Override
    public void tickClient(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState blockState, @NotNull MachineBlockEntity blockEntity) {
        if (((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue() && level.f_46441_.m_188503_(Math.max(Math.round(4.0f - (float)this.nrChimney / 2.0f), 1)) == 0) {
            for (int i = 0; i < level.f_46441_.m_188503_(2) + 2; ++i) {
                AbstractPrimitiveMachineBlockEntity.makeParticles(level, pos, this.nrChimney);
            }
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.nrChimney == -1) {
            this.nrChimney = this.detectChimneys(this.f_58857_);
            AbstractPrimitiveMachineBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.f_58858_, (BlockState)Blocks.f_50016_.m_49966_());
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            if (tag.m_128441_(TAG_ITEMS)) {
                this.itemStackHandler.deserializeNBT(tag.m_128469_(TAG_ITEMS));
            }
            if (tag.m_128441_(TAG_NR_CHIMNEY)) {
                this.nrChimney = tag.m_128451_(TAG_NR_CHIMNEY);
            }
            this.burningTime = tag.m_128451_(TAG_BURNING_TIME);
            this.leftBurningTime = tag.m_128451_(TAG_LEFT_BURNING);
            this.smeltingTime = tag.m_128451_(TAG_SMELTING_TIME);
            this.leftSmelting = tag.m_128451_(TAG_LEFT_SMELTING);
            this.temperature = tag.m_128451_(TAG_TEMPERATURE);
            this.recipeTemperature = tag.m_128451_(TAG_RECIPE_TEMPERATURE);
        } else {
            this.nrChimney = tag.m_128451_(TAG_NR_CHIMNEY);
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_(TAG_NR_CHIMNEY, this.nrChimney);
        return tag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    @NotNull
    public ContainerData createContainerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> Math.round((float)AbstractPrimitiveMachineBlockEntity.this.leftBurningTime / (float)AbstractPrimitiveMachineBlockEntity.this.burningTime * 100.0f);
                    case 1 -> AbstractPrimitiveMachineBlockEntity.this.getMaxTemperature();
                    case 2 -> AbstractPrimitiveMachineBlockEntity.this.temperature;
                    case 3 -> {
                        if (AbstractPrimitiveMachineBlockEntity.this.leftSmelting > 0) {
                            yield Math.round((float)(AbstractPrimitiveMachineBlockEntity.this.smeltingTime - AbstractPrimitiveMachineBlockEntity.this.leftSmelting) / (float)AbstractPrimitiveMachineBlockEntity.this.smeltingTime * 100.0f);
                        }
                        yield 0;
                    }
                    case 4 -> {
                        if (AbstractPrimitiveMachineBlockEntity.this.hasActiveRecipe()) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 5 -> {
                        if (((Boolean)AbstractPrimitiveMachineBlockEntity.this.m_58900_().m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                            yield 1;
                        }
                        yield 0;
                    }
                    default -> throw new IllegalStateException("Invalid index");
                };
            }

            public void m_8050_(int index, int value) {
            }

            public int m_6499_() {
                return 6;
            }
        };
    }

    public void onRemove() {
        BlockEntity blockEntity;
        if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7494_())) instanceof BrickChimneyBlockEntity) {
            BrickChimneyBlockEntity chimney = (BrickChimneyBlockEntity)blockEntity;
            chimney.onRemove();
        }
    }

    public int temperature() {
        return this.temperature;
    }

    public int progress() {
        return Math.round((float)(this.smeltingTime - this.leftSmelting) / (float)this.smeltingTime * 100.0f);
    }

    public void chimneyAdded() {
        if (this.f_58857_ != null) {
            ++this.nrChimney;
            AbstractPrimitiveMachineBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.f_58858_, (BlockState)Blocks.f_50016_.m_49966_());
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void chimneyRemoved() {
        if (this.f_58857_ != null) {
            --this.nrChimney;
            AbstractPrimitiveMachineBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.f_58858_, (BlockState)Blocks.f_50016_.m_49966_());
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            tag.m_128365_(TAG_ITEMS, (Tag)this.itemStackHandler.serializeNBT());
            tag.m_128405_(TAG_NR_CHIMNEY, this.nrChimney);
            tag.m_128405_(TAG_BURNING_TIME, this.burningTime);
            tag.m_128405_(TAG_LEFT_BURNING, this.leftBurningTime);
            tag.m_128405_(TAG_SMELTING_TIME, this.smeltingTime);
            tag.m_128405_(TAG_LEFT_SMELTING, this.leftSmelting);
            tag.m_128405_(TAG_TEMPERATURE, this.temperature);
            tag.m_128405_(TAG_RECIPE_TEMPERATURE, this.recipeTemperature);
        } else {
            tag.m_128405_(TAG_NR_CHIMNEY, this.nrChimney);
        }
    }

    protected abstract boolean hasItemsInInput();

    protected abstract int getFuelSlot();

    protected abstract void startRecipe(@NotNull AtomicBoolean var1);

    protected abstract void finishRecipe();

    public abstract boolean hasActiveRecipe();

    protected abstract boolean isValidRecipeInInput();

    private void setLitState(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockPos pos, boolean lit) {
        if (lit != (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_)) {
            BlockState newState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(lit));
            level.m_7731_(pos, newState, 3);
            AbstractPrimitiveMachineBlockEntity.m_155232_((Level)level, (BlockPos)this.f_58858_, (BlockState)newState);
        }
    }

    private int detectChimneys(@NotNull Level level) {
        BlockEntity blockEntity;
        int nrChimney = 0;
        BlockPos.MutableBlockPos blockPos = this.f_58858_.m_122032_();
        while ((blockEntity = level.m_7702_((BlockPos)(blockPos = blockPos.m_7494_()))) instanceof BrickChimneyBlockEntity) {
            BrickChimneyBlockEntity blockEntity2 = (BrickChimneyBlockEntity)blockEntity;
            ++nrChimney;
            blockEntity2.setMaster(this.f_58858_);
        }
        return nrChimney;
    }

    private int getMaxTemperature() {
        return YTechMod.CONFIGURATION.getMaxSmelterTemperature() + this.nrChimney * YTechMod.CONFIGURATION.getTemperaturePerChimney();
    }

    private static void makeParticles(@NotNull Level level, @NotNull BlockPos pos, int offset) {
        level.m_6485_((ParticleOptions)ParticleTypes.f_123777_, true, (double)pos.m_123341_() + 0.5 + level.f_46441_.m_188500_() / 3.0 * (double)(level.f_46441_.m_188499_() ? 1 : -1), (double)pos.m_123342_() + 0.5 + (double)offset + level.f_46441_.m_188500_() + level.f_46441_.m_188500_(), (double)pos.m_123343_() + 0.5 + level.f_46441_.m_188500_() / 3.0 * (double)(level.f_46441_.m_188499_() ? 1 : -1), 0.0, 0.07 + 0.02 * (double)offset, 0.0);
    }
}

