/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.MachineItemStackHandler;
import com.yanny.ytech.configuration.block_entity.AqueductHydratorBlockEntity;
import com.yanny.ytech.configuration.block_entity.IMenuBlockEntity;
import com.yanny.ytech.configuration.container.AqueductFertilizerMenu;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AqueductFertilizerBlockEntity
extends AqueductHydratorBlockEntity
implements MenuProvider,
IMenuBlockEntity {
    private static final String TAG_FERTILIZER = "fertilizer";
    private static final String TAG_ITEMS = "items";
    @NotNull
    protected final MachineItemStackHandler itemStackHandler = this.createItemStackHandler();
    @NotNull
    protected final ContainerData containerData = this.createContainerData();
    private int fertilizer = 0;

    public AqueductFertilizerBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        super((BlockEntityType<? extends BlockEntity>)((BlockEntityType)YTechBlockEntityTypes.AQUEDUCT_FERTILIZER.get()), pos, blockState);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.fertilizer = tag.m_128451_(TAG_FERTILIZER);
        if (tag.m_128441_(TAG_ITEMS)) {
            this.itemStackHandler.deserializeNBT(tag.m_128469_(TAG_ITEMS));
        }
    }

    @Override
    public void tick(@NotNull ServerLevel level) {
        super.tick(level);
        if (this.isHydrating()) {
            int z;
            int y;
            int x;
            BlockPos randomPos;
            if (this.fertilizer == 0 && level.m_46467_() % 20L == 0L) {
                if (this.useFertilizer()) {
                    this.fertilizer = YTechMod.CONFIGURATION.getFertilizerDuration();
                    AqueductFertilizerBlockEntity.m_155232_((Level)level, (BlockPos)this.f_58858_, (BlockState)Blocks.f_50016_.m_49966_());
                }
            } else if (this.fertilizer > 0) {
                --this.fertilizer;
                if (this.fertilizer == 0) {
                    if (this.useFertilizer()) {
                        this.fertilizer = YTechMod.CONFIGURATION.getFertilizerDuration();
                        AqueductFertilizerBlockEntity.m_155232_((Level)level, (BlockPos)this.f_58858_, (BlockState)Blocks.f_50016_.m_49966_());
                    }
                } else {
                    AqueductFertilizerBlockEntity.m_155232_((Level)level, (BlockPos)this.f_58858_, (BlockState)Blocks.f_50016_.m_49966_());
                }
            }
            if (this.fertilizer > 0 && level.f_46441_.m_188503_(YTechMod.CONFIGURATION.getApplyFertilizerChance()) == 0 && (randomPos = (BlockPos)BlockPos.m_235641_((RandomSource)level.f_46441_, (int)1, (int)((x = this.f_58858_.m_123341_()) - 4), (int)(y = this.f_58858_.m_123342_()), (int)((z = this.f_58858_.m_123343_()) - 4), (int)(x + 4), (int)y, (int)(z + 4)).iterator().next()) != null) {
                BonemealableBlock bonemealableBlock;
                Block block;
                BlockState state = level.m_8055_(randomPos);
                if (state.m_60734_() instanceof FarmBlock) {
                    randomPos = randomPos.m_7494_();
                    state = level.m_8055_(randomPos);
                }
                if ((block = state.m_60734_()) instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)block).m_7370_((LevelReader)level, randomPos, state, level.f_46443_) && bonemealableBlock.m_214167_((Level)level, level.f_46441_, randomPos, state)) {
                    bonemealableBlock.m_214148_(level, level.f_46441_, randomPos, state);
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)randomPos.m_123341_() + 0.5, (double)randomPos.m_123342_() + 0.5, (double)randomPos.m_123343_() + 0.5, 10, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"block.ytech.aqueduct_fertilizer");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        return new AqueductFertilizerMenu(pContainerId, pPlayer, this.f_58858_, this.itemStackHandler, this.createContainerData());
    }

    @Override
    @NotNull
    public MachineItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    @Override
    @NotNull
    public MachineItemStackHandler createItemStackHandler() {
        return new MachineItemStackHandler.Builder().addInputSlot(80, 32, (itemStackHandler, slot, itemStack) -> itemStack.m_204117_(YTechItemTags.FERTILIZER)).setOnChangeListener(() -> ((AqueductFertilizerBlockEntity)this).m_6596_()).build();
    }

    @Override
    @NotNull
    public ContainerData createContainerData() {
        return new SimpleContainerData(0);
    }

    @Override
    public int getDataSize() {
        return this.containerData.m_6499_();
    }

    public boolean isFertilizing() {
        return this.fertilizer > 0 && this.isHydrating();
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_(TAG_FERTILIZER, this.fertilizer);
        tag.m_128365_(TAG_ITEMS, (Tag)this.itemStackHandler.serializeNBT());
    }

    private boolean useFertilizer() {
        return !this.itemStackHandler.extractItem(0, 1, false).m_41619_();
    }
}

