/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.mojang.logging.LogUtils;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block.ReinforcedBrickChimneyBlock;
import com.yanny.ytech.configuration.block_entity.AbstractPrimitiveMachineBlockEntity;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BrickChimneyBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_MASTER_POSITION = "masterPos";
    private static final String TAG_HEIGHT_INDEX = "heightIndex";
    private static final int MAX_HEIGHT = 3;
    @Nullable
    private BlockPos masterPos = null;
    private int heightIndex = -1;

    public BrickChimneyBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)YTechBlockEntityTypes.BRICK_CHIMNEY.get(), pos, blockState);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.masterPos = tag.m_128441_(TAG_MASTER_POSITION) ? Utils.loadBlockPos(tag.m_128469_(TAG_MASTER_POSITION)) : null;
        this.heightIndex = tag.m_128441_(TAG_HEIGHT_INDEX) ? tag.m_128451_(TAG_HEIGHT_INDEX) : -1;
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.masterPos == null) {
            this.setMaster(this.f_58858_.m_7495_());
        }
    }

    public void setMaster(@NotNull BlockPos blockPos) {
        if (this.f_58857_ != null) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(blockPos);
            if (blockEntity instanceof AbstractPrimitiveMachineBlockEntity) {
                BrickChimneyBlockEntity chimney;
                BlockEntity blockEntity2;
                AbstractPrimitiveMachineBlockEntity primitiveMachine = (AbstractPrimitiveMachineBlockEntity)blockEntity;
                int height = -1;
                if (blockPos.equals((Object)this.f_58858_.m_7495_())) {
                    height = 3;
                } else {
                    blockEntity2 = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
                    if (blockEntity2 instanceof BrickChimneyBlockEntity) {
                        chimney = (BrickChimneyBlockEntity)blockEntity2;
                        height = chimney.getNextHeight(this.m_58900_().m_60734_() instanceof ReinforcedBrickChimneyBlock);
                    } else {
                        LOGGER.warn("Cannot get chimney height index, should not happen! At {}, master at {}", (Object)this.f_58858_, (Object)blockPos);
                    }
                }
                if (height == -1) {
                    this.removeBlock();
                } else {
                    this.registerChimney(this.f_58857_, blockPos, primitiveMachine, height);
                    blockEntity2 = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
                    if (blockEntity2 instanceof BrickChimneyBlockEntity) {
                        chimney = (BrickChimneyBlockEntity)blockEntity2;
                        chimney.setMaster(blockPos);
                    }
                }
            } else {
                blockEntity = this.f_58857_.m_7702_(blockPos);
                if (blockEntity instanceof BrickChimneyBlockEntity) {
                    BrickChimneyBlockEntity blockEntity3 = (BrickChimneyBlockEntity)blockEntity;
                    if (blockEntity3.masterPos != null) {
                        this.setMaster(blockEntity3.masterPos);
                    }
                }
            }
        }
    }

    public void onRemove() {
        BlockEntity blockEntity;
        if (this.f_58857_ != null && this.masterPos != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof AbstractPrimitiveMachineBlockEntity) {
            AbstractPrimitiveMachineBlockEntity primitiveMachine = (AbstractPrimitiveMachineBlockEntity)blockEntity;
            this.masterPos = null;
            this.heightIndex = -1;
            primitiveMachine.chimneyRemoved();
            BrickChimneyBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.f_58858_, (BlockState)Blocks.f_50016_.m_49966_());
            BlockEntity blockEntity2 = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
            if (blockEntity2 instanceof BrickChimneyBlockEntity) {
                BrickChimneyBlockEntity chimney = (BrickChimneyBlockEntity)blockEntity2;
                chimney.onRemove();
            }
        }
    }

    public void removeBlock() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_46961_(this.f_58858_, true);
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
            if (blockEntity instanceof BrickChimneyBlockEntity) {
                BrickChimneyBlockEntity chimney = (BrickChimneyBlockEntity)blockEntity;
                chimney.removeBlock();
            }
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        if (this.masterPos != null) {
            tag.m_128365_(TAG_MASTER_POSITION, (Tag)Utils.saveBlockPos(this.masterPos));
        }
        tag.m_128405_(TAG_HEIGHT_INDEX, this.heightIndex);
    }

    private int getNextHeight(boolean isReinforced) {
        if (this.heightIndex == -1) {
            return -1;
        }
        if (this.m_58900_().m_60734_() instanceof ReinforcedBrickChimneyBlock) {
            if (this.heightIndex > 0) {
                if (isReinforced) {
                    return this.heightIndex - 1;
                }
                return 3;
            }
            if (isReinforced) {
                return -1;
            }
            return 3;
        }
        if (isReinforced) {
            return -1;
        }
        if (this.heightIndex > 0) {
            return this.heightIndex - 1;
        }
        return -1;
    }

    private void registerChimney(@NotNull Level level, @NotNull BlockPos masterPos, @NotNull AbstractPrimitiveMachineBlockEntity primitiveMachine, int height) {
        this.masterPos = masterPos;
        this.heightIndex = height;
        primitiveMachine.chimneyAdded();
        BrickChimneyBlockEntity.m_155232_((Level)level, (BlockPos)this.f_58858_, (BlockState)Blocks.f_50016_.m_49966_());
    }
}

