/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.configuration.block.CraftingWorkspaceBlock;
import com.yanny.ytech.configuration.recipe.WorkspaceCraftingRecipe;
import com.yanny.ytech.configuration.renderer.FakeCraftingWorkspaceLevel;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.objenesis.ObjenesisStd;
import org.objenesis.instantiator.ObjectInstantiator;

public class CraftingWorkspaceBlockEntity
extends BlockEntity {
    private static final FakeCraftingWorkspaceLevel FAKE_LEVEL;
    private static final String TAG_BITMASK = "bitmask";
    private static final String TAG_ITEMS = "items";
    private static final String TAG_BLOCK_STATES = "blockStates";
    private final NonNullList<ItemStack> itemList = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    private final NonNullList<BlockState> blockStates = NonNullList.m_122780_((int)27, (Object)Blocks.f_50016_.m_49966_());
    private int bitmask = 0;

    public CraftingWorkspaceBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)YTechBlockEntityTypes.CRAFTING_WORKSPACE.get(), pPos, pBlockState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult use(@NotNull BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        int[] pos = CraftingWorkspaceBlock.getPosition(pHit, pPlayer.m_21120_(pHand).m_41619_());
        ItemStack itemStack = pPlayer.m_21120_(pHand);
        if (pos == null) return this.constructBlock(itemStack, pLevel, pPos, pPlayer, pHand, pHit) ? InteractionResult.CONSUME : InteractionResult.PASS;
        int index = CraftingWorkspaceBlock.getIndex(pos);
        BlockPos fakePos = new BlockPos(pos[0] + 1, pos[1] + 1, pos[2] + 1);
        if ((this.bitmask >> index & 1) == 0 && !itemStack.m_41619_()) {
            this.bitmask |= 1 << index;
            if (this.constructBlock(itemStack, pLevel, pPos, pPlayer, pHand, pHit)) return InteractionResult.CONSUME;
            BlockHitResult hit = new BlockHitResult(pHit.m_82450_(), pHit.m_82434_(), fakePos, true);
            FAKE_LEVEL.setData(pPos, (Level)pLevel, this.itemList, this.blockStates);
            Item item = itemStack.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                block = blockItem.m_40614_();
                BlockState state = block.m_5573_(new BlockPlaceContext((Level)FAKE_LEVEL, pPlayer, pHand, itemStack, hit));
                if (state == null) {
                    state = block.m_49966_();
                }
                this.blockStates.set(index, (Object)state);
                this.updateNeighbors(state, pos, fakePos);
            } else {
                block = itemStack.m_41720_();
                if (block instanceof BucketItem) {
                    BucketItem bucket = (BucketItem)block;
                    BlockState state = bucket.getFluid().m_76145_().m_76188_();
                    this.blockStates.set(index, (Object)state);
                    this.updateNeighbors(state, pos, fakePos);
                }
            }
            FAKE_LEVEL.clearData();
            this.itemList.set(index, (Object)itemStack.m_41620_(1));
        } else {
            if ((this.bitmask >> index & 1) != 1 || !itemStack.m_41619_()) return this.constructBlock(itemStack, pLevel, pPos, pPlayer, pHand, pHit) ? InteractionResult.CONSUME : InteractionResult.PASS;
            Block.m_152435_((Level)pLevel, (BlockPos)pPos, (Direction)pHit.m_82434_(), (ItemStack)((ItemStack)this.itemList.get(index)));
            FAKE_LEVEL.setData(pPos, (Level)pLevel, this.itemList, this.blockStates);
            this.blockStates.set(index, (Object)Blocks.f_50016_.m_49966_());
            this.updateNeighbors(Blocks.f_50016_.m_49966_(), pos, fakePos);
            FAKE_LEVEL.clearData();
            this.itemList.set(index, (Object)ItemStack.f_41583_);
            this.bitmask &= ~(1 << index);
        }
        pLevel.m_7260_(pPos, pState, pState, 3);
        pLevel.m_151543_(pPos);
        return InteractionResult.CONSUME;
    }

    public int getBitmask() {
        return this.bitmask;
    }

    public NonNullList<ItemStack> getItems() {
        return this.itemList;
    }

    public NonNullList<BlockState> getBlockStates() {
        return this.blockStates;
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.bitmask = pTag.m_128451_(TAG_BITMASK);
        ListTag list = pTag.m_128437_(TAG_ITEMS, 10);
        ListTag states = pTag.m_128437_(TAG_BLOCK_STATES, 10);
        for (int i = 0; i < 27; ++i) {
            this.itemList.set(i, (Object)ItemStack.m_41712_((CompoundTag)list.m_128728_(i)));
            this.blockStates.set(i, (Object)NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)states.m_128728_(i)));
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_(TAG_BITMASK, this.bitmask);
        ListTag list = new ListTag();
        ListTag states = new ListTag();
        for (int i = 0; i < 27; ++i) {
            list.add(i, (Tag)((ItemStack)this.itemList.get(i)).m_41739_(new CompoundTag()));
            states.add(i, (Tag)NbtUtils.m_129202_((BlockState)((BlockState)this.blockStates.get(i))));
        }
        pTag.m_128365_(TAG_ITEMS, (Tag)list);
        pTag.m_128365_(TAG_BLOCK_STATES, (Tag)states);
    }

    private boolean constructBlock(@NotNull ItemStack itemStack, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        SimpleContainer container = new SimpleContainer((ItemStack[])this.itemList.toArray(ItemStack[]::new));
        Optional op = pLevel.m_7465_().m_44015_((RecipeType)YTechRecipeTypes.WORKSPACE_CRAFTING.get(), (Container)container, (Level)pLevel);
        if (op.isPresent() && ((WorkspaceCraftingRecipe)op.get()).tool().test(itemStack)) {
            BlockItem item = (BlockItem)((WorkspaceCraftingRecipe)op.get()).m_5874_((Container)container, pLevel.m_9598_()).m_41720_();
            BlockState blockState = item.m_40614_().m_5573_(new BlockPlaceContext(pPlayer, pHand, ItemStack.f_41583_, pHit));
            if (blockState == null) {
                blockState = item.m_40614_().m_49966_();
            }
            this.itemList.clear();
            pLevel.m_7731_(pPos, blockState, 3);
            pLevel.m_151543_(pPos);
            pLevel.m_5594_(null, pPos, SoundEvents.f_12442_, SoundSource.BLOCKS, 1.0f, 1.0f);
            pLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, 200, (double)0.3f, (double)0.3f, (double)0.3f, (double)0.15f);
            itemStack.m_41622_(1, (LivingEntity)pPlayer, e -> e.m_21190_(pHand));
            return true;
        }
        return false;
    }

    private void updateNeighbors(BlockState state, int[] pos, BlockPos fakePos) {
        for (Direction value : Direction.values()) {
            Item item;
            int neighborIndex;
            int[] neighborPos = new int[]{pos[0] + value.m_122436_().m_123341_(), pos[1] + value.m_122436_().m_123342_(), pos[2] + value.m_122436_().m_123343_()};
            if (!CraftingWorkspaceBlock.validPosition(neighborPos) || (neighborIndex = CraftingWorkspaceBlock.getIndex(neighborPos)) < 0 || neighborIndex >= 27 || !((item = ((ItemStack)this.itemList.get(neighborIndex)).m_41720_()) instanceof BlockItem)) continue;
            BlockItem neighborBlock = (BlockItem)item;
            this.blockStates.set(neighborIndex, (Object)neighborBlock.m_40614_().m_7417_((BlockState)this.blockStates.get(neighborIndex), value.m_122424_(), state, (LevelAccessor)FAKE_LEVEL, fakePos.m_121955_(value.m_122436_()), fakePos));
        }
    }

    static {
        ObjenesisStd objenesis = new ObjenesisStd();
        ObjectInstantiator instantiator = objenesis.getInstantiatorOf(FakeCraftingWorkspaceLevel.class);
        FAKE_LEVEL = (FakeCraftingWorkspaceLevel)((Object)instantiator.newInstance());
        FAKE_LEVEL.init();
    }
}

