/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.network.irrigation.IIrrigationBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class IrrigationBlockEntity
extends BlockEntity
implements IIrrigationBlockEntity {
    private static final String NETWORK_ID = "networkId";
    @NotNull
    private final List<BlockPos> validNeighbors;
    protected int networkId = -1;

    public IrrigationBlockEntity(@NotNull BlockEntityType<? extends BlockEntity> entityType, @NotNull BlockPos pos, @NotNull BlockState blockState, @NotNull List<BlockPos> validNeighbors) {
        super(entityType, pos, blockState);
        this.validNeighbors = validNeighbors;
    }

    @Override
    public int getNetworkId() {
        return this.networkId;
    }

    @Override
    public void setNetworkId(int networkId) {
        this.networkId = networkId;
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    @Override
    @NotNull
    public List<BlockPos> getValidNeighbors() {
        return this.validNeighbors;
    }

    @Override
    public void onRemove() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            YTechMod.IRRIGATION_PROPAGATOR.server().remove(this);
            this.m_6596_();
        }
    }

    @Override
    public void onChangedState(@NotNull BlockState oldBlockState, @NotNull BlockState newBlockState) {
        if (!oldBlockState.equals(newBlockState)) {
            this.m_6596_();
        }
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(NETWORK_ID)) {
            this.networkId = tag.m_128451_(NETWORK_ID);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.onLevelSet((ServerLevel)this.f_58857_);
            if (this.networkId < 0) {
                YTechMod.IRRIGATION_PROPAGATOR.server().add(this);
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
                this.m_6596_();
            }
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_(NETWORK_ID, this.networkId);
        return tag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.networkId = tag.m_128451_(NETWORK_ID);
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    protected void onLevelSet(@NotNull ServerLevel level) {
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_(NETWORK_ID, this.networkId);
    }
}

