/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.configuration.MachineItemStackHandler;
import com.yanny.ytech.configuration.block_entity.AbstractPrimitiveMachineBlockEntity;
import com.yanny.ytech.configuration.container.PrimitiveAlloySmelterContainerMenu;
import com.yanny.ytech.configuration.recipe.AlloyingRecipe;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrimitiveAlloySmelterBlockEntity
extends AbstractPrimitiveMachineBlockEntity {
    private static final String TAG_RECIPE_INPUT_LEFT = "recipeInputLeft";
    private static final String TAG_RECIPE_INPUT_RIGHT = "recipeInputRight";
    private static final int SLOT_INPUT_LEFT = 0;
    private static final int SLOT_INPUT_RIGHT = 1;
    private static final int SLOT_FUEL = 2;
    private static final int SLOT_OUTPUT = 3;
    private final RecipeManager.CachedCheck<Container, AlloyingRecipe> quickCheck;
    @Nullable
    private ItemStack recipeInputLeft = ItemStack.f_41583_;
    @Nullable
    private ItemStack recipeInputRight = ItemStack.f_41583_;

    public PrimitiveAlloySmelterBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)YTechBlockEntityTypes.PRIMITIVE_ALLOY_SMELTER.get(), pos, blockState, (RecipeType)YTechRecipeTypes.ALLOYING.get());
        this.quickCheck = RecipeManager.m_220267_((RecipeType)((RecipeType)YTechRecipeTypes.ALLOYING.get()));
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"block.ytech.primitive_alloy_smelter");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory inventory, @NotNull Player player) {
        return new PrimitiveAlloySmelterContainerMenu(windowId, inventory.f_35978_, this.f_58858_, this.itemStackHandler, this.containerData);
    }

    @Override
    @NotNull
    public MachineItemStackHandler createItemStackHandler() {
        return new MachineItemStackHandler.Builder().addInputSlot(45, 16, this::canInput).addInputSlot(65, 16, this::canInput).addInputSlot(55, 52, (itemStackHandler, slot, itemStack) -> ForgeHooks.getBurnTime((ItemStack)itemStack, (RecipeType)RecipeType.f_44109_) > 0).addOutputSlot(116, 35).setOnChangeListener(() -> ((PrimitiveAlloySmelterBlockEntity)this).m_6596_()).build();
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            this.recipeInputLeft = tag.m_128441_(TAG_RECIPE_INPUT_LEFT) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_(TAG_RECIPE_INPUT_LEFT)) : null;
            this.recipeInputRight = tag.m_128441_(TAG_RECIPE_INPUT_RIGHT) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_(TAG_RECIPE_INPUT_RIGHT)) : null;
        }
    }

    @Override
    public boolean hasActiveRecipe() {
        return this.recipeInputLeft != null && this.recipeInputRight != null;
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            CompoundTag itemStack;
            if (this.recipeInputLeft != null) {
                itemStack = new CompoundTag();
                this.recipeInputLeft.m_41739_(itemStack);
                tag.m_128365_(TAG_RECIPE_INPUT_LEFT, (Tag)itemStack);
            }
            if (this.recipeInputRight != null) {
                itemStack = new CompoundTag();
                this.recipeInputRight.m_41739_(itemStack);
                tag.m_128365_(TAG_RECIPE_INPUT_RIGHT, (Tag)itemStack);
            }
        }
    }

    @Override
    protected boolean hasItemsInInput() {
        return !this.itemStackHandler.getStackInSlot(0).m_41619_() && !this.itemStackHandler.getStackInSlot(1).m_41619_();
    }

    @Override
    protected int getFuelSlot() {
        return 2;
    }

    @Override
    protected void startRecipe(@NotNull AtomicBoolean hasChanged) {
        if (this.f_58857_ != null) {
            ItemStack inputLeft = this.itemStackHandler.getStackInSlot(0);
            ItemStack inputRight = this.itemStackHandler.getStackInSlot(1);
            this.quickCheck.m_213657_((Container)new SimpleContainer(new ItemStack[]{inputLeft, inputRight}), this.f_58857_).ifPresent(r -> {
                ItemStack result = this.itemStackHandler.getStackInSlot(3);
                if (r.minTemperature() <= this.temperature && (result.m_41619_() || ItemStack.m_150942_((ItemStack)result, (ItemStack)r.result()) && result.m_41741_() > result.m_41613_() + r.result().m_41613_())) {
                    if (r.matchesIngredient1(inputLeft, false) && r.matchesIngredient2(inputRight, false)) {
                        this.recipeInputLeft = inputLeft.m_41620_(r.getInput1Count());
                        this.recipeInputRight = inputRight.m_41620_(r.getInput2Count());
                    } else {
                        this.recipeInputLeft = inputLeft.m_41620_(r.getInput2Count());
                        this.recipeInputRight = inputRight.m_41620_(r.getInput1Count());
                    }
                    this.leftSmelting = this.smeltingTime = r.smeltingTime();
                    this.recipeTemperature = r.minTemperature();
                    hasChanged.set(true);
                }
            });
        }
    }

    @Override
    protected void finishRecipe() {
        if (this.f_58857_ != null) {
            ItemStack result = this.itemStackHandler.getStackInSlot(3);
            this.quickCheck.m_213657_((Container)new SimpleContainer(new ItemStack[]{this.recipeInputLeft, this.recipeInputRight}), this.f_58857_).ifPresent(r -> {
                if (result.m_41619_()) {
                    this.itemStackHandler.setStackInSlot(3, r.result().m_41777_());
                } else {
                    result.m_41769_(r.result().m_41613_());
                }
            });
            this.recipeInputLeft = null;
            this.recipeInputRight = null;
        }
    }

    @Override
    protected boolean isValidRecipeInInput() {
        if (this.f_58857_ != null) {
            ItemStack inputLeft = this.itemStackHandler.getStackInSlot(0);
            ItemStack inputRight = this.itemStackHandler.getStackInSlot(1);
            return this.f_58857_.m_7465_().m_44013_((RecipeType)YTechRecipeTypes.ALLOYING.get()).stream().anyMatch(recipe -> recipe.matchesFully(inputLeft, inputRight, false));
        }
        return false;
    }

    private boolean canInput(@NotNull MachineItemStackHandler itemStackHandler, int slot, @NotNull ItemStack itemStack) {
        boolean isPartial;
        ItemStack itemStack1 = slot != 0 ? itemStackHandler.getStackInSlot(0) : itemStack;
        ItemStack itemStack2 = slot != 1 ? itemStackHandler.getStackInSlot(1) : itemStack;
        boolean bl = isPartial = itemStack1.m_41619_() || itemStack2.m_41619_();
        if (this.f_58857_ != null) {
            return this.f_58857_.m_7465_().m_44013_((RecipeType)YTechRecipeTypes.ALLOYING.get()).stream().anyMatch(recipe -> {
                if (isPartial) {
                    return recipe.matchesPartially(itemStack1, itemStack2, true);
                }
                return recipe.matchesFully(itemStack1, itemStack2, true);
            });
        }
        return false;
    }
}

