/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.entity;

import com.yanny.ytech.YTechMod;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WildAnimalEntity
extends Animal {
    private static final EntityDataAccessor<Integer> DATA_GENERATION_ID = SynchedEntityData.m_135353_(WildAnimalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final String TAG_GENERATION = "Generation";

    protected WildAnimalEntity(EntityType<? extends WildAnimalEntity> entityType, Level level) {
        super(entityType, level);
    }

    abstract EntityType<? extends AgeableMob> getDomesticBreedOffspring();

    public int getGeneration() {
        return (Integer)this.f_19804_.m_135370_(DATA_GENERATION_ID);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel serverLevel, @NotNull AgeableMob parent) {
        WildAnimalEntity parentAnimal;
        int nextGeneration;
        if (parent instanceof WildAnimalEntity && (nextGeneration = WildAnimalEntity.getNextGeneration(this, parentAnimal = (WildAnimalEntity)parent)) > YTechMod.CONFIGURATION.getMinBreedingGenerations() && this.f_19796_.m_188500_() < (double)(nextGeneration - YTechMod.CONFIGURATION.getMinBreedingGenerations()) * YTechMod.CONFIGURATION.getDomesticChance()) {
            return (AgeableMob)this.getDomesticBreedOffspring().m_20615_((Level)serverLevel);
        }
        return (AgeableMob)this.m_6095_().m_20615_((Level)serverLevel);
    }

    public void m_277117_(@NotNull ServerLevel level, @NotNull Animal parent, @Nullable AgeableMob baby) {
        if (baby instanceof WildAnimalEntity) {
            WildAnimalEntity childAnimal = (WildAnimalEntity)baby;
            if (parent instanceof WildAnimalEntity) {
                WildAnimalEntity parentAnimal = (WildAnimalEntity)parent;
                childAnimal.f_19804_.m_135381_(DATA_GENERATION_ID, (Object)WildAnimalEntity.getNextGeneration(this, parentAnimal));
            }
        }
        super.m_277117_(level, parent, baby);
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_(TAG_GENERATION, this.getGeneration());
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(DATA_GENERATION_ID, (Object)tag.m_128451_(TAG_GENERATION));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_GENERATION_ID, (Object)0);
    }

    private static int getNextGeneration(@NotNull WildAnimalEntity parent1, @NotNull WildAnimalEntity parent2) {
        return (int)Math.ceil((float)(parent1.getGeneration() + parent2.getGeneration()) / 2.0f + 1.0f);
    }
}

