/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yanny.ytech.configuration.SpearType;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.registration.YTechItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SpearModel
extends Model {
    public static final Map<SpearType, ModelLayerLocation> LAYER_LOCATIONS = new HashMap<SpearType, ModelLayerLocation>();
    public static final Map<SpearType, ModelResourceLocation> MODEL_LOCATIONS = new HashMap<SpearType, ModelResourceLocation>();
    public static final Map<SpearType, ModelResourceLocation> MODEL_IN_HAND_LOCATIONS = new HashMap<SpearType, ModelResourceLocation>();
    @NotNull
    private final ModelPart root;

    public SpearModel(@NotNull ModelPart root) {
        super(RenderType::m_110446_);
        this.root = root;
    }

    @NotNull
    public static LayerDefinition createLayer(int xOffset, int yOffset) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition rootPart = meshDefinition.m_171576_();
        PartDefinition polePart = rootPart.m_171599_("root", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 25.0f, 1.0f), PartPose.f_171404_);
        polePart.m_171599_("base", CubeListBuilder.m_171558_().m_171514_(4 + xOffset, yOffset).m_171481_(-1.5f, -1.0f, -0.5f, 3.0f, 1.0f, 1.0f), PartPose.f_171404_);
        polePart.m_171599_("tip", CubeListBuilder.m_171558_().m_171514_(4 + xOffset, 2 + yOffset).m_171481_(-1.0f, -2.0f, -0.5f, 2.0f, 1.0f, 1.0f), PartPose.f_171404_);
        polePart.m_171599_("k", CubeListBuilder.m_171558_().m_171514_(4 + xOffset, 4 + yOffset).m_171481_(-0.5f, -3.0f, -0.5f, 1.0f, 1.0f, 1.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)32, (int)32);
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    static {
        for (SpearType type : SpearType.values()) {
            String key = Utils.getPath((RegistryObject)YTechItems.SPEARS.get(type.materialType));
            LAYER_LOCATIONS.put(type, new ModelLayerLocation(Utils.modLoc(key), "main"));
            MODEL_LOCATIONS.put(type, new ModelResourceLocation("ytech", key, "inventory"));
            MODEL_IN_HAND_LOCATIONS.put(type, new ModelResourceLocation("ytech", key + "_in_hand", "inventory"));
        }
    }
}

