/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.network.generic;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class NetworkUtils {
    private static int messageId = 0;

    public static int getMessageId() {
        return ++messageId;
    }

    @NotNull
    public static BlockPos loadBlockPos(@NotNull CompoundTag tag) {
        return new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
    }

    @NotNull
    public static ChunkPos loadChunkPos(@NotNull CompoundTag tag) {
        return new ChunkPos(tag.m_128451_("x"), tag.m_128451_("z"));
    }

    @NotNull
    public static CompoundTag saveBlockPos(@NotNull BlockPos pos) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("x", pos.m_123341_());
        tag.m_128405_("y", pos.m_123342_());
        tag.m_128405_("z", pos.m_123343_());
        return tag;
    }

    @NotNull
    public static CompoundTag saveChunkPos(@NotNull ChunkPos pos) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("x", pos.f_45578_);
        tag.m_128405_("z", pos.f_45579_);
        return tag;
    }

    @NotNull
    public static ResourceLocation getLevelId(@NotNull Level level) {
        return level.m_46472_().m_135782_();
    }

    @NotNull
    public static List<BlockPos> getDirections(@NotNull List<Direction> validDirections, @NotNull BlockPos position, @NotNull Direction currentDirection) {
        return validDirections.stream().map(direction -> position.m_121955_(NetworkUtils.rotateDirection(currentDirection, direction).m_122436_())).collect(Collectors.toList());
    }

    @NotNull
    private static Direction rotateDirection(@NotNull Direction currentDirection, @NotNull Direction baseDirection) {
        return Direction.m_122407_((int)((currentDirection.m_122416_() + baseDirection.m_122416_()) % 4));
    }
}

