/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.network.generic.server;

import com.mojang.logging.LogUtils;
import com.yanny.ytech.network.generic.common.CommonNetwork;
import com.yanny.ytech.network.generic.common.INetworkBlockEntity;
import com.yanny.ytech.network.generic.common.NetworkFactory;
import com.yanny.ytech.network.generic.server.ServerNetwork;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ServerLevelData<T extends ServerNetwork<T, O>, O extends INetworkBlockEntity>
extends SavedData {
    protected static final String TAG_NETWORKS = "networks";
    protected static final String TAG_NETWORK = "network";
    protected static final String TAG_NETWORK_ID = "networkId";
    protected static final Logger LOGGER = LogUtils.getLogger();
    @NotNull
    private final ConcurrentHashMap<Integer, T> networkMap = new ConcurrentHashMap();
    @NotNull
    private final NetworkFactory<T, O> networkFactory;
    @NotNull
    private final ResourceLocation levelId;
    @NotNull
    private final MinecraftServer server;
    @NotNull
    private final String networkName;

    ServerLevelData(@NotNull CompoundTag tag, @NotNull ResourceLocation levelId, @NotNull MinecraftServer server, @NotNull NetworkFactory<T, O> networkFactory, @NotNull String networkName) {
        this.levelId = levelId;
        this.server = server;
        this.networkName = networkName;
        this.networkFactory = networkFactory;
        this.load(tag);
    }

    ServerLevelData(@NotNull ResourceLocation levelId, @NotNull MinecraftServer server, @NotNull NetworkFactory<T, O> networkFactory, @NotNull String networkName) {
        this.levelId = levelId;
        this.server = server;
        this.networkFactory = networkFactory;
        this.networkName = networkName;
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag tag) {
        ListTag list = new ListTag();
        AtomicInteger index = new AtomicInteger();
        this.networkMap.forEach((networkId, network) -> {
            CompoundTag itemHolder = new CompoundTag();
            itemHolder.m_128405_(TAG_NETWORK_ID, networkId.intValue());
            itemHolder.m_128365_(TAG_NETWORK, (Tag)network.save());
            list.add(index.getAndIncrement(), (Tag)itemHolder);
        });
        tag.m_128365_(TAG_NETWORKS, (Tag)list);
        return tag;
    }

    public void add(@NotNull O blockEntity) {
        int networkId = blockEntity.getNetworkId();
        Level level = blockEntity.m_58904_();
        if (level instanceof ServerLevel) {
            ServerNetwork resultNetwork;
            ServerLevel level2 = (ServerLevel)level;
            if (networkId >= 0) {
                resultNetwork = (ServerNetwork)this.networkMap.get(networkId);
                if (!resultNetwork.canAttach(blockEntity)) {
                    LOGGER.warn("[{}] Can't attach block {} to network at {}", new Object[]{this.networkName, blockEntity, blockEntity.m_58899_()});
                    level2.m_46961_(blockEntity.m_58899_(), true);
                    return;
                }
            } else {
                List<ServerNetwork> networks = this.networkMap.values().stream().filter(n -> n.canConnect(blockEntity)).toList();
                if (networks.isEmpty()) {
                    T network = this.networkFactory.createNetwork(this.getUniqueId(), this::onChange, this::onRemove);
                    this.networkMap.put(((CommonNetwork)network).getNetworkId(), network);
                    resultNetwork = network;
                } else if (networks.size() == 1) {
                    resultNetwork = networks.get(0);
                    if (!resultNetwork.canAttach(blockEntity)) {
                        LOGGER.warn("[{}] Can't attach block {} to network at {}", new Object[]{this.networkName, blockEntity, blockEntity.m_58899_()});
                        level2.m_46961_(blockEntity.m_58899_(), true);
                        return;
                    }
                } else {
                    ArrayList distinctNetworks = networks.stream().filter(ServerLevelData.distinctByKey(CommonNetwork::getNetworkId)).collect(Collectors.toCollection(ArrayList::new));
                    if (distinctNetworks.size() == 1) {
                        resultNetwork = (ServerNetwork)distinctNetworks.get(0);
                        if (!resultNetwork.canAttach(blockEntity)) {
                            LOGGER.warn("[{}] Can't attach block {} to network at {}", new Object[]{this.networkName, blockEntity, blockEntity.m_58899_()});
                            level2.m_46961_(blockEntity.m_58899_(), true);
                            return;
                        }
                    } else {
                        ServerNetwork network = (ServerNetwork)distinctNetworks.remove(0);
                        if (!network.canAttach(blockEntity) || !distinctNetworks.stream().allMatch(n -> n.canAttach(blockEntity) && n.canAttach(network))) {
                            LOGGER.warn("[{}] Can't attach block {} to network at {}", new Object[]{this.networkName, blockEntity, blockEntity.m_58899_()});
                            level2.m_46961_(blockEntity.m_58899_(), true);
                            return;
                        }
                        do {
                            ServerNetwork toRemove = (ServerNetwork)distinctNetworks.remove(0);
                            network.appendNetwork(toRemove, (Level)level2);
                            this.networkMap.remove(toRemove.getNetworkId());
                            network.getChunks().stream().map(chunkPos -> level.m_7726_().f_8325_.m_183262_(chunkPos, false)).flatMap(Collection::stream).collect(Collectors.toSet()).forEach(player -> this.networkFactory.sendRemoved(PacketDistributor.PLAYER.with(() -> player), toRemove.getNetworkId()));
                        } while (!distinctNetworks.isEmpty());
                        resultNetwork = network;
                    }
                }
            }
            resultNetwork.addBlockEntity(blockEntity);
            this.m_77762_();
            resultNetwork.setDirty();
        } else {
            LOGGER.warn("[{}][add] Invalid level: {}", (Object)this.networkName, (Object)blockEntity.m_58904_());
        }
    }

    public void update(@NotNull O blockEntity) {
        T network = this.getNetwork(blockEntity);
        Level level = blockEntity.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (network != null) {
                if (((ServerNetwork)network).canAttach(blockEntity)) {
                    if (((ServerNetwork)network).updateBlockEntity(blockEntity)) {
                        this.m_77762_();
                        ((ServerNetwork)network).setDirty();
                    }
                } else {
                    List networks = ((ServerNetwork)network).removeBlockEntity(this::getUniqueIds, this::onRemove, blockEntity);
                    this.networkMap.putAll(networks.stream().collect(Collectors.toMap(CommonNetwork::getNetworkId, n -> {
                        n.setDirty();
                        return n;
                    })));
                    level2.m_46961_(blockEntity.m_58899_(), true);
                    LOGGER.warn("[{}] Removed block {} from network at {}", new Object[]{this.networkName, blockEntity, blockEntity.m_58899_()});
                    this.m_77762_();
                    if (((ServerNetwork)network).isNotEmpty()) {
                        ((ServerNetwork)network).setDirty();
                    }
                }
            } else {
                LOGGER.warn("[{}] UPDATE: Can't get network for block {} at {}", new Object[]{this.networkName, blockEntity, blockEntity.m_58899_()});
            }
        } else {
            LOGGER.warn("[{}][add] Invalid level: {}", (Object)this.networkName, (Object)blockEntity.m_58904_());
        }
    }

    public void remove(@NotNull O blockEntity) {
        T network = this.getNetwork(blockEntity);
        if (network != null) {
            List networks = ((ServerNetwork)network).removeBlockEntity(this::getUniqueIds, this::onRemove, blockEntity);
            this.networkMap.putAll(networks.stream().peek(ServerNetwork::setDirty).collect(Collectors.toMap(CommonNetwork::getNetworkId, n -> n)));
            this.m_77762_();
            if (((ServerNetwork)network).isNotEmpty()) {
                ((ServerNetwork)network).setDirty();
            }
        } else {
            LOGGER.warn("[{}] REMOVE: Can't get network for block {} at {}", new Object[]{this.networkName, blockEntity, blockEntity.m_58899_()});
        }
    }

    public void tick(@NotNull ServerChunkCache chunkCache) {
        this.networkMap.values().forEach(network -> {
            if (network.isDirty()) {
                network.getChunks().stream().map(chunkPos -> chunkCache.f_8325_.m_183262_(chunkPos, false)).flatMap(Collection::stream).collect(Collectors.toSet()).forEach(player -> this.networkFactory.sendUpdated(PacketDistributor.PLAYER.with(() -> player), (ServerNetwork)network));
                network.setClean();
            }
        });
    }

    @NotNull
    public Map<Integer, T> getNetworks() {
        return this.networkMap;
    }

    public T getNetwork(@NotNull O blockEntity) {
        return (T)((ServerNetwork)this.networkMap.get(blockEntity.getNetworkId()));
    }

    private void onChange(int networkId) {
        ((ServerNetwork)this.networkMap.get(networkId)).setDirty();
        this.m_77762_();
    }

    private void onRemove(int networkId, @NotNull ChunkPos chunkPos) {
        ServerLevel level = this.server.m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)this.levelId));
        if (level != null) {
            this.networkMap.remove(networkId);
            level.m_7726_().f_8325_.m_183262_(chunkPos, false).forEach(player -> this.networkFactory.sendRemoved(PacketDistributor.PLAYER.with(() -> player), networkId));
            this.m_77762_();
        }
    }

    private int getUniqueId() {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.networkMap.containsKey(i)) continue;
            return i;
        }
        LOGGER.error("[{}] Network keys overflow!", (Object)this.networkName);
        throw new IllegalStateException("Can't generate new ID for network!");
    }

    private List<Integer> getUniqueIds(int count) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.networkMap.containsKey(i)) continue;
            result.add(i);
            if (result.size() != count) continue;
            return result;
        }
        LOGGER.error("[{}] Network keys overflow!", (Object)this.networkName);
        throw new IllegalStateException("Can't generate new ID for network!");
    }

    private void load(@NotNull CompoundTag tag) {
        if (tag.m_128441_(TAG_NETWORKS)) {
            ListTag list = tag.m_128437_(TAG_NETWORKS, 10);
            list.forEach(listItem -> {
                CompoundTag itemHolder = (CompoundTag)listItem;
                int networkId = itemHolder.m_128451_(TAG_NETWORK_ID);
                this.networkMap.put(networkId, this.networkFactory.createNetwork(itemHolder.m_128469_(TAG_NETWORK), networkId, this::onChange, this::onRemove));
            });
            LOGGER.debug("[{}] Loaded {} networks", (Object)this.networkName, (Object)this.networkMap.size());
        } else {
            LOGGER.debug("[{}] No network loaded", (Object)this.networkName);
        }
    }

    private static <T> Predicate<T> distinctByKey(@NotNull Function<? super T, ?> keyExtractor) {
        return t -> ConcurrentHashMap.newKeySet().add(keyExtractor.apply(t));
    }
}

