/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.compatibility.emi;

import com.yanny.ytech.compatibility.EmiCompatibility;
import com.yanny.ytech.configuration.recipe.SmeltingRecipe;
import com.yanny.ytech.registration.YTechItems;
import com.yanny.ytech.registration.YTechRecipeTypes;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class EmiSmeltingRecipe
extends BasicEmiRecipe {
    public static final EmiStack WORKSTATION = EmiStack.of((ItemLike)((ItemLike)YTechItems.PRIMITIVE_SMELTER.get()));
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(EmiCompatibility.ref(YTechRecipeTypes.SMELTING), (EmiRenderable)WORKSTATION, (EmiRenderable)new EmiTexture(EmiCompatibility.TEXTURE, 144, 240, 16, 16));
    public static final EmiTexture EMPTY_TEMPERATURE = new EmiTexture(EmiCompatibility.TEXTURE, 0, 0, 8, 38);
    public static final EmiTexture FULL_TEMPERATURE = new EmiTexture(EmiCompatibility.TEXTURE, 9, 0, 8, 38);
    private final int time;
    private final int temperature;

    public EmiSmeltingRecipe(SmeltingRecipe recipe, ResourceLocation id) {
        super(CATEGORY, id, 94, 41);
        this.inputs = List.of(EmiIngredient.of((Ingredient)recipe.ingredient(), (long)recipe.inputCount()));
        this.catalysts = List.of(EmiIngredient.of((Ingredient)recipe.mold()));
        this.outputs = List.of(EmiStack.of((ItemStack)recipe.result()));
        this.time = recipe.smeltingTime();
        this.temperature = recipe.minTemperature();
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        widgetHolder.addFillingArrow(36, 5, 50 * this.time).tooltip((mx, my) -> List.of(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)"emi.cooking.time", (Object[])new Object[]{Float.valueOf((float)this.time / 20.0f)}).getVisualOrderText())));
        widgetHolder.addSlot((EmiIngredient)this.inputs.get(0), 10, 4);
        widgetHolder.addTexture(EMPTY_TEMPERATURE, 0, 2);
        widgetHolder.addAnimatedTexture(FULL_TEMPERATURE, 0, 2, 4000, false, true, false).tooltip((mx, my) -> List.of(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)"emi.alloying.temperature", (Object[])new Object[]{this.temperature}).getVisualOrderText())));
        widgetHolder.addTexture(EmiTexture.EMPTY_FLAME, 10, 24);
        widgetHolder.addAnimatedTexture(EmiTexture.FULL_FLAME, 10, 24, 4000, false, true, true);
        widgetHolder.addSlot((EmiIngredient)this.catalysts.get(0), 39, 23).catalyst(true);
        widgetHolder.addSlot((EmiIngredient)this.outputs.get(0), 68, 0).large(true).recipeContext((EmiRecipe)this);
    }
}

