/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.compatibility.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.BooleanSupplier;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;

public class ButtonWidget
implements IRecipeWidget {
    protected final int x;
    protected final int y;
    protected final int width;
    protected final int height;
    protected final int u;
    protected final int v;
    protected final BooleanSupplier isActive;
    protected final ClickAction action;
    protected final ResourceLocation texture;

    public ButtonWidget(int x, int y, int width, int height, int u, int v, ResourceLocation texture, BooleanSupplier isActive, ClickAction action) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.u = u;
        this.v = v;
        this.texture = texture;
        this.isActive = isActive;
        this.action = action;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.action.click(mouseX, mouseY, button);
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        return true;
    }

    @NotNull
    public ScreenPosition getPosition() {
        return new ScreenPosition(this.x, this.y);
    }

    public void drawWidget(@NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int v = this.v;
        boolean active = this.isActive.getAsBoolean();
        if (!active) {
            v += this.height * 2;
        } else if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height)) {
            v += this.height;
        }
        RenderSystem.enableDepthTest();
        guiGraphics.blit(this.texture, this.x, this.y, this.u, v, this.width, this.height);
    }

    public static interface ClickAction {
        public void click(double var1, double var3, int var5);
    }
}

