/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.compatibility.jei;

import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.recipe.DryingRecipe;
import com.yanny.ytech.registration.YTechItems;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

public class DryingRecipeCategory
extends AbstractRecipeCategory<DryingRecipe> {
    public static final RecipeType<DryingRecipe> RECIPE_TYPE = RecipeType.create((String)"ytech", (String)"drying", DryingRecipe.class);

    public DryingRecipeCategory(IGuiHelper guiHelper) {
        super(RECIPE_TYPE, (Component)Component.translatable((String)"emi.category.ytech.drying"), guiHelper.createDrawableItemLike((ItemLike)((DeferredItem)YTechItems.DRYING_RACKS.get(MaterialType.OAK_WOOD)).get()), 84, 26);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DryingRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 0, 5).setStandardSlotBackground().addIngredients(recipe.ingredient());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 62, 5).setOutputSlotBackground().addItemStack(recipe.result());
    }

    public void createRecipeExtras(@NotNull IRecipeExtrasBuilder builder, @NotNull DryingRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addAnimatedRecipeArrow(recipe.dryingTime()).setPosition(26, 5);
    }

    public void getTooltip(@NotNull ITooltipBuilder tooltip, @NotNull DryingRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX >= 26.0 && mouseX <= 50.0 && mouseY >= 5.0 && mouseY <= 22.0) {
            tooltip.add((FormattedText)Component.translatable((String)"emi.drying.time", (Object[])new Object[]{Float.valueOf((float)recipe.dryingTime() / 20.0f)}));
        }
    }

    public static List<DryingRecipe> getRecipes(@NotNull RecipeManager recipeManager) {
        return recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)YTechRecipeTypes.DRYING.get()).stream().map(RecipeHolder::value).toList();
    }

    public static void registerCatalyst(@NotNull IRecipeCatalystRegistration registration) {
        YTechItems.DRYING_RACKS.values().forEach(item -> registration.addRecipeCatalyst(new ItemStack((ItemLike)item.get()), new RecipeType[]{RECIPE_TYPE}));
    }
}

