/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration;

import com.yanny.ytech.configuration.IType;
import com.yanny.ytech.configuration.YTechTier;
import java.util.EnumSet;
import java.util.function.Supplier;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import org.jetbrains.annotations.NotNull;

public enum MaterialType implements IType
{
    COPPER(new Builder("copper", "Copper", () -> YTechTier.COPPER).temp(1085, 2562)),
    GOLD(new Builder("gold", "Gold", () -> Tiers.GOLD).temp(1064, 2856)),
    IRON(new Builder("iron", "Iron", () -> Tiers.IRON).temp(1538, 2861)),
    LEAD(new Builder("lead", "Lead", () -> YTechTier.LEAD).temp(327, 1749)),
    TIN(new Builder("tin", "Tin", () -> YTechTier.TIN).temp(232, 2602)),
    BRONZE(new Builder("bronze", "Bronze", () -> YTechTier.BRONZE).temp(913, 2300)),
    CASSITERITE(new Builder("cassiterite", "Cassiterite", () -> Tiers.STONE).temp(1127)),
    GALENA(new Builder("galena", "Galena", () -> Tiers.WOOD).temp(1114)),
    WOODEN(new Builder("wooden", "Wooden", () -> Tiers.WOOD).group("wooden")),
    ACACIA_WOOD(new Builder("acacia", "Acacia", () -> Tiers.WOOD).group("wooden")),
    BIRCH_WOOD(new Builder("birch", "Birch", () -> Tiers.WOOD).group("wooden")),
    CHERRY_WOOD(new Builder("cherry", "Cherry", () -> Tiers.WOOD).group("wooden")),
    DARK_OAK_WOOD(new Builder("dark_oak", "Dark Oak", () -> Tiers.WOOD).group("wooden")),
    JUNGLE_WOOD(new Builder("jungle", "Jungle", () -> Tiers.WOOD).group("wooden")),
    MANGROVE_WOOD(new Builder("mangrove", "Mangrove", () -> Tiers.WOOD).group("wooden")),
    OAK_WOOD(new Builder("oak", "Oak", () -> Tiers.WOOD).group("wooden")),
    SPRUCE_WOOD(new Builder("spruce", "Spruce", () -> Tiers.WOOD).group("wooden")),
    TWINE(new Builder("twine", "Twine", () -> Tiers.WOOD)),
    FLINT(new Builder("flint", "Flint", () -> Tiers.STONE)),
    ANTLER(new Builder("antler", "Antler", () -> Tiers.STONE)),
    STONE(new Builder("stone", "Stone", () -> Tiers.STONE)),
    LEATHER(new Builder("leather", "Leather", () -> Tiers.STONE)),
    TERRACOTTA(new Builder("terracotta", "Terracotta", () -> Tiers.STONE)),
    MUDBRICK(new Builder("mudbrick", "Mudbrick", () -> Tiers.STONE));

    public static final EnumSet<MaterialType> ALL_WOODS;
    public static final EnumSet<MaterialType> ALL_METALS;
    public static final EnumSet<MaterialType> ALL_ORES;
    public static final EnumSet<MaterialType> ALL_DEPOSIT_ORES;
    public static final EnumSet<MaterialType> ALL_HARD_METALS;
    public static final EnumSet<MaterialType> AQUEDUCT_MATERIALS;
    public static final EnumSet<MaterialType> MESH_MATERIALS;
    public static final EnumSet<MaterialType> VANILLA_METALS;
    @NotNull
    public final String key;
    @NotNull
    public final String name;
    public final int meltingTemp;
    @NotNull
    public final String group;
    @NotNull
    private final Supplier<Tier> tier;

    private MaterialType(Builder builder) {
        this.key = builder.key;
        this.name = builder.name;
        this.group = builder.group;
        this.meltingTemp = builder.meltingTemp;
        this.tier = builder.tier;
    }

    @NotNull
    public Tier getTier() {
        return this.tier.get();
    }

    @Override
    public String key() {
        return this.key;
    }

    static {
        ALL_WOODS = EnumSet.of(ACACIA_WOOD, new MaterialType[]{BIRCH_WOOD, CHERRY_WOOD, DARK_OAK_WOOD, JUNGLE_WOOD, MANGROVE_WOOD, OAK_WOOD, SPRUCE_WOOD});
        ALL_METALS = EnumSet.of(BRONZE, new MaterialType[]{COPPER, GOLD, IRON, LEAD, TIN});
        ALL_ORES = EnumSet.of(COPPER, GOLD, IRON, CASSITERITE, GALENA);
        ALL_DEPOSIT_ORES = EnumSet.of(GOLD, CASSITERITE);
        ALL_HARD_METALS = EnumSet.of(BRONZE, COPPER, IRON);
        AQUEDUCT_MATERIALS = EnumSet.of(MUDBRICK, STONE, TERRACOTTA);
        MESH_MATERIALS = EnumSet.of(TWINE, COPPER, BRONZE);
        VANILLA_METALS = EnumSet.of(COPPER, GOLD, IRON);
    }

    private static class Builder {
        @NotNull
        private final String key;
        @NotNull
        private final String name;
        @NotNull
        private String group;
        @NotNull
        private final Supplier<Tier> tier;
        private int meltingTemp = Integer.MAX_VALUE;
        private int boilingTemp = Integer.MAX_VALUE;

        Builder(@NotNull String key, @NotNull String name, @NotNull Supplier<Tier> tier) {
            this.key = key;
            this.name = name;
            this.group = key;
            this.tier = tier;
        }

        Builder temp(int m, int b) {
            this.meltingTemp = m;
            this.boilingTemp = b;
            return this;
        }

        Builder temp(int m) {
            this.meltingTemp = m;
            return this;
        }

        Builder group(@NotNull String group) {
            this.group = group;
            return this;
        }
    }
}

