/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block_entity.TanningRackBlockEntity;
import com.yanny.ytech.configuration.recipe.WorkspaceCraftingRecipe;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechItemTags;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TanningRackBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE_EAST_WEST = Shapes.box((double)0.0, (double)0.0, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625);
    private static final VoxelShape SHAPE_NORTH_SOUTH = Shapes.box((double)0.4375, (double)0.0, (double)0.0, (double)0.5625, (double)1.0, (double)1.0);

    public TanningRackBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @NotNull
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)blockPlaceContext.getHorizontalDirection().getOpposite());
    }

    public boolean propagatesSkylightDown(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos) {
        return true;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull CollisionContext collisionContext) {
        Direction direction = (Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return direction == Direction.EAST || direction == Direction.WEST ? SHAPE_NORTH_SOUTH : SHAPE_EAST_WEST;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new TanningRackBlockEntity(pos, state);
    }

    @NotNull
    public ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Optional optional = level.getBlockEntity(pos, (BlockEntityType)YTechBlockEntityTypes.TANNING_RACK.get());
        if (optional.isPresent()) {
            return ((TanningRackBlockEntity)((Object)optional.get())).onUse(state, level, pos, player, hand, hitResult);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && !level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof TanningRackBlockEntity) {
            TanningRackBlockEntity tanningRack = (TanningRackBlockEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)NonNullList.withSize((int)1, (Object)tanningRack.getItem()));
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public static void registerModel(@NotNull BlockStateProvider provider, @NotNull DeferredBlock<Block> block, MaterialType material) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(Utils.getPath(block))).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    faceBuilder.uvs(2.0f, 2.0f, 14.0f, 4.0f).texture("#2");
                }
            }
        }).from(2.0f, 13.0f, 8.0f).to(14.0f, 15.0f, 8.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: {
                    faceBuilder.uvs(2.0f, 2.0f, 14.0f, 4.0f).texture("#2");
                }
            }
        }).from(2.0f, 1.0f, 8.0f).to(14.0f, 3.0f, 8.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 16.0f).texture("#3");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(2.0f, 0.0f, 4.0f, 16.0f).texture("#3");
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(4.0f, 0.0f, 6.0f, 16.0f).texture("#3");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(6.0f, 0.0f, 8.0f, 16.0f).texture("#3").cullface(direction);
                    break;
                }
                case UP: {
                    faceBuilder.uvs(0.0f, 0.0f, 2.0f, 2.0f).texture("#3").cullface(direction);
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(0.0f, 2.0f, 2.0f, 4.0f).texture("#3").cullface(direction);
                }
            }
        }).from(0.0f, 0.0f, 7.0f).to(2.0f, 16.0f, 9.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: {
                    faceBuilder.uvs(8.0f, 0.0f, 10.0f, 16.0f).texture("#3");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(10.0f, 0.0f, 12.0f, 16.0f).texture("#3").cullface(direction);
                    break;
                }
                case SOUTH: {
                    faceBuilder.uvs(12.0f, 0.0f, 14.0f, 16.0f).texture("#3");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(14.0f, 0.0f, 16.0f, 16.0f).texture("#3");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(8.0f, 0.0f, 10.0f, 2.0f).texture("#3").cullface(direction);
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(8.0f, 2.0f, 10.0f, 4.0f).texture("#3").cullface(direction);
                }
            }
        }).from(14.0f, 0.0f, 7.0f).to(16.0f, 16.0f, 9.0f).end()).texture("particle", Utils.modBlockLoc("wood/dark_bottom_" + material.key + "_log"))).texture("3", Utils.modBlockLoc("wood/dark_bottom_" + material.key + "_log"))).texture("2", Utils.modBlockLoc("horizontal_rope"));
        provider.horizontalBlock((Block)block.get(), (ModelFile)model);
        ((ItemModelBuilder)provider.itemModels().getBuilder(Utils.getPath(block))).parent((ModelFile)model);
    }

    public static void registerRecipe(@NotNull RecipeOutput recipeConsumer, @NotNull DeferredItem<Item> item, MaterialType material) {
        WorkspaceCraftingRecipe.Builder.recipe(YTechItemTags.AXES.tag, (ItemLike)item.get()).define(Character.valueOf('W'), Utils.getLogFromMaterial(material)).define(Character.valueOf('T'), YTechItemTags.GRASS_TWINES).bottomPattern("   ").bottomPattern("WTW").bottomPattern("   ").middlePattern("   ").middlePattern("W W").middlePattern("   ").topPattern("   ").topPattern("WTW").topPattern("   ").group(YTechBlocks.TANNING_RACKS.getGroup() + "_" + material.group).unlockedBy("has_logs", RecipeProvider.has((TagKey)ItemTags.LOGS)).save(recipeConsumer, Utils.modLoc(item));
    }
}

