/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block.AqueductConsumerBlock;
import com.yanny.ytech.configuration.block.IrrigationBlock;
import com.yanny.ytech.configuration.block_entity.WellPulleyBlockEntity;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechBlocks;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WellPulleyBlock
extends IrrigationBlock {
    public static final EnumProperty<WellPulleyPart> WELL_PART = EnumProperty.create((String)"well", WellPulleyPart.class);
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty ACTIVATED = AqueductConsumerBlock.ACTIVATED;
    private static final VoxelShape WELL_SHAPE_Z = Shapes.box((double)0.0, (double)0.0, (double)0.375, (double)1.0, (double)1.0, (double)0.625);
    private static final VoxelShape WELL_SHAPE_X = Shapes.box((double)0.375, (double)0.0, (double)0.0, (double)0.625, (double)1.0, (double)1.0);

    public WellPulleyBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TERRACOTTA).pushReaction(PushReaction.DESTROY));
    }

    @NotNull
    public VoxelShape getShape(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        if (pState.getValue(WELL_PART) == WellPulleyPart.BASE) {
            return Shapes.block();
        }
        if (((Direction)pState.getValue((Property)HORIZONTAL_FACING)).getAxis() == Direction.Axis.X) {
            return WELL_SHAPE_X;
        }
        return WELL_SHAPE_Z;
    }

    @NotNull
    public ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Optional optional;
        BlockPos basePos = pos;
        BlockState aboveState = state;
        if (state.getValue(WELL_PART) == WellPulleyPart.TOP) {
            basePos = basePos.below();
        }
        if (aboveState.getValue(WELL_PART) == WellPulleyPart.BASE) {
            aboveState = level.getBlockState(basePos.above());
        }
        if ((optional = level.getBlockEntity(pos, (BlockEntityType)YTechBlockEntityTypes.WELL_PULLEY.get())).isPresent()) {
            return ((WellPulleyBlockEntity)optional.get()).onUse(level, aboveState, player);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState blockState) {
        return RenderShape.MODEL;
    }

    @Override
    public List<BlockPos> getValidNeighbors(@NotNull BlockState blockState, @NotNull BlockPos pos) {
        return Direction.Plane.HORIZONTAL.stream().map(dir -> pos.offset(dir.getNormal())).toList();
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        if (blockState.getValue(WELL_PART) == WellPulleyPart.BASE) {
            return new WellPulleyBlockEntity(blockPos, blockState);
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> entityType) {
        if (!level.isClientSide) {
            return (level1, pos, state1, blockEntity) -> WellPulleyBlock.createAqueductConsumerTicker(level1, blockEntity);
        }
        return null;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction direction = pContext.getHorizontalDirection();
        BlockPos clickedPos = pContext.getClickedPos();
        BlockPos relative = clickedPos.relative(Direction.UP);
        Level level = pContext.getLevel();
        BlockPos below = clickedPos.below();
        BlockState blockBelow = level.getBlockState(below);
        if (level.getBlockState(relative).canBeReplaced(pContext) && level.getWorldBorder().isWithinBounds(relative) && blockBelow.isCollisionShapeFullBlock((BlockGetter)level, below)) {
            boolean hasNorthConnection = WellPulleyBlock.isValidForConnection((LevelAccessor)level, clickedPos, Direction.NORTH);
            boolean hasEastConnection = WellPulleyBlock.isValidForConnection((LevelAccessor)level, clickedPos, Direction.EAST);
            boolean hasSouthConnection = WellPulleyBlock.isValidForConnection((LevelAccessor)level, clickedPos, Direction.SOUTH);
            boolean hasWestConnection = WellPulleyBlock.isValidForConnection((LevelAccessor)level, clickedPos, Direction.WEST);
            BlockState state = this.defaultBlockState();
            state = (BlockState)state.setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(hasNorthConnection));
            state = (BlockState)state.setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(hasEastConnection));
            state = (BlockState)state.setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(hasSouthConnection));
            state = (BlockState)state.setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(hasWestConnection));
            return (BlockState)((BlockState)((BlockState)state.setValue(WELL_PART, (Comparable)((Object)WellPulleyPart.BASE))).setValue((Property)HORIZONTAL_FACING, (Comparable)direction.getOpposite())).setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false));
        }
        return null;
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        if (state.getValue(WELL_PART) == WellPulleyPart.BASE && (pos.above().equals((Object)neighborPos) && !neighborState.is((Block)YTechBlocks.WELL_PULLEY.get()) || pos.below().equals((Object)neighborPos) && !neighborState.isCollisionShapeFullBlock((BlockGetter)level, neighborPos))) {
            return Blocks.AIR.defaultBlockState();
        }
        if (state.getValue(WELL_PART) == WellPulleyPart.TOP && pos.below().equals((Object)neighborPos) && !neighborState.is((Block)YTechBlocks.WELL_PULLEY.get())) {
            return Blocks.AIR.defaultBlockState();
        }
        boolean hasNorthConnection = WellPulleyBlock.isValidForConnection(level, pos, Direction.NORTH);
        boolean hasEastConnection = WellPulleyBlock.isValidForConnection(level, pos, Direction.EAST);
        boolean hasSouthConnection = WellPulleyBlock.isValidForConnection(level, pos, Direction.SOUTH);
        boolean hasWestConnection = WellPulleyBlock.isValidForConnection(level, pos, Direction.WEST);
        state = (BlockState)state.setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(hasNorthConnection));
        state = (BlockState)state.setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(hasEastConnection));
        state = (BlockState)state.setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(hasSouthConnection));
        state = (BlockState)state.setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(hasWestConnection));
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{WELL_PART, HORIZONTAL_FACING, ACTIVATED, BlockStateProperties.NORTH, BlockStateProperties.EAST, BlockStateProperties.SOUTH, BlockStateProperties.WEST});
    }

    public void setPlacedBy(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @javax.annotation.Nullable LivingEntity pPlacer, @NotNull ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        if (!pLevel.isClientSide) {
            pLevel.setBlock(pPos.above(), (BlockState)pState.setValue(WELL_PART, (Comparable)((Object)WellPulleyPart.TOP)), 3);
            pLevel.blockUpdated(pPos, Blocks.AIR);
            pState.updateNeighbourShapes((LevelAccessor)pLevel, pPos, 3);
        }
    }

    @NotNull
    public BlockState playerWillDestroy(Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull Player pPlayer) {
        if (!pLevel.isClientSide && pPlayer.isCreative()) {
            WellPulleyPart part = (WellPulleyPart)((Object)pState.getValue(WELL_PART));
            if (part == WellPulleyPart.BASE) {
                BlockPos blockPos = pPos.above();
                BlockState blockState = pLevel.getBlockState(blockPos);
                if (blockState.is((Block)this) && blockState.getValue(WELL_PART) == WellPulleyPart.TOP) {
                    pLevel.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 35);
                    pLevel.levelEvent(pPlayer, 2001, blockPos, Block.getId((BlockState)blockState));
                }
            } else {
                BlockPos blockPos = pPos.below();
                BlockState blockState = pLevel.getBlockState(blockPos);
                if (blockState.is((Block)this) && blockState.getValue(WELL_PART) == WellPulleyPart.BASE) {
                    pLevel.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3);
                    pLevel.levelEvent(pPlayer, 2001, blockPos, Block.getId((BlockState)blockState));
                }
            }
        }
        super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
        return pState;
    }

    public static void registerModel(@NotNull BlockStateProvider provider) {
        ModelBuilder base = provider.models().cubeColumnHorizontal("well_pulley_base", Utils.modBlockLoc("terracotta_bricks"), Utils.modBlockLoc("aqueduct/aqueduct_well"));
        ModelBuilder overlay = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(Utils.getPath(YTechBlocks.WELL_PULLEY) + "_overlay")).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            if (Objects.requireNonNull(direction) == Direction.NORTH) {
                faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#1");
            } else {
                faceBuilder.uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#3");
            }
        }).from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).end()).renderType("minecraft:cutout")).texture("1", Utils.modBlockLoc("aqueduct/aqueduct_valve"))).texture("3", Utils.modBlockLoc("invisible"));
        ModelFile top = WellPulleyBlock.getTopModel(provider, false);
        ModelFile topActivated = WellPulleyBlock.getTopModel(provider, true);
        MultiPartBlockStateBuilder builder = provider.getMultipartBuilder((Block)YTechBlocks.WELL_PULLEY.get());
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)base).addModel()).condition(WELL_PART, (Comparable[])new WellPulleyPart[]{WellPulleyPart.BASE}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(top).addModel()).condition(WELL_PART, (Comparable[])new WellPulleyPart[]{WellPulleyPart.TOP}).condition((Property)HORIZONTAL_FACING, (Comparable[])new Direction[]{Direction.NORTH, Direction.SOUTH}).condition((Property)ACTIVATED, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(top).rotationY(90).addModel()).condition(WELL_PART, (Comparable[])new WellPulleyPart[]{WellPulleyPart.TOP}).condition((Property)HORIZONTAL_FACING, (Comparable[])new Direction[]{Direction.EAST, Direction.WEST}).condition((Property)ACTIVATED, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(topActivated).addModel()).condition(WELL_PART, (Comparable[])new WellPulleyPart[]{WellPulleyPart.TOP}).condition((Property)HORIZONTAL_FACING, (Comparable[])new Direction[]{Direction.NORTH, Direction.SOUTH}).condition((Property)ACTIVATED, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(topActivated).rotationY(90).addModel()).condition(WELL_PART, (Comparable[])new WellPulleyPart[]{WellPulleyPart.TOP}).condition((Property)HORIZONTAL_FACING, (Comparable[])new Direction[]{Direction.EAST, Direction.WEST}).condition((Property)ACTIVATED, (Comparable[])new Boolean[]{true}).end();
        PROPERTY_BY_DIRECTION.forEach((arg_0, arg_1) -> WellPulleyBlock.lambda$registerModel$3(builder, (ModelFile)overlay, arg_0, arg_1));
        ((ItemModelBuilder)provider.itemModels().getBuilder(Utils.getPath(YTechBlocks.WELL_PULLEY))).parent(top);
    }

    protected static void createAqueductConsumerTicker(@NotNull Level level, @NotNull BlockEntity blockEntity) {
        if (blockEntity instanceof WellPulleyBlockEntity) {
            WellPulleyBlockEntity wellPulleyBlockEntity = (WellPulleyBlockEntity)blockEntity;
            wellPulleyBlockEntity.tick((ServerLevel)level);
        }
    }

    private static ModelFile getTopModel(@NotNull BlockStateProvider provider, boolean activated) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().getBuilder(Utils.getPath(YTechBlocks.WELL_PULLEY) + (activated ? "_activated" : ""))).parent((ModelFile)provider.models().getExistingFile(Utils.mcBlockLoc("block")))).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case EAST: 
                case SOUTH: {
                    faceBuilder.uvs(0.0f, 0.0f, 4.0f, 16.0f).texture("#0");
                    break;
                }
                case WEST: {
                    faceBuilder.uvs(0.0f, 0.0f, 4.0f, 16.0f).texture("#0").cullface(direction);
                    break;
                }
                case UP: 
                case DOWN: {
                    faceBuilder.uvs(6.0f, 6.0f, 10.0f, 10.0f).texture("#1").cullface(direction);
                }
            }
        }).from(0.0f, 0.0f, 6.0f).to(4.0f, 16.0f, 10.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 0.0f, 4.0f, 16.0f).texture("#0");
                    break;
                }
                case EAST: {
                    faceBuilder.uvs(0.0f, 0.0f, 4.0f, 16.0f).texture("#0").cullface(direction);
                    break;
                }
                case UP: 
                case DOWN: {
                    faceBuilder.uvs(6.0f, 6.0f, 10.0f, 10.0f).texture("#1").cullface(direction);
                }
            }
        }).from(12.0f, 0.0f, 6.0f).to(16.0f, 16.0f, 10.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: 
                case UP: 
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 3.0f, 2.0f).texture("#2");
                }
            }
        }).from(4.0f, 13.0f, 7.0f).to(7.0f, 15.0f, 9.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case SOUTH: 
                case UP: 
                case DOWN: {
                    faceBuilder.uvs(0.0f, 0.0f, 3.0f, 2.0f).texture("#2");
                }
            }
        }).from(9.0f, 13.0f, 7.0f).to(12.0f, 15.0f, 9.0f).end()).element().allFaces((direction, faceBuilder) -> {
            switch (direction) {
                case NORTH: 
                case EAST: 
                case SOUTH: 
                case WEST: {
                    faceBuilder.uvs(0.0f, 1.0f, 2.0f, 16.0f).texture("#3");
                    break;
                }
                case UP: {
                    faceBuilder.uvs(2.0f, 0.0f, 4.0f, 2.0f).texture("#3");
                    break;
                }
                case DOWN: {
                    faceBuilder.uvs(2.0f, 0.0f, 4.0f, 2.0f).texture("#3").cullface(direction);
                }
            }
        }).from(7.0f, 0.0f, 7.0f).to(9.0f, 15.0f, 9.0f).end()).texture("particle", Utils.mcBlockLoc("oak_log"))).texture("0", Utils.mcBlockLoc("oak_log"))).texture("1", Utils.modBlockLoc("well_top"))).texture("2", Utils.mcBlockLoc("oak_planks"))).texture("3", Utils.modBlockLoc(activated ? "vertical_rope_activated" : "vertical_rope"));
    }

    private static /* synthetic */ void lambda$registerModel$3(MultiPartBlockStateBuilder builder, ModelFile overlay, Direction dir, BooleanProperty value) {
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(overlay).rotationY(((Integer)ANGLE_BY_DIRECTION.get(dir)).intValue()).addModel()).condition(WELL_PART, (Comparable[])new WellPulleyPart[]{WellPulleyPart.BASE}).condition((Property)value, (Comparable[])new Boolean[]{true}).end();
    }

    public static enum WellPulleyPart implements StringRepresentable
    {
        BASE("base"),
        TOP("top");

        public final String name;

        private WellPulleyPart(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

