/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.util.DataComponentUtil;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class AmphoraBlockEntity
extends BlockEntity {
    private static final String TAG_ITEM = "Item";
    private static final int STACK_MULTIPLIER = 8;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Codec<ItemStack> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.ITEM_NON_AIR_CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)ExtraCodecs.intRange((int)1, (int)512).fieldOf("count").orElse((Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(ItemStack::getComponentsPatch)).apply((Applicative)instance, ItemStack::new));
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            if (AmphoraBlockEntity.this.level != null) {
                AmphoraBlockEntity.this.level.blockEntityChanged(AmphoraBlockEntity.this.worldPosition);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.isStackable();
        }

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return stack.getMaxStackSize() * 8;
        }

        public int getSlotLimit(int slot) {
            return 512;
        }
    };

    public AmphoraBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)YTechBlockEntityTypes.AMPHORA.get(), pPos, pBlockState);
    }

    public ItemStack getItem() {
        return this.itemHandler.getStackInSlot(0);
    }

    public ItemInteractionResult useItemOn(@NotNull ItemStack holdingItem, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        ItemStack item = this.itemHandler.getStackInSlot(0);
        if (item.isEmpty()) {
            if (!holdingItem.isEmpty()) {
                this.itemHandler.setStackInSlot(0, holdingItem.copyAndClear());
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        } else {
            if (holdingItem.isEmpty()) {
                Block.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)hitResult.getDirection(), (ItemStack)this.itemHandler.extractItem(0, player.isCrouching() ? item.getMaxStackSize() : 1, false));
            } else {
                player.setItemInHand(hand, this.itemHandler.insertItem(0, holdingItem, false));
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains(TAG_ITEM)) {
            if (tag.getCompound(TAG_ITEM).isEmpty()) {
                this.itemHandler.setStackInSlot(0, ItemStack.EMPTY);
            } else {
                this.itemHandler.setStackInSlot(0, CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.getCompound(TAG_ITEM)).resultOrPartial(error -> LOGGER.error("Tried to load invalid item: '{}'", error)).orElse(ItemStack.EMPTY));
            }
        }
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        ItemStack itemStack = this.itemHandler.getStackInSlot(0);
        if (itemStack.isEmpty()) {
            tag.put(TAG_ITEM, (Tag)new CompoundTag());
        } else {
            tag.put(TAG_ITEM, DataComponentUtil.wrapEncodingExceptions((DataComponentHolder)itemStack, CODEC, (HolderLookup.Provider)provider, (Tag)new CompoundTag()));
        }
    }
}

