/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.configuration.MachineItemStackHandler;
import com.yanny.ytech.configuration.block_entity.IMenuBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class MachineBlockEntity
extends BlockEntity
implements MenuProvider,
IMenuBlockEntity {
    private static final String TAG_ITEMS = "items";
    @NotNull
    protected final MachineItemStackHandler itemStackHandler = this.createItemStackHandler();
    @NotNull
    protected final ContainerData containerData = this.createContainerData();

    public MachineBlockEntity(@NotNull BlockEntityType<?> blockEntityType, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        super(blockEntityType, pos, blockState);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains(TAG_ITEMS)) {
            this.itemStackHandler.deserializeNBT(provider, tag.getCompound(TAG_ITEMS));
        }
    }

    @Override
    @NotNull
    public MachineItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    @Override
    public int getDataSize() {
        return this.containerData.getCount();
    }

    public void tickServer(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState blockState, @NotNull MachineBlockEntity blockEntity) {
    }

    public void tickClient(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState blockState, @NotNull MachineBlockEntity blockEntity) {
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_ITEMS, (Tag)this.itemStackHandler.serializeNBT(provider));
    }

    @Override
    @NotNull
    public abstract MachineItemStackHandler createItemStackHandler();

    @Override
    @NotNull
    public abstract ContainerData createContainerData();
}

