/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.configuration.recipe.PotteryRecipe;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PottersWheelBlockEntity
extends BlockEntity {
    private static final String TAG_ITEMS = "items";
    private static final String TAG_RESULT = "result";
    private final ItemStackHandler items = new ItemStackHandler(1);
    private final RecipeManager.CachedCheck<RecipeInput, PotteryRecipe> quickCheck = RecipeManager.createCheck((RecipeType)((RecipeType)YTechRecipeTypes.POTTERY.get()));
    @Nullable
    private ItemStack result = null;

    public PottersWheelBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)YTechBlockEntityTypes.POTTERS_WHEEL.get(), pPos, pBlockState);
    }

    public ItemInteractionResult onUse(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand) {
        if (!level.isClientSide) {
            ItemStack holdingItemStack = player.getItemInHand(hand);
            if (player.isCrouching()) {
                Block.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)Direction.UP, (ItemStack)this.items.getStackInSlot(0));
                this.items.setStackInSlot(0, ItemStack.EMPTY);
                this.result = null;
                level.playSound(null, pos, SoundEvents.SLIME_SQUISH, SoundSource.BLOCKS, level.random.nextFloat() * 0.25f + 0.75f, 1.0f);
                level.sendBlockUpdated(pos, state, state, 3);
                PottersWheelBlockEntity.setChanged((Level)level, (BlockPos)this.worldPosition, (BlockState)Blocks.AIR.defaultBlockState());
            } else if (holdingItemStack.is(Items.CLAY) || holdingItemStack.is(Items.CLAY_BALL)) {
                ItemStack inHand = holdingItemStack.copyWithCount(1);
                if (inHand.is(Items.CLAY)) {
                    inHand = Items.CLAY_BALL.getDefaultInstance();
                    inHand.setCount(4);
                }
                if (this.items.insertItem(0, inHand, true).isEmpty()) {
                    this.items.insertItem(0, inHand, false);
                    holdingItemStack.shrink(1);
                    level.playSound(null, pos, SoundEvents.SLIME_SQUISH, SoundSource.BLOCKS, level.random.nextFloat() * 0.25f + 0.75f, 1.0f);
                    Optional recipes = this.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(this.items.getStackInSlot(0)), level);
                    this.result = recipes.map(m -> ((PotteryRecipe)m.value()).result()).orElse(null);
                    player.causeFoodExhaustion(4.0f);
                    level.sendBlockUpdated(pos, state, state, 3);
                    PottersWheelBlockEntity.setChanged((Level)level, (BlockPos)this.worldPosition, (BlockState)Blocks.AIR.defaultBlockState());
                }
            } else if (holdingItemStack.isEmpty() && this.result != null) {
                this.items.setStackInSlot(0, ItemStack.EMPTY);
                Block.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)Direction.UP, (ItemStack)this.result);
                this.result = null;
                level.playSound(null, pos, SoundEvents.SLIME_SQUISH, SoundSource.BLOCKS, level.random.nextFloat() * 0.25f + 0.75f, 1.0f);
                level.sendBlockUpdated(pos, state, state, 3);
                player.causeFoodExhaustion(4.0f);
                PottersWheelBlockEntity.setChanged((Level)level, (BlockPos)this.worldPosition, (BlockState)Blocks.AIR.defaultBlockState());
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains(TAG_ITEMS)) {
            this.items.deserializeNBT(provider, tag.getCompound(TAG_ITEMS));
        }
        this.result = tag.contains(TAG_RESULT) ? ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound(TAG_RESULT)) : null;
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.saveAdditional(tag, provider);
        return tag;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public ItemStack getItem() {
        return this.items.getStackInSlot(0);
    }

    @Nullable
    public ItemStack getResult() {
        return this.result;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_ITEMS, (Tag)this.items.serializeNBT(provider));
        if (this.result != null) {
            tag.put(TAG_RESULT, this.result.saveOptional(provider));
        }
    }
}

