/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.yanny.ytech.configuration.MachineItemStackHandler;
import com.yanny.ytech.configuration.block_entity.AbstractPrimitiveMachineBlockEntity;
import com.yanny.ytech.configuration.container.PrimitiveAlloySmelterContainerMenu;
import com.yanny.ytech.configuration.recipe.AlloyingRecipe;
import com.yanny.ytech.configuration.recipe.YTechRecipeInput;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrimitiveAlloySmelterBlockEntity
extends AbstractPrimitiveMachineBlockEntity {
    private static final String TAG_RECIPE_INPUT_LEFT = "recipeInputLeft";
    private static final String TAG_RECIPE_INPUT_RIGHT = "recipeInputRight";
    private static final int SLOT_INPUT_LEFT = 0;
    private static final int SLOT_INPUT_RIGHT = 1;
    private static final int SLOT_FUEL = 2;
    private static final int SLOT_OUTPUT = 3;
    private final RecipeManager.CachedCheck<RecipeInput, AlloyingRecipe> quickCheck;
    @Nullable
    private ItemStack recipeInputLeft = ItemStack.EMPTY;
    @Nullable
    private ItemStack recipeInputRight = ItemStack.EMPTY;

    public PrimitiveAlloySmelterBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)YTechBlockEntityTypes.PRIMITIVE_ALLOY_SMELTER.get(), pos, blockState, (RecipeType)YTechRecipeTypes.ALLOYING.get());
        this.quickCheck = RecipeManager.createCheck((RecipeType)((RecipeType)YTechRecipeTypes.ALLOYING.get()));
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.ytech.primitive_alloy_smelter");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory inventory, @NotNull Player player) {
        return new PrimitiveAlloySmelterContainerMenu(windowId, inventory.player, this.worldPosition, this.itemStackHandler, this.containerData);
    }

    @Override
    @NotNull
    public MachineItemStackHandler createItemStackHandler() {
        return new MachineItemStackHandler.Builder().addInputSlot(45, 16, this::canInput).addInputSlot(65, 16, this::canInput).addInputSlot(55, 52, (itemStackHandler, slot, itemStack) -> itemStack.getBurnTime(RecipeType.BLASTING) > 0).addOutputSlot(116, 35).setOnChangeListener(() -> ((PrimitiveAlloySmelterBlockEntity)this).setChanged()).build();
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (this.level == null || !this.level.isClientSide) {
            this.recipeInputLeft = tag.contains(TAG_RECIPE_INPUT_LEFT) ? ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound(TAG_RECIPE_INPUT_LEFT)) : null;
            this.recipeInputRight = tag.contains(TAG_RECIPE_INPUT_RIGHT) ? ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound(TAG_RECIPE_INPUT_RIGHT)) : null;
        }
    }

    @Override
    public boolean hasActiveRecipe() {
        return this.recipeInputLeft != null && this.recipeInputRight != null;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.level == null || !this.level.isClientSide) {
            if (this.recipeInputLeft != null) {
                tag.put(TAG_RECIPE_INPUT_LEFT, this.recipeInputLeft.saveOptional(provider));
            }
            if (this.recipeInputRight != null) {
                tag.put(TAG_RECIPE_INPUT_RIGHT, this.recipeInputRight.saveOptional(provider));
            }
        }
    }

    @Override
    protected boolean hasItemsInInput() {
        return !this.itemStackHandler.getStackInSlot(0).isEmpty() && !this.itemStackHandler.getStackInSlot(1).isEmpty();
    }

    @Override
    protected int getFuelSlot() {
        return 2;
    }

    @Override
    protected void startRecipe(@NotNull AtomicBoolean hasChanged) {
        if (this.level != null) {
            ItemStack inputLeft = this.itemStackHandler.getStackInSlot(0);
            ItemStack inputRight = this.itemStackHandler.getStackInSlot(1);
            this.quickCheck.getRecipeFor((RecipeInput)new YTechRecipeInput(inputLeft, inputRight), this.level).ifPresent(recipe -> {
                ItemStack result = this.itemStackHandler.getStackInSlot(3);
                AlloyingRecipe r = (AlloyingRecipe)recipe.value();
                if (r.minTemperature() <= this.temperature && (result.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)result, (ItemStack)r.result()) && result.getMaxStackSize() > result.getCount() + r.result().getCount())) {
                    if (r.ingredient1().test(inputLeft) && r.ingredient2().test(inputRight)) {
                        this.recipeInputLeft = inputLeft.split(r.ingredient1().count());
                        this.recipeInputRight = inputRight.split(r.ingredient2().count());
                    } else {
                        this.recipeInputLeft = inputLeft.split(r.ingredient2().count());
                        this.recipeInputRight = inputRight.split(r.ingredient1().count());
                    }
                    this.leftSmelting = this.smeltingTime = r.smeltingTime();
                    this.recipeTemperature = r.minTemperature();
                    hasChanged.set(true);
                }
            });
        }
    }

    @Override
    protected void finishRecipe() {
        if (this.level != null && this.recipeInputLeft != null && this.recipeInputRight != null) {
            ItemStack result = this.itemStackHandler.getStackInSlot(3);
            this.quickCheck.getRecipeFor((RecipeInput)new YTechRecipeInput(this.recipeInputLeft, this.recipeInputRight), this.level).ifPresent(r -> {
                if (result.isEmpty()) {
                    this.itemStackHandler.setStackInSlot(3, ((AlloyingRecipe)r.value()).result().copy());
                } else {
                    result.grow(((AlloyingRecipe)r.value()).result().getCount());
                }
            });
            this.recipeInputLeft = null;
            this.recipeInputRight = null;
        }
    }

    @Override
    protected boolean isValidRecipeInInput() {
        if (this.level != null) {
            ItemStack inputLeft = this.itemStackHandler.getStackInSlot(0);
            ItemStack inputRight = this.itemStackHandler.getStackInSlot(1);
            return this.level.getRecipeManager().getAllRecipesFor((RecipeType)YTechRecipeTypes.ALLOYING.get()).stream().anyMatch(recipe -> ((AlloyingRecipe)recipe.value()).matches(new YTechRecipeInput(inputLeft, inputRight), this.level));
        }
        return false;
    }

    private boolean canInput(@NotNull MachineItemStackHandler itemStackHandler, int slot, @NotNull ItemStack itemStack) {
        ItemStack itemStack2;
        ItemStack itemStack1 = slot != 0 ? itemStackHandler.getStackInSlot(0) : itemStack;
        ItemStack itemStack3 = itemStack2 = slot != 1 ? itemStackHandler.getStackInSlot(1) : itemStack;
        if (this.level != null) {
            return this.level.getRecipeManager().getAllRecipesFor((RecipeType)YTechRecipeTypes.ALLOYING.get()).stream().anyMatch(recipe -> ((AlloyingRecipe)recipe.value()).matchesPartially(new YTechRecipeInput(itemStack1, itemStack2)));
        }
        return false;
    }
}

