/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block_entity;

import com.google.common.collect.ImmutableList;
import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.block.WellPulleyBlock;
import com.yanny.ytech.configuration.block_entity.IrrigationBlockEntity;
import com.yanny.ytech.network.irrigation.NetworkType;
import com.yanny.ytech.registration.YTechBiomeTags;
import com.yanny.ytech.registration.YTechBlockEntityTypes;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechSoundEvents;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import org.jetbrains.annotations.NotNull;

public class WellPulleyBlockEntity
extends IrrigationBlockEntity {
    private static final String TAG_TIMER = "timer";
    private static final PerlinSimplexNoise WATER_SOURCE_NOISE = new PerlinSimplexNoise((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(5432L)), (List)ImmutableList.of((Object)0));
    protected int timer = 0;
    private int cachedFlow = -1;

    public WellPulleyBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        super((BlockEntityType<? extends BlockEntity>)((BlockEntityType)YTechBlockEntityTypes.WELL_PULLEY.get()), pos, blockState, ((WellPulleyBlock)blockState.getBlock()).getValidNeighbors(blockState, pos));
    }

    @Override
    public int getFlow() {
        if (this.level != null) {
            BlockState blockState = this.level.getBlockState(this.worldPosition.above());
            if (this.cachedFlow < 0) {
                this.cachedFlow = this.getNoiseFlow(this.level);
            }
            if (blockState.is((Block)YTechBlocks.WELL_PULLEY.get())) {
                return (Boolean)this.level.getBlockState(this.worldPosition.above()).getValue((Property)WellPulleyBlock.ACTIVATED) != false ? this.cachedFlow : 0;
            }
        }
        return 0;
    }

    @Override
    @NotNull
    public NetworkType getNetworkType() {
        return NetworkType.PROVIDER;
    }

    @NotNull
    public ItemInteractionResult onUse(@NotNull Level level, @NotNull BlockState aboveState, @NotNull Player player) {
        if (aboveState.is((Block)YTechBlocks.WELL_PULLEY.get())) {
            this.timer = 20;
            if (!((Boolean)aboveState.getValue((Property)WellPulleyBlock.ACTIVATED)).booleanValue()) {
                level.setBlock(this.worldPosition.above(), (BlockState)aboveState.setValue((Property)WellPulleyBlock.ACTIVATED, (Comparable)Boolean.valueOf((Boolean)aboveState.getValue((Property)WellPulleyBlock.ACTIVATED) == false)), 3);
                YTechMod.IRRIGATION_PROPAGATOR.server().changed(this);
            }
            level.playSound(null, this.worldPosition, (SoundEvent)YTechSoundEvents.WELL_PULLEY_USE.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            level.blockEntityChanged(this.worldPosition);
            player.causeFoodExhaustion(0.5f);
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider pProvider) {
        super.loadAdditional(tag, pProvider);
        this.timer = tag.getInt(TAG_TIMER);
    }

    public void tick(ServerLevel level) {
        if (this.timer > 0) {
            BlockState aboveState;
            --this.timer;
            level.blockEntityChanged(this.worldPosition);
            if (this.timer == 0 && (aboveState = level.getBlockState(this.worldPosition.above())).is((Block)YTechBlocks.WELL_PULLEY.get())) {
                level.setBlock(this.worldPosition.above(), (BlockState)aboveState.setValue((Property)WellPulleyBlock.ACTIVATED, (Comparable)Boolean.valueOf(false)), 3);
                YTechMod.IRRIGATION_PROPAGATOR.server().changed(this);
            }
        }
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider pProvider) {
        super.saveAdditional(tag, pProvider);
        tag.putInt(TAG_TIMER, this.timer);
    }

    public static double getWaterAbundance(BlockPos pos) {
        return WATER_SOURCE_NOISE.getValue((double)pos.getX() * 0.01, (double)pos.getZ() * 0.01, false);
    }

    private int getNoiseFlow(@NotNull Level level) {
        Holder biome = level.getBiome(this.worldPosition);
        if (!biome.is(YTechBiomeTags.WELL_DISABLED_BIOMES)) {
            double biomeModifier = 1.0;
            double waterAbundance = WellPulleyBlockEntity.getWaterAbundance(this.worldPosition);
            boolean dryBiome = biome.is(YTechBiomeTags.WELL_DRY_BIOMES);
            boolean wetBiome = biome.is(YTechBiomeTags.WELL_WET_BIOMES);
            if (dryBiome) {
                biomeModifier = YTechMod.CONFIGURATION.getWellPulleyDryBonus();
            } else if (wetBiome) {
                biomeModifier = YTechMod.CONFIGURATION.getWellPulleyWetBonus();
            }
            return (int)Math.max(Math.round(waterAbundance * (double)YTechMod.CONFIGURATION.getWellPulleyGeneration() * biomeModifier), 1L);
        }
        return 1;
    }
}

