/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.entity;

import com.yanny.ytech.configuration.entity.SaberToothTigerEntity;
import com.yanny.ytech.configuration.entity.WildDangerousEntity;
import com.yanny.ytech.configuration.goal.IRaidGarden;
import com.yanny.ytech.configuration.goal.RaidGardenGoal;
import com.yanny.ytech.registration.YTechBlockTags;
import com.yanny.ytech.registration.YTechItemTags;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class AurochsEntity
extends WildDangerousEntity
implements IRaidGarden {
    private static final int EAT_ANIMATION_TICKS = 40;
    private static final String TAG_MORE_WHEAT_TICKS = "MoreWheatTicks";
    private int moreWheatTicks;
    private int eatAnimationTick;
    private EatBlockGoal eatBlockGoal;

    public AurochsEntity(EntityType<? extends WildDangerousEntity> entityType, Level level) {
        super(entityType, level);
    }

    public float getVoicePitch() {
        return this.isBaby() ? (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f : (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.6f;
    }

    public boolean isFood(@NotNull ItemStack pStack) {
        return pStack.is(YTechItemTags.AUROCHS_FOOD);
    }

    public void aiStep() {
        if (this.level().isClientSide) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
        super.aiStep();
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 10) {
            this.eatAnimationTick = 40;
        } else {
            super.handleEntityEvent(pId);
        }
    }

    @Override
    public boolean wantsMoreFood() {
        return this.moreWheatTicks <= 0;
    }

    @Override
    public void setWantsMoreFoodTicks() {
        this.moreWheatTicks = 40;
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt(TAG_MORE_WHEAT_TICKS, this.moreWheatTicks);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.moreWheatTicks = tag.getInt(TAG_MORE_WHEAT_TICKS);
    }

    public float getHeadEatPositionScale(float pPartialTick) {
        if (this.eatAnimationTick <= 0) {
            return 0.0f;
        }
        if (this.eatAnimationTick >= 4 && this.eatAnimationTick <= 36) {
            return 1.0f;
        }
        return this.eatAnimationTick < 4 ? ((float)this.eatAnimationTick - pPartialTick) / 4.0f : -((float)(this.eatAnimationTick - 40) - pPartialTick) / 4.0f;
    }

    public float getHeadEatAngleScale(float pPartialTick) {
        if (this.eatAnimationTick > 4 && this.eatAnimationTick <= 36) {
            float f = ((float)(this.eatAnimationTick - 4) - pPartialTick) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.sin((float)(f * 28.7f));
        }
        return this.eatAnimationTick > 0 ? 0.62831855f : this.getXRot() * ((float)Math.PI / 180);
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    protected EntityType<? extends AgeableMob> getDomesticBreedOffspring() {
        return EntityType.COW;
    }

    @Override
    protected Class<? extends WildDangerousEntity> getMineClass() {
        return AurochsEntity.class;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.COW_AMBIENT;
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return SoundEvents.COW_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.COW_DEATH;
    }

    protected void playStepSound(@NotNull BlockPos pos, @NotNull BlockState state) {
        this.playSound(SoundEvents.COW_STEP, 0.15f, 1.0f);
    }

    protected void registerGoals() {
        this.eatBlockGoal = new EatBlockGoal((Mob)this);
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, (Predicate)Ingredient.of(YTechItemTags.AUROCHS_TEMP_ITEMS), false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, SaberToothTigerEntity.class, 8.0f, 2.2, 2.2));
        this.goalSelector.addGoal(6, (Goal)this.eatBlockGoal);
        this.goalSelector.addGoal(6, new RaidGardenGoal<AurochsEntity>(this, YTechBlockTags.AUROCHS_RAID_BLOCKS));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.registerTargetGoals();
    }

    @Override
    protected void customServerAiStep() {
        this.eatAnimationTick = this.eatBlockGoal.getEatAnimationTick();
        super.customServerAiStep();
        if (this.moreWheatTicks > 0) {
            this.moreWheatTicks -= this.random.nextInt(3);
            if (this.moreWheatTicks < 0) {
                this.moreWheatTicks = 0;
            }
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ARMOR, 1.0).add(Attributes.ATTACK_DAMAGE, 5.0);
    }
}

