/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.entity;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yanny.ytech.configuration.entity.SaberToothTigerEntity;
import com.yanny.ytech.configuration.goal.IRaidGarden;
import com.yanny.ytech.configuration.goal.RaidGardenGoal;
import com.yanny.ytech.registration.YTechBlockTags;
import com.yanny.ytech.registration.YTechItemTags;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeerEntity
extends Animal
implements IRaidGarden {
    private static final EntityDataAccessor<Boolean> DATA_HAS_ANTLERS_ID = SynchedEntityData.defineId(DeerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final String TAG_HAS_ANTLERS = "HasAntlers";
    private static final String TAG_MORE_WHEAT_TICKS = "MoreWheatTicks";
    private static final int EAT_ANIMATION_TICKS = 40;
    private int moreWheatTicks;
    private int eatAnimationTick;
    private EatBlockGoal eatBlockGoal;

    public DeerEntity(@NotNull EntityType<? extends Animal> entityType, @NotNull Level level) {
        super(entityType, level);
    }

    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        this.entityData.set(DATA_HAS_ANTLERS_ID, (Object)this.random.nextBoolean());
        return super.finalizeSpawn(level, difficulty, reason, spawnData);
    }

    @Nullable
    public AgeableMob getBreedOffspring(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageableMob) {
        return null;
    }

    public boolean isFood(@NotNull ItemStack pStack) {
        return false;
    }

    public void customServerAiStep() {
        this.eatAnimationTick = this.eatBlockGoal.getEatAnimationTick();
        super.customServerAiStep();
        if (this.moreWheatTicks > 0) {
            this.moreWheatTicks -= this.random.nextInt(3);
            if (this.moreWheatTicks < 0) {
                this.moreWheatTicks = 0;
            }
        }
    }

    public void aiStep() {
        if (this.level().isClientSide) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
        super.aiStep();
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 10) {
            this.eatAnimationTick = 40;
        } else {
            super.handleEntityEvent(pId);
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt(TAG_MORE_WHEAT_TICKS, this.moreWheatTicks);
        tag.putBoolean(TAG_HAS_ANTLERS, ((Boolean)this.entityData.get(DATA_HAS_ANTLERS_ID)).booleanValue());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.moreWheatTicks = tag.getInt(TAG_MORE_WHEAT_TICKS);
        this.entityData.set(DATA_HAS_ANTLERS_ID, (Object)tag.getBoolean(TAG_HAS_ANTLERS));
    }

    public float getHeadEatPositionScale(float pPartialTick) {
        if (this.eatAnimationTick <= 0) {
            return 0.0f;
        }
        if (this.eatAnimationTick >= 4 && this.eatAnimationTick <= 36) {
            return 1.0f;
        }
        return this.eatAnimationTick < 4 ? ((float)this.eatAnimationTick - pPartialTick) / 4.0f : -((float)(this.eatAnimationTick - 40) - pPartialTick) / 4.0f;
    }

    public float getHeadEatAngleScale(float pPartialTick) {
        if (this.eatAnimationTick > 4 && this.eatAnimationTick <= 36) {
            float f = ((float)(this.eatAnimationTick - 4) - pPartialTick) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.sin((float)(f * 28.7f));
        }
        return this.eatAnimationTick > 0 ? 0.62831855f : this.getXRot() * ((float)Math.PI / 180);
    }

    @Override
    public boolean wantsMoreFood() {
        return this.moreWheatTicks <= 0;
    }

    @Override
    public void setWantsMoreFoodTicks() {
        this.moreWheatTicks = 40;
    }

    public boolean hasAntlers() {
        return (Boolean)this.entityData.get(DATA_HAS_ANTLERS_ID);
    }

    protected void onOffspringSpawnedFromEgg(@NotNull Player pPlayer, @NotNull Mob pChild) {
        this.entityData.set(DATA_HAS_ANTLERS_ID, (Object)this.random.nextBoolean());
        super.onOffspringSpawnedFromEgg(pPlayer, pChild);
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_HAS_ANTLERS_ID, (Object)false);
    }

    protected void registerGoals() {
        this.eatBlockGoal = new EatBlockGoal((Mob)this);
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.goalSelector.addGoal(2, (Goal)new TemptGoal((PathfinderMob)this, 1.25, (Predicate)Ingredient.of(YTechItemTags.DEER_TEMP_ITEMS), true));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, SaberToothTigerEntity.class, 12.0f, 2.2, 2.2));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 2.2, 2.2));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 10.0f, 2.2, 2.2));
        this.goalSelector.addGoal(4, (Goal)this.eatBlockGoal);
        this.goalSelector.addGoal(4, new RaidGardenGoal<DeerEntity>(this, YTechBlockTags.DEER_RAID_BLOCKS));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f);
    }

    public static String hasAntlersStr() {
        JsonObject object = new JsonObject();
        object.addProperty(TAG_HAS_ANTLERS, Boolean.valueOf(true));
        return new Gson().toJson((JsonElement)object);
    }
}

