/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.item;

import com.yanny.ytech.registration.YTechItemTags;
import com.yanny.ytech.registration.YTechItems;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class ClayBucketItem
extends BucketItem {
    public ClayBucketItem(Fluid fluid, Item.Properties builder) {
        super(fluid, builder);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        BlockHitResult blockHitResult = ClayBucketItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)(this.content == Fluids.EMPTY ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (blockHitResult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemInHand);
        }
        if (blockHitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemInHand);
        }
        BlockPos blockPos = blockHitResult.getBlockPos();
        Direction direction = blockHitResult.getDirection();
        BlockPos relativePos = blockPos.relative(direction);
        if (level.mayInteract(player, blockPos) && player.mayUseItemAt(relativePos, direction, itemInHand)) {
            BlockPos placePos;
            if (this.content == Fluids.EMPTY) {
                BucketPickup bucketPickup;
                ItemStack pickedItemStack;
                Block block;
                BlockState blockState = level.getBlockState(blockPos);
                if (!blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (block = blockState.getBlock()) instanceof LiquidBlock) {
                    LiquidBlock liquidBlock = (LiquidBlock)block;
                    if (!liquidBlock.fluid.isSame((Fluid)Fluids.WATER) && !liquidBlock.fluid.isSame((Fluid)Fluids.LAVA)) {
                        return InteractionResultHolder.fail((Object)itemInHand);
                    }
                }
                if ((block = blockState.getBlock()) instanceof BucketPickup && !(pickedItemStack = (bucketPickup = (BucketPickup)block).pickupBlock(player, (LevelAccessor)level, blockPos, blockState)).isEmpty()) {
                    if (pickedItemStack.is(Items.WATER_BUCKET)) {
                        pickedItemStack = new ItemStack((ItemLike)YTechItems.WATER_CLAY_BUCKET.get());
                    } else if (pickedItemStack.is(Items.LAVA_BUCKET)) {
                        pickedItemStack = new ItemStack((ItemLike)YTechItems.LAVA_CLAY_BUCKET.get());
                    } else {
                        return InteractionResultHolder.fail((Object)itemInHand);
                    }
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                    bucketPickup.getPickupSound(blockState).ifPresent(soundEvent -> player.playSound(soundEvent, 1.0f, 1.0f));
                    level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, blockPos);
                    ItemStack filledResult = ItemUtils.createFilledResult((ItemStack)itemInHand, (Player)player, (ItemStack)pickedItemStack);
                    if (!level.isClientSide) {
                        CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, pickedItemStack);
                    }
                    return InteractionResultHolder.sidedSuccess((Object)filledResult, (boolean)level.isClientSide());
                }
                return InteractionResultHolder.fail((Object)itemInHand);
            }
            BlockState blockState = level.getBlockState(blockPos);
            BlockPos blockPos2 = placePos = this.canBlockContainFluid(player, level, blockPos, blockState) ? blockPos : relativePos;
            if (this.emptyContents(player, level, placePos, blockHitResult, itemInHand)) {
                this.checkExtraContent(player, level, itemInHand, placePos);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, placePos, itemInHand);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                return InteractionResultHolder.sidedSuccess((Object)ClayBucketItem.getEmptySuccessItem(itemInHand, player), (boolean)level.isClientSide());
            }
            return InteractionResultHolder.fail((Object)itemInHand);
        }
        return InteractionResultHolder.fail((Object)itemInHand);
    }

    @NotNull
    public static ItemStack getEmptySuccessItem(@NotNull ItemStack bucketItemStack, Player player) {
        if (bucketItemStack.is(YTechItemTags.LAVA_BUCKETS) && !player.getAbilities().instabuild) {
            return ItemStack.EMPTY;
        }
        return !player.getAbilities().instabuild ? new ItemStack((ItemLike)YTechItems.CLAY_BUCKET.get()) : bucketItemStack;
    }
}

