/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.item;

import com.yanny.ytech.registration.YTechBlockTags;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class UnlitTorchItem
extends Item {
    public UnlitTorchItem() {
        super(new Item.Properties());
    }

    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext pContext, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.translatable((String)"text.ytech.hover.unlit_torch1").withStyle(ChatFormatting.DARK_GRAY));
        pTooltipComponents.add((Component)Component.translatable((String)"text.ytech.hover.unlit_torch2").withStyle(ChatFormatting.DARK_GRAY));
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Level level;
        Player player = context.getPlayer();
        if (player != null && (level = context.getLevel()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            BlockState blockState = level2.getBlockState(context.getClickedPos());
            if (blockState.is(YTechBlockTags.FIRE_SOURCE) && (!blockState.hasProperty((Property)BlockStateProperties.LIT) || ((Boolean)blockState.getValue((Property)BlockStateProperties.LIT)).booleanValue())) {
                context.getPlayer().setItemInHand(context.getHand(), new ItemStack((ItemLike)Items.TORCH, context.getItemInHand().getCount()));
                return InteractionResult.CONSUME;
            }
            if (blockState.is(YTechBlockTags.SOUL_FIRE_SOURCE) && (!blockState.hasProperty((Property)BlockStateProperties.LIT) || ((Boolean)blockState.getValue((Property)BlockStateProperties.LIT)).booleanValue())) {
                context.getPlayer().setItemInHand(context.getHand(), new ItemStack((ItemLike)Items.SOUL_TORCH, context.getItemInHand().getCount()));
                return InteractionResult.CONSUME;
            }
        }
        return super.useOn(context);
    }
}

