/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yanny.ytech.registration.YTechRecipeSerializers;
import com.yanny.ytech.registration.YTechRecipeTypes;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record AlloyingRecipe(SizedIngredient ingredient1, SizedIngredient ingredient2, int minTemperature, int smeltingTime, ItemStack result) implements Recipe<RecipeInput>
{
    public boolean matches(@NotNull RecipeInput recipeInput, @NotNull Level level) {
        return this.ingredient1.test(recipeInput.getItem(0)) && this.ingredient2.test(recipeInput.getItem(1)) || this.ingredient1.test(recipeInput.getItem(1)) && this.ingredient2.test(recipeInput.getItem(0));
    }

    public boolean matchesPartially(@NotNull RecipeInput recipeInput) {
        return recipeInput.getItem(0).isEmpty() || this.ingredient1.test(recipeInput.getItem(0)) || recipeInput.getItem(1).isEmpty() || this.ingredient2.test(recipeInput.getItem(1)) || recipeInput.getItem(0).isEmpty() || this.ingredient2.test(recipeInput.getItem(0)) || recipeInput.getItem(1).isEmpty() || this.ingredient1.test(recipeInput.getItem(1));
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput recipeInput, @NotNull HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int w, int h) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider provider) {
        return this.result;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)YTechRecipeSerializers.ALLOYING.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)YTechRecipeTypes.ALLOYING.get();
    }

    public static class Builder
    implements RecipeBuilder {
        private final SizedIngredient ingredient1;
        private final SizedIngredient ingredient2;
        private final int minTemperature;
        private final int smeltingTime;
        private final Item result;
        private final int count;
        private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

        Builder(@NotNull SizedIngredient ingredient1, @NotNull SizedIngredient ingredient2, int minTemperature, int smeltingTime, @NotNull Item result, int count) {
            this.ingredient1 = ingredient1;
            this.ingredient2 = ingredient2;
            this.minTemperature = minTemperature;
            this.smeltingTime = smeltingTime;
            this.result = result;
            this.count = count;
        }

        public static Builder alloying(@NotNull TagKey<Item> input1, int count1, @NotNull TagKey<Item> input2, int count2, int minTemperature, int smeltingTime, @NotNull Item result, int count) {
            return new Builder(SizedIngredient.of(input1, (int)count1), SizedIngredient.of(input2, (int)count2), minTemperature, smeltingTime, result, count);
        }

        public static Builder alloying(@NotNull TagKey<Item> input1, int count1, @NotNull ItemLike input2, int count2, int minTemperature, int smeltingTime, @NotNull Item result, int count) {
            return new Builder(SizedIngredient.of(input1, (int)count1), SizedIngredient.of((ItemLike)input2, (int)count2), minTemperature, smeltingTime, result, count);
        }

        @NotNull
        public RecipeBuilder unlockedBy(@NotNull String criterionName, @NotNull Criterion criterionTrigger) {
            this.criteria.put(criterionName, criterionTrigger);
            return this;
        }

        @NotNull
        public RecipeBuilder group(@Nullable String groupName) {
            return this;
        }

        @NotNull
        public Item getResult() {
            return this.result;
        }

        public void save(@NotNull RecipeOutput finishedRecipeConsumer, @NotNull ResourceLocation recipeId) {
            this.ensureValid(recipeId);
            Advancement.Builder builder = finishedRecipeConsumer.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)recipeId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId)).requirements(AdvancementRequirements.Strategy.OR);
            this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
            finishedRecipeConsumer.accept(recipeId, (Recipe)new AlloyingRecipe(this.ingredient1, this.ingredient2, this.minTemperature, this.smeltingTime, new ItemStack((ItemLike)this.result, this.count)), builder.build(recipeId.withPrefix("recipes/alloying/")));
        }

        private void ensureValid(@NotNull ResourceLocation id) {
            if (this.criteria.isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(id));
            }
        }
    }

    public static class Serializer
    implements RecipeSerializer<AlloyingRecipe> {
        private static final MapCodec<AlloyingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SizedIngredient.NESTED_CODEC.fieldOf("ingredient1").forGetter(alloyingRecipe -> alloyingRecipe.ingredient1), (App)SizedIngredient.NESTED_CODEC.fieldOf("ingredient2").forGetter(alloyingRecipe -> alloyingRecipe.ingredient2), (App)Codec.INT.fieldOf("minTemp").forGetter(alloyingRecipe -> alloyingRecipe.minTemperature), (App)Codec.INT.fieldOf("smeltingTime").forGetter(alloyingRecipe -> alloyingRecipe.smeltingTime), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(alloyingRecipe -> alloyingRecipe.result)).apply((Applicative)instance, AlloyingRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, AlloyingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<AlloyingRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, AlloyingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        @NotNull
        private static AlloyingRecipe fromNetwork(@NotNull RegistryFriendlyByteBuf buffer) {
            SizedIngredient ingredient1 = (SizedIngredient)SizedIngredient.STREAM_CODEC.decode((Object)buffer);
            SizedIngredient ingredient2 = (SizedIngredient)SizedIngredient.STREAM_CODEC.decode((Object)buffer);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int minTemperature = buffer.readInt();
            int smeltingTime = buffer.readInt();
            return new AlloyingRecipe(ingredient1, ingredient2, minTemperature, smeltingTime, result);
        }

        private static void toNetwork(@NotNull RegistryFriendlyByteBuf buffer, @NotNull AlloyingRecipe recipe) {
            SizedIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient1);
            SizedIngredient.STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient2);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeInt(recipe.minTemperature);
            buffer.writeInt(recipe.smeltingTime);
        }
    }
}

