/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yanny.ytech.registration.YTechRecipeSerializers;
import com.yanny.ytech.registration.YTechRecipeTypes;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record WorkspaceCraftingRecipe(PatternHolder patternHolder, Ingredient tool, ItemStack result) implements Recipe<RecipeInput>
{
    public boolean matches(@NotNull RecipeInput container, @NotNull Level level) {
        return this.patternHolder.matches(container);
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.patternHolder.ingredients;
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput container, @NotNull HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider provider) {
        return this.result;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)YTechRecipeSerializers.WORKSPACE_CRAFTING.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)YTechRecipeTypes.WORKSPACE_CRAFTING.get();
    }

    private record PatternHolder(NonNullList<Ingredient> ingredients, Optional<Pattern> data) {
        public static final MapCodec<PatternHolder> CODEC = Pattern.MAP_CODEC.flatXmap(PatternHolder::unpack, pattern -> pattern.data().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));
        public static final StreamCodec<RegistryFriendlyByteBuf, PatternHolder> STREAM_CODEC = StreamCodec.ofMember(PatternHolder::toNetwork, PatternHolder::fromNetwork);

        public boolean matches(RecipeInput container) {
            int z;
            int x;
            int y;
            int i;
            boolean matches = true;
            for (i = 0; i < 27; ++i) {
                if (((Ingredient)this.ingredients.get(i)).test(container.getItem(i))) continue;
                matches = false;
            }
            if (!matches) {
                i = 0;
                matches = true;
                for (y = 0; y < 3; ++y) {
                    for (x = 0; x < 3; ++x) {
                        for (z = 0; z < 3; ++z) {
                            if (!((Ingredient)this.ingredients.get(i)).test(container.getItem(x + z * 3 + y * 9))) {
                                matches = false;
                            }
                            ++i;
                        }
                    }
                }
            }
            if (!matches) {
                i = 0;
                matches = true;
                for (y = 0; y < 3; ++y) {
                    for (int z2 = 2; z2 >= 0; --z2) {
                        for (int x2 = 2; x2 >= 0; --x2) {
                            if (!((Ingredient)this.ingredients.get(i)).test(container.getItem(x2 + z2 * 3 + y * 9))) {
                                matches = false;
                            }
                            ++i;
                        }
                    }
                }
            }
            if (!matches) {
                i = 0;
                matches = true;
                for (y = 0; y < 3; ++y) {
                    for (x = 2; x >= 0; --x) {
                        for (z = 2; z >= 0; --z) {
                            if (!((Ingredient)this.ingredients.get(i)).test(container.getItem(x + z * 3 + y * 9))) {
                                matches = false;
                            }
                            ++i;
                        }
                    }
                }
            }
            return matches;
        }

        private void toNetwork(RegistryFriendlyByteBuf p_320098_) {
            for (Ingredient ingredient : this.ingredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)p_320098_, (Object)ingredient);
            }
        }

        public static PatternHolder of(Map<Character, Ingredient> keys, List<String> bottom, List<String> middle, List<String> top) {
            Pattern data = new Pattern(keys, new Data(bottom, middle, top));
            return (PatternHolder)PatternHolder.unpack(data).getOrThrow();
        }

        private static DataResult<PatternHolder> unpack(Pattern pattern) {
            Ingredient ingredient;
            char c0;
            int l;
            String s;
            int k;
            NonNullList ingredients = NonNullList.withSize((int)27, (Object)Ingredient.EMPTY);
            CharArraySet charSet = new CharArraySet(pattern.keys.keySet());
            int i = 0;
            for (k = 0; k < pattern.data.bottom.size(); ++k) {
                s = pattern.data.bottom.get(k);
                for (l = 0; l < s.length(); ++l) {
                    c0 = s.charAt(l);
                    Ingredient ingredient2 = ingredient = c0 == ' ' ? Ingredient.EMPTY : pattern.keys.get(Character.valueOf(c0));
                    if (ingredient == null) {
                        return DataResult.error(() -> "Pattern references symbol '" + c0 + "' but it's not defined in the key");
                    }
                    charSet.remove(c0);
                    ingredients.set(i, (Object)ingredient);
                    ++i;
                }
            }
            for (k = 0; k < pattern.data.middle.size(); ++k) {
                s = pattern.data.middle.get(k);
                for (l = 0; l < s.length(); ++l) {
                    c0 = s.charAt(l);
                    Ingredient ingredient3 = ingredient = c0 == ' ' ? Ingredient.EMPTY : pattern.keys.get(Character.valueOf(c0));
                    if (ingredient == null) {
                        return DataResult.error(() -> "Pattern references symbol '" + c0 + "' but it's not defined in the key");
                    }
                    charSet.remove(c0);
                    ingredients.set(i, (Object)ingredient);
                    ++i;
                }
            }
            for (k = 0; k < pattern.data.top.size(); ++k) {
                s = pattern.data.top.get(k);
                for (l = 0; l < s.length(); ++l) {
                    c0 = s.charAt(l);
                    Ingredient ingredient4 = ingredient = c0 == ' ' ? Ingredient.EMPTY : pattern.keys.get(Character.valueOf(c0));
                    if (ingredient == null) {
                        return DataResult.error(() -> "Pattern references symbol '" + c0 + "' but it's not defined in the key");
                    }
                    charSet.remove(c0);
                    ingredients.set(i, (Object)ingredient);
                    ++i;
                }
            }
            return !charSet.isEmpty() ? DataResult.error(() -> PatternHolder.lambda$unpack$6((CharSet)charSet)) : DataResult.success((Object)new PatternHolder((NonNullList<Ingredient>)ingredients, Optional.of(pattern)));
        }

        private static PatternHolder fromNetwork(RegistryFriendlyByteBuf p_319788_) {
            NonNullList nonnulllist = NonNullList.withSize((int)27, (Object)Ingredient.EMPTY);
            nonnulllist.replaceAll(p_319733_ -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)p_319788_));
            return new PatternHolder((NonNullList<Ingredient>)nonnulllist, Optional.empty());
        }

        private static /* synthetic */ String lambda$unpack$6(CharSet charSet) {
            return "Key defines symbols that aren't used in pattern: " + String.valueOf(charSet);
        }
    }

    private record Pattern(Map<Character, Ingredient> keys, Data data) {
        private static final Codec<Character> SYMBOL_CODEC = Codec.STRING.comapFlatMap(key -> {
            if (key.length() != 1) {
                return DataResult.error(() -> "Invalid key entry: '" + key + "' is an invalid symbol (must be 1 character only).");
            }
            return " ".equals(key) ? DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.") : DataResult.success((Object)Character.valueOf(key.charAt(0)));
        }, String::valueOf);
        public static final MapCodec<Pattern> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.strictUnboundedMap(SYMBOL_CODEC, (Codec)Ingredient.CODEC_NONEMPTY).fieldOf("key").forGetter(pattern -> pattern.keys), (App)Data.MAP_CODEC.fieldOf("pattern").forGetter(pattern -> pattern.data)).apply((Applicative)instance, Pattern::new));
    }

    private record Data(List<String> bottom, List<String> middle, List<String> top) {
        private static final Codec<List<String>> PATTERN_CODEC = Codec.STRING.listOf().comapFlatMap(pattern -> {
            if (pattern.size() != 3) {
                return DataResult.error(() -> "Invalid pattern: %s is expected".formatted(pattern.size()));
            }
            int i = ((String)pattern.getFirst()).length();
            for (String s : pattern) {
                if (s.length() > 3) {
                    return DataResult.error(() -> "Invalid pattern: too many columns, %s is expected".formatted(s.length()));
                }
                if (i == s.length()) continue;
                return DataResult.error(() -> "Invalid pattern: each row must be the same width");
            }
            return DataResult.success((Object)pattern);
        }, Function.identity());
        public static final MapCodec<Data> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PATTERN_CODEC.fieldOf("bottom").forGetter(data -> data.bottom), (App)PATTERN_CODEC.fieldOf("middle").forGetter(data -> data.middle), (App)PATTERN_CODEC.fieldOf("top").forGetter(data -> data.top)).apply((Applicative)instance, Data::new));
    }

    public static class Builder
    implements RecipeBuilder {
        private final Item result;
        private final Ingredient tool;
        private final List<String> bottomRows = Lists.newArrayList();
        private final List<String> middleRows = Lists.newArrayList();
        private final List<String> topRows = Lists.newArrayList();
        private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
        private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

        protected Builder(Ingredient tool, ItemLike pResult) {
            this.tool = tool;
            this.result = pResult.asItem();
        }

        public static Builder recipe(TagKey<Item> tool, ItemLike pResult) {
            return new Builder(Ingredient.of(tool), pResult);
        }

        public Builder define(Character pSymbol, TagKey<Item> pTag) {
            return this.define(pSymbol, Ingredient.of(pTag));
        }

        public Builder define(Character pSymbol, ItemLike pItem) {
            return this.define(pSymbol, Ingredient.of((ItemLike[])new ItemLike[]{pItem}));
        }

        public Builder define(Character pSymbol, Ingredient pIngredient) {
            if (this.key.containsKey(pSymbol)) {
                throw new IllegalArgumentException("Symbol '" + pSymbol + "' is already defined!");
            }
            if (pSymbol.charValue() == ' ') {
                throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
            }
            this.key.put(pSymbol, pIngredient);
            return this;
        }

        public Builder bottomPattern(String pPattern) {
            return this.pattern(pPattern, this.bottomRows);
        }

        public Builder middlePattern(String pPattern) {
            return this.pattern(pPattern, this.middleRows);
        }

        public Builder topPattern(String pPattern) {
            return this.pattern(pPattern, this.topRows);
        }

        @NotNull
        public RecipeBuilder unlockedBy(@NotNull String criterionName, @NotNull Criterion criterionTrigger) {
            this.criteria.put(criterionName, criterionTrigger);
            return this;
        }

        @NotNull
        public Builder group(@Nullable String pGroupName) {
            return this;
        }

        @NotNull
        public Item getResult() {
            return this.result;
        }

        public void save(@NotNull RecipeOutput finishedRecipeConsumer, @NotNull ResourceLocation recipeId) {
            this.ensureValid(recipeId);
            Advancement.Builder builder = finishedRecipeConsumer.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)recipeId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId)).requirements(AdvancementRequirements.Strategy.OR);
            this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
            finishedRecipeConsumer.accept(recipeId, (Recipe)new WorkspaceCraftingRecipe(PatternHolder.of(this.key, this.bottomRows, this.middleRows, this.topRows), this.tool, new ItemStack((ItemLike)this.result)), builder.build(recipeId.withPrefix("recipes/workspace_crafting/")));
        }

        private Builder pattern(String pPattern, List<String> list) {
            if (pPattern.length() != 3) {
                throw new IllegalArgumentException("Pattern must have exactly 3 characters!");
            }
            if (list.size() == 3) {
                throw new IllegalArgumentException("Pattern must have exactly 3 rows!");
            }
            list.add(pPattern);
            return this;
        }

        private void ensureValid(ResourceLocation pId) {
            if (this.bottomRows.isEmpty()) {
                throw new IllegalStateException("No pattern is defined for bottom layer for recipe " + String.valueOf(pId) + "!");
            }
            if (this.middleRows.isEmpty()) {
                throw new IllegalStateException("No pattern is defined for middle layer for recipe " + String.valueOf(pId) + "!");
            }
            if (this.topRows.isEmpty()) {
                throw new IllegalStateException("No pattern is defined for bottom layer for recipe " + String.valueOf(pId) + "!");
            }
            HashSet set = Sets.newHashSet(this.key.keySet());
            set.remove(Character.valueOf(' '));
            this.processList(pId, this.bottomRows, set);
            this.processList(pId, this.middleRows, set);
            this.processList(pId, this.topRows, set);
            if (!set.isEmpty()) {
                throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + String.valueOf(pId));
            }
            if (this.bottomRows.size() != 3 || this.middleRows.size() != 3 || this.topRows.size() != 3) {
                throw new IllegalStateException("Recipe " + String.valueOf(pId) + " has invalid count of rows");
            }
            if (this.criteria.isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(pId));
            }
        }

        private void processList(ResourceLocation pId, List<String> rows, Set<Character> set) {
            for (String s : rows) {
                for (int i = 0; i < s.length(); ++i) {
                    char c0 = s.charAt(i);
                    if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                        throw new IllegalStateException("Pattern in recipe " + String.valueOf(pId) + " uses undefined symbol '" + c0 + "'");
                    }
                    set.remove(Character.valueOf(c0));
                }
            }
        }
    }

    public static class Serializer
    implements RecipeSerializer<WorkspaceCraftingRecipe> {
        private static final MapCodec<WorkspaceCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PatternHolder.CODEC.forGetter(recipe -> recipe.patternHolder), (App)Ingredient.CODEC.fieldOf("tool").forGetter(recipe -> recipe.tool), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)instance, WorkspaceCraftingRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, WorkspaceCraftingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<WorkspaceCraftingRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, WorkspaceCraftingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        @NotNull
        private static WorkspaceCraftingRecipe fromNetwork(@NotNull RegistryFriendlyByteBuf buffer) {
            PatternHolder pattern = (PatternHolder)PatternHolder.STREAM_CODEC.decode((Object)buffer);
            Ingredient tool = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new WorkspaceCraftingRecipe(pattern, tool, result);
        }

        private static void toNetwork(@NotNull RegistryFriendlyByteBuf buffer, @NotNull WorkspaceCraftingRecipe recipe) {
            PatternHolder.STREAM_CODEC.encode((Object)buffer, (Object)recipe.patternHolder);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.tool);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
        }
    }
}

