/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.generation;

import com.yanny.ytech.configuration.MaterialType;
import com.yanny.ytech.configuration.NameHolder;
import com.yanny.ytech.configuration.PartType;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.YtechAdvancementType;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechEntityTypes;
import com.yanny.ytech.registration.YTechItemTags;
import com.yanny.ytech.registration.YTechItems;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import org.apache.commons.lang3.function.TriFunction;

class YTechLanguageProvider
extends LanguageProvider {
    public YTechLanguageProvider(PackOutput output, String locale) {
        super(output, "ytech", locale);
    }

    protected void addTranslations() {
        this.addItem((Supplier)YTechItems.ANTLER, "Antler");
        this.addItem((Supplier)YTechItems.BASKET, "Basket");
        this.addItem((Supplier)YTechItems.BEESWAX, "Beeswax");
        this.addItem((Supplier)YTechItems.BONE_NEEDLE, "Bone Needle");
        this.addItem((Supplier)YTechItems.BREAD_DOUGH, "Bread Dough");
        this.addItem((Supplier)YTechItems.BRICK_MOLD, "Brick Mold");
        this.addItem((Supplier)YTechItems.CLAY_BUCKET, "Clay Bucket");
        this.addItem((Supplier)YTechItems.COOKED_VENISON, "Cooked Venison");
        this.addItem((Supplier)YTechItems.DIVINING_ROD, "Divining Rod");
        this.addItem((Supplier)YTechItems.DRIED_BEEF, "Dried Beef");
        this.addItem((Supplier)YTechItems.DRIED_CHICKEN, "Dried Chicken");
        this.addItem((Supplier)YTechItems.DRIED_COD, "Dried Cod");
        this.addItem((Supplier)YTechItems.DRIED_MUTTON, "Dried Mutton");
        this.addItem((Supplier)YTechItems.DRIED_PORKCHOP, "Dried Porkchop");
        this.addItem((Supplier)YTechItems.DRIED_RABBIT, "Dried Rabbit");
        this.addItem((Supplier)YTechItems.DRIED_SALMON, "Dried Salmon");
        this.addItem((Supplier)YTechItems.DRIED_VENISON, "Dried Venison");
        this.addItem((Supplier)YTechItems.FLOUR, "Flour");
        this.addItem((Supplier)YTechItems.GRASS_FIBERS, "Grass Fibers");
        this.addItem((Supplier)YTechItems.GRASS_TWINE, "Grass Twine");
        this.addItem((Supplier)YTechItems.IRON_BLOOM, "Iron Bloom");
        this.addItem((Supplier)YTechItems.LAVA_CLAY_BUCKET, "Lava Clay Bucket");
        this.addItem((Supplier)YTechItems.LEATHER_STRIPS, "Leather Strips");
        this.addItem((Supplier)YTechItems.MAMMOTH_TUSK, "Mammoth Tusk");
        this.addItem((Supplier)YTechItems.PEBBLE, "Pebble");
        this.addItem((Supplier)YTechItems.RAW_HIDE, "Raw Hide");
        this.addItem((Supplier)YTechItems.RHINO_HORN, "Rhino Horn");
        this.addItem((Supplier)YTechItems.SHARP_FLINT, "Sharp Flint");
        this.addItem((Supplier)YTechItems.UNFIRED_AMPHORA, "Unfired Amphora");
        this.addItem((Supplier)YTechItems.UNFIRED_BRICK, "Unfired Brick");
        this.addItem((Supplier)YTechItems.UNFIRED_CLAY_BUCKET, "Unfired Clay Bucket");
        this.addItem((Supplier)YTechItems.UNFIRED_DECORATED_POT, "Unfired Decorated Pot");
        this.addItem((Supplier)YTechItems.UNFIRED_FLOWER_POT, "Unfired Flower Pot");
        this.addItem((Supplier)YTechItems.UNLIT_TORCH, "Unlit Torch");
        this.addItem((Supplier)YTechItems.VENISON, "Venison");
        this.addItem((Supplier)YTechItems.WATER_CLAY_BUCKET, "Water Clay Bucket");
        this.addItem((Supplier)YTechItems.CHLORITE_BRACELET, "Chlorite Bracelet");
        this.addItem((Supplier)YTechItems.LION_MAN, "Lion-Man");
        this.addItem((Supplier)YTechItems.SHELL_BEADS, "Shell Beads");
        this.addItem((Supplier)YTechItems.VENUS_OF_HOHLE_FELS, "Venus of Hohle Fels");
        this.addItem((Supplier)YTechItems.WILD_HORSE, "Wild Horse");
        this.addItem((Supplier)YTechItems.AUROCHS_SPAWN_EGG, "Aurochs Spawn Egg");
        this.addItem((Supplier)YTechItems.DEER_SPAWN_EGG, "Deer Spawn Egg");
        this.addItem((Supplier)YTechItems.FOWL_SPAWN_EGG, "Fowl Spawn Egg");
        this.addItem((Supplier)YTechItems.MOUFLON_SPAWN_EGG, "Mouflon Spawn Egg");
        this.addItem((Supplier)YTechItems.SABER_TOOTH_TIGER_SPAWN_EGG, "Saber-Toothed Tiger Spawn Egg");
        this.addItem((Supplier)YTechItems.TERROR_BIRD_SPAWN_EGG, "Terror Bird Spawn Egg");
        this.addItem((Supplier)YTechItems.WILD_BOAR_SPAWN_EGG, "Wild Boar Spawn Egg");
        this.addItem((Supplier)YTechItems.WOOLLY_MAMMOTH_SPAWN_EGG, "Woolly Mammoth Spawn Egg");
        this.addItem((Supplier)YTechItems.WOOLLY_RHINO_SPAWN_EGG, "Woolly Rhino Spawn Egg");
        this.addBlock((Supplier)YTechBlocks.AMPHORA, "Amphora");
        this.addBlock((Supplier)YTechBlocks.AQUEDUCT_FERTILIZER, "Aqueduct Fertilizer");
        this.addBlock((Supplier)YTechBlocks.AQUEDUCT_HYDRATOR, "Aqueduct Hydrator");
        this.addBlock((Supplier)YTechBlocks.AQUEDUCT_VALVE, "Aqueduct Valve");
        this.addBlock((Supplier)YTechBlocks.BRICK_CHIMNEY, "Brick Chimney");
        this.addBlock((Supplier)YTechBlocks.BRONZE_ANVIL, "Bronze Anvil");
        this.addBlock((Supplier)YTechBlocks.CRAFTING_WORKSPACE, "Crafting Workspace");
        this.addBlock((Supplier)YTechBlocks.FIRE_PIT, "Fire Pit");
        this.addBlock((Supplier)YTechBlocks.GRASS_BED, "Grass Bed");
        this.addBlock((Supplier)YTechBlocks.MILLSTONE, "Millstone");
        this.addBlock((Supplier)YTechBlocks.POTTERS_WHEEL, "Potter's Wheel");
        this.addBlock((Supplier)YTechBlocks.PRIMITIVE_ALLOY_SMELTER, "Primitive Alloy Smelter");
        this.addBlock((Supplier)YTechBlocks.PRIMITIVE_SMELTER, "Primitive Smelter");
        this.addBlock((Supplier)YTechBlocks.REINFORCED_BRICKS, "Reinforced Bricks");
        this.addBlock((Supplier)YTechBlocks.REINFORCED_BRICK_CHIMNEY, "Reinforced Brick Chimney");
        this.addBlock((Supplier)YTechBlocks.STRAINER, "Strainer");
        this.addBlock((Supplier)YTechBlocks.TERRACOTTA_BRICKS, "Terracotta Bricks");
        this.addBlock((Supplier)YTechBlocks.TERRACOTTA_BRICK_SLAB, "Terracotta Brick Slab");
        this.addBlock((Supplier)YTechBlocks.TERRACOTTA_BRICK_STAIRS, "Terracotta Brick Stairs");
        this.addBlock((Supplier)YTechBlocks.THATCH, "Thatch");
        this.addBlock((Supplier)YTechBlocks.THATCH_SLAB, "Thatch Slab");
        this.addBlock((Supplier)YTechBlocks.THATCH_STAIRS, "Thatch Stairs");
        this.addBlock((Supplier)YTechBlocks.TOOL_RACK, "Tool Rack");
        this.addBlock((Supplier)YTechBlocks.TREE_STUMP, "Tree Stump");
        this.addBlock((Supplier)YTechBlocks.WELL_PULLEY, "Well Pulley");
        this.addBlock((Supplier)YTechBlocks.WOODEN_BOX, "Wooden Box");
        this.addTypedItem(YTechItems.CLAY_MOLDS, NameHolder.suffix("Clay Mold"), YTechLanguageProvider::getName);
        this.addTypedItem(YTechItems.PATTERNS, NameHolder.suffix("Pattern"), YTechLanguageProvider::getName);
        this.addTypedItem(YTechItems.SAND_MOLDS, NameHolder.suffix("Sand Mold"), YTechLanguageProvider::getName);
        this.addTypedItem(YTechItems.UNFIRED_MOLDS, NameHolder.both("Unfired", "Mold"), YTechLanguageProvider::getName);
        this.addMultiTypedItem(YTechItems.PARTS, NameHolder.suffix("Part"), YTechLanguageProvider::getName);
        this.addTypedItem(YTechItems.ARROWS, NameHolder.suffix("Arrow"), YTechLanguageProvider::getMaterialName);
        this.addTypedItem(YTechItems.AXES, NameHolder.suffix("Axe"), YTechLanguageProvider::getMaterialName, YTechLanguageProvider::goldIronWoodLeatherFilter);
        this.addTypedItem(YTechItems.BOLTS, NameHolder.suffix("Bolt"), YTechLanguageProvider::getMaterialName);
        this.addTypedItem(YTechItems.BOOTS, NameHolder.suffix("Boots"), YTechLanguageProvider::getMaterialName, YTechLanguageProvider::goldIronWoodLeatherFilter);
        this.addTypedItem(YTechItems.CHESTPLATES, NameHolder.suffix("Chestplate"), YTechLanguageProvider::getMaterialName, YTechLanguageProvider::goldIronWoodLeatherFilter);
        this.addTypedItem(YTechItems.CRUSHED_MATERIALS, NameHolder.prefix("Crushed"), YTechLanguageProvider::getMaterialName);
        this.addTypedItem(YTechItems.FILES, NameHolder.suffix("File"), YTechLanguageProvider::getMaterialName);
        this.addTypedItem(YTechItems.HAMMERS, NameHolder.suffix("Hammer"), YTechLanguageProvider::getMaterialName);
        this.addTypedItem(YTechItems.HELMETS, NameHolder.suffix("Helmet"), YTechLanguageProvider::getMaterialName, YTechLanguageProvider::goldIronWoodLeatherFilter);
        this.addTypedItem(YTechItems.HOES, NameHolder.suffix("Hoe"), YTechLanguageProvider::getMaterialName, YTechLanguageProvider::goldIronWoodLeatherFilter);
        this.addTypedItem(YTechItems.INGOTS, NameHolder.suffix("Ingot"), YTechLanguageProvider::getMaterialName, YTechLanguageProvider::vanillaMaterialsFilter);
        this.addTypedItem(YTechItems.KNIVES, NameHolder.suffix("Knife"), YTechLanguageProvider::getMaterialName);
        this.addTypedItem(YTechItems.LEGGINGS, NameHolder.suffix("Leggings"), YTechLanguageProvider::getMaterialName, YTechLanguageProvider::goldIronWoodLeatherFilter);
        this.addTypedItem(YTechItems.MESHES, NameHolder.suffix("Mesh"), YTechLanguageProvider::getMaterialName);
        this.addTypedItem(YTechItems.MORTAR_AND_PESTLES, NameHolder.suffix("Mortar and Pestle"), YTechLanguageProvider::getMaterialName);
        this.addTypedItem(YTechItems.PICKAXES, NameHolder.suffix("Pickaxe"), YTechLanguageProvider::getMaterialName, YTechLanguageProvider::goldIronWoodLeatherFilter);
        this.addTypedItem(YTechItems.PLATES, NameHolder.suffix("Plate"), YTechLanguageProvider::getMaterialName);
        this.addTypedItem(YTechItems.RAW_MATERIALS, NameHolder.prefix("Raw"), YTechLanguageProvider::getMaterialName, YTechLanguageProvider::vanillaMaterialsFilter);
        this.addTypedItem(YTechItems.RODS, NameHolder.suffix("Rod"), YTechLanguageProvider::getMaterialName);
        this.addTypedItem(YTechItems.SAWS, NameHolder.suffix("Saw"), YTechLanguageProvider::getMaterialName);
        this.addTypedItem(YTechItems.SAW_BLADES, NameHolder.suffix("Saw Blade"), YTechLanguageProvider::getMaterialName);
        this.addTypedItem(YTechItems.SHEARS, NameHolder.suffix("Shears"), YTechLanguageProvider::getMaterialName, YTechLanguageProvider::ironFilter);
        this.addTypedItem(YTechItems.SHOVELS, NameHolder.suffix("Shovel"), YTechLanguageProvider::getMaterialName, YTechLanguageProvider::goldIronWoodLeatherFilter);
        this.addTypedItem(YTechItems.SPEARS, NameHolder.suffix("Spear"), YTechLanguageProvider::getMaterialName);
        this.addTypedItem(YTechItems.SWORDS, NameHolder.suffix("Sword"), YTechLanguageProvider::getMaterialName, YTechLanguageProvider::goldIronWoodLeatherFilter);
        this.addMaterialBlock(YTechBlocks.AQUEDUCTS, NameHolder.suffix("Aqueduct"));
        this.addMaterialBlock(YTechBlocks.DEEPSLATE_ORES, NameHolder.both("Deepslate", "Ore"), YTechLanguageProvider::vanillaMaterialsFilter);
        this.addMaterialBlock(YTechBlocks.DRYING_RACKS, NameHolder.suffix("Drying Rack"));
        this.addMaterialBlock(YTechBlocks.GRAVEL_DEPOSITS, NameHolder.suffix("Gravel Deposit"));
        this.addMaterialBlock(YTechBlocks.NETHER_ORES, NameHolder.both("Nether", "Ore"), type -> type.getKey() != MaterialType.GOLD);
        this.addStorageBlockLanguage(YTechBlocks.RAW_STORAGE_BLOCKS, "Block of Raw");
        this.addMaterialBlock(YTechBlocks.SAND_DEPOSITS, NameHolder.suffix("Sand Deposit"));
        this.addMaterialBlock(YTechBlocks.STONE_ORES, NameHolder.suffix("Ore"), YTechLanguageProvider::vanillaMaterialsFilter);
        this.addStorageBlockLanguage(YTechBlocks.STORAGE_BLOCKS, "Block of");
        this.addMaterialBlock(YTechBlocks.TANNING_RACKS, NameHolder.suffix("Tanning Rack"));
        this.addEntityType((Supplier)YTechEntityTypes.AUROCHS, "Aurochs");
        this.addEntityType((Supplier)YTechEntityTypes.DEER, "Deer");
        this.addEntityType((Supplier)YTechEntityTypes.FOWL, "Fowl");
        this.addEntityType((Supplier)YTechEntityTypes.MOUFLON, "Mouflon");
        this.addEntityType((Supplier)YTechEntityTypes.SABER_TOOTH_TIGER, "Saber-Toothed Tiger");
        this.addEntityType((Supplier)YTechEntityTypes.TERROR_BIRD, "Terror Bird");
        this.addEntityType((Supplier)YTechEntityTypes.WILD_BOAR, "Wild Boar");
        this.addEntityType((Supplier)YTechEntityTypes.WOOLLY_MAMMOTH, "Woolly Mammoth");
        this.addEntityType((Supplier)YTechEntityTypes.WOOLLY_RHINO, "Woolly Rhino");
        this.addTag(YTechItemTags.ANTLERS, "Antlers");
        this.addTag(YTechItemTags.BASKETS, "Baskets");
        this.addTag(YTechItemTags.BEESWAXES, "Bees Waxes");
        this.addTag(YTechItemTags.BONE_NEEDLES, "Bone Needles");
        this.addTag(YTechItemTags.BREAD_DOUGHS, "Bread Doughs");
        this.addTag(YTechItemTags.BRICK_MOLDS, "Brick Molds");
        this.addTag(YTechItemTags.CLAY_BUCKETS, "Clay Buckets");
        this.addTag(YTechItemTags.COOKED_VENISON, "Cooked Venison");
        this.addTag(YTechItemTags.DIVINING_RODS, "Divining Rods");
        this.addTag(YTechItemTags.DRIED_BEEFS, "Dried Beefs");
        this.addTag(YTechItemTags.DRIED_CHICKENS, "Dried Chicken");
        this.addTag(YTechItemTags.DRIED_CODS, "Dried Cods");
        this.addTag(YTechItemTags.DRIED_MUTTONS, "Dried Mutton");
        this.addTag(YTechItemTags.DRIED_PORKCHOP, "Dried Porkchop");
        this.addTag(YTechItemTags.DRIED_RABBITS, "Dried Rabbit");
        this.addTag(YTechItemTags.DRIED_SALMONS, "Dried Salmon");
        this.addTag(YTechItemTags.DRIED_VENISON, "Dried Venison");
        this.addTag(YTechItemTags.FLOURS, "Flours");
        this.addTag(YTechItemTags.GRASS_FIBERS, "Grass Fibers");
        this.addTag(YTechItemTags.GRASS_TWINES, "Grass Twines");
        this.addTag(YTechItemTags.IRON_BLOOMS, "Iron Blooms");
        this.addTag(YTechItemTags.LAVA_BUCKETS, "Lava Buckets");
        this.addTag(YTechItemTags.LEATHER_STRIPS, "Leather Strips");
        this.addTag(YTechItemTags.MAMMOTH_TUSKS, "Mammoth Tusks");
        this.addTag(YTechItemTags.PEBBLES, "Pebbles");
        this.addTag(YTechItemTags.RAW_HIDES, "Raw Hides");
        this.addTag(YTechItemTags.RHINO_HORNS, "Rhino Horns");
        this.addTag(YTechItemTags.SHARP_FLINTS, "Sharp Flints");
        this.addTag(YTechItemTags.UNFIRED_AMPHORAE, "Unfired Amphorae");
        this.addTag(YTechItemTags.UNFIRED_BRICKS, "Unfired Bricks");
        this.addTag(YTechItemTags.UNFIRED_CLAY_BUCKETS, "Unfired Clay Buckets");
        this.addTag(YTechItemTags.UNFIRED_DECORATED_POTS, "Unfired Decorated Pots");
        this.addTag(YTechItemTags.UNFIRED_FLOWER_POTS, "Unfired Flower Pots");
        this.addTag(YTechItemTags.UNLIT_TORCH, "Unlit Torch");
        this.addTag(YTechItemTags.VENISON, "Venison");
        this.addTag(YTechItemTags.WATER_BUCKETS, "Water Buckets");
        this.addTag(YTechItemTags.FERTILIZER, "Fertilizers");
        this.addTag(YTechItemTags.FIRE_SOURCE, "Fire Sources");
        this.addTag(YTechItemTags.SOUL_FIRE_SOURCE, "Soul Fire Sources");
        this.addTag(YTechItemTags.AUROCHS_FOOD, "Aurochs Foods");
        this.addTag(YTechItemTags.AUROCHS_TEMP_ITEMS, "Aurochs Temptation Items");
        this.addTag(YTechItemTags.DEER_TEMP_ITEMS, "Deer Temptation Items");
        this.addTag(YTechItemTags.FOWL_FOOD, "Fowl Foods");
        this.addTag(YTechItemTags.FOWL_TEMP_ITEMS, "Fowl Temptation Items");
        this.addTag(YTechItemTags.MOUFLON_FOOD, "Mouflon Foods");
        this.addTag(YTechItemTags.MOUFLON_TEMP_ITEMS, "Mouflon Temptation Items");
        this.addTag(YTechItemTags.SABER_TOOTH_TIGER_TEMP_ITEMS, "Saber-Toothed Tiger Temptation Items");
        this.addTag(YTechItemTags.TERROR_BIRD_TEMP_ITEMS, "Terror Bird Temptation Items");
        this.addTag(YTechItemTags.WILD_BOAR_FOOD, "Wild Boar Foods");
        this.addTag(YTechItemTags.WILD_BOAR_TEMP_ITEMS, "Wild Boar Temptation Items");
        this.addTag(YTechItemTags.WOOLLY_MAMMOTH_TEMP_ITEMS, "Woolly Mammoth Temptation Items");
        this.addTag(YTechItemTags.WOOLLY_RHINO_TEMP_ITEMS, "Woolly Rhino Temptation Items");
        this.addTag(YTechItemTags.AMPHORAE, "Amphorae");
        this.addTag(YTechItemTags.AQUEDUCT_FERTILIZERS, "Aqueduct Fertilizers");
        this.addTag(YTechItemTags.AQUEDUCT_HYDRATORS, "Aqueduct Hydrators");
        this.addTag(YTechItemTags.AQUEDUCT_VALVES, "Aqueduct Valves");
        this.addTag(YTechItemTags.BRICK_CHIMNEYS, "Brick Chimneys");
        this.addTag(YTechItemTags.BRONZE_ANVILS, "Bronze Anvils");
        this.addTag(YTechItemTags.CRAFTING_WORKSPACES, "Crafting Workspaces");
        this.addTag(YTechItemTags.FIRE_PITS, "Fire Pits");
        this.addTag(YTechItemTags.GRASS_BEDS, "Grass Beds");
        this.addTag(YTechItemTags.MILLSTONES, "Millstones");
        this.addTag(YTechItemTags.POTTERS_WHEELS, "Potters Wheels");
        this.addTag(YTechItemTags.PRIMITIVE_ALLOY_SMELTERS, "Primitive Alloy Smelters");
        this.addTag(YTechItemTags.PRIMITIVE_SMELTERS, "Primitive Smelters");
        this.addTag(YTechItemTags.REINFORCED_BRICKS, "Reinforced Bricks");
        this.addTag(YTechItemTags.REINFORCED_BRICK_CHIMNEYS, "Reinforced Brick Chimneys");
        this.addTag(YTechItemTags.STRAINERS, "Strainers");
        this.addTag(YTechItemTags.TERRACOTTA_BRICKS, "Terracotta Bricks");
        this.addTag(YTechItemTags.TERRACOTTA_BRICK_SLABS, "Terracotta Brick Slabs");
        this.addTag(YTechItemTags.TERRACOTTA_BRICK_STAIRS, "Terracotta Brick Stairs");
        this.addTag(YTechItemTags.THATCH, "Thatch");
        this.addTag(YTechItemTags.THATCH_SLABS, "Thatch Slabs");
        this.addTag(YTechItemTags.THATCH_STAIRS, "Thatch Stairs");
        this.addTag(YTechItemTags.TOOL_RACKS, "Tool Racks");
        this.addTag(YTechItemTags.TREE_STUMPS, "Tree Stumps");
        this.addTag(YTechItemTags.WELL_PULLEYS, "Well Pulleys");
        this.addTag(YTechItemTags.WOODEN_BOXES, "Wooden Boxes");
        this.addTag(YTechItemTags.CHLORITE_BRACELETS, "Chlorite Bracelets");
        this.addTag(YTechItemTags.LION_MANS, "Lion Mans");
        this.addTag(YTechItemTags.SHELL_BEADS, "Shell Beads");
        this.addTag(YTechItemTags.VENUS_OF_HOHLE_FELS, "Venus of Hohle Fels");
        this.addTag(YTechItemTags.WILD_HORSES, "Wild Horses");
        this.addTag(YTechItemTags.CLAY_MOLDS, NameHolder.suffix("Clay Molds"), YTechLanguageProvider::getName);
        this.addTag(YTechItemTags.PATTERNS, NameHolder.suffix("Patterns"), YTechLanguageProvider::getName);
        this.addTag(YTechItemTags.SAND_MOLDS, NameHolder.suffix("Sand Molds"), YTechLanguageProvider::getName);
        this.addTag(YTechItemTags.UNFIRED_MOLDS, NameHolder.suffix("Unfired Molds"), YTechLanguageProvider::getName);
        this.addTag(YTechItemTags.MOLDS, NameHolder.suffix("Molds"), YTechLanguageProvider::getName);
        this.addTag(YTechItemTags.ARROWS, NameHolder.suffix("Arrows"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.AXES, NameHolder.suffix("Axes"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.BOLTS, NameHolder.suffix("Bolts"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.BOOTS, NameHolder.suffix("Boots"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.CHESTPLATES, NameHolder.suffix("Chestplates"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.CRUSHED_MATERIALS, NameHolder.suffix("Crushed Materials"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.FILES, NameHolder.suffix("Files"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.HAMMERS, NameHolder.suffix("Hammers"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.HELMETS, NameHolder.suffix("Helmets"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.HOES, NameHolder.suffix("Hoes"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.INGOTS, NameHolder.suffix("Ingots"), YTechLanguageProvider::getMaterialName, MaterialType.VANILLA_METALS);
        this.addTag(YTechItemTags.KNIVES, NameHolder.suffix("Knives"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.MESHES, NameHolder.suffix("Meshes"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.MORTAR_AND_PESTLES, NameHolder.suffix("Mortar and Pestles"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.LEGGINGS, NameHolder.suffix("Leggings"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.PICKAXES, NameHolder.suffix("Pickaxes"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.PLATES, NameHolder.suffix("Plates"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.RAW_MATERIALS, NameHolder.suffix("Raw Materials"), YTechLanguageProvider::getMaterialName, MaterialType.VANILLA_METALS);
        this.addTag(YTechItemTags.RODS, NameHolder.suffix("Rods"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.SAWS, NameHolder.suffix("Saws"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.SHEARS, NameHolder.suffix("Shears"), YTechLanguageProvider::getMaterialName, EnumSet.of(MaterialType.IRON));
        this.addTag(YTechItemTags.SAW_BLADES, NameHolder.suffix("Saw Blades"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.SHOVELS, NameHolder.suffix("Shovels"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.SPEARS, NameHolder.suffix("Spears"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.SWORDS, NameHolder.suffix("Swords"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.AQUEDUCTS, NameHolder.suffix("Aqueducts"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.DRYING_RACKS, NameHolder.suffix("Drying Racks"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.GRAVEL_DEPOSITS, NameHolder.suffix("Gravel Deposits"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.SAND_DEPOSITS, NameHolder.suffix("Sand Deposits"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.TANNING_RACKS, NameHolder.suffix("Tanning Racks"), YTechLanguageProvider::getMaterialName);
        this.addTag(YTechItemTags.PARTS, NameHolder.suffix("Parts"), YTechLanguageProvider::getName, YTechLanguageProvider::getName);
        for (YtechAdvancementType type2 : YtechAdvancementType.values()) {
            this.add(type2.titleId(), type2.title());
            this.add(type2.descriptionId(), type2.description());
        }
        this.addJadeTranslation(YTechBlocks.BRONZE_ANVIL, "Bronze Anvil");
        this.addJadeTranslation(Utils.modLoc("drying_racks"), "Drying Racks");
        this.addJadeTranslation(YTechBlocks.MILLSTONE, "Millstone");
        this.addJadeTranslation(Utils.modLoc("tanning_racks"), "Tanning Racks");
        this.addJadeTranslation(Utils.modLoc("primitive_machines"), "Primitive Machines");
        this.addJadeTranslation(Utils.modLoc("irrigation"), "Irrigation");
        this.addJadeTranslation(YTechBlocks.POTTERS_WHEEL, "Potter's Wheel");
        this.addJadeTranslation(YTechBlocks.FIRE_PIT, "Fire Pit");
        this.addJadeTranslation(YTechBlocks.TREE_STUMP, "Tree Stump");
        this.addJadeTranslation(YTechBlocks.AMPHORA, "Amphora");
        this.addJadeTranslation(YTechBlocks.WOODEN_BOX, "Wooden Box");
        this.addJadeTranslation(YTechBlocks.TOOL_RACK, "Tool Rack");
        this.add("effect.ytech.abyss_walker", "Abyss Walker");
        this.add("effect.ytech.lions_heart", "Lion's Heart");
        this.add("effect.ytech.lucky_stone", "Lucky Stone");
        this.add("effect.ytech.venus_touch", "Venus' Touch");
        this.add("effect.ytech.wild_ride", "Wild Ride");
        this.add("emi.category.ytech.drying", "Drying");
        this.add("emi.category.ytech.tanning", "Tanning");
        this.add("emi.category.ytech.milling", "Milling");
        this.add("emi.category.ytech.smelting", "Smelting");
        this.add("emi.category.ytech.block_hit", "Block Hit");
        this.add("emi.category.ytech.alloying", "Alloying");
        this.add("emi.category.ytech.hammering", "Hammering");
        this.add("emi.category.ytech.pottery", "Pottery");
        this.add("emi.category.ytech.workspace_crafting", "Workspace Crafting");
        this.add("emi.category.ytech.chopping", "Chopping");
        this.add("emi.alloying.time", "%s s");
        this.add("emi.drying.time", "%s s");
        this.add("emi.smelting.time", "%s s");
        this.add("emi.milling.chance", "%s%% +1");
        this.add("emi.alloying.temperature", "%s \u00b0C");
        this.add("emi.smelting.temperature", "%s \u00b0C");
        this.add("emi.chopping.hit_count", "%s time(s)");
        this.add("emi.tanning.hit_count", "%s time(s)");
        this.add("emi.hammering.hit_count", "%s time(s)");
        this.add("emi.workspace_crafting.layer", "Layer %s");
        this.add("sound.ytech.saber_tooth_tiger.ambient", "Saber-Toothed Tiger Roars");
        this.add("sound.ytech.saber_tooth_tiger.hurt", "Saber-Toothed Tiger Hurts");
        this.add("sound.ytech.saber_tooth_tiger.death", "Saber-Toothed Tiger Dies");
        this.add("sound.ytech.terror_bird.ambient", "Terror Bird Clucks");
        this.add("sound.ytech.terror_bird.hurt", "Terror Bird Hurts");
        this.add("sound.ytech.terror_bird.death", "Terror Bird Dies");
        this.add("sound.ytech.woolly_mammoth.ambient", "Woolly Mammoth Trumpets");
        this.add("sound.ytech.woolly_mammoth.hurt", "Woolly Mammoth Hurts");
        this.add("sound.ytech.woolly_mammoth.death", "Woolly Mammoth Dies");
        this.add("sound.ytech.woolly_rhino.ambient", "Woolly Rhino Grunts");
        this.add("sound.ytech.woolly_rhino.hurt", "Woolly Rhino Hurts");
        this.add("sound.ytech.woolly_rhino.death", "Woolly Rhino Dies");
        this.add("sound.ytech.bronze_anvil.use", "Bronze Anvil Used");
        this.add("sound.ytech.tanning_rack.use", "Tanning Rack Used");
        this.add("sound.ytech.tree_stump.use", "Tree Stump Used");
        this.add("sound.ytech.well_pulley.use", "Well Pulley Used");
        this.add("text.ytech.info.grass_fibers", "Grass fibers are obtained by breaking grass with Sharp Flint.");
        this.add("text.ytech.info.missing_curios", "Missing CuriosAPI, item is useless now");
        this.add("text.ytech.hover.amphora1", "Right-click to insert stackable items");
        this.add("text.ytech.hover.amphora2", "Right-click with empty hand to extract single item");
        this.add("text.ytech.hover.amphora3", "Right-click with empty hand while sneaking to extract stack");
        this.add("text.ytech.hover.grass_fibers", "Obtainable by breaking grass with Sharp Flint (10% chance)");
        this.add("text.ytech.hover.primitive_smelter", "Increase temperature by adding chimneys");
        this.add("text.ytech.hover.chimney", "Increases temperature in smelter by %s \u00b0C");
        this.add("text.ytech.hover.aqueduct1", "Can hold %smB of water");
        this.add("text.ytech.hover.aqueduct2", "Raining generates %smB every %s tick(s), if visible to sky");
        this.add("text.ytech.hover.aqueduct3", "Dripping generates %smB every %s tick(s)");
        this.add("text.ytech.hover.aqueduct_valve1", "Provides water from water source to aqueduct network");
        this.add("text.ytech.hover.aqueduct_valve2", "Generates %smB every %s tick(s)");
        this.add("text.ytech.hover.aqueduct_hydrator1", "Hydrates soil similar to water source");
        this.add("text.ytech.hover.aqueduct_hydrator2", "Consumes %smB every %s tick(s)");
        this.add("text.ytech.hover.aqueduct_fertilizer1", "Hydrates soil similar to water source and applies random bonemeal effect when fertilizer is provided");
        this.add("text.ytech.hover.aqueduct_fertilizer2", "Consumes %smB every %s tick(s)");
        this.add("text.ytech.hover.crafting_workbench1", "Right-click to insert item");
        this.add("text.ytech.hover.crafting_workbench2", "Right-click with Hammer to assemble block");
        this.add("text.ytech.hover.crafting_workbench3", "Left-click with empty hand to remove item");
        this.add("text.ytech.hover.drying_rack1", "Works faster in dry biomes and slower in wet biomes");
        this.add("text.ytech.hover.drying_rack2", "Doesn't work during rain");
        this.add("text.ytech.hover.millstone", "Use leashed animal on block as power source. Shift-right click with empty hand for disconnecting animal.");
        this.add("text.ytech.hover.fire_pit1", "Lit by right-click when holding sticks in both hands (40% chance)");
        this.add("text.ytech.hover.fire_pit2", "Right-click with burnable item to increase level by formula: floor(log10(burnTime))");
        this.add("text.ytech.hover.fire_pit3", "Each random tick is level decreased by 1");
        this.add("text.ytech.hover.fire_pit4", "Rain have chance to extinguish fire (50% chance on random tick)");
        this.add("text.ytech.hover.pebble", "Drops from gravel (10% chance)");
        this.add("text.ytech.hover.grass_bed", "Doesn't set respawn point");
        this.add("text.ytech.hover.potters_wheel1", "Right-click with Clay Ball or Clay Block to add clay. Right-click with empty hand to get result");
        this.add("text.ytech.hover.potters_wheel2", "Right-click while sneaking to get all clay back");
        this.add("text.ytech.hover.venus_of_hohle_fels", "Representing a fertility goddess. Small chance to apply bonemeal effect on crops around");
        this.add("text.ytech.hover.lion_man", "Oldest known statue ever discovered. Increases attack damage when worn");
        this.add("text.ytech.hover.wild_horse", "The earliest sculpture of a horse. Increases speed when worn");
        this.add("text.ytech.hover.shell_beads", "World\u2019s oldest jewelry. Will extend the time under water when worn");
        this.add("text.ytech.hover.chlorite_bracelet", "Oldest piece of jewellery of its kind in the world, crafted by an extinct branch of early humans known as Denisovans. Increases luck when worn");
        this.add("text.ytech.hover.unlit_torch1", "Right-click on fire source to lit a torch");
        this.add("text.ytech.hover.unlit_torch2", "Right-click while sneaking on machine that can be lit (e.g. Furnace) to lit a torch");
        this.add("text.ytech.hover.well_pulley1", "Adds water to connected Aqueduct network when right-clicked");
        this.add("text.ytech.hover.well_pulley2", "Must be placed on full block");
        this.add("text.ytech.hover.well_pulley3", "Has double output in wet biome and half output in dry biome");
        this.add("text.ytech.top.drying_rack.progress", "Progress: %s%%");
        this.add("text.ytech.top.entity.generation", "Generation: %s");
        this.add("text.ytech.top.fire_pit.progress", "Progress: %s%%");
        this.add("text.ytech.top.irrigation.fertilizing", "Fertilizing");
        this.add("text.ytech.top.irrigation.hydrating", "Hydrating");
        this.add("text.ytech.top.irrigation.production", "Producing: %s mb/s");
        this.add("text.ytech.top.irrigation.network", "Network: %s/%s");
        this.add("text.ytech.top.smelter.progress", "Progress: %s%%");
        this.add("text.ytech.top.smelter.temperature", "Temperature: %s\u00b0C");
        this.add("text.ytech.top.tanning_rack.progress", "Progress: %s%%");
        this.add("text.ytech.top.tree_stump.progress", "Progress: %s%%");
        this.add("creativeTab.ytech.title", "YTech");
    }

    private <E extends Enum<E>> void addTypedItem(YTechItems.TypedItem<E> item, NameHolder nameHolder, BiFunction<NameHolder, E, String> nameGetter, Predicate<Map.Entry<E, DeferredItem<Item>>> filter) {
        item.entrySet().stream().filter(filter).forEach(entry -> this.addItem((Supplier)entry.getValue(), (String)nameGetter.apply(nameHolder, (Enum)entry.getKey())));
    }

    private <E extends Enum<E>> void addTypedItem(YTechItems.TypedItem<E> typedItem, NameHolder nameHolder, BiFunction<NameHolder, E, String> nameGetter) {
        typedItem.forEach((key, item) -> this.addItem((Supplier)item, (String)nameGetter.apply(nameHolder, key)));
    }

    private <E extends Enum<E>, F extends Enum<F>> void addMultiTypedItem(YTechItems.MultiTypedItem<E, F> multiTypedItem, NameHolder nameHolder, TriFunction<NameHolder, E, F, String> nameGetter) {
        multiTypedItem.forEach((key1, map) -> map.forEach((key2, item) -> this.addItem((Supplier)item, (String)nameGetter.apply((Object)nameHolder, key1, key2))));
    }

    private void addMaterialBlock(YTechBlocks.MaterialBlock block, NameHolder nameHolder, Predicate<Map.Entry<MaterialType, DeferredBlock<Block>>> filter) {
        block.entries().stream().filter(filter).forEach(entry -> this.addBlock((Supplier)entry.getValue(), YTechLanguageProvider.getMaterialName(nameHolder, (MaterialType)entry.getKey())));
    }

    private void addMaterialBlock(YTechBlocks.MaterialBlock block, NameHolder nameHolder) {
        block.entries().forEach(entry -> this.addBlock((Supplier)entry.getValue(), YTechLanguageProvider.getMaterialName(nameHolder, (MaterialType)entry.getKey())));
    }

    private void addStorageBlockLanguage(YTechBlocks.MaterialBlock block, String prefix) {
        block.entries().stream().filter(YTechLanguageProvider::vanillaMaterialsFilter).forEach(entry -> this.addBlock((Supplier)entry.getValue(), YTechLanguageProvider.getMaterialName(NameHolder.prefix(prefix), (MaterialType)entry.getKey())));
    }

    private void addTag(TagKey<Item> tag, String name) {
        ResourceLocation location = tag.location();
        this.add("tag.item." + location.getNamespace().replace("/", ".") + "." + location.getPath().replace("/", "."), name);
    }

    private <E extends Enum<E>> void addTag(YTechItemTags.TypedTag<E> tag, NameHolder nameHolder, BiFunction<NameHolder, E, String> nameGetter) {
        this.addTag(tag.tag, nameHolder.prefix() != null ? nameHolder.prefix() : nameHolder.suffix());
        tag.forEach((type, t) -> this.addTag((TagKey<Item>)t, (String)nameGetter.apply(nameHolder, type)));
    }

    private <E extends Enum<E>> void addTag(YTechItemTags.TypedTag<E> tag, NameHolder nameHolder, BiFunction<NameHolder, E, String> nameGetter, EnumSet<E> exclude) {
        this.addTag(tag.tag, nameHolder.prefix() != null ? nameHolder.prefix() : nameHolder.suffix());
        tag.entrySet().stream().filter(e -> !exclude.contains(e.getKey())).forEach(e -> this.addTag((TagKey<Item>)((TagKey)e.getValue()), (String)nameGetter.apply(nameHolder, (Enum)e.getKey())));
    }

    private <E extends Enum<E>, F extends Enum<F>> void addTag(YTechItemTags.MultiTypedTag<E, F> tag, NameHolder nameHolder, BiFunction<NameHolder, F, String> subNameGetter, TriFunction<NameHolder, E, F, String> nameGetter) {
        String name = nameHolder.prefix() != null ? nameHolder.prefix() : nameHolder.suffix();
        this.addTag(tag.tag, name);
        tag.forEach((type1, map) -> map.forEach((type2, t) -> this.addTag(tag.get(type1, type2), (String)nameGetter.apply((Object)nameHolder, type1, type2))));
        tag.entrySubSet().forEach(e -> this.addTag((TagKey<Item>)((TagKey)e.getValue()), (String)subNameGetter.apply(nameHolder, (Enum)e.getKey())));
    }

    private static <T extends DeferredHolder<?, ?>> boolean vanillaMaterialsFilter(Map.Entry<MaterialType, T> entry) {
        return !MaterialType.VANILLA_METALS.contains(entry.getKey());
    }

    private static boolean goldIronWoodLeatherFilter(Map.Entry<MaterialType, DeferredItem<Item>> entry) {
        return !EnumSet.of(MaterialType.GOLD, MaterialType.IRON, MaterialType.WOODEN, MaterialType.LEATHER).contains(entry.getKey());
    }

    private static boolean ironFilter(Map.Entry<MaterialType, DeferredItem<Item>> entry) {
        return !EnumSet.of(MaterialType.IRON).contains(entry.getKey());
    }

    private static String getMaterialName(NameHolder nameHolder, MaterialType material) {
        Object key = nameHolder.prefix() != null ? nameHolder.prefix() + " " : "";
        key = material.name.equals("Gold") && nameHolder.prefix() == null ? (String)key + "Golden" : (String)key + material.name;
        key = (String)key + (String)(nameHolder.suffix() != null ? " " + nameHolder.suffix() : "");
        return key;
    }

    private static String getName(NameHolder nameHolder, PartType partType) {
        Object key = nameHolder.prefix() != null ? nameHolder.prefix() + " " : "";
        key = (String)key + partType.name;
        key = (String)key + (String)(nameHolder.suffix() != null ? " " + nameHolder.suffix() : "");
        return key;
    }

    private static String getName(NameHolder nameHolder, MaterialType material, PartType partType) {
        Object key = nameHolder.prefix() != null ? nameHolder.prefix() + " " : "";
        key = material.name.equals("Gold") && nameHolder.prefix() == null ? (String)key + "Golden" : (String)key + material.name;
        key = (String)key + " ";
        key = (String)key + partType.name;
        key = (String)key + (String)(nameHolder.suffix() != null ? " " + nameHolder.suffix() : "");
        return key;
    }

    private void addJadeTranslation(DeferredBlock<Block> block, String name) {
        this.add("config.jade.plugin_ytech." + block.getId().getPath(), name);
    }

    private void addJadeTranslation(ResourceLocation group, String name) {
        this.add("config.jade.plugin_ytech." + group.getPath(), name);
    }
}

