/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.network.generic.server;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.yanny.ytech.network.generic.NetworkUtils;
import com.yanny.ytech.network.generic.common.CommonNetwork;
import com.yanny.ytech.network.generic.common.INetworkBlockEntity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class ServerNetwork<N extends ServerNetwork<N, O>, O extends INetworkBlockEntity>
extends CommonNetwork {
    private static final String TAG_CHUNK_MAP = "chunkMap";
    private static final String TAG_POS_MAP = "posMap";
    private static final String TAG_BLOCK_POS = "blockPos";
    private static final String TAG_CHUNK_POS = "chunkPos";
    private static final Logger LOGGER = LogUtils.getLogger();
    @NotNull
    protected final Consumer<Integer> onChange;
    @NotNull
    protected final BiConsumer<Integer, ChunkPos> onRemove;
    @NotNull
    private final Map<ChunkPos, Set<BlockPos>> chunkMap = new HashMap<ChunkPos, Set<BlockPos>>();
    private boolean dirty = false;

    public ServerNetwork(int networkId, @NotNull Consumer<Integer> onChange, @NotNull BiConsumer<Integer, ChunkPos> onRemove) {
        super(networkId);
        this.onChange = onChange;
        this.onRemove = onRemove;
    }

    protected abstract boolean canAttach(@NotNull O var1);

    protected abstract boolean canAttach(@NotNull N var1);

    protected void load(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        if (tag.contains(TAG_CHUNK_MAP) && tag.getTagType(TAG_CHUNK_MAP) != 0) {
            tag.getList(TAG_CHUNK_MAP, 10).forEach(t -> {
                HashSet blockPosSet = new HashSet();
                ((CompoundTag)t).getList(TAG_POS_MAP, 10).forEach(u -> blockPosSet.add(NetworkUtils.loadBlockPos(((CompoundTag)u).getCompound(TAG_BLOCK_POS))));
                this.chunkMap.put(NetworkUtils.loadChunkPos(((CompoundTag)t).getCompound(TAG_CHUNK_POS)), blockPosSet);
            });
        }
    }

    @NotNull
    protected CompoundTag save(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        ListTag chunksTag = new ListTag();
        this.chunkMap.forEach((pos, set) -> {
            CompoundTag t = new CompoundTag();
            ListTag posTag = new ListTag();
            t.put(TAG_CHUNK_POS, (Tag)NetworkUtils.saveChunkPos(pos));
            set.forEach(blockPos -> {
                CompoundTag u = new CompoundTag();
                u.put(TAG_BLOCK_POS, (Tag)NetworkUtils.saveBlockPos(blockPos));
                posTag.add((Object)u);
            });
            t.put(TAG_POS_MAP, (Tag)posTag);
            chunksTag.add((Object)t);
        });
        tag.put(TAG_CHUNK_MAP, (Tag)chunksTag);
        return tag;
    }

    protected abstract void appendNetwork(@NotNull N var1, @NotNull Level var2);

    protected abstract boolean updateBlockEntity(@NotNull O var1);

    @NotNull
    protected abstract List<N> removeBlockEntity(@NotNull Function<Integer, List<Integer>> var1, @NotNull BiConsumer<Integer, ChunkPos> var2, @NotNull O var3);

    protected abstract boolean isNotEmpty();

    protected abstract boolean isValidPosition(@NotNull O var1, @NotNull BlockPos var2);

    protected void addBlockEntity(@NotNull O blockEntity) {
        ChunkPos chunkPos = new ChunkPos(blockEntity.getBlockPos());
        blockEntity.setNetworkId(this.getNetworkId());
        if (this.chunkMap.containsKey(chunkPos)) {
            this.chunkMap.get(chunkPos).add(blockEntity.getBlockPos());
        } else {
            this.chunkMap.put(chunkPos, Sets.newHashSet((Object[])new BlockPos[]{blockEntity.getBlockPos()}));
        }
    }

    protected void removeBlockEntity(@NotNull O blockEntity) {
        ChunkPos chunkPos = new ChunkPos(blockEntity.getBlockPos());
        Set<BlockPos> blockPosSet = this.chunkMap.get(chunkPos);
        if (blockPosSet != null) {
            if (blockPosSet.isEmpty() && this.chunkMap.size() > 1) {
                this.chunkMap.remove(chunkPos);
            }
        } else {
            LOGGER.warn("{} NULL BlockPos", (Object)this.getNetworkId());
        }
        blockEntity.setNetworkId(-1);
        if (!this.isNotEmpty()) {
            this.onRemove.accept(this.getNetworkId(), chunkPos);
        }
    }

    protected boolean canConnect(@NotNull O blockEntity) {
        return blockEntity.getValidNeighbors().stream().anyMatch(pos -> this.isValidPosition(blockEntity, (BlockPos)pos));
    }

    protected void setClean() {
        this.dirty = false;
    }

    protected void setDirty() {
        this.dirty = true;
    }

    protected boolean isDirty() {
        return this.dirty;
    }

    protected Set<ChunkPos> getChunks() {
        return this.chunkMap.keySet();
    }
}

