/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.network.irrigation;

import com.mojang.logging.LogUtils;
import com.yanny.ytech.YTechMod;
import com.yanny.ytech.network.generic.NetworkUtils;
import com.yanny.ytech.network.generic.server.ServerNetwork;
import com.yanny.ytech.network.irrigation.IIrrigationBlockEntity;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class IrrigationServerNetwork
extends ServerNetwork<IrrigationServerNetwork, IIrrigationBlockEntity> {
    private static final String TAG_PROVIDERS = "providers";
    private static final String TAG_CONSUMERS = "consumers";
    private static final String TAG_STORAGES = "storages";
    private static final String TAG_FILLED_BY_RAIN = "filledByRain";
    private static final String TAG_FILLED_BY_DRIPPING = "filledByDripping";
    private static final String TAG_BLOCK_POS = "pos";
    private static final String TAG_FLOW = "flow";
    private static final String TAG_FLUID_TANK = "fluidHolder";
    private static final String TAG_CAPACITY = "capacity";
    private static final Logger LOGGER = LogUtils.getLogger();
    @NotNull
    private final HashMap<BlockPos, Integer> providers = new HashMap();
    @NotNull
    private final Set<BlockPos> consumers = new HashSet<BlockPos>();
    @NotNull
    private final HashMap<BlockPos, Integer> storages = new HashMap();
    @NotNull
    private final Set<BlockPos> filledByRain = new HashSet<BlockPos>();
    @NotNull
    private final Set<BlockPos> filledByDripping = new HashSet<BlockPos>();
    @NotNull
    private final FluidTank fluidHandler;
    private int inflow = 0;

    public IrrigationServerNetwork(@NotNull CompoundTag tag, int networkId, @NotNull Consumer<Integer> onChange, @NotNull BiConsumer<Integer, ChunkPos> onRemove, HolderLookup.Provider provider) {
        super(networkId, onChange, onRemove);
        this.fluidHandler = this.createFluidTank(networkId);
        this.load(tag, provider);
    }

    public IrrigationServerNetwork(int networkId, @NotNull Consumer<Integer> onChange, @NotNull BiConsumer<Integer, ChunkPos> onRemove) {
        super(networkId, onChange, onRemove);
        this.fluidHandler = this.createFluidTank(networkId);
    }

    public String toString() {
        return MessageFormat.format("Id:{0,number}, C:{1,number}, P:{2,number}, S:{3,number}, Y:{4,number}, Z:{5,number}, {6,number}, {7,number}/{8,number}", this.getNetworkId(), this.consumers.size(), this.providers.size(), this.storages.size(), this.filledByRain.size(), this.filledByDripping.size(), this.inflow, this.fluidHandler.getFluidAmount(), this.fluidHandler.getCapacity());
    }

    @Override
    protected boolean canAttach(@NotNull IIrrigationBlockEntity blockEntity) {
        return true;
    }

    @Override
    protected boolean canAttach(@NotNull IrrigationServerNetwork network) {
        return true;
    }

    @Override
    protected void load(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.load(tag, provider);
        if (tag.contains(TAG_PROVIDERS) && tag.getTagType(TAG_PROVIDERS) != 0) {
            tag.getList(TAG_PROVIDERS, 10).forEach(t -> this.providers.put(NetworkUtils.loadBlockPos(((CompoundTag)t).getCompound(TAG_BLOCK_POS)), ((CompoundTag)t).getInt(TAG_FLOW)));
        }
        if (tag.contains(TAG_CONSUMERS) && tag.getTagType(TAG_CONSUMERS) != 0) {
            tag.getList(TAG_CONSUMERS, 10).forEach(t -> this.consumers.add(NetworkUtils.loadBlockPos(((CompoundTag)t).getCompound(TAG_BLOCK_POS))));
        }
        if (tag.contains(TAG_STORAGES) && tag.getTagType(TAG_STORAGES) != 0) {
            tag.getList(TAG_STORAGES, 10).forEach(t -> this.storages.put(NetworkUtils.loadBlockPos(((CompoundTag)t).getCompound(TAG_BLOCK_POS)), ((CompoundTag)t).getInt(TAG_CAPACITY)));
        }
        if (tag.contains(TAG_FILLED_BY_RAIN) && tag.getTagType(TAG_FILLED_BY_RAIN) != 0) {
            tag.getList(TAG_FILLED_BY_RAIN, 10).forEach(t -> this.filledByRain.add(NetworkUtils.loadBlockPos(((CompoundTag)t).getCompound(TAG_BLOCK_POS))));
        }
        if (tag.contains(TAG_FILLED_BY_DRIPPING) && tag.getTagType(TAG_FILLED_BY_DRIPPING) != 0) {
            tag.getList(TAG_FILLED_BY_DRIPPING, 10).forEach(t -> this.filledByDripping.add(NetworkUtils.loadBlockPos(((CompoundTag)t).getCompound(TAG_BLOCK_POS))));
        }
        if (tag.contains(TAG_FLUID_TANK) && tag.getTagType(TAG_FLUID_TANK) != 0) {
            this.fluidHandler.setCapacity(this.storages.values().stream().mapToInt(Integer::intValue).sum());
            this.fluidHandler.readFromNBT(provider, tag.getCompound(TAG_FLUID_TANK));
        }
        this.inflow = this.providers.values().stream().mapToInt(Integer::intValue).sum();
        LOGGER.debug("Network {}: {}", (Object)this.getNetworkId(), (Object)this);
    }

    @Override
    @NotNull
    protected CompoundTag save(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.save(provider);
        ListTag providersTag = new ListTag();
        ListTag consumersTag = new ListTag();
        ListTag storagesTag = new ListTag();
        ListTag filledByRainTag = new ListTag();
        ListTag filledByDrippingTag = new ListTag();
        this.providers.forEach((pos, flow) -> {
            CompoundTag t = new CompoundTag();
            t.put(TAG_BLOCK_POS, (Tag)NetworkUtils.saveBlockPos(pos));
            t.putInt(TAG_FLOW, flow.intValue());
            providersTag.add((Object)t);
        });
        this.consumers.forEach(pos -> {
            CompoundTag t = new CompoundTag();
            t.put(TAG_BLOCK_POS, (Tag)NetworkUtils.saveBlockPos(pos));
            consumersTag.add((Object)t);
        });
        this.storages.forEach((pos, capacity) -> {
            CompoundTag t = new CompoundTag();
            t.put(TAG_BLOCK_POS, (Tag)NetworkUtils.saveBlockPos(pos));
            t.putInt(TAG_CAPACITY, capacity.intValue());
            storagesTag.add((Object)t);
        });
        this.filledByRain.forEach(pos -> {
            CompoundTag t = new CompoundTag();
            t.put(TAG_BLOCK_POS, (Tag)NetworkUtils.saveBlockPos(pos));
            filledByRainTag.add((Object)t);
        });
        this.filledByDripping.forEach(pos -> {
            CompoundTag t = new CompoundTag();
            t.put(TAG_BLOCK_POS, (Tag)NetworkUtils.saveBlockPos(pos));
            filledByDrippingTag.add((Object)t);
        });
        tag.put(TAG_PROVIDERS, (Tag)providersTag);
        tag.put(TAG_CONSUMERS, (Tag)consumersTag);
        tag.put(TAG_STORAGES, (Tag)storagesTag);
        tag.put(TAG_FILLED_BY_RAIN, (Tag)filledByRainTag);
        tag.put(TAG_FILLED_BY_DRIPPING, (Tag)filledByDrippingTag);
        tag.put(TAG_FLUID_TANK, (Tag)this.fluidHandler.writeToNBT(provider, new CompoundTag()));
        return tag;
    }

    @Override
    protected void appendNetwork(@NotNull IrrigationServerNetwork network, @NotNull Level level) {
        network.providers.forEach((pos, value) -> {
            this.providers.put((BlockPos)pos, (Integer)value);
            BlockEntity patt0$temp = level.getBlockEntity(pos);
            if (patt0$temp instanceof IIrrigationBlockEntity) {
                IIrrigationBlockEntity irrigationBlockEntity = (IIrrigationBlockEntity)patt0$temp;
                this.addBlockEntity(irrigationBlockEntity);
            }
        });
        network.consumers.forEach(pos -> {
            this.consumers.add((BlockPos)pos);
            BlockEntity patt0$temp = level.getBlockEntity(pos);
            if (patt0$temp instanceof IIrrigationBlockEntity) {
                IIrrigationBlockEntity irrigationBlockEntity = (IIrrigationBlockEntity)patt0$temp;
                this.addBlockEntity(irrigationBlockEntity);
            }
        });
        network.storages.forEach((pos, value) -> {
            this.storages.put((BlockPos)pos, (Integer)value);
            BlockEntity patt0$temp = level.getBlockEntity(pos);
            if (patt0$temp instanceof IIrrigationBlockEntity) {
                IIrrigationBlockEntity irrigationBlockEntity = (IIrrigationBlockEntity)patt0$temp;
                this.addBlockEntity(irrigationBlockEntity);
            }
        });
        this.filledByRain.addAll(network.filledByRain);
        this.filledByDripping.addAll(network.filledByDripping);
        this.inflow += network.inflow;
        this.fluidHandler.setCapacity(this.fluidHandler.getCapacity() + network.fluidHandler.getCapacity());
        this.fluidHandler.setFluid(new FluidStack((Fluid)Fluids.WATER, this.fluidHandler.getFluidAmount() + network.fluidHandler.getFluidAmount()));
    }

    @Override
    protected boolean updateBlockEntity(@NotNull IIrrigationBlockEntity blockEntity) {
        BlockPos blockPos = blockEntity.getBlockPos();
        boolean wasChange = false;
        switch (blockEntity.getNetworkType()) {
            case PROVIDER: {
                int oldCapacity = this.inflow;
                int value = blockEntity.getFlow();
                this.providers.put(blockPos, value);
                this.inflow = this.providers.values().stream().mapToInt(Integer::intValue).sum();
                if (oldCapacity == this.inflow) break;
                wasChange = true;
                break;
            }
            case CONSUMER: {
                this.consumers.add(blockPos);
                break;
            }
            case STORAGE: {
                boolean drippingFilling;
                boolean oldValue = this.filledByRain.contains(blockPos);
                boolean rainFilling = blockEntity.validForRainFilling();
                if (oldValue != rainFilling) {
                    if (rainFilling) {
                        this.filledByRain.add(blockPos);
                    } else {
                        this.filledByRain.remove(blockPos);
                    }
                    wasChange = true;
                }
                if ((oldValue = this.filledByDripping.contains(blockPos)) == (drippingFilling = blockEntity.validForDripping())) break;
                if (drippingFilling) {
                    this.filledByDripping.add(blockPos);
                } else {
                    this.filledByDripping.remove(blockPos);
                }
                wasChange = true;
            }
        }
        return wasChange;
    }

    @Override
    @NotNull
    protected List<IrrigationServerNetwork> removeBlockEntity(@NotNull Function<Integer, List<Integer>> idsGetter, @NotNull BiConsumer<Integer, ChunkPos> onRemove, @NotNull IIrrigationBlockEntity blockEntity) {
        Level level = blockEntity.getLevel();
        HashMap<BlockPos, Integer> providerBlocks = new HashMap<BlockPos, Integer>(this.providers);
        HashSet<BlockPos> consumerBlocks = new HashSet<BlockPos>(this.consumers);
        HashMap<BlockPos, Integer> storageBlocks = new HashMap<BlockPos, Integer>(this.storages);
        HashSet<BlockPos> filledByRainBlocks = new HashSet<BlockPos>(this.filledByRain);
        HashSet<BlockPos> filledByDrippingBlocks = new HashSet<BlockPos>(this.filledByDripping);
        BlockPos blockPos = blockEntity.getBlockPos();
        double fluidPerBlock = this.storageBlockCount() > 0 ? (double)this.fluidHandler.getFluidAmount() / (double)this.storageBlockCount() : 0.0;
        providerBlocks.remove(blockPos);
        consumerBlocks.remove(blockPos);
        storageBlocks.remove(blockPos);
        filledByRainBlocks.remove(blockPos);
        filledByDrippingBlocks.remove(blockPos);
        this.removeBlockEntity(blockEntity);
        List neighbors = blockEntity.getValidNeighbors().stream().filter(pos -> providerBlocks.containsKey(pos) || consumerBlocks.contains(pos) || storageBlocks.containsKey(pos)).collect(Collectors.toList());
        if (neighbors.size() == 1 || providerBlocks.isEmpty() && consumerBlocks.isEmpty() && storageBlocks.isEmpty() || level == null) {
            this.fluidHandler.setFluid(new FluidStack((Fluid)Fluids.WATER, (int)((double)this.storageBlockCount() * fluidPerBlock)));
            return List.of();
        }
        List<Integer> ids = idsGetter.apply(neighbors.size() - 1);
        BlockPos neighbor = (BlockPos)neighbors.remove(0);
        this.clear();
        IrrigationServerNetwork.insertConnectedPositions(this, providerBlocks, consumerBlocks, storageBlocks, filledByRainBlocks, filledByDrippingBlocks, neighbor, level);
        this.fluidHandler.setFluid(new FluidStack((Fluid)Fluids.WATER, (int)((double)this.storageBlockCount() * fluidPerBlock)));
        return neighbors.stream().map(pos -> {
            if (providerBlocks.isEmpty() && consumerBlocks.isEmpty() && storageBlocks.isEmpty() || !providerBlocks.containsKey(pos) && !consumerBlocks.contains(pos) && !storageBlocks.containsKey(pos)) {
                return null;
            }
            IrrigationServerNetwork network = new IrrigationServerNetwork((Integer)ids.remove(0), this.onChange, onRemove);
            IrrigationServerNetwork.insertConnectedPositions(network, providerBlocks, consumerBlocks, storageBlocks, filledByRainBlocks, filledByDrippingBlocks, pos, level);
            return network;
        }).filter(Objects::nonNull).peek(n -> n.fluidHandler.setFluid(new FluidStack((Fluid)Fluids.WATER, (int)((double)n.storageBlockCount() * fluidPerBlock)))).toList();
    }

    @Override
    protected boolean isNotEmpty() {
        return !this.providers.isEmpty() || !this.consumers.isEmpty() || !this.storages.isEmpty();
    }

    @Override
    protected boolean isValidPosition(@NotNull IIrrigationBlockEntity blockEntity, @NotNull BlockPos pos) {
        BlockEntity blockEntity2;
        Level level;
        if ((this.providers.containsKey(pos) || this.consumers.contains(pos) || this.storages.containsKey(pos)) && (level = blockEntity.getLevel()) != null && level.isLoaded(pos) && (blockEntity2 = level.getBlockEntity(pos)) instanceof IIrrigationBlockEntity) {
            IIrrigationBlockEntity irrigationBlockEntity = (IIrrigationBlockEntity)blockEntity2;
            return irrigationBlockEntity.getValidNeighbors().contains(blockEntity.getBlockPos());
        }
        return false;
    }

    @Override
    protected void addBlockEntity(@NotNull IIrrigationBlockEntity blockEntity) {
        super.addBlockEntity(blockEntity);
        switch (blockEntity.getNetworkType()) {
            case CONSUMER: {
                this.addConsumer(blockEntity);
                break;
            }
            case PROVIDER: {
                this.addProvider(blockEntity);
                break;
            }
            case STORAGE: {
                this.addStorage(blockEntity);
            }
        }
        if (blockEntity.validForRainFilling()) {
            this.filledByRain.add(blockEntity.getBlockPos());
        }
        if (blockEntity.validForDripping()) {
            this.filledByDripping.add(blockEntity.getBlockPos());
        }
    }

    @Override
    protected void removeBlockEntity(@NotNull IIrrigationBlockEntity blockEntity) {
        switch (blockEntity.getNetworkType()) {
            case CONSUMER: {
                this.removeConsumer(blockEntity);
                break;
            }
            case PROVIDER: {
                this.removeProvider(blockEntity);
                break;
            }
            case STORAGE: {
                this.removeStorage(blockEntity);
            }
        }
        this.filledByRain.remove(blockEntity.getBlockPos());
        this.filledByDripping.remove(blockEntity.getBlockPos());
        super.removeBlockEntity(blockEntity);
    }

    public void tick(@NotNull ServerLevel level) {
        int amount = 0;
        if (YTechMod.CONFIGURATION.shouldRainingFillAqueduct() && level.isRaining() && level.getGameTime() % (long)YTechMod.CONFIGURATION.getRainingFillPerNthTick() == 0L) {
            amount += YTechMod.CONFIGURATION.getRainingFillAmount() * this.filledByRainCount();
        }
        if (YTechMod.CONFIGURATION.shouldDrippingFillAqueduct() && level.getGameTime() % (long)YTechMod.CONFIGURATION.getDrippingFillPerNthTick() == 0L) {
            amount += YTechMod.CONFIGURATION.getDrippingFillAmount() * this.filledByDrippingCount();
        }
        if (level.getGameTime() % (long)YTechMod.CONFIGURATION.getValveFillPerNthTick() == 0L) {
            amount += this.inflow;
        }
        if (amount > 0 && this.fluidHandler.getFluidAmount() < this.fluidHandler.getCapacity()) {
            this.fluidHandler.fill(new FluidStack((Fluid)Fluids.WATER, amount), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @NotNull
    public FluidTank getFluidHandler() {
        return this.fluidHandler;
    }

    public int storageBlockCount() {
        return this.storages.size();
    }

    public int filledByRainCount() {
        return this.filledByRain.size();
    }

    public int filledByDrippingCount() {
        return this.filledByDripping.size();
    }

    private void addProvider(@NotNull IIrrigationBlockEntity entity) {
        BlockPos blockPos = entity.getBlockPos();
        int flow = entity.getFlow();
        this.providers.put(blockPos, flow);
        this.inflow += flow;
    }

    private void addConsumer(@NotNull IIrrigationBlockEntity entity) {
        BlockPos blockPos = entity.getBlockPos();
        this.consumers.add(blockPos);
    }

    private void addStorage(@NotNull IIrrigationBlockEntity entity) {
        BlockPos blockPos = entity.getBlockPos();
        int capacity = entity.getCapacity();
        this.storages.put(blockPos, capacity);
        this.fluidHandler.setCapacity(this.fluidHandler.getCapacity() + capacity);
    }

    private void removeProvider(@NotNull IIrrigationBlockEntity entity) {
        BlockPos blockPos = entity.getBlockPos();
        int value = this.providers.remove(blockPos);
        this.inflow -= value;
    }

    private void removeConsumer(@NotNull IIrrigationBlockEntity entity) {
        BlockPos blockPos = entity.getBlockPos();
        this.consumers.remove(blockPos);
    }

    private void removeStorage(@NotNull IIrrigationBlockEntity entity) {
        BlockPos blockPos = entity.getBlockPos();
        this.storages.remove(blockPos);
        this.fluidHandler.setCapacity(this.fluidHandler.getCapacity() - entity.getCapacity());
    }

    private void clear() {
        this.consumers.clear();
        this.providers.clear();
        this.storages.clear();
        this.filledByRain.clear();
        this.filledByDripping.clear();
        this.inflow = 0;
        this.fluidHandler.setCapacity(0);
    }

    private FluidTank createFluidTank(final int networkId) {
        return new FluidTank(0, fluid -> fluid.getFluid().isSame((Fluid)Fluids.WATER)){

            protected void onContentsChanged() {
                IrrigationServerNetwork.this.onChange.accept(networkId);
            }
        };
    }

    private static void insertConnectedPositions(@NotNull IrrigationServerNetwork network, @NotNull Map<BlockPos, Integer> providerBlocks, @NotNull Set<BlockPos> consumerBlocks, @NotNull Map<BlockPos, Integer> storageBlocks, @NotNull Set<BlockPos> filledByRainBlocks, @NotNull Set<BlockPos> filledByDrippingBlocks, @NotNull BlockPos from, @NotNull Level level) {
        BlockEntity blockEntity = level.getBlockEntity(from);
        if (blockEntity instanceof IIrrigationBlockEntity) {
            IIrrigationBlockEntity block = (IIrrigationBlockEntity)blockEntity;
            network.addBlockEntity(block);
            providerBlocks.remove(from);
            consumerBlocks.remove(from);
            storageBlocks.remove(from);
            filledByRainBlocks.remove(from);
            filledByDrippingBlocks.remove(from);
            block.getValidNeighbors().forEach(pos -> {
                if (providerBlocks.containsKey(pos) || consumerBlocks.contains(pos) || storageBlocks.containsKey(pos)) {
                    IrrigationServerNetwork.insertConnectedPositions(network, providerBlocks, consumerBlocks, storageBlocks, filledByRainBlocks, filledByDrippingBlocks, pos, level);
                }
            });
        }
    }
}

