/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.compatibility;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block.WellPulleyBlock;
import com.yanny.ytech.configuration.block_entity.AbstractPrimitiveMachineBlockEntity;
import com.yanny.ytech.configuration.block_entity.AmphoraBlockEntity;
import com.yanny.ytech.configuration.block_entity.AqueductFertilizerBlockEntity;
import com.yanny.ytech.configuration.block_entity.AqueductHydratorBlockEntity;
import com.yanny.ytech.configuration.block_entity.BronzeAnvilBlockEntity;
import com.yanny.ytech.configuration.block_entity.DryingRackBlockEntity;
import com.yanny.ytech.configuration.block_entity.FirePitBlockEntity;
import com.yanny.ytech.configuration.block_entity.MillstoneBlockEntity;
import com.yanny.ytech.configuration.block_entity.PottersWheelBlockEntity;
import com.yanny.ytech.configuration.block_entity.TanningRackBlockEntity;
import com.yanny.ytech.configuration.block_entity.ToolRackBlockEntity;
import com.yanny.ytech.configuration.block_entity.TreeStumpBlockEntity;
import com.yanny.ytech.configuration.block_entity.WellPulleyBlockEntity;
import com.yanny.ytech.configuration.block_entity.WoodenBoxBlockEntity;
import com.yanny.ytech.configuration.entity.AurochsEntity;
import com.yanny.ytech.configuration.entity.FowlEntity;
import com.yanny.ytech.configuration.entity.MouflonEntity;
import com.yanny.ytech.configuration.entity.WildBoarEntity;
import com.yanny.ytech.network.irrigation.IIrrigationBlockEntity;
import com.yanny.ytech.network.irrigation.IrrigationServerNetwork;
import com.yanny.ytech.registration.YTechBlocks;
import java.util.function.Function;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class TopCompatibility {
    public static void register() {
        if (!ModList.get().isLoaded("theoneprobe")) {
            return;
        }
        InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", GetTheOneProbe::new);
    }

    private static void addIrrigationInfo(IProbeInfo probeInfo, IIrrigationBlockEntity blockEntity) {
        switch (blockEntity.getNetworkType()) {
            case PROVIDER: {
                int perSec = Math.round((float)blockEntity.getFlow() * (20.0f / (float)YTechMod.CONFIGURATION.getValveFillPerNthTick()));
                probeInfo.horizontal().text((Component)Component.translatable((String)"text.ytech.top.irrigation.production", (Object[])new Object[]{Integer.toString(perSec)}));
                break;
            }
            case CONSUMER: {
                AqueductFertilizerBlockEntity fertilizerBlock;
                AqueductHydratorBlockEntity hydratorBlock;
                if (blockEntity instanceof AqueductHydratorBlockEntity && (hydratorBlock = (AqueductHydratorBlockEntity)blockEntity).isHydrating()) {
                    probeInfo.horizontal().text((Component)Component.translatable((String)"text.ytech.top.irrigation.hydrating"));
                }
                if (!(blockEntity instanceof AqueductFertilizerBlockEntity) || !(fertilizerBlock = (AqueductFertilizerBlockEntity)blockEntity).isFertilizing()) break;
                probeInfo.horizontal().text((Component)Component.translatable((String)"text.ytech.top.irrigation.fertilizing"));
            }
        }
        IrrigationServerNetwork network = YTechMod.IRRIGATION_PROPAGATOR.server().getNetwork(blockEntity);
        if (network != null) {
            probeInfo.horizontal().text((Component)Component.translatable((String)"text.ytech.top.irrigation.network", (Object[])new Object[]{Integer.toString(network.getFluidHandler().getFluidAmount()), Integer.toString(network.getFluidHandler().getCapacity())}));
        }
    }

    private static void addPrimitiveSmelterInfo(IProbeInfo probeInfo, AbstractPrimitiveMachineBlockEntity blockEntity) {
        IProbeInfo verticalLayout = probeInfo.vertical();
        if (blockEntity.hasActiveRecipe()) {
            verticalLayout.horizontal().text((Component)Component.translatable((String)"text.ytech.top.smelter.progress", (Object[])new Object[]{Integer.toString(blockEntity.progress())}));
        }
        verticalLayout.horizontal().text((Component)Component.translatable((String)"text.ytech.top.smelter.temperature", (Object[])new Object[]{Integer.toString(blockEntity.temperature())}));
    }

    public static class GetTheOneProbe
    implements Function<ITheOneProbe, Void> {
        public static ITheOneProbe probe;

        @Override
        @Nullable
        public Void apply(ITheOneProbe theOneProbe) {
            probe = theOneProbe;
            probe.registerProvider(new IProbeInfoProvider(this){

                public ResourceLocation getID() {
                    return Utils.modLoc("theoneprobe");
                }

                public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level level, BlockState blockState, IProbeHitData probeHitData) {
                    if (!level.isClientSide) {
                        BlockEntity blockEntity;
                        TreeStumpBlockEntity blockEntity2;
                        FirePitBlockEntity blockEntity3;
                        PottersWheelBlockEntity blockEntity4;
                        TanningRackBlockEntity blockEntity5;
                        MillstoneBlockEntity blockEntity6;
                        DryingRackBlockEntity blockEntity7;
                        BronzeAnvilBlockEntity blockEntity8;
                        BlockEntity entity = level.getBlockEntity(probeHitData.getPos());
                        if (entity instanceof BronzeAnvilBlockEntity && !(blockEntity8 = (BronzeAnvilBlockEntity)entity).getItem().isEmpty()) {
                            probeInfo.horizontal().item(blockEntity8.getItem());
                        } else if (entity instanceof DryingRackBlockEntity && !(blockEntity7 = (DryingRackBlockEntity)entity).getItem().isEmpty()) {
                            probeInfo.horizontal().text((Component)Component.translatable((String)"text.ytech.top.drying_rack.progress", (Object[])new Object[]{Integer.toString(blockEntity7.getProgress())}));
                        } else if (entity instanceof MillstoneBlockEntity && !(blockEntity6 = (MillstoneBlockEntity)entity).getInputItem().isEmpty()) {
                            probeInfo.horizontal().item(blockEntity6.getInputItem());
                        } else if (entity instanceof TanningRackBlockEntity && !(blockEntity5 = (TanningRackBlockEntity)entity).getItem().isEmpty()) {
                            probeInfo.horizontal().text((Component)Component.translatable((String)"text.ytech.top.tanning_rack.progress", (Object[])new Object[]{Integer.toString(blockEntity5.getProgress())}));
                        } else if (entity instanceof AbstractPrimitiveMachineBlockEntity) {
                            AbstractPrimitiveMachineBlockEntity blockEntity9 = (AbstractPrimitiveMachineBlockEntity)entity;
                            TopCompatibility.addPrimitiveSmelterInfo(probeInfo, blockEntity9);
                        } else if (entity instanceof IIrrigationBlockEntity) {
                            IIrrigationBlockEntity blockEntity10 = (IIrrigationBlockEntity)entity;
                            TopCompatibility.addIrrigationInfo(probeInfo, blockEntity10);
                        } else if (entity instanceof PottersWheelBlockEntity && !(blockEntity4 = (PottersWheelBlockEntity)entity).getItem().isEmpty()) {
                            probeInfo.horizontal().item(blockEntity4.getItem());
                        } else if (entity instanceof FirePitBlockEntity && !(blockEntity3 = (FirePitBlockEntity)entity).getItem().isEmpty()) {
                            probeInfo.horizontal().text((Component)Component.translatable((String)"text.ytech.top.fire_pit.progress", (Object[])new Object[]{Integer.toString(blockEntity3.getProgress())}));
                        } else if (entity instanceof TreeStumpBlockEntity && !(blockEntity2 = (TreeStumpBlockEntity)entity).getItem().isEmpty()) {
                            probeInfo.horizontal().text((Component)Component.translatable((String)"text.ytech.top.tree_stump.progress", (Object[])new Object[]{Integer.toString(blockEntity2.getProgress())}));
                        } else if (entity instanceof AmphoraBlockEntity) {
                            AmphoraBlockEntity blockEntity11 = (AmphoraBlockEntity)entity;
                            probeInfo.horizontal().item(blockEntity11.getItem());
                        } else if (entity instanceof WoodenBoxBlockEntity) {
                            WoodenBoxBlockEntity blockEntity12 = (WoodenBoxBlockEntity)entity;
                            ItemStack item = blockEntity12.getItem(probeHitData.getPos(), probeHitData.getSideHit(), probeHitData.getHitVec());
                            if (!item.isEmpty()) {
                                probeInfo.horizontal().item(item).text((Component)Component.translatable((String)item.getDescriptionId()));
                            }
                        } else if (entity instanceof ToolRackBlockEntity) {
                            ToolRackBlockEntity blockEntity13 = (ToolRackBlockEntity)entity;
                            ItemStack item = blockEntity13.getItem(probeHitData.getPos(), probeHitData.getSideHit(), probeHitData.getHitVec());
                            if (!item.isEmpty()) {
                                probeInfo.horizontal().item(item).text((Component)Component.translatable((String)item.getDescriptionId()));
                            }
                        } else if (blockState.is((Block)YTechBlocks.WELL_PULLEY.get()) && blockState.getValue(WellPulleyBlock.WELL_PART) == WellPulleyBlock.WellPulleyPart.TOP && (blockEntity = level.getBlockEntity(probeHitData.getPos().below())) instanceof WellPulleyBlockEntity) {
                            WellPulleyBlockEntity blockEntity14 = (WellPulleyBlockEntity)blockEntity;
                            TopCompatibility.addIrrigationInfo(probeInfo, blockEntity14);
                        }
                    }
                }
            });
            probe.registerEntityProvider(new IProbeInfoEntityProvider(this){

                public String getID() {
                    return "ytech";
                }

                public void addProbeEntityInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, Player player, Level level, Entity entity, IProbeHitEntityData iProbeHitEntityData) {
                    if (!level.isClientSide) {
                        if (entity instanceof AurochsEntity) {
                            AurochsEntity aurochsEntity = (AurochsEntity)entity;
                            iProbeInfo.horizontal().text((Component)Component.translatable((String)"text.ytech.top.entity.generation", (Object[])new Object[]{aurochsEntity.getGeneration()}));
                        } else if (entity instanceof MouflonEntity) {
                            MouflonEntity mouflonEntity = (MouflonEntity)entity;
                            iProbeInfo.horizontal().text((Component)Component.translatable((String)"text.ytech.top.entity.generation", (Object[])new Object[]{mouflonEntity.getGeneration()}));
                        } else if (entity instanceof FowlEntity) {
                            FowlEntity fowlEntity = (FowlEntity)entity;
                            iProbeInfo.horizontal().text((Component)Component.translatable((String)"text.ytech.top.entity.generation", (Object[])new Object[]{fowlEntity.getGeneration()}));
                        } else if (entity instanceof WildBoarEntity) {
                            WildBoarEntity wildBoarEntity = (WildBoarEntity)entity;
                            iProbeInfo.horizontal().text((Component)Component.translatable((String)"text.ytech.top.entity.generation", (Object[])new Object[]{wildBoarEntity.getGeneration()}));
                        }
                    }
                }
            });
            return null;
        }
    }
}

