/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.compatibility.emi;

import com.yanny.ytech.compatibility.EmiCompatibility;
import com.yanny.ytech.configuration.recipe.AlloyingRecipe;
import com.yanny.ytech.registration.YTechItems;
import com.yanny.ytech.registration.YTechRecipeTypes;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class EmiAlloyingRecipe
extends BasicEmiRecipe {
    public static final EmiStack WORKSTATION = EmiStack.of((ItemLike)((ItemLike)YTechItems.PRIMITIVE_ALLOY_SMELTER.get()));
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(EmiCompatibility.ref(YTechRecipeTypes.ALLOYING), (EmiRenderable)WORKSTATION, (EmiRenderable)new EmiTexture(EmiCompatibility.TEXTURE, 240, 240, 16, 16));
    public static final EmiTexture EMPTY_TEMPERATURE = new EmiTexture(EmiCompatibility.TEXTURE, 0, 0, 8, 38);
    public static final EmiTexture FULL_TEMPERATURE = new EmiTexture(EmiCompatibility.TEXTURE, 8, 0, 8, 38);
    private final int time;
    private final int temperature;

    public EmiAlloyingRecipe(AlloyingRecipe recipe, ResourceLocation id) {
        super(CATEGORY, id, 112, 38);
        this.inputs = List.of(EmiIngredient.of((Ingredient)recipe.ingredient1().ingredient()), EmiIngredient.of((Ingredient)recipe.ingredient2().ingredient()));
        this.outputs = List.of(EmiStack.of((ItemStack)recipe.result()));
        this.time = recipe.smeltingTime();
        this.temperature = recipe.minTemperature();
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        widgetHolder.addFillingArrow(54, 5, 50 * this.time).tooltip((mx, my) -> List.of(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)"emi.alloying.time", (Object[])new Object[]{Float.valueOf((float)this.time / 20.0f)}).getVisualOrderText())));
        widgetHolder.addSlot((EmiIngredient)this.inputs.get(0), 10, 4);
        widgetHolder.addSlot((EmiIngredient)this.inputs.get(1), 28, 4);
        widgetHolder.addTexture(EMPTY_TEMPERATURE, 0, 0);
        widgetHolder.addAnimatedTexture(FULL_TEMPERATURE, 0, 0, 4000, false, true, false).tooltip((mx, my) -> List.of(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)"emi.alloying.temperature", (Object[])new Object[]{this.temperature}).getVisualOrderText())));
        widgetHolder.addTexture(EmiTexture.EMPTY_FLAME, 19, 24);
        widgetHolder.addAnimatedTexture(EmiTexture.FULL_FLAME, 19, 24, 4000, false, true, true);
        widgetHolder.addSlot((EmiIngredient)this.outputs.get(0), 86, 0).large(true).recipeContext((EmiRecipe)this);
    }
}

