/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.compatibility.emi;

import com.yanny.ytech.compatibility.EmiCompatibility;
import com.yanny.ytech.configuration.recipe.MillingRecipe;
import com.yanny.ytech.registration.YTechItems;
import com.yanny.ytech.registration.YTechRecipeTypes;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class EmiMillingRecipe
extends BasicEmiRecipe {
    public static final EmiStack WORKSTATION = EmiStack.of((ItemLike)((ItemLike)YTechItems.MILLSTONE.get()));
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(EmiCompatibility.ref(YTechRecipeTypes.MILLING), (EmiRenderable)WORKSTATION, (EmiRenderable)new EmiTexture(EmiCompatibility.TEXTURE, 112, 240, 16, 16));
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.US));
    private final MillingRecipe recipe;

    public EmiMillingRecipe(MillingRecipe recipe, ResourceLocation id) {
        super(CATEGORY, id, 84, 37);
        this.recipe = recipe;
        this.inputs = List.of(EmiIngredient.of((Ingredient)recipe.ingredient()));
        this.outputs = List.of(EmiStack.of((ItemStack)recipe.result()));
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        MutableComponent chance = Component.translatable((String)"emi.milling.chance", (Object[])new Object[]{DECIMAL_FORMAT.format(this.recipe.bonusChance() * 100.0f)});
        int width = Minecraft.getInstance().font.width((FormattedText)chance);
        widgetHolder.addTexture(EmiTexture.EMPTY_ARROW, 26, 5);
        widgetHolder.addSlot((EmiIngredient)this.inputs.get(0), 0, 4);
        widgetHolder.addSlot((EmiIngredient)this.outputs.get(0), 58, 0).large(true).recipeContext((EmiRecipe)this);
        widgetHolder.addText((Component)chance, 42 - width / 2, 29, 0, false);
    }
}

