/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ytech.configuration.block;

import com.yanny.ytech.YTechMod;
import com.yanny.ytech.configuration.Utils;
import com.yanny.ytech.configuration.block.IrrigationBlock;
import com.yanny.ytech.configuration.block_entity.AqueductValveBlockEntity;
import com.yanny.ytech.configuration.recipe.RemainingShapedRecipe;
import com.yanny.ytech.network.generic.NetworkUtils;
import com.yanny.ytech.network.irrigation.IrrigationServerNetwork;
import com.yanny.ytech.registration.YTechBlocks;
import com.yanny.ytech.registration.YTechItemTags;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AqueductValveBlock
extends IrrigationBlock {
    public AqueductValveBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TERRACOTTA));
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        return new AqueductValveBlockEntity(pos, blockState);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState blockState) {
        return RenderShape.MODEL;
    }

    public boolean propagatesSkylightDown(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return false;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)blockPlaceContext.getHorizontalDirection().getClockWise());
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block neighborBlock, @NotNull BlockPos neighborPos, boolean movedByPiston) {
        BlockEntity blockEntity;
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof AqueductValveBlockEntity) {
            AqueductValveBlockEntity blockEntity2 = (AqueductValveBlockEntity)blockEntity;
            IrrigationServerNetwork network = YTechMod.IRRIGATION_PROPAGATOR.server().getNetwork(blockEntity2);
            if (network != null) {
                blockEntity2.neighborChanged();
            }
        }
    }

    @Override
    public List<BlockPos> getValidNeighbors(@NotNull BlockState blockState, @NotNull BlockPos pos) {
        return NetworkUtils.getDirections(List.of(Direction.EAST, Direction.WEST), pos, (Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        AqueductValveBlockEntity valveBlockEntity;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AqueductValveBlockEntity && (valveBlockEntity = (AqueductValveBlockEntity)blockEntity).getFlow() > 0 && random.nextInt(10) == 0) {
            level.playLocalSound(pos, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, random.nextFloat() * 0.25f + 0.75f, random.nextFloat() + 0.5f, false);
        }
    }

    public boolean isRandomlyTicking(@NotNull BlockState state) {
        return true;
    }

    public void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AqueductValveBlockEntity) {
            AqueductValveBlockEntity blockEntity2 = (AqueductValveBlockEntity)blockEntity;
            blockEntity2.randomTick(level);
        }
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    public static void registerModel(@NotNull BlockStateProvider provider) {
        ResourceLocation valveTexture = Utils.modBlockLoc("aqueduct/aqueduct_valve");
        ResourceLocation bricksTexture = Utils.modBlockLoc("terracotta_bricks");
        String name = Utils.getPath(YTechBlocks.AQUEDUCT_VALVE);
        ModelBuilder model = ((BlockModelBuilder)provider.models().cube(name, bricksTexture, bricksTexture, bricksTexture, bricksTexture, valveTexture, valveTexture)).texture("particle", valveTexture);
        provider.horizontalBlock((Block)YTechBlocks.AQUEDUCT_VALVE.get(), (ModelFile)model);
        ((ItemModelBuilder)provider.itemModels().getBuilder(name)).parent((ModelFile)model);
    }

    public static void registerRecipe(RecipeOutput recipeConsumer) {
        RemainingShapedRecipe.Builder.shaped(RecipeCategory.MISC, (ItemLike)YTechBlocks.AQUEDUCT_VALVE.get()).define(Character.valueOf('#'), YTechItemTags.TERRACOTTA_BRICKS).define(Character.valueOf('R'), YTechItemTags.RODS.tag).define(Character.valueOf('H'), YTechItemTags.HAMMERS.tag).define(Character.valueOf('S'), YTechItemTags.SAWS.tag).pattern("###").pattern("HRS").pattern("###").unlockedBy(Utils.getHasName(), RecipeProvider.has(YTechItemTags.TERRACOTTA_BRICKS)).save(recipeConsumer, Utils.modLoc(YTechBlocks.AQUEDUCT_VALVE));
    }
}

